# generated by datamodel-codegen:
#   filename:  api/classification/createClassification.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field

from ...entity.classification import tag
from ...type import basic


class CreateClassificationRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: tag.TagName
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this classification.'
    )
    description: basic.Markdown = Field(
        ..., description='Description of the classification.'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    mutuallyExclusive: Optional[bool] = Field(
        'false',
        description='Tags under this classification are mutually exclusive. When mutually exclusive is `true` the tags from this classification are used to **classify** an entity. An entity can only be in one class - example, it can only be either `tier1` or `tier2` and not both. When mutually exclusive is `false`, the tags from this classification are used to **categorize** an entity. An entity can be in multiple categories simultaneously - example a customer can be `newCustomer` and `atRisk` simultaneously.',
    )
