# generated by datamodel-codegen:
#   filename:  api/data/createDashboardDataModel.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...entity.data import dashboardDataModel, table
from ...entity.services import dashboardService
from ...type import basic, entityReference, lifeCycle, tagLabel


class CreateDashboardDataModelRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(
        ..., description='Name that identifies this data model.'
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this data model. It could be title or label from the source services.',
    )
    description: Optional[basic.Markdown] = Field(
        None,
        description='Description of the data model instance. What it has and how to use it.',
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this data model.'
    )
    dataProducts: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified names of data products this entity is part of.',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this data model.'
    )
    service: basic.FullyQualifiedEntityName = Field(
        ...,
        description='Link to the data model service where this data model is hosted in.',
    )
    serviceType: Optional[dashboardService.DashboardServiceType] = Field(
        None, description='Service type where this data model is hosted in.'
    )
    dataModelType: dashboardDataModel.DataModelType
    sql: Optional[basic.SqlQuery] = Field(
        None, description='In case the Data Model is based on a SQL query.'
    )
    columns: List[table.Column] = Field(..., description='Columns from the data model.')
    project: Optional[str] = Field(
        None,
        description='Name of the project / workspace / collection in which the dataModel is contained',
    )
    domain: Optional[str] = Field(
        None,
        description='Fully qualified name of the domain the Dashboard Data Model belongs to.',
    )
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )
