# generated by datamodel-codegen:
#   filename:  api/data/createTable.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...entity.data import table
from ...type import basic, entityReference, lifeCycle, tagLabel


class CreateTableRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: table.EntityName = Field(
        ...,
        description='Name that identifies the this entity instance uniquely. Same as id if when name is not unique',
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this table.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of entity instance.'
    )
    tableType: Optional[table.TableType] = None
    columns: List[table.Column] = Field(
        ..., description='Name of the tables in the database'
    )
    tableConstraints: Optional[List[table.TableConstraint]] = None
    tablePartition: Optional[table.TablePartition] = None
    tableProfilerConfig: Optional[table.TableProfilerConfig] = None
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this entity'
    )
    databaseSchema: basic.FullyQualifiedEntityName = Field(
        ..., description='FullyQualified name of the Schema corresponding to this table'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this table'
    )
    viewDefinition: Optional[basic.SqlQuery] = Field(
        None, description='View Definition in SQL. Applies to TableType.View only'
    )
    retentionPeriod: Optional[basic.Duration] = Field(
        None,
        description='Retention period of the data in the database. Period is expressed as duration in ISO 8601 format in UTC. Example - `P23DT23H`.',
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
    sourceUrl: Optional[basic.SourceUrl] = Field(
        None, description='Source URL of table.'
    )
    domain: Optional[str] = Field(
        None, description='Fully qualified name of the domain the Table belongs to.'
    )
    dataProducts: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified names of data products this entity is part of.',
    )
    fileFormat: Optional[table.FileFormat] = Field(
        None, description='File format in case of file/datalake tables.'
    )
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )
