# generated by datamodel-codegen:
#   filename:  api/domains/createDomain.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...entity.domains import domain
from ...type import basic, entityReference


class CreateDomainRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    domainType: domain.DomainType = Field(..., description='Domain type')
    name: basic.EntityName = Field(..., description='A unique name of the Domain')
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    displayName: Optional[str] = Field(
        None,
        description="Name used for display purposes. Example 'Marketing', 'Payments', etc.",
    )
    description: basic.Markdown = Field(..., description='Description of the Domain.')
    style: Optional[basic.Style] = None
    parent: Optional[str] = Field(
        None, description='Fully qualified name of parent domain.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Domain.'
    )
    experts: Optional[List[str]] = Field(
        None,
        description='List of user/login names of users who are experts in this Domain.',
    )
