# generated by datamodel-codegen:
#   filename:  api/services/createPipelineService.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...entity.services import pipelineService
from ...type import basic, entityReference, lifeCycle, tagLabel


class CreatePipelineServiceRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(
        ..., description='Name that identifies the this entity instance uniquely'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this pipeline service.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of pipeline service entity.'
    )
    serviceType: pipelineService.PipelineServiceType
    connection: Optional[pipelineService.PipelineConnection] = None
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this Pipeline Service.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this pipeline service.'
    )
    scheduleInterval: Optional[str] = Field(
        None, description='Scheduler Interval for the pipeline in cron format.'
    )
    dataProducts: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified names of data products this entity is part of.',
    )
    domain: Optional[str] = Field(
        None,
        description='Fully qualified name of the domain the Pipeline Service belongs to.',
    )
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle of the entity'
    )
