# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/externalAppIngestionConfig.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field

from ....metadataIngestion import workflow
from ....type import basic
from ...services.ingestionPipelines import ingestionPipeline


class Service(BaseModel):
    name: Optional[str] = Field(None, description='Name of the Service.')
    type: Optional[str] = Field(None, description='Type of Service')


class ExternalAppIngestionConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(..., description='Name of the ingestion Pipeline.')
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this ingestion pipeline.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the pipeline.'
    )
    pipelineType: ingestionPipeline.PipelineType
    sourceConfig: Optional[workflow.SourceConfig] = None
    airflowConfig: Optional[ingestionPipeline.AirflowConfig] = None
    loggerLevel: Optional[workflow.LogLevels] = Field(
        workflow.LogLevels.INFO, description='Set the logging level for the workflow.'
    )
    service: Service
