# generated by datamodel-codegen:
#   filename:  entity/domains/domain.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference, entityReferenceList


class DomainType(Enum):
    Source_aligned = 'Source-aligned'
    Consumer_aligned = 'Consumer-aligned'
    Aggregate = 'Aggregate'


class Domain(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(..., description='Unique ID of the Domain')
    domainType: DomainType = Field(..., description='Domain type')
    name: basic.EntityName = Field(..., description='A unique name of the Domain')
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    displayName: Optional[str] = Field(
        None,
        description="Name used for display purposes. Example 'Marketing', 'Payments', etc.",
    )
    description: basic.Markdown = Field(..., description='Description of the Domain.')
    style: Optional[basic.Style] = None
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    parent: Optional[entityReference.EntityReference] = Field(
        None,
        description="Parent domains. When 'null' or not set, indicates that this is the top level domain.",
    )
    children: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='Children domains or sub-domains.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Domain.'
    )
    experts: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='List of users who are experts in this Domain.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
