# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/lightdashConnection.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class LightdashType(Enum):
    Lightdash = 'Lightdash'


class LightdashConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[LightdashType] = Field(
        LightdashType.Lightdash, description='Service Type', title='Service Type'
    )
    hostPort: AnyUrl = Field(
        ...,
        description='Address for your running Lightdash instance',
        title='Host Port',
    )
    apiKey: CustomSecretStr = Field(
        ...,
        description='The personal access token you can generate in the Lightdash app under the user settings',
        title='API Key',
    )
    projectUUID: str = Field(
        ...,
        description='The Project UUID for your Lightdash instance',
        title='Project UUID',
    )
    spaceUUID: str = Field(
        ...,
        description='The Space UUID for your Lightdash instance',
        title='Space UUID',
    )
    proxyAuthentication: Optional[CustomSecretStr] = Field(
        None,
        description='Use if your Lightdash instance is behind a proxy like (Cloud IAP)',
        title='Proxy Authentication',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
