# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/couchbaseConnection.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr


class CouchbaseType(Enum):
    Couchbase = 'Couchbase'


class CouchbaseScheme(Enum):
    couchbase = 'couchbase'


class CouchbaseConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[CouchbaseType] = Field(
        CouchbaseType.Couchbase, description='Service Type', title='Service Type'
    )
    scheme: Optional[CouchbaseScheme] = Field(
        CouchbaseScheme.couchbase,
        description='Couchbase driver scheme options.',
        title='Connection Scheme',
    )
    bucket: Optional[str] = Field(
        None,
        description='Couchbase connection Bucket options.',
        title='Connection Bucket',
    )
    username: str = Field(
        ...,
        description='Username to connect to Couchbase. This user should have privileges to read all the metadata in Couchbase.',
        title='Username',
    )
    password: CustomSecretStr = Field(
        ..., description='Password to connect to Couchbase.', title='Password'
    )
    hostport: str = Field(
        ..., description='Hostname of the Couchbase service.', title='Hostport'
    )
