# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/sapHanaConnection.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class SapHanaType(Enum):
    SapHana = 'SapHana'


class SapHanaScheme(Enum):
    hana = 'hana'


class SqlConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    hostPort: str = Field(
        ..., description='Host and port of the Hana service.', title='Host and Port'
    )
    username: str = Field(
        ...,
        description='Username to connect to Hana. This user should have privileges to read all the metadata.',
        title='Username',
    )
    password: CustomSecretStr = Field(
        ..., description='Password to connect to Hana.', title='Password'
    )
    databaseSchema: Optional[str] = Field(
        None,
        description='Database Schema of the data source. This is an optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
        title='Database Schema',
    )
    database: Optional[str] = Field(
        None, description='Database of the data source.', title='Database'
    )


class HdbUserStoreConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    userKey: Optional[str] = Field(
        None,
        description='HDB Store User Key generated from the command `hdbuserstore SET <KEY> <host:port> <USERNAME> <PASSWORD>`',
        title='User Key',
    )


class SapHanaConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SapHanaType] = Field(
        SapHanaType.SapHana, description='Service Type', title='Service Type'
    )
    scheme: Optional[SapHanaScheme] = Field(
        SapHanaScheme.hana,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    connection: Union[SqlConnection, HdbUserStoreConnection] = Field(
        ...,
        description='Choose between Database connection or HDB User Store connection.',
        title='SAP Hana Connection',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
    sampleDataStorageConfig: Optional[
        connectionBasicType.SampleDataStorageConfig
    ] = Field(None, title='S3 Config for Sample Data')
