# generated by datamodel-codegen:
#   filename:  entity/services/connections/metadata/metadataESConnection.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from .....configuration import elasticSearchConfiguration
from .....system import eventPublisherJob
from .. import connectionBasicType


class MetadataESType(Enum):
    MetadataES = 'MetadataES'


class MetadataESConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[MetadataESType] = Field(
        MetadataESType.MetadataES, description='Service Type'
    )
    entities: Optional[List[str]] = Field(
        [
            'table',
            'topic',
            'dashboard',
            'pipeline',
            'mlmodel',
            'user',
            'team',
            'glossaryTerm',
            'tag',
            'entityReportData',
            'webAnalyticEntityViewReportData',
            'webAnalyticUserActivityReportData',
            'container',
            'query',
        ],
        description='List of entities that you need to reindex',
        title='Entities',
        unique_items=True,
    )
    recreateIndex: Optional[bool] = Field(True, title='Recreate Indexes')
    runMode: Optional[eventPublisherJob.RunMode] = None
    searchIndexMappingLanguage: Optional[
        elasticSearchConfiguration.SearchIndexMappingLanguage
    ] = Field(
        elasticSearchConfiguration.SearchIndexMappingLanguage.EN,
        description='Recreate Indexes with updated Language',
    )
    batchSize: Optional[int] = Field(
        100,
        description='Maximum number of events sentx in a batch (Default 10).',
        title='Batch Size',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
