# generated by datamodel-codegen:
#   filename:  analytics/reportDataType/aggregatedCostAnalysisReportData.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field


class DataAssetValues(BaseModel):
    class Config:
        extra = Extra.forbid

    threeDays: Optional[float] = Field(
        None, description='Data Asset Count or Size for 3 days'
    )
    sevenDays: Optional[float] = Field(
        None, description='Data Asset Count or Size for 7 days'
    )
    fourteenDays: Optional[float] = Field(
        None, description='Data Asset Count or Size for 14 days'
    )
    thirtyDays: Optional[float] = Field(
        None, description='Data Asset Count or Size for 30 days'
    )
    sixtyDays: Optional[float] = Field(
        None, description='Data Asset Count or Size for 60 days'
    )


class DataAssetMetrics(BaseModel):
    size: Optional[DataAssetValues] = Field(
        None, description='Size of the Data Assets over a period of time'
    )
    count: Optional[DataAssetValues] = Field(
        None, description='Count of the Data Assets over a period of time'
    )
    totalSize: Optional[float] = Field(None, description='Total Size based in Bytes')
    totalCount: Optional[float] = Field(None, description='Total Count')


class AggregatedCostAnalysisReportData(BaseModel):
    class Config:
        extra = Extra.forbid

    unusedDataAssets: Optional[DataAssetMetrics] = Field(
        None,
        description='Count and Size of the unused Data Assets over a period of time',
    )
    frequentlyUsedDataAssets: Optional[DataAssetMetrics] = Field(
        None,
        description='Count and Size of the frequently used Data Assets over a period of time',
    )
    totalSize: Optional[float] = Field(None, description='Total Size based in Bytes')
    totalCount: Optional[float] = Field(None, description='Total Count')
    serviceName: Optional[str] = Field(None, description='Name of the service')
    serviceType: Optional[str] = Field(None, description='Type of the service')
    entityType: Optional[str] = Field(None, description='Type of the entity')
    serviceOwner: Optional[str] = Field(None, description='Name of the service owner')
