# generated by datamodel-codegen:
#   filename:  api/data/createChart.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...entity.data import chart
from ...type import basic, entityReference, lifeCycle, tagLabel


class CreateChartRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(..., description='Name that identifies this Chart.')
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this Chart. It could be title or label from the source services',
    )
    description: Optional[basic.Markdown] = Field(
        None,
        description='Description of the chart instance. What it has and how to use it.',
    )
    chartType: Optional[chart.ChartType] = None
    sourceUrl: Optional[basic.SourceUrl] = Field(
        None, description='Chart URL suffix from its service.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this chart'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this chart'
    )
    service: basic.FullyQualifiedEntityName = Field(
        ..., description='Link to the chart service where this chart is hosted in'
    )
    domain: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='Fully qualified name of the domain the Chart belongs to.'
    )
    dataProducts: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified names of data products this entity is part of.',
    )
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )
