# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/qlikSenseConnection.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class QlikSenseType(Enum):
    QlikSense = 'QlikSense'


class QlikCertificatePath(BaseModel):
    clientCertificate: str = Field(
        ..., description='Client Certificate', title='Client Certificate Path'
    )
    clientKeyCertificate: str = Field(
        ..., description='Client Key Certificate.', title='Client Key Certificate'
    )
    rootCertificate: str = Field(
        ..., description='Root Certificate.', title='Root Certificate'
    )


class QlikCertificateValues(BaseModel):
    clientCertificateData: CustomSecretStr = Field(
        ..., description='Client Certificate', title='Client Certificate Value'
    )
    clientKeyCertificateData: CustomSecretStr = Field(
        ..., description='Client Key Certificate.', title='Client Key Certificate Value'
    )
    rootCertificateData: CustomSecretStr = Field(
        ..., description='Root Certificate.', title='Root Certificate Value'
    )
    stagingDir: str = Field(
        ..., description='Staging Directory Path', title='Staging Directory Path'
    )


class QlikSenseConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[QlikSenseType] = Field(
        QlikSenseType.QlikSense, description='Service Type', title='Service Type'
    )
    displayUrl: Optional[AnyUrl] = Field(
        None,
        description='Qlik Sense Base URL, used for genrating dashboard & chat url',
        title='Qlik Sense Base URL',
    )
    hostPort: AnyUrl = Field(
        ...,
        description='URL for the superset instance.',
        title='Qlik Engine JSON API Websocket URL',
    )
    certificates: Union[QlikCertificateValues, QlikCertificatePath]
    userDirectory: Optional[str] = Field(
        None, description='User Directory.', title='User Directory'
    )
    userId: Optional[str] = Field(None, description='User ID.', title='User ID')
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
