# generated by datamodel-codegen:
#   filename:  entity/services/connections/search/openSearchConnection.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from .. import connectionBasicType


class OpenSearchType(Enum):
    OpenSearch = 'OpenSearch'


class OpensearchConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[OpenSearchType] = Field(
        OpenSearchType.OpenSearch, description='Service Type', title='Service Type'
    )
    hostPort: str = Field(
        ...,
        description='Host and port of the OpenSearch service.',
        title='Host and Port',
    )
    scheme: Optional[str] = Field(None, description='Http/Https connection scheme')
    username: Optional[str] = Field(None, description='OpenSearch Username for Login')
    password: Optional[str] = Field(None, description='OpenSearch Password for Login')
    truststorePath: Optional[str] = Field(None, description='Truststore Path')
    truststorePassword: Optional[str] = Field(None, description='Truststore Password')
    connectionTimeoutSecs: Optional[int] = Field(
        5, description='Connection Timeout in Seconds'
    )
    socketTimeoutSecs: Optional[int] = Field(
        60, description='Socket Timeout in Seconds'
    )
    keepAliveTimeoutSecs: Optional[int] = Field(
        None, description='Keep Alive Timeout in Seconds'
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
