# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceMetadataPipeline.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ..type import filterPattern


class DatabaseMetadataConfigType(Enum):
    DatabaseMetadata = 'DatabaseMetadata'


class DatabaseServiceMetadataPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DatabaseMetadataConfigType] = Field(
        DatabaseMetadataConfigType.DatabaseMetadata, description='Pipeline type'
    )
    markDeletedTables: Optional[bool] = Field(
        True,
        description='This is an optional configuration for enabling soft deletion of tables. When this option is enabled, only tables that have been deleted from the source will be soft deleted, and this will apply solely to the schema that is currently being ingested via the pipeline. Any related entities such as test suites or lineage information that were associated with those tables will also be deleted.',
        title='Mark Deleted Tables',
    )
    markDeletedStoredProcedures: Optional[bool] = Field(
        True,
        description='Optional configuration to soft delete stored procedures in OpenMetadata if the source stored procedures are deleted. Also, if the stored procedures is deleted, all the associated entities like lineage, etc., with that stored procedures will be deleted',
        title='Mark Deleted Stored Procedures',
    )
    includeTables: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for tables.',
        title='Include Tables',
    )
    includeViews: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for views.',
        title='Include Views',
    )
    includeTags: Optional[bool] = Field(
        True,
        description='Optional configuration to toggle the tags ingestion.',
        title='Include Tags',
    )
    includeStoredProcedures: Optional[bool] = Field(
        True,
        description='Optional configuration to toggle the Stored Procedures ingestion.',
        title='Include Stored Procedures',
    )
    queryLogDuration: Optional[int] = Field(
        1,
        description='Configuration to tune how far we want to look back in query logs to process Stored Procedures results.',
        title='Query Log Duration',
    )
    queryParsingTimeoutLimit: Optional[int] = Field(
        300,
        description='Configuration to set the timeout for parsing the query in seconds.',
        title='Query Parsing Timeout Limit',
    )
    useFqnForFiltering: Optional[bool] = Field(
        False,
        description='Regex will be applied on fully qualified name (e.g service_name.db_name.schema_name.table_name) instead of raw name (e.g. table_name)',
        title='Use FQN For Filtering',
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
        title='Schema Filter Pattern',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex exclude tables or databases that matches the pattern.',
        title='Table Filter Pattern',
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch databases that matches the pattern.',
        title='Database Filter Pattern',
    )
