# generated by datamodel-codegen:
#   filename:  tests/basic.json
#   timestamp: 2024-01-30T14:23:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional

from pydantic import BaseModel, Extra, Field

from ..type import basic


class Basic(BaseModel):
    __root__: Any = Field(
        ...,
        description='This schema defines basic types that are used by other test schemas.',
        title='Basic',
    )


class TestSummary(BaseModel):
    success: Optional[int] = Field(
        None, description='Number of test cases that passed.'
    )
    failed: Optional[int] = Field(None, description='Number of test cases that failed.')
    aborted: Optional[int] = Field(
        None, description='Number of test cases that aborted.'
    )
    total: Optional[int] = Field(None, description='Total number of test cases.')


class TestResultValue(BaseModel):
    name: Optional[str] = Field(None, description='name of the value')
    value: Optional[str] = Field(None, description='test result value')


class TestCaseStatus(Enum):
    Success = 'Success'
    Failed = 'Failed'
    Aborted = 'Aborted'


class TestCaseFailureStatusType(Enum):
    Ack = 'Ack'
    New = 'New'
    Resolved = 'Resolved'


class TestCaseFailureReason(Enum):
    FalsePositive = 'FalsePositive'
    MissingData = 'MissingData'
    Duplicates = 'Duplicates'
    OutOfBounds = 'OutOfBounds'
    Other = 'Other'


class TestSuiteExecutionFrequency(Enum):
    Hourly = 'Hourly'
    Daily = 'Daily'
    Weekly = 'Weekly'


class TestCaseFailureStatus(BaseModel):
    testCaseFailureStatusType: Optional[TestCaseFailureStatusType] = Field(
        None, description='Status of Test Case Acknowledgement.'
    )
    testCaseFailureReason: Optional[TestCaseFailureReason] = Field(
        None, description='Reason of Test Case resolution.'
    )
    testCaseFailureComment: Optional[str] = Field(
        None, description='Test case failure resolution comment.'
    )
    updatedBy: Optional[str] = Field(
        None, description='User who updated the test case failure status.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None, description='Time when test case failure status was updated.'
    )


class TestCaseResult(BaseModel):
    class Config:
        extra = Extra.forbid

    timestamp: Optional[basic.Timestamp] = Field(
        None, description='Data one which test case result is taken.'
    )
    testCaseStatus: Optional[TestCaseStatus] = Field(
        None, description='Status of Test Case run.'
    )
    result: Optional[str] = Field(None, description='Details of test case results.')
    sampleData: Optional[str] = Field(
        None,
        description="sample data to capture rows/columns that didn't match the expressed testcase.",
    )
    testResultValue: Optional[List[TestResultValue]] = None
    testCaseFailureStatus: Optional[TestCaseFailureStatus] = Field(
        None, description='Schema to capture test case result.'
    )
