"""
Copyright (c) Microsoft Corporation.
Licensed under the MIT license.
This module contains the constants used in the DDBC module.
"""

from enum import Enum


class ConstantsDDBC(Enum):
    """
    Constants used in the DDBC module.
    """
    SQL_HANDLE_ENV = 1
    SQL_HANDLE_DBC = 2
    SQL_HANDLE_STMT = 3
    SQL_SUCCESS = 0
    SQL_SUCCESS_WITH_INFO = 1
    SQL_NO_DATA = 100
    SQL_STILL_EXECUTING = 2
    SQL_NTS = -3
    SQL_DRIVER_NOPROMPT = 0
    SQL_ATTR_ASYNC_DBC_EVENT = 119
    SQL_IS_INTEGER = -6
    SQL_ATTR_ASYNC_DBC_FUNCTIONS_ENABLE = 117
    SQL_OV_DDBC3_80 = 380
    SQL_ATTR_DDBC_VERSION = 200
    SQL_ATTR_ASYNC_ENABLE = 4
    SQL_ATTR_ASYNC_STMT_EVENT = 29
    SQL_ERROR = -1
    SQL_INVALID_HANDLE = -2
    SQL_NULL_HANDLE = 0
    SQL_OV_DDBC3 = 3
    SQL_COMMIT = 0
    SQL_ROLLBACK = 1
    SQL_ATTR_AUTOCOMMIT = 102
    SQL_SMALLINT = 5
    SQL_CHAR = 1
    SQL_WCHAR = -8
    SQL_WVARCHAR = -9
    SQL_BIT = -7
    SQL_TINYINT = -6
    SQL_BIGINT = -5
    SQL_BINARY = -2
    SQL_VARBINARY = -3
    SQL_LONGVARBINARY = -4
    SQL_LONGVARCHAR = -1
    SQL_UNKNOWN_TYPE = 0
    SQL_NUMERIC = 2
    SQL_DECIMAL = 3
    SQL_INTEGER = 4
    SQL_FLOAT = 6
    SQL_REAL = 7
    SQL_DOUBLE = 8
    SQL_DATETIME = 9
    SQL_INTERVAL = 10
    SQL_TIMESTAMP = 11
    SQL_DATE = 9
    SQL_TIME = 10
    SQL_VARCHAR = 12
    SQL_TYPE_DATE = 91
    SQL_TYPE_TIME = 92
    SQL_TYPE_TIMESTAMP = 93
    SQL_TYPE_TIMESTAMP_WITH_TIMEZONE = 95
    SQL_GUID = -11
    SQL_XML = 241
    SQL_SMALLDATETIME = 58
    SQL_TIMESTAMPOFFSET = 43
    SQL_DATETIME2 = 42
    SQL_SMALLMONEY = 122
    SQL_MONEY = 60
    SQL_WLONGVARCHAR = -10
    SQL_C_BIT = -7
    SQL_C_TINYINT = -6
    SQL_C_SBIGINT = -25
    SQL_C_BINARY = -2
    SQL_AUTOCOMMIT_ON = 1
    SQL_AUTOCOMMIT_OFF = 0
    SQL_C_VARBINARY = -3
    SQL_C_LONGVARBINARY = -4
    SQL_C_LONGVARCHAR = -1
    SQL_C_CHAR = -8
    SQL_C_NUMERIC = 2
    SQL_C_DECIMAL = 3
    SQL_C_LONG = 4
    SQL_C_SHORT = 5
    SQL_C_FLOAT = 7
    SQL_C_DOUBLE = 8
    SQL_C_TYPE_DATE = 91
    SQL_C_TYPE_TIME = 92
    SQL_C_TYPE_TIMESTAMP = 93
    SQL_C_TYPE_TIMESTAMP_WITH_TIMEZONE = 95
    SQL_C_GUID = -11
    SQL_DESC_TYPE = 2
    SQL_DESC_LENGTH = 3
    SQL_DESC_NAME = 4
    SQL_ATTR_ROW_ARRAY_SIZE = 27
    SQL_ATTR_ROWS_FETCHED_PTR = 26
    SQL_ATTR_ROW_STATUS_PTR = 25
    SQL_FETCH_NEXT = 1
    SQL_ROW_SUCCESS = 0
    SQL_ROW_SUCCESS_WITH_INFO = 1
    SQL_ROW_NOROW = 100
    SQL_ATTR_CURSOR_TYPE = 6
    SQL_CURSOR_FORWARD_ONLY = 0
    SQL_CURSOR_STATIC = 3
    SQL_CURSOR_KEYSET_DRIVEN = 2
    SQL_CURSOR_DYNAMIC = 3
    SQL_NULL_DATA = -1
    SQL_C_DEFAULT = 99
    SQL_ATTR_ROW_BIND_TYPE = 5
    SQL_BIND_BY_COLUMN = 0
    SQL_PARAM_INPUT = 1
    SQL_PARAM_OUTPUT = 2
    SQL_PARAM_INPUT_OUTPUT = 3
    SQL_C_WCHAR = -8
    SQL_NULLABLE = 1
    SQL_MAX_NUMERIC_LEN = 16

class AuthType(Enum):
    """Constants for authentication types"""
    INTERACTIVE = "activedirectoryinteractive"
    DEVICE_CODE = "activedirectorydevicecode"
    DEFAULT = "activedirectorydefault"