"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeployment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const ecs_appspec_1 = require("../ecs-appspec");
const ecs_deployment_provider_1 = require("../ecs-deployment-provider");
/**
 * A CodeDeploy Deployment for a Amazon ECS service DeploymentGroup. An EcsDeploymentGroup
 * must only have 1 EcsDeployment. This limit is enforced by removing the scope and id
 * from the constructor. The scope will always be set to the EcsDeploymentGroup
 * and the id will always be set to the string 'Deployment' to force an error if mulitiple
 * EcsDeployment constructs are created for a single EcsDeploymentGroup.
 */
class EcsDeployment extends constructs_1.Construct {
    constructor(props) {
        super(props.deploymentGroup, 'Deployment');
        const ecsDeploymentProvider = new ecs_deployment_provider_1.EcsDeploymentProvider(this, 'DeploymentProvider', {
            deploymentGroup: props.deploymentGroup,
            timeout: props.timeout || cdk.Duration.minutes(30),
        });
        let autoRollbackConfigurationEvents = undefined;
        let autoRollbackConfigurationEnabled = undefined;
        if (props.autoRollback) {
            let events = [];
            if (props.autoRollback.deploymentInAlarm) {
                events.push('DEPLOYMENT_STOP_ON_ALARM');
            }
            if (props.autoRollback.failedDeployment) {
                events.push('DEPLOYMENT_FAILURE');
            }
            if (props.autoRollback.stoppedDeployment) {
                events.push('DEPLOYMENT_STOP_ON_REQUEST');
            }
            if (events.length > 0) {
                autoRollbackConfigurationEnabled = 'true';
                autoRollbackConfigurationEvents = events.join(',');
            }
            else {
                autoRollbackConfigurationEnabled = 'false';
            }
        }
        const appspec = new ecs_appspec_1.EcsAppSpec(props.targetService, props.hooks);
        const deployment = new cdk.CustomResource(this, 'Resource', {
            serviceToken: ecsDeploymentProvider.serviceToken,
            resourceType: 'Custom::EcsDeployment',
            properties: {
                applicationName: props.deploymentGroup.application.applicationName,
                deploymentConfigName: props.deploymentGroup.deploymentConfig.deploymentConfigName,
                deploymentGroupName: props.deploymentGroup.deploymentGroupName,
                autoRollbackConfigurationEnabled,
                autoRollbackConfigurationEvents,
                description: props.description,
                revisionAppSpecContent: appspec.toString(),
            },
        });
        this.deploymentId = deployment.getAttString('deploymentId');
    }
}
exports.EcsDeployment = EcsDeployment;
_a = JSII_RTTI_SYMBOL_1;
EcsDeployment[_a] = { fqn: "@cdklabs/cdk-ecs-codedeploy.EcsDeployment", version: "0.0.352" };
//# sourceMappingURL=data:application/json;base64,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