import { CodeDeployServiceException as __BaseException } from "./CodeDeployServiceException";
export class InstanceLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "InstanceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "InstanceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InstanceLimitExceededException.prototype);
    }
}
export class InstanceNameRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "InstanceNameRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "InstanceNameRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InstanceNameRequiredException.prototype);
    }
}
export class InstanceNotRegisteredException extends __BaseException {
    constructor(opts) {
        super({
            name: "InstanceNotRegisteredException",
            $fault: "client",
            ...opts,
        });
        this.name = "InstanceNotRegisteredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InstanceNotRegisteredException.prototype);
    }
}
export class InvalidInstanceNameException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInstanceNameException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceNameException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceNameException.prototype);
    }
}
export class InvalidTagException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTagException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTagException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTagException.prototype);
    }
}
export class TagLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "TagLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "TagLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TagLimitExceededException.prototype);
    }
}
export class TagRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "TagRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "TagRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TagRequiredException.prototype);
    }
}
export class AlarmsLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "AlarmsLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "AlarmsLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AlarmsLimitExceededException.prototype);
    }
}
export class ApplicationAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "ApplicationAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "ApplicationAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ApplicationAlreadyExistsException.prototype);
    }
}
export class ApplicationDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "ApplicationDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "ApplicationDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ApplicationDoesNotExistException.prototype);
    }
}
export const ComputePlatform = {
    ECS: "ECS",
    LAMBDA: "Lambda",
    SERVER: "Server",
};
export class ApplicationLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ApplicationLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ApplicationLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ApplicationLimitExceededException.prototype);
    }
}
export class ApplicationNameRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "ApplicationNameRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "ApplicationNameRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ApplicationNameRequiredException.prototype);
    }
}
export const ApplicationRevisionSortBy = {
    FirstUsedTime: "firstUsedTime",
    LastUsedTime: "lastUsedTime",
    RegisterTime: "registerTime",
};
export class ArnNotSupportedException extends __BaseException {
    constructor(opts) {
        super({
            name: "ArnNotSupportedException",
            $fault: "client",
            ...opts,
        });
        this.name = "ArnNotSupportedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ArnNotSupportedException.prototype);
    }
}
export const AutoRollbackEvent = {
    DEPLOYMENT_FAILURE: "DEPLOYMENT_FAILURE",
    DEPLOYMENT_STOP_ON_ALARM: "DEPLOYMENT_STOP_ON_ALARM",
    DEPLOYMENT_STOP_ON_REQUEST: "DEPLOYMENT_STOP_ON_REQUEST",
};
export const RevisionLocationType = {
    AppSpecContent: "AppSpecContent",
    GitHub: "GitHub",
    S3: "S3",
    String: "String",
};
export const BundleType = {
    JSON: "JSON",
    Tar: "tar",
    TarGZip: "tgz",
    YAML: "YAML",
    Zip: "zip",
};
export class BatchLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "BatchLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "BatchLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, BatchLimitExceededException.prototype);
    }
}
export class InvalidApplicationNameException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidApplicationNameException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidApplicationNameException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidApplicationNameException.prototype);
    }
}
export class InvalidRevisionException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidRevisionException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidRevisionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidRevisionException.prototype);
    }
}
export class RevisionRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "RevisionRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "RevisionRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, RevisionRequiredException.prototype);
    }
}
export const DeploymentReadyAction = {
    CONTINUE_DEPLOYMENT: "CONTINUE_DEPLOYMENT",
    STOP_DEPLOYMENT: "STOP_DEPLOYMENT",
};
export const GreenFleetProvisioningAction = {
    COPY_AUTO_SCALING_GROUP: "COPY_AUTO_SCALING_GROUP",
    DISCOVER_EXISTING: "DISCOVER_EXISTING",
};
export const InstanceAction = {
    KEEP_ALIVE: "KEEP_ALIVE",
    TERMINATE: "TERMINATE",
};
export const DeploymentOption = {
    WITHOUT_TRAFFIC_CONTROL: "WITHOUT_TRAFFIC_CONTROL",
    WITH_TRAFFIC_CONTROL: "WITH_TRAFFIC_CONTROL",
};
export const DeploymentType = {
    BLUE_GREEN: "BLUE_GREEN",
    IN_PLACE: "IN_PLACE",
};
export const EC2TagFilterType = {
    KEY_AND_VALUE: "KEY_AND_VALUE",
    KEY_ONLY: "KEY_ONLY",
    VALUE_ONLY: "VALUE_ONLY",
};
export const DeploymentStatus = {
    BAKING: "Baking",
    CREATED: "Created",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    QUEUED: "Queued",
    READY: "Ready",
    STOPPED: "Stopped",
    SUCCEEDED: "Succeeded",
};
export const TagFilterType = {
    KEY_AND_VALUE: "KEY_AND_VALUE",
    KEY_ONLY: "KEY_ONLY",
    VALUE_ONLY: "VALUE_ONLY",
};
export const OutdatedInstancesStrategy = {
    Ignore: "IGNORE",
    Update: "UPDATE",
};
export const TriggerEventType = {
    DEPLOYMENT_FAILURE: "DeploymentFailure",
    DEPLOYMENT_READY: "DeploymentReady",
    DEPLOYMENT_ROLLBACK: "DeploymentRollback",
    DEPLOYMENT_START: "DeploymentStart",
    DEPLOYMENT_STOP: "DeploymentStop",
    DEPLOYMENT_SUCCESS: "DeploymentSuccess",
    INSTANCE_FAILURE: "InstanceFailure",
    INSTANCE_READY: "InstanceReady",
    INSTANCE_START: "InstanceStart",
    INSTANCE_SUCCESS: "InstanceSuccess",
};
export class DeploymentConfigDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentConfigDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentConfigDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentConfigDoesNotExistException.prototype);
    }
}
export class DeploymentGroupNameRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentGroupNameRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentGroupNameRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentGroupNameRequiredException.prototype);
    }
}
export class InvalidDeploymentGroupNameException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeploymentGroupNameException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeploymentGroupNameException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeploymentGroupNameException.prototype);
    }
}
export const _InstanceType = {
    BLUE: "Blue",
    GREEN: "Green",
};
export const LifecycleErrorCode = {
    SCRIPT_FAILED: "ScriptFailed",
    SCRIPT_MISSING: "ScriptMissing",
    SCRIPT_NOT_EXECUTABLE: "ScriptNotExecutable",
    SCRIPT_TIMED_OUT: "ScriptTimedOut",
    SUCCESS: "Success",
    UNKNOWN_ERROR: "UnknownError",
};
export const LifecycleEventStatus = {
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    SKIPPED: "Skipped",
    SUCCEEDED: "Succeeded",
    UNKNOWN: "Unknown",
};
export const InstanceStatus = {
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    READY: "Ready",
    SKIPPED: "Skipped",
    SUCCEEDED: "Succeeded",
    UNKNOWN: "Unknown",
};
export class DeploymentDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentDoesNotExistException.prototype);
    }
}
export class DeploymentIdRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentIdRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentIdRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentIdRequiredException.prototype);
    }
}
export class InstanceIdRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "InstanceIdRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "InstanceIdRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InstanceIdRequiredException.prototype);
    }
}
export class InvalidComputePlatformException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidComputePlatformException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidComputePlatformException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidComputePlatformException.prototype);
    }
}
export class InvalidDeploymentIdException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeploymentIdException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeploymentIdException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeploymentIdException.prototype);
    }
}
export const DeploymentCreator = {
    Autoscaling: "autoscaling",
    AutoscalingTermination: "autoscalingTermination",
    CloudFormation: "CloudFormation",
    CloudFormationRollback: "CloudFormationRollback",
    CodeDeploy: "CodeDeploy",
    CodeDeployAutoUpdate: "CodeDeployAutoUpdate",
    CodeDeployRollback: "codeDeployRollback",
    User: "user",
};
export const ErrorCode = {
    AGENT_ISSUE: "AGENT_ISSUE",
    ALARM_ACTIVE: "ALARM_ACTIVE",
    APPLICATION_MISSING: "APPLICATION_MISSING",
    AUTOSCALING_VALIDATION_ERROR: "AUTOSCALING_VALIDATION_ERROR",
    AUTO_SCALING_CONFIGURATION: "AUTO_SCALING_CONFIGURATION",
    AUTO_SCALING_IAM_ROLE_PERMISSIONS: "AUTO_SCALING_IAM_ROLE_PERMISSIONS",
    CLOUDFORMATION_STACK_FAILURE: "CLOUDFORMATION_STACK_FAILURE",
    CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND: "CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND",
    CUSTOMER_APPLICATION_UNHEALTHY: "CUSTOMER_APPLICATION_UNHEALTHY",
    DEPLOYMENT_GROUP_MISSING: "DEPLOYMENT_GROUP_MISSING",
    ECS_UPDATE_ERROR: "ECS_UPDATE_ERROR",
    ELASTIC_LOAD_BALANCING_INVALID: "ELASTIC_LOAD_BALANCING_INVALID",
    ELB_INVALID_INSTANCE: "ELB_INVALID_INSTANCE",
    HEALTH_CONSTRAINTS: "HEALTH_CONSTRAINTS",
    HEALTH_CONSTRAINTS_INVALID: "HEALTH_CONSTRAINTS_INVALID",
    HOOK_EXECUTION_FAILURE: "HOOK_EXECUTION_FAILURE",
    IAM_ROLE_MISSING: "IAM_ROLE_MISSING",
    IAM_ROLE_PERMISSIONS: "IAM_ROLE_PERMISSIONS",
    INTERNAL_ERROR: "INTERNAL_ERROR",
    INVALID_ECS_SERVICE: "INVALID_ECS_SERVICE",
    INVALID_LAMBDA_CONFIGURATION: "INVALID_LAMBDA_CONFIGURATION",
    INVALID_LAMBDA_FUNCTION: "INVALID_LAMBDA_FUNCTION",
    INVALID_REVISION: "INVALID_REVISION",
    MANUAL_STOP: "MANUAL_STOP",
    MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION: "MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION",
    MISSING_ELB_INFORMATION: "MISSING_ELB_INFORMATION",
    MISSING_GITHUB_TOKEN: "MISSING_GITHUB_TOKEN",
    NO_EC2_SUBSCRIPTION: "NO_EC2_SUBSCRIPTION",
    NO_INSTANCES: "NO_INSTANCES",
    OVER_MAX_INSTANCES: "OVER_MAX_INSTANCES",
    RESOURCE_LIMIT_EXCEEDED: "RESOURCE_LIMIT_EXCEEDED",
    REVISION_MISSING: "REVISION_MISSING",
    THROTTLED: "THROTTLED",
    TIMEOUT: "TIMEOUT",
};
export const FileExistsBehavior = {
    DISALLOW: "DISALLOW",
    OVERWRITE: "OVERWRITE",
    RETAIN: "RETAIN",
};
export const TargetStatus = {
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    READY: "Ready",
    SKIPPED: "Skipped",
    SUCCEEDED: "Succeeded",
    UNKNOWN: "Unknown",
};
export const DeploymentTargetType = {
    CLOUDFORMATION_TARGET: "CloudFormationTarget",
    ECS_TARGET: "ECSTarget",
    INSTANCE_TARGET: "InstanceTarget",
    LAMBDA_TARGET: "LambdaTarget",
};
export const TargetLabel = {
    BLUE: "Blue",
    GREEN: "Green",
};
export class DeploymentNotStartedException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentNotStartedException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentNotStartedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentNotStartedException.prototype);
    }
}
export class DeploymentTargetDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentTargetDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentTargetDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentTargetDoesNotExistException.prototype);
    }
}
export class DeploymentTargetIdRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentTargetIdRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentTargetIdRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentTargetIdRequiredException.prototype);
    }
}
export class DeploymentTargetListSizeExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentTargetListSizeExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentTargetListSizeExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentTargetListSizeExceededException.prototype);
    }
}
export class InstanceDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "InstanceDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "InstanceDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InstanceDoesNotExistException.prototype);
    }
}
export class InvalidDeploymentTargetIdException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeploymentTargetIdException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeploymentTargetIdException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeploymentTargetIdException.prototype);
    }
}
export class BucketNameFilterRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "BucketNameFilterRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "BucketNameFilterRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, BucketNameFilterRequiredException.prototype);
    }
}
export const DeploymentWaitType = {
    READY_WAIT: "READY_WAIT",
    TERMINATION_WAIT: "TERMINATION_WAIT",
};
export class DeploymentAlreadyCompletedException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentAlreadyCompletedException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentAlreadyCompletedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentAlreadyCompletedException.prototype);
    }
}
export class DeploymentIsNotInReadyStateException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentIsNotInReadyStateException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentIsNotInReadyStateException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentIsNotInReadyStateException.prototype);
    }
}
export class InvalidDeploymentStatusException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeploymentStatusException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeploymentStatusException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeploymentStatusException.prototype);
    }
}
export class InvalidDeploymentWaitTypeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeploymentWaitTypeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeploymentWaitTypeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeploymentWaitTypeException.prototype);
    }
}
export class UnsupportedActionForDeploymentTypeException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedActionForDeploymentTypeException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedActionForDeploymentTypeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedActionForDeploymentTypeException.prototype);
    }
}
export class InvalidTagsToAddException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTagsToAddException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTagsToAddException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTagsToAddException.prototype);
    }
}
export class DeploymentGroupDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentGroupDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentGroupDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentGroupDoesNotExistException.prototype);
    }
}
export class DeploymentLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentLimitExceededException.prototype);
    }
}
export class DescriptionTooLongException extends __BaseException {
    constructor(opts) {
        super({
            name: "DescriptionTooLongException",
            $fault: "client",
            ...opts,
        });
        this.name = "DescriptionTooLongException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DescriptionTooLongException.prototype);
    }
}
export class InvalidAlarmConfigException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAlarmConfigException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAlarmConfigException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAlarmConfigException.prototype);
    }
}
export class InvalidAutoRollbackConfigException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAutoRollbackConfigException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAutoRollbackConfigException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAutoRollbackConfigException.prototype);
    }
}
export class InvalidAutoScalingGroupException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAutoScalingGroupException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAutoScalingGroupException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAutoScalingGroupException.prototype);
    }
}
export class InvalidDeploymentConfigNameException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeploymentConfigNameException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeploymentConfigNameException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeploymentConfigNameException.prototype);
    }
}
export class InvalidFileExistsBehaviorException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidFileExistsBehaviorException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFileExistsBehaviorException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFileExistsBehaviorException.prototype);
    }
}
export class InvalidGitHubAccountTokenException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidGitHubAccountTokenException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidGitHubAccountTokenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidGitHubAccountTokenException.prototype);
    }
}
export class InvalidIgnoreApplicationStopFailuresValueException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidIgnoreApplicationStopFailuresValueException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidIgnoreApplicationStopFailuresValueException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidIgnoreApplicationStopFailuresValueException.prototype);
    }
}
export class InvalidLoadBalancerInfoException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidLoadBalancerInfoException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidLoadBalancerInfoException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidLoadBalancerInfoException.prototype);
    }
}
export class InvalidRoleException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidRoleException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidRoleException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidRoleException.prototype);
    }
}
export class InvalidTargetInstancesException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTargetInstancesException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTargetInstancesException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTargetInstancesException.prototype);
    }
}
export class InvalidTrafficRoutingConfigurationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTrafficRoutingConfigurationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTrafficRoutingConfigurationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTrafficRoutingConfigurationException.prototype);
    }
}
export class InvalidUpdateOutdatedInstancesOnlyValueException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidUpdateOutdatedInstancesOnlyValueException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidUpdateOutdatedInstancesOnlyValueException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidUpdateOutdatedInstancesOnlyValueException.prototype);
    }
}
export class RevisionDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "RevisionDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "RevisionDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, RevisionDoesNotExistException.prototype);
    }
}
export class ThrottlingException extends __BaseException {
    constructor(opts) {
        super({
            name: "ThrottlingException",
            $fault: "client",
            ...opts,
        });
        this.name = "ThrottlingException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ThrottlingException.prototype);
    }
}
export const MinimumHealthyHostsType = {
    FLEET_PERCENT: "FLEET_PERCENT",
    HOST_COUNT: "HOST_COUNT",
};
export const TrafficRoutingType = {
    AllAtOnce: "AllAtOnce",
    TimeBasedCanary: "TimeBasedCanary",
    TimeBasedLinear: "TimeBasedLinear",
};
export const MinimumHealthyHostsPerZoneType = {
    FLEET_PERCENT: "FLEET_PERCENT",
    HOST_COUNT: "HOST_COUNT",
};
export class DeploymentConfigAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentConfigAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentConfigAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentConfigAlreadyExistsException.prototype);
    }
}
export class DeploymentConfigLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentConfigLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentConfigLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentConfigLimitExceededException.prototype);
    }
}
export class DeploymentConfigNameRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentConfigNameRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentConfigNameRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentConfigNameRequiredException.prototype);
    }
}
export class InvalidMinimumHealthyHostValueException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidMinimumHealthyHostValueException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidMinimumHealthyHostValueException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidMinimumHealthyHostValueException.prototype);
    }
}
export class InvalidZonalDeploymentConfigurationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidZonalDeploymentConfigurationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidZonalDeploymentConfigurationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidZonalDeploymentConfigurationException.prototype);
    }
}
export class DeploymentGroupAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentGroupAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentGroupAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentGroupAlreadyExistsException.prototype);
    }
}
export class DeploymentGroupLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentGroupLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentGroupLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentGroupLimitExceededException.prototype);
    }
}
export class ECSServiceMappingLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ECSServiceMappingLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ECSServiceMappingLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ECSServiceMappingLimitExceededException.prototype);
    }
}
export class InvalidBlueGreenDeploymentConfigurationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidBlueGreenDeploymentConfigurationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidBlueGreenDeploymentConfigurationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidBlueGreenDeploymentConfigurationException.prototype);
    }
}
export class InvalidDeploymentStyleException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeploymentStyleException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeploymentStyleException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeploymentStyleException.prototype);
    }
}
export class InvalidEC2TagCombinationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidEC2TagCombinationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidEC2TagCombinationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidEC2TagCombinationException.prototype);
    }
}
export class InvalidEC2TagException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidEC2TagException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidEC2TagException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidEC2TagException.prototype);
    }
}
export class InvalidECSServiceException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidECSServiceException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidECSServiceException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidECSServiceException.prototype);
    }
}
export class InvalidInputException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInputException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInputException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInputException.prototype);
    }
}
export class InvalidOnPremisesTagCombinationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidOnPremisesTagCombinationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOnPremisesTagCombinationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOnPremisesTagCombinationException.prototype);
    }
}
export class InvalidTargetGroupPairException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTargetGroupPairException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTargetGroupPairException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTargetGroupPairException.prototype);
    }
}
export class InvalidTriggerConfigException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTriggerConfigException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTriggerConfigException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTriggerConfigException.prototype);
    }
}
export class LifecycleHookLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "LifecycleHookLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "LifecycleHookLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, LifecycleHookLimitExceededException.prototype);
    }
}
export class RoleRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "RoleRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "RoleRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, RoleRequiredException.prototype);
    }
}
export class TagSetListLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "TagSetListLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "TagSetListLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TagSetListLimitExceededException.prototype);
    }
}
export class TriggerTargetsLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "TriggerTargetsLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "TriggerTargetsLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TriggerTargetsLimitExceededException.prototype);
    }
}
export class DeploymentConfigInUseException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeploymentConfigInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeploymentConfigInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeploymentConfigInUseException.prototype);
    }
}
export class InvalidOperationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidOperationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOperationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOperationException.prototype);
    }
}
export class GitHubAccountTokenDoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "GitHubAccountTokenDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "GitHubAccountTokenDoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, GitHubAccountTokenDoesNotExistException.prototype);
    }
}
export class GitHubAccountTokenNameRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "GitHubAccountTokenNameRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "GitHubAccountTokenNameRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, GitHubAccountTokenNameRequiredException.prototype);
    }
}
export class InvalidGitHubAccountTokenNameException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidGitHubAccountTokenNameException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidGitHubAccountTokenNameException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidGitHubAccountTokenNameException.prototype);
    }
}
export class OperationNotSupportedException extends __BaseException {
    constructor(opts) {
        super({
            name: "OperationNotSupportedException",
            $fault: "client",
            ...opts,
        });
        this.name = "OperationNotSupportedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OperationNotSupportedException.prototype);
    }
}
export class ResourceValidationException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceValidationException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceValidationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceValidationException.prototype);
    }
}
export class InvalidBucketNameFilterException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidBucketNameFilterException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidBucketNameFilterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidBucketNameFilterException.prototype);
    }
}
export class InvalidDeployedStateFilterException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeployedStateFilterException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeployedStateFilterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeployedStateFilterException.prototype);
    }
}
export class InvalidKeyPrefixFilterException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidKeyPrefixFilterException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidKeyPrefixFilterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidKeyPrefixFilterException.prototype);
    }
}
export class InvalidNextTokenException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidNextTokenException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidNextTokenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidNextTokenException.prototype);
    }
}
export class InvalidSortByException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidSortByException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidSortByException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidSortByException.prototype);
    }
}
export class InvalidSortOrderException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidSortOrderException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidSortOrderException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidSortOrderException.prototype);
    }
}
export const ListStateFilterAction = {
    Exclude: "exclude",
    Ignore: "ignore",
    Include: "include",
};
export const SortOrder = {
    Ascending: "ascending",
    Descending: "descending",
};
export class InvalidDeploymentInstanceTypeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeploymentInstanceTypeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeploymentInstanceTypeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeploymentInstanceTypeException.prototype);
    }
}
export class InvalidInstanceStatusException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInstanceStatusException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceStatusException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceStatusException.prototype);
    }
}
export class InvalidInstanceTypeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInstanceTypeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceTypeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceTypeException.prototype);
    }
}
export class InvalidTargetFilterNameException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTargetFilterNameException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTargetFilterNameException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTargetFilterNameException.prototype);
    }
}
export class InvalidExternalIdException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidExternalIdException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidExternalIdException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidExternalIdException.prototype);
    }
}
export class InvalidTimeRangeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTimeRangeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTimeRangeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTimeRangeException.prototype);
    }
}
export const TargetFilterName = {
    SERVER_INSTANCE_LABEL: "ServerInstanceLabel",
    TARGET_STATUS: "TargetStatus",
};
export class InvalidRegistrationStatusException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidRegistrationStatusException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidRegistrationStatusException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidRegistrationStatusException.prototype);
    }
}
export class InvalidTagFilterException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTagFilterException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTagFilterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTagFilterException.prototype);
    }
}
export const RegistrationStatus = {
    Deregistered: "Deregistered",
    Registered: "Registered",
};
export class InvalidArnException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidArnException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidArnException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidArnException.prototype);
    }
}
export class ResourceArnRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceArnRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceArnRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceArnRequiredException.prototype);
    }
}
export class InvalidLifecycleEventHookExecutionIdException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidLifecycleEventHookExecutionIdException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidLifecycleEventHookExecutionIdException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidLifecycleEventHookExecutionIdException.prototype);
    }
}
export class InvalidLifecycleEventHookExecutionStatusException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidLifecycleEventHookExecutionStatusException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidLifecycleEventHookExecutionStatusException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidLifecycleEventHookExecutionStatusException.prototype);
    }
}
export class LifecycleEventAlreadyCompletedException extends __BaseException {
    constructor(opts) {
        super({
            name: "LifecycleEventAlreadyCompletedException",
            $fault: "client",
            ...opts,
        });
        this.name = "LifecycleEventAlreadyCompletedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, LifecycleEventAlreadyCompletedException.prototype);
    }
}
export class IamArnRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "IamArnRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "IamArnRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, IamArnRequiredException.prototype);
    }
}
export class IamSessionArnAlreadyRegisteredException extends __BaseException {
    constructor(opts) {
        super({
            name: "IamSessionArnAlreadyRegisteredException",
            $fault: "client",
            ...opts,
        });
        this.name = "IamSessionArnAlreadyRegisteredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, IamSessionArnAlreadyRegisteredException.prototype);
    }
}
export class IamUserArnAlreadyRegisteredException extends __BaseException {
    constructor(opts) {
        super({
            name: "IamUserArnAlreadyRegisteredException",
            $fault: "client",
            ...opts,
        });
        this.name = "IamUserArnAlreadyRegisteredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, IamUserArnAlreadyRegisteredException.prototype);
    }
}
export class IamUserArnRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "IamUserArnRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "IamUserArnRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, IamUserArnRequiredException.prototype);
    }
}
export class InstanceNameAlreadyRegisteredException extends __BaseException {
    constructor(opts) {
        super({
            name: "InstanceNameAlreadyRegisteredException",
            $fault: "client",
            ...opts,
        });
        this.name = "InstanceNameAlreadyRegisteredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InstanceNameAlreadyRegisteredException.prototype);
    }
}
export class InvalidIamSessionArnException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidIamSessionArnException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidIamSessionArnException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidIamSessionArnException.prototype);
    }
}
export class InvalidIamUserArnException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidIamUserArnException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidIamUserArnException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidIamUserArnException.prototype);
    }
}
export class MultipleIamArnsProvidedException extends __BaseException {
    constructor(opts) {
        super({
            name: "MultipleIamArnsProvidedException",
            $fault: "client",
            ...opts,
        });
        this.name = "MultipleIamArnsProvidedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, MultipleIamArnsProvidedException.prototype);
    }
}
export const StopStatus = {
    PENDING: "Pending",
    SUCCEEDED: "Succeeded",
};
