"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventbridgeToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("aws-cdk-lib/aws-events");
const defaults = require("@aws-solutions-constructs/core");
const iam = require("aws-cdk-lib/aws-iam");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const core_1 = require("@aws-solutions-constructs/core");
class EventbridgeToLambda extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the EventbridgeToLambda class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {EventbridgeToLambdaProps} props - user provided props for the construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckLambdaProps(props);
        defaults.CheckEventBridgeProps(props);
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps
        });
        const lambdaFunc = {
            bind: () => ({
                id: '',
                arn: this.lambdaFunction.functionArn
            })
        };
        // build an event bus if existingEventBus is provided or eventBusProps are provided
        this.eventBus = defaults.buildEventBus(this, {
            existingEventBusInterface: props.existingEventBusInterface,
            eventBusProps: props.eventBusProps
        });
        const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([lambdaFunc], this.eventBus);
        const eventsRuleProps = (0, core_1.overrideProps)(defaultEventsRuleProps, props.eventRuleProps, true);
        this.eventsRule = new events.Rule(this, 'EventsRule', eventsRuleProps);
        defaults.addPermission(this.lambdaFunction, "AwsEventsLambdaInvokePermission", {
            principal: new iam.ServicePrincipal('events.amazonaws.com'),
            sourceArn: this.eventsRule.ruleArn
        });
    }
}
exports.EventbridgeToLambda = EventbridgeToLambda;
_a = JSII_RTTI_SYMBOL_1;
EventbridgeToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-eventbridge-lambda.EventbridgeToLambda", version: "2.97.0" };
//# sourceMappingURL=data:application/json;base64,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