import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { SnsEventSource } from 'aws-cdk-lib/aws-lambda-event-sources';
import { ITopic } from 'aws-cdk-lib/aws-sns';
import { Construct } from 'constructs';
export interface MSTeamsIncomingWebhookConfigurationProps {
    /**
     * The url of the incoming webhook for a channel
     */
    readonly url: string;
    /**
     * Specifies a custom brand color for the card. The color will be displayed in a non-obtrusive manner.
     *
     * @default `#CEDB56`
     */
    readonly themeColor?: string;
    /**
     * @default ACCOUNT_LABEL_MODE.ID_AND_ALIAS
     */
    readonly accountLabelMode?: AccountLabelMode;
    /**
     * The SNS topics that deliver notifications to MS Teams.
     */
    readonly notificationTopics?: ITopic[];
}
export declare class MSTeamsIncomingWebhookConfiguration extends Construct {
    readonly incomingWebhook: IFunction;
    constructor(scope: Construct, id: string, props: MSTeamsIncomingWebhookConfigurationProps);
    addEventSource(snsEventSource: SnsEventSource): void;
}
export declare enum AccountLabelMode {
    ID = "ID",
    ALIAS = "ALIAS",
    ID_AND_ALIAS = "ID_AND_ALIAS"
}
