"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountLabelMode = exports.MSTeamsIncomingWebhookConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_lambda_event_sources_1 = require("aws-cdk-lib/aws-lambda-event-sources");
const constructs_1 = require("constructs");
class MSTeamsIncomingWebhookConfiguration extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.incomingWebhook = new aws_lambda_1.Function(this, 'Function', {
            runtime: aws_lambda_1.Runtime.NODEJS_18_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'msteams-incoming-webhook')),
            handler: 'index.handler',
            environment: {
                URL: props.url,
                THEME_COLOR: props.themeColor || '#CEDB56',
                ACCOUNT_LABEL_MODE: props.accountLabelMode || AccountLabelMode.ID_AND_ALIAS,
            },
        });
        this.incomingWebhook.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['iam:ListAccountAliases'],
            resources: ['*'],
        }));
        props.notificationTopics?.forEach((topic) => {
            this.incomingWebhook.addEventSource(new aws_lambda_event_sources_1.SnsEventSource(topic));
        });
    }
    addEventSource(snsEventSource) {
        this.incomingWebhook.addEventSource(snsEventSource);
    }
}
exports.MSTeamsIncomingWebhookConfiguration = MSTeamsIncomingWebhookConfiguration;
_a = JSII_RTTI_SYMBOL_1;
MSTeamsIncomingWebhookConfiguration[_a] = { fqn: "@cloudcomponents/cdk-chatops.MSTeamsIncomingWebhookConfiguration", version: "2.2.0" };
var AccountLabelMode;
(function (AccountLabelMode) {
    AccountLabelMode["ID"] = "ID";
    AccountLabelMode["ALIAS"] = "ALIAS";
    AccountLabelMode["ID_AND_ALIAS"] = "ID_AND_ALIAS";
})(AccountLabelMode = exports.AccountLabelMode || (exports.AccountLabelMode = {}));
//# sourceMappingURL=data:application/json;base64,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