import { IRole, PolicyStatement } from 'aws-cdk-lib/aws-iam';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { ITopic } from 'aws-cdk-lib/aws-sns';
import { Construct } from 'constructs';
export interface ISlackChannelConfiguration {
    readonly configurationArn: string;
}
export interface SlackChannelConfigurationProps {
    /**
     * The name of the configuration.
     */
    readonly configurationName: string;
    /**
     * The iam role that defines the permissions for AWS Chatbot.
     *
     * This is a user-defined role that AWS Chatbot will assume. This is
     * not the service-linked role. For more information, see IAM Policies
     * for AWS Chatbot.
     */
    readonly role?: IRole;
    /**
     * The ID of the Slack channel.
     *
     * To get the ID, open Slack, right click on the channel name
     * in the left pane, then choose Copy Link. The channel ID is
     * the 9-character string at the end of the URL.
     * For example, ABCBBLZZZ.
     */
    readonly slackChannelId: string;
    /**
     * The ID of the Slack workspace authorized with AWS Chatbot.
     *
     * To get the workspace ID, you must perform the initial authorization
     * flow with Slack in the AWS Chatbot console. Then you can copy and
     * paste the workspace ID from the console. For more details, see steps
     * 1-4 in Setting Up AWS Chatbot with Slack in the AWS Chatbot User Guide.
     */
    readonly slackWorkspaceId: string;
    /**
     * The SNS topics that deliver notifications to AWS Chatbot.
     */
    readonly notificationTopics?: ITopic[];
    /**
     * Specifies the logging level for this configuration. This property
     * affects the log entries pushed to Amazon CloudWatch Logs.
     *
     * Logging levels include ERROR, INFO, or NONE.
     *
     * @default NONE
     */
    readonly loggingLevel?: LoggingLevel;
}
export declare class SlackChannelConfiguration extends Construct {
    readonly configurationArn: string;
    readonly role: IRole;
    constructor(scope: Construct, id: string, props: SlackChannelConfigurationProps);
    /**
     * Adds a statement to the IAM role assumed by the instance.
     */
    addToRolePolicy(statement: PolicyStatement): void;
    /**
     * Allows AWS Chatbot to retreive metric graphs from Amazon Cloudwatch
     */
    addNotificationPermissions(): void;
    addReadOnlyCommandPermissions(): void;
    /**
     * Allows Lambda-invoke commands in supported clients
     */
    addLambdaInvokeCommandPermissions(lambda?: IFunction): void;
    /**
     * Allows calling AWS Support APIs in supportzed clients
     */
    addSupportCommandPermissions(): void;
}
export declare enum LoggingLevel {
    ERROR = "ERROR",
    INFO = "INFO",
    NONE = "NONE"
}
