"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggingLevel = exports.SlackChannelConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_chatbot_1 = require("aws-cdk-lib/aws-chatbot");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
class SlackChannelConfiguration extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.role =
            props.role ||
                new aws_iam_1.Role(this, 'ServiceRole', {
                    assumedBy: new aws_iam_1.ServicePrincipal('chatbot.amazonaws.com'),
                });
        const configuration = new aws_chatbot_1.CfnSlackChannelConfiguration(this, 'SlackChannelConfiguration', {
            configurationName: props.configurationName,
            iamRoleArn: this.role.roleArn,
            slackChannelId: props.slackChannelId,
            slackWorkspaceId: props.slackWorkspaceId,
            snsTopicArns: props.notificationTopics ? props.notificationTopics.map((topic) => topic.topicArn) : undefined,
            loggingLevel: props.loggingLevel || LoggingLevel.NONE,
        });
        this.configurationArn = configuration.ref;
    }
    /**
     * Adds a statement to the IAM role assumed by the instance.
     */
    addToRolePolicy(statement) {
        this.role.addToPrincipalPolicy(statement);
    }
    /**
     * Allows AWS Chatbot to retreive metric graphs from Amazon Cloudwatch
     */
    addNotificationPermissions() {
        this.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['cloudwatch:Describe*', 'cloudwatch:Get*', 'cloudwatch:List*'],
            resources: ['*'],
        }));
    }
    addReadOnlyCommandPermissions() {
        this.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.DENY,
            actions: [
                'iam:*',
                's3:GetBucketPolicy',
                'ssm:*',
                'sts:*',
                'kms:*',
                'cognito-idp:GetSigningCertificate',
                'ec2:GetPasswordData',
                'ecr:GetAuthorizationToken',
                'gamelift:RequestUploadCredentials',
                'gamelift:GetInstanceAccess',
                'lightsail:DownloadDefaultKeyPair',
                'lightsail:GetInstanceAccessDetails',
                'lightsail:GetKeyPair',
                'lightsail:GetKeyPairs',
                'redshift:GetClusterCredentials',
                'storagegateway:DescribeChapCredentials',
            ],
            resources: ['*'],
        }));
        this.role.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('ReadOnlyAccess'));
    }
    /**
     * Allows Lambda-invoke commands in supported clients
     */
    addLambdaInvokeCommandPermissions(lambda) {
        this.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['lambda:invokeAsync', 'lambda:invokeFunction'],
            resources: [lambda?.functionArn || '*'],
        }));
    }
    /**
     * Allows calling AWS Support APIs in supportzed clients
     */
    addSupportCommandPermissions() {
        this.role.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AWSSupportAccess'));
    }
}
exports.SlackChannelConfiguration = SlackChannelConfiguration;
_a = JSII_RTTI_SYMBOL_1;
SlackChannelConfiguration[_a] = { fqn: "@cloudcomponents/cdk-chatops.SlackChannelConfiguration", version: "2.2.0" };
var LoggingLevel;
(function (LoggingLevel) {
    LoggingLevel["ERROR"] = "ERROR";
    LoggingLevel["INFO"] = "INFO";
    LoggingLevel["NONE"] = "NONE";
})(LoggingLevel = exports.LoggingLevel || (exports.LoggingLevel = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2xhY2stY2hhbm5lbC1jb25maWd1cmF0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3NsYWNrLWNoYW5uZWwtY29uZmlndXJhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHlEQUF1RTtBQUN2RSxpREFBNEc7QUFHNUcsMkNBQXVDO0FBeUR2QyxNQUFhLHlCQUEwQixTQUFRLHNCQUFTO0lBSXRELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBcUM7UUFDN0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsSUFBSTtZQUNQLEtBQUssQ0FBQyxJQUFJO2dCQUNWLElBQUksY0FBSSxDQUFDLElBQUksRUFBRSxhQUFhLEVBQUU7b0JBQzVCLFNBQVMsRUFBRSxJQUFJLDBCQUFnQixDQUFDLHVCQUF1QixDQUFDO2lCQUN6RCxDQUFDLENBQUM7UUFFTCxNQUFNLGFBQWEsR0FBRyxJQUFJLDBDQUE0QixDQUFDLElBQUksRUFBRSwyQkFBMkIsRUFBRTtZQUN4RixpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLFVBQVUsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU87WUFDN0IsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsWUFBWSxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUFDLEdBQUcsQ0FBQyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQzVHLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWSxJQUFJLFlBQVksQ0FBQyxJQUFJO1NBQ3RELENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxhQUFhLENBQUMsR0FBRyxDQUFDO0lBQzVDLENBQUM7SUFFRDs7T0FFRztJQUNJLGVBQWUsQ0FBQyxTQUEwQjtRQUMvQyxJQUFJLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFRDs7T0FFRztJQUNJLDBCQUEwQjtRQUMvQixJQUFJLENBQUMsZUFBZSxDQUNsQixJQUFJLHlCQUFlLENBQUM7WUFDbEIsTUFBTSxFQUFFLGdCQUFNLENBQUMsS0FBSztZQUNwQixPQUFPLEVBQUUsQ0FBQyxzQkFBc0IsRUFBRSxpQkFBaUIsRUFBRSxrQkFBa0IsQ0FBQztZQUN4RSxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7U0FDakIsQ0FBQyxDQUNILENBQUM7SUFDSixDQUFDO0lBRU0sNkJBQTZCO1FBQ2xDLElBQUksQ0FBQyxlQUFlLENBQ2xCLElBQUkseUJBQWUsQ0FBQztZQUNsQixNQUFNLEVBQUUsZ0JBQU0sQ0FBQyxJQUFJO1lBQ25CLE9BQU8sRUFBRTtnQkFDUCxPQUFPO2dCQUNQLG9CQUFvQjtnQkFDcEIsT0FBTztnQkFDUCxPQUFPO2dCQUNQLE9BQU87Z0JBQ1AsbUNBQW1DO2dCQUNuQyxxQkFBcUI7Z0JBQ3JCLDJCQUEyQjtnQkFDM0IsbUNBQW1DO2dCQUNuQyw0QkFBNEI7Z0JBQzVCLGtDQUFrQztnQkFDbEMsb0NBQW9DO2dCQUNwQyxzQkFBc0I7Z0JBQ3RCLHVCQUF1QjtnQkFDdkIsZ0NBQWdDO2dCQUNoQyx3Q0FBd0M7YUFDekM7WUFDRCxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7U0FDakIsQ0FBQyxDQUNILENBQUM7UUFFRixJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHVCQUFhLENBQUMsd0JBQXdCLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO0lBQ3ZGLENBQUM7SUFFRDs7T0FFRztJQUNJLGlDQUFpQyxDQUFDLE1BQWtCO1FBQ3pELElBQUksQ0FBQyxlQUFlLENBQ2xCLElBQUkseUJBQWUsQ0FBQztZQUNsQixNQUFNLEVBQUUsZ0JBQU0sQ0FBQyxLQUFLO1lBQ3BCLE9BQU8sRUFBRSxDQUFDLG9CQUFvQixFQUFFLHVCQUF1QixDQUFDO1lBQ3hELFNBQVMsRUFBRSxDQUFDLE1BQU0sRUFBRSxXQUFXLElBQUksR0FBRyxDQUFDO1NBQ3hDLENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVEOztPQUVHO0lBQ0ksNEJBQTRCO1FBQ2pDLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsdUJBQWEsQ0FBQyx3QkFBd0IsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDekYsQ0FBQzs7QUE1RkgsOERBNkZDOzs7QUFFRCxJQUFZLFlBSVg7QUFKRCxXQUFZLFlBQVk7SUFDdEIsK0JBQWUsQ0FBQTtJQUNmLDZCQUFhLENBQUE7SUFDYiw2QkFBYSxDQUFBO0FBQ2YsQ0FBQyxFQUpXLFlBQVksR0FBWixvQkFBWSxLQUFaLG9CQUFZLFFBSXZCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ2ZuU2xhY2tDaGFubmVsQ29uZmlndXJhdGlvbiB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1jaGF0Ym90JztcbmltcG9ydCB7IElSb2xlLCBSb2xlLCBTZXJ2aWNlUHJpbmNpcGFsLCBQb2xpY3lTdGF0ZW1lbnQsIEVmZmVjdCwgTWFuYWdlZFBvbGljeSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgSUZ1bmN0aW9uIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWxhbWJkYSc7XG5pbXBvcnQgeyBJVG9waWMgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc25zJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIElTbGFja0NoYW5uZWxDb25maWd1cmF0aW9uIHtcbiAgcmVhZG9ubHkgY29uZmlndXJhdGlvbkFybjogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFNsYWNrQ2hhbm5lbENvbmZpZ3VyYXRpb25Qcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgY29uZmlndXJhdGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IGNvbmZpZ3VyYXRpb25OYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBpYW0gcm9sZSB0aGF0IGRlZmluZXMgdGhlIHBlcm1pc3Npb25zIGZvciBBV1MgQ2hhdGJvdC5cbiAgICpcbiAgICogVGhpcyBpcyBhIHVzZXItZGVmaW5lZCByb2xlIHRoYXQgQVdTIENoYXRib3Qgd2lsbCBhc3N1bWUuIFRoaXMgaXNcbiAgICogbm90IHRoZSBzZXJ2aWNlLWxpbmtlZCByb2xlLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIElBTSBQb2xpY2llc1xuICAgKiBmb3IgQVdTIENoYXRib3QuXG4gICAqL1xuICByZWFkb25seSByb2xlPzogSVJvbGU7XG5cbiAgLyoqXG4gICAqIFRoZSBJRCBvZiB0aGUgU2xhY2sgY2hhbm5lbC5cbiAgICpcbiAgICogVG8gZ2V0IHRoZSBJRCwgb3BlbiBTbGFjaywgcmlnaHQgY2xpY2sgb24gdGhlIGNoYW5uZWwgbmFtZVxuICAgKiBpbiB0aGUgbGVmdCBwYW5lLCB0aGVuIGNob29zZSBDb3B5IExpbmsuIFRoZSBjaGFubmVsIElEIGlzXG4gICAqIHRoZSA5LWNoYXJhY3RlciBzdHJpbmcgYXQgdGhlIGVuZCBvZiB0aGUgVVJMLlxuICAgKiBGb3IgZXhhbXBsZSwgQUJDQkJMWlpaLlxuICAgKi9cbiAgcmVhZG9ubHkgc2xhY2tDaGFubmVsSWQ6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIElEIG9mIHRoZSBTbGFjayB3b3Jrc3BhY2UgYXV0aG9yaXplZCB3aXRoIEFXUyBDaGF0Ym90LlxuICAgKlxuICAgKiBUbyBnZXQgdGhlIHdvcmtzcGFjZSBJRCwgeW91IG11c3QgcGVyZm9ybSB0aGUgaW5pdGlhbCBhdXRob3JpemF0aW9uXG4gICAqIGZsb3cgd2l0aCBTbGFjayBpbiB0aGUgQVdTIENoYXRib3QgY29uc29sZS4gVGhlbiB5b3UgY2FuIGNvcHkgYW5kXG4gICAqIHBhc3RlIHRoZSB3b3Jrc3BhY2UgSUQgZnJvbSB0aGUgY29uc29sZS4gRm9yIG1vcmUgZGV0YWlscywgc2VlIHN0ZXBzXG4gICAqIDEtNCBpbiBTZXR0aW5nIFVwIEFXUyBDaGF0Ym90IHdpdGggU2xhY2sgaW4gdGhlIEFXUyBDaGF0Ym90IFVzZXIgR3VpZGUuXG4gICAqL1xuICByZWFkb25seSBzbGFja1dvcmtzcGFjZUlkOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBTTlMgdG9waWNzIHRoYXQgZGVsaXZlciBub3RpZmljYXRpb25zIHRvIEFXUyBDaGF0Ym90LlxuICAgKi9cbiAgcmVhZG9ubHkgbm90aWZpY2F0aW9uVG9waWNzPzogSVRvcGljW107XG5cbiAgLyoqXG4gICAqIFNwZWNpZmllcyB0aGUgbG9nZ2luZyBsZXZlbCBmb3IgdGhpcyBjb25maWd1cmF0aW9uLiBUaGlzIHByb3BlcnR5XG4gICAqIGFmZmVjdHMgdGhlIGxvZyBlbnRyaWVzIHB1c2hlZCB0byBBbWF6b24gQ2xvdWRXYXRjaCBMb2dzLlxuICAgKlxuICAgKiBMb2dnaW5nIGxldmVscyBpbmNsdWRlIEVSUk9SLCBJTkZPLCBvciBOT05FLlxuICAgKlxuICAgKiBAZGVmYXVsdCBOT05FXG4gICAqL1xuICByZWFkb25seSBsb2dnaW5nTGV2ZWw/OiBMb2dnaW5nTGV2ZWw7XG59XG5cbmV4cG9ydCBjbGFzcyBTbGFja0NoYW5uZWxDb25maWd1cmF0aW9uIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGNvbmZpZ3VyYXRpb25Bcm46IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IHJvbGU6IElSb2xlO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTbGFja0NoYW5uZWxDb25maWd1cmF0aW9uUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5yb2xlID1cbiAgICAgIHByb3BzLnJvbGUgfHxcbiAgICAgIG5ldyBSb2xlKHRoaXMsICdTZXJ2aWNlUm9sZScsIHtcbiAgICAgICAgYXNzdW1lZEJ5OiBuZXcgU2VydmljZVByaW5jaXBhbCgnY2hhdGJvdC5hbWF6b25hd3MuY29tJyksXG4gICAgICB9KTtcblxuICAgIGNvbnN0IGNvbmZpZ3VyYXRpb24gPSBuZXcgQ2ZuU2xhY2tDaGFubmVsQ29uZmlndXJhdGlvbih0aGlzLCAnU2xhY2tDaGFubmVsQ29uZmlndXJhdGlvbicsIHtcbiAgICAgIGNvbmZpZ3VyYXRpb25OYW1lOiBwcm9wcy5jb25maWd1cmF0aW9uTmFtZSxcbiAgICAgIGlhbVJvbGVBcm46IHRoaXMucm9sZS5yb2xlQXJuLFxuICAgICAgc2xhY2tDaGFubmVsSWQ6IHByb3BzLnNsYWNrQ2hhbm5lbElkLFxuICAgICAgc2xhY2tXb3Jrc3BhY2VJZDogcHJvcHMuc2xhY2tXb3Jrc3BhY2VJZCxcbiAgICAgIHNuc1RvcGljQXJuczogcHJvcHMubm90aWZpY2F0aW9uVG9waWNzID8gcHJvcHMubm90aWZpY2F0aW9uVG9waWNzLm1hcCgodG9waWMpID0+IHRvcGljLnRvcGljQXJuKSA6IHVuZGVmaW5lZCxcbiAgICAgIGxvZ2dpbmdMZXZlbDogcHJvcHMubG9nZ2luZ0xldmVsIHx8IExvZ2dpbmdMZXZlbC5OT05FLFxuICAgIH0pO1xuXG4gICAgdGhpcy5jb25maWd1cmF0aW9uQXJuID0gY29uZmlndXJhdGlvbi5yZWY7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHN0YXRlbWVudCB0byB0aGUgSUFNIHJvbGUgYXNzdW1lZCBieSB0aGUgaW5zdGFuY2UuXG4gICAqL1xuICBwdWJsaWMgYWRkVG9Sb2xlUG9saWN5KHN0YXRlbWVudDogUG9saWN5U3RhdGVtZW50KTogdm9pZCB7XG4gICAgdGhpcy5yb2xlLmFkZFRvUHJpbmNpcGFsUG9saWN5KHN0YXRlbWVudCk7XG4gIH1cblxuICAvKipcbiAgICogQWxsb3dzIEFXUyBDaGF0Ym90IHRvIHJldHJlaXZlIG1ldHJpYyBncmFwaHMgZnJvbSBBbWF6b24gQ2xvdWR3YXRjaFxuICAgKi9cbiAgcHVibGljIGFkZE5vdGlmaWNhdGlvblBlcm1pc3Npb25zKCk6IHZvaWQge1xuICAgIHRoaXMuYWRkVG9Sb2xlUG9saWN5KFxuICAgICAgbmV3IFBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIGVmZmVjdDogRWZmZWN0LkFMTE9XLFxuICAgICAgICBhY3Rpb25zOiBbJ2Nsb3Vkd2F0Y2g6RGVzY3JpYmUqJywgJ2Nsb3Vkd2F0Y2g6R2V0KicsICdjbG91ZHdhdGNoOkxpc3QqJ10sXG4gICAgICAgIHJlc291cmNlczogWycqJ10sXG4gICAgICB9KSxcbiAgICApO1xuICB9XG5cbiAgcHVibGljIGFkZFJlYWRPbmx5Q29tbWFuZFBlcm1pc3Npb25zKCk6IHZvaWQge1xuICAgIHRoaXMuYWRkVG9Sb2xlUG9saWN5KFxuICAgICAgbmV3IFBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIGVmZmVjdDogRWZmZWN0LkRFTlksXG4gICAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgICAnaWFtOionLFxuICAgICAgICAgICdzMzpHZXRCdWNrZXRQb2xpY3knLFxuICAgICAgICAgICdzc206KicsXG4gICAgICAgICAgJ3N0czoqJyxcbiAgICAgICAgICAna21zOionLFxuICAgICAgICAgICdjb2duaXRvLWlkcDpHZXRTaWduaW5nQ2VydGlmaWNhdGUnLFxuICAgICAgICAgICdlYzI6R2V0UGFzc3dvcmREYXRhJyxcbiAgICAgICAgICAnZWNyOkdldEF1dGhvcml6YXRpb25Ub2tlbicsXG4gICAgICAgICAgJ2dhbWVsaWZ0OlJlcXVlc3RVcGxvYWRDcmVkZW50aWFscycsXG4gICAgICAgICAgJ2dhbWVsaWZ0OkdldEluc3RhbmNlQWNjZXNzJyxcbiAgICAgICAgICAnbGlnaHRzYWlsOkRvd25sb2FkRGVmYXVsdEtleVBhaXInLFxuICAgICAgICAgICdsaWdodHNhaWw6R2V0SW5zdGFuY2VBY2Nlc3NEZXRhaWxzJyxcbiAgICAgICAgICAnbGlnaHRzYWlsOkdldEtleVBhaXInLFxuICAgICAgICAgICdsaWdodHNhaWw6R2V0S2V5UGFpcnMnLFxuICAgICAgICAgICdyZWRzaGlmdDpHZXRDbHVzdGVyQ3JlZGVudGlhbHMnLFxuICAgICAgICAgICdzdG9yYWdlZ2F0ZXdheTpEZXNjcmliZUNoYXBDcmVkZW50aWFscycsXG4gICAgICAgIF0sXG4gICAgICAgIHJlc291cmNlczogWycqJ10sXG4gICAgICB9KSxcbiAgICApO1xuXG4gICAgdGhpcy5yb2xlLmFkZE1hbmFnZWRQb2xpY3koTWFuYWdlZFBvbGljeS5mcm9tQXdzTWFuYWdlZFBvbGljeU5hbWUoJ1JlYWRPbmx5QWNjZXNzJykpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFsbG93cyBMYW1iZGEtaW52b2tlIGNvbW1hbmRzIGluIHN1cHBvcnRlZCBjbGllbnRzXG4gICAqL1xuICBwdWJsaWMgYWRkTGFtYmRhSW52b2tlQ29tbWFuZFBlcm1pc3Npb25zKGxhbWJkYT86IElGdW5jdGlvbik6IHZvaWQge1xuICAgIHRoaXMuYWRkVG9Sb2xlUG9saWN5KFxuICAgICAgbmV3IFBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIGVmZmVjdDogRWZmZWN0LkFMTE9XLFxuICAgICAgICBhY3Rpb25zOiBbJ2xhbWJkYTppbnZva2VBc3luYycsICdsYW1iZGE6aW52b2tlRnVuY3Rpb24nXSxcbiAgICAgICAgcmVzb3VyY2VzOiBbbGFtYmRhPy5mdW5jdGlvbkFybiB8fCAnKiddLFxuICAgICAgfSksXG4gICAgKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBbGxvd3MgY2FsbGluZyBBV1MgU3VwcG9ydCBBUElzIGluIHN1cHBvcnR6ZWQgY2xpZW50c1xuICAgKi9cbiAgcHVibGljIGFkZFN1cHBvcnRDb21tYW5kUGVybWlzc2lvbnMoKTogdm9pZCB7XG4gICAgdGhpcy5yb2xlLmFkZE1hbmFnZWRQb2xpY3koTWFuYWdlZFBvbGljeS5mcm9tQXdzTWFuYWdlZFBvbGljeU5hbWUoJ0FXU1N1cHBvcnRBY2Nlc3MnKSk7XG4gIH1cbn1cblxuZXhwb3J0IGVudW0gTG9nZ2luZ0xldmVsIHtcbiAgRVJST1IgPSAnRVJST1InLFxuICBJTkZPID0gJ0lORk8nLFxuICBOT05FID0gJ05PTkUnLFxufVxuIl19