# coding: utf-8

"""
    EHESO API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from eheso_api_client.models.data_access_config_schema_grants_value import DataAccessConfigSchemaGrantsValue

class DataAccessConfigSchema(BaseModel):
    """
    DataAccessConfigSchema
    """
    restricted_documents: Optional[Dict[str, Any]] = Field(default=None, alias="restrictedDocuments")
    restricted_fields: Optional[conlist(StrictStr)] = Field(default=None, alias="restrictedFields")
    grants: Optional[Dict[str, DataAccessConfigSchemaGrantsValue]] = None
    __properties = ["restrictedDocuments", "restrictedFields", "grants"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DataAccessConfigSchema:
        """Create an instance of DataAccessConfigSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in grants (dict)
        _field_dict = {}
        if self.grants:
            for _key in self.grants:
                if self.grants[_key]:
                    _field_dict[_key] = self.grants[_key].to_dict()
            _dict['grants'] = _field_dict
        # set to None if restricted_documents (nullable) is None
        # and __fields_set__ contains the field
        if self.restricted_documents is None and "restricted_documents" in self.__fields_set__:
            _dict['restrictedDocuments'] = None

        # set to None if restricted_fields (nullable) is None
        # and __fields_set__ contains the field
        if self.restricted_fields is None and "restricted_fields" in self.__fields_set__:
            _dict['restrictedFields'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DataAccessConfigSchema:
        """Create an instance of DataAccessConfigSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DataAccessConfigSchema.parse_obj(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in DataAccessConfigSchema) in the input: " + obj)

        _obj = DataAccessConfigSchema.parse_obj({
            "restricted_documents": obj.get("restrictedDocuments"),
            "restricted_fields": obj.get("restrictedFields"),
            "grants": dict(
                (_k, DataAccessConfigSchemaGrantsValue.from_dict(_v))
                for _k, _v in obj.get("grants").items()
            )
            if obj.get("grants") is not None
            else None
        })
        return _obj


