# coding: utf-8

"""
    EHESO API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class ErrorSchema(BaseModel):
    """
    ErrorSchema
    """
    var_date: Optional[StrictStr] = Field(default=None, alias="date", description="The date is a string that represents the date and time when the error occurred.  The date is formatted according to the ISO 8601 standard. ")
    status_code: Optional[StrictInt] = Field(default=None, alias="statusCode", description="The statusCode is an integer that represents the HTTP status code of the error. ")
    message: Optional[StrictStr] = Field(default=None, description="The message is a string that represents the error message. ")
    call_info: Optional[StrictStr] = Field(default=None, alias="callInfo", description="The Endpoint that was called when the error occurred. ")
    __properties = ["date", "statusCode", "message", "callInfo"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ErrorSchema:
        """Create an instance of ErrorSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ErrorSchema:
        """Create an instance of ErrorSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ErrorSchema.parse_obj(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in ErrorSchema) in the input: " + obj)

        _obj = ErrorSchema.parse_obj({
            "var_date": obj.get("date"),
            "status_code": obj.get("statusCode"),
            "message": obj.get("message"),
            "call_info": obj.get("callInfo")
        })
        return _obj


