# coding: utf-8

"""
    EHESO API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class ExportSchemaFileExport(BaseModel):
    """
    Export related parameters  # noqa: E501
    """
    format: Optional[StrictStr] = Field(default=None, description="The format of the file to export.  > At the moment the supported formats are CSV and XLSX. ")
    field_separator: Optional[StrictStr] = Field(default=',', alias="fieldSeparator", description="The field separator for the CSV file. This parameter is only relevant if the format is CSV. > The default value is a comma `,`. ")
    include_time_in_filename: Optional[StrictBool] = Field(default=True, alias="includeTimeInFilename", description="If this parameter is set to `true`, the current date and time are included in the filename. > The default value is `true`. ")
    __properties = ["format", "fieldSeparator", "includeTimeInFilename"]

    @validator('format')
    def format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('csv', 'xlsx'):
            raise ValueError("must be one of enum values ('csv', 'xlsx')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExportSchemaFileExport:
        """Create an instance of ExportSchemaFileExport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExportSchemaFileExport:
        """Create an instance of ExportSchemaFileExport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExportSchemaFileExport.parse_obj(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in ExportSchemaFileExport) in the input: " + obj)

        _obj = ExportSchemaFileExport.parse_obj({
            "format": obj.get("format"),
            "field_separator": obj.get("fieldSeparator") if obj.get("fieldSeparator") is not None else ',',
            "include_time_in_filename": obj.get("includeTimeInFilename") if obj.get("includeTimeInFilename") is not None else True
        })
        return _obj


