# coding: utf-8

"""
    EHESO API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, validator
from eheso_api_client.models.export_schema_file_export import ExportSchemaFileExport
from eheso_api_client.models.query_post_schema_sort_value import QueryPostSchemaSortValue

class LayerIdExportRequest(BaseModel):
    """
    LayerIdExportRequest
    """
    format: StrictStr = Field(default=..., description="The format in which the data should be returned.  The available formats are:    - \"default\": this returns a so-called field-based structure.      This field-based structure is a nested object where the fieldIds      define the nested properties. Each field is represented by an object that     may have either a `v` property or a `c` property, like so: `{SOME: { FIELD { v: 1 }}}`.     The `v` property is the value of the field, while the `c` property is the code,      if there was no value for that field (e.g. \"m\" for \"missing\").   - \"flat\": this returns a flat array of objects, where each object represents a row.        The object has properties that correspond to the fieldIds, like so: `{ \"SOME.FIELD\": 1 }`.       The `.c` and `.v` properties are not present in this format, so it is possible to        get a string value for a number field, because the value it is actually a code.    - \"sql\": this is similar to the \"flat\" format, but the fieldIds        don't have the dot notation. The dots are replaced with `_`       to make the fieldIds SQL-friendly, like so: `{ \"SOME_FIELD\": 1 }`. ")
    locale: Optional[StrictStr] = Field(default=None, description="> Note: This parameter is not yet fully implemented.  The locale in which the data should be returned.  The locale is a string that represents the language and country  (e.g. `fr_BE` for French in Belgium).  If the locale is not provided, the default locale `de_AT` is used. ")
    find: Optional[Dict[str, Any]] = Field(default=None, description="The find object is a nested object that represents the filter criteria.  The keys of the find object are the fieldIds, and the values are the filter criteria.  For a detailed description of the operators and the filter criteria,  see this page: [MongoDB query reference](https://docs.mongodb.com/manual/reference/operator/query/) ")
    select: Optional[conlist(StrictStr)] = Field(default=None, description="The select array is an array of fieldIds (or part of a fieldId) that should be returned.  If the select array is not provided, all fields are returned.  If the select array is provided, only the fields matching the select array are returned.  For example, if the select array is `[\"SOME\"]`, only the fields that start with `\"SOME.\"` are returned. If the select array is  ``` [\"SOME.FIELD\", \"SOME.OTHER.FIELD\"] ``` , the fields with the fieldId `\"SOME.FIELD\"` and `\"SOME.OTHER.FIELD\"` are returned. ")
    include_key_fields: Optional[StrictBool] = Field(default=None, alias="includeKeyFields", description="Specifies whether the key fields should be included in the result, even if they are not part of the select array.  If the select array is not provided, this property has no effect. ")
    deselect: Optional[conlist(StrictStr)] = Field(default=None, description="> Note: This parameter is not yet implemented. ")
    sort: Optional[Dict[str, QueryPostSchemaSortValue]] = Field(default=None, description="- The sort object is an object that represents the sort criteria.  - The keys of the sort object are the fieldIds. - The order of the keys in the sort object defines the sort order. - The sort order can be either 1 (ascending) or -1 (descending).    For example, a valid sort object would be  ``` { \"SOME.FIELD\": 1, \"SOME.OTHER.FIELD\": -1 } ```  If you want to explicitly specify, if the value (`v`) or the code (`c`)  should be used for sorting, you need to include the respective property  in the sort object, like so:  ``` { \"SOME.FIELD.c\": -1, \"SOME.FIELD.v\": 1 } ``` ")
    limit: Optional[StrictInt] = Field(default=None, description="The limit is an integer that represents the maximum number of records that should be returned.  If the limit is not provided, all records are returned. ")
    result_info: Optional[StrictBool] = Field(default=None, alias="resultInfo", description="> Note: This parameter is not yet fully implemented.  Specifies whether the result info should be included in the result.  The result info contains the total number of records, the number of records  that were returned, and (sometimes) the number of records that were skipped.  This is useful for pagination or a preview of the data. > Note: The result info is the last object in the result array. > This block is marked with an `itemType` property like so: ``` {   \"itemType\": \"ResultInfo\",   \"itemsSent\": 9,   \"messages\": [] } ``` ")
    file_export: ExportSchemaFileExport = Field(default=..., alias="fileExport")
    __properties = ["format", "locale", "find", "select", "includeKeyFields", "deselect", "sort", "limit", "resultInfo", "fileExport"]

    @validator('format')
    def format_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('detailed', 'flat', 'sql'):
            raise ValueError("must be one of enum values ('detailed', 'flat', 'sql')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LayerIdExportRequest:
        """Create an instance of LayerIdExportRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in sort (dict)
        _field_dict = {}
        if self.sort:
            for _key in self.sort:
                if self.sort[_key]:
                    _field_dict[_key] = self.sort[_key].to_dict()
            _dict['sort'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of file_export
        if self.file_export:
            _dict['fileExport'] = self.file_export.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LayerIdExportRequest:
        """Create an instance of LayerIdExportRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LayerIdExportRequest.parse_obj(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in LayerIdExportRequest) in the input: " + obj)

        _obj = LayerIdExportRequest.parse_obj({
            "format": obj.get("format"),
            "locale": obj.get("locale"),
            "find": obj.get("find"),
            "select": obj.get("select"),
            "include_key_fields": obj.get("includeKeyFields"),
            "deselect": obj.get("deselect"),
            "sort": dict(
                (_k, QueryPostSchemaSortValue.from_dict(_v))
                for _k, _v in obj.get("sort").items()
            )
            if obj.get("sort") is not None
            else None,
            "limit": obj.get("limit"),
            "result_info": obj.get("resultInfo"),
            "file_export": ExportSchemaFileExport.from_dict(obj.get("fileExport")) if obj.get("fileExport") is not None else None
        })
        return _obj


