/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.api;

import io.ray.api.BaseActorHandle;
import io.ray.api.PyActorHandle;
import io.ray.api.Ray;
import io.ray.api.call.PyActorCreator;
import io.ray.api.exception.RayActorException;
import io.ray.api.exception.RayTimeoutException;
import io.ray.api.function.PyActorClass;
import io.ray.api.function.PyActorMethod;
import io.ray.api.options.ActorLifetime;
import io.ray.serve.api.ServeControllerClient;
import io.ray.serve.dag.Graph;
import io.ray.serve.deployment.Application;
import io.ray.serve.deployment.Deployment;
import io.ray.serve.deployment.DeploymentCreator;
import io.ray.serve.deployment.DeploymentRoute;
import io.ray.serve.exception.RayServeException;
import io.ray.serve.generated.ActorNameList;
import io.ray.serve.handle.DeploymentHandle;
import io.ray.serve.poll.LongPollClientFactory;
import io.ray.serve.replica.ReplicaContext;
import io.ray.serve.util.CollectionUtil;
import io.ray.serve.util.MessageFormatter;
import io.ray.serve.util.ServeProtoUtil;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Serve {
    private static final Logger LOGGER = LoggerFactory.getLogger(Serve.class);
    private static ReplicaContext INTERNAL_REPLICA_CONTEXT;
    private static ServeControllerClient GLOBAL_CLIENT;

    public static synchronized ServeControllerClient start(Map<String, String> config) {
        return Serve.serveStart(config);
    }

    private static synchronized ServeControllerClient serveStart(Map<String, String> config) {
        try {
            ServeControllerClient client = Serve.getGlobalClient(true);
            LOGGER.info("Connecting to existing Serve app in namespace {}", (Object)"serve");
            return client;
        }
        catch (RayServeException | IllegalStateException e) {
            LOGGER.info("There is no Serve instance running on this Ray cluster. A new one will be started.");
            if (!Ray.isInitialized()) {
                Serve.init();
            }
            int httpPort = Optional.ofNullable(config).map(m4 -> (String)m4.get("ray.serve.proxy.http.port")).map(Integer::parseInt).orElse(Integer.valueOf(System.getProperty("ray.serve.proxy.http.port", "8000")));
            PyActorHandle controllerAvatar = ((PyActorCreator)((PyActorCreator)((PyActorCreator)((PyActorCreator)Ray.actor(PyActorClass.of("ray.serve._private.controller", "ServeControllerAvatar"), (Object)httpPort).setName("SERVE_CONTROLLER_ACTOR_AVATAR")).setLifetime(ActorLifetime.DETACHED)).setMaxRestarts(-1)).setMaxConcurrency(1)).remote();
            controllerAvatar.task(PyActorMethod.of("check_alive")).remote().get();
            PyActorHandle controller = (PyActorHandle)Ray.getActor("SERVE_CONTROLLER_ACTOR", "serve").get();
            ActorNameList actorNameList = ServeProtoUtil.bytesToProto((byte[])controller.task(PyActorMethod.of("get_proxy_names")).remote().get(), ActorNameList::parseFrom);
            if (actorNameList != null && !CollectionUtil.isEmpty(actorNameList.getNamesList())) {
                try {
                    for (String name : actorNameList.getNamesList()) {
                        PyActorHandle proxyActorHandle = (PyActorHandle)Ray.getActor(name, "serve").get();
                        proxyActorHandle.task(PyActorMethod.of("ready")).remote().get(60000L);
                    }
                }
                catch (RayTimeoutException e2) {
                    String errMsg = MessageFormatter.format("HTTP proxies not available after {}s.", 60);
                    LOGGER.error(errMsg, e2);
                    throw new RayServeException(errMsg, e2);
                }
            }
            ServeControllerClient client = new ServeControllerClient(controller);
            Serve.setGlobalClient(client);
            LOGGER.info("Started Serve in namespace {}", (Object)"serve");
            return client;
        }
    }

    public static void shutdown() {
        ServeControllerClient client = null;
        try {
            client = Serve.getGlobalClient();
        }
        catch (RayServeException | IllegalStateException e) {
            LOGGER.info("Nothing to shut down. There's no Serve application running on this Ray cluster.");
            return;
        }
        LongPollClientFactory.stop();
        client.shutdown(null);
        Serve.clearContext();
    }

    public static void clearContext() {
        Serve.setGlobalClient(null);
        Serve.setInternalReplicaContext(null);
    }

    public static DeploymentCreator deployment() {
        return new DeploymentCreator();
    }

    public static void setInternalReplicaContext(String deploymentName, String replicaTag, Object servableObject, Map<String, String> config, String appName) {
        INTERNAL_REPLICA_CONTEXT = new ReplicaContext(deploymentName, replicaTag, servableObject, config, appName);
    }

    public static void setInternalReplicaContext(ReplicaContext replicaContext) {
        INTERNAL_REPLICA_CONTEXT = replicaContext;
    }

    public static ReplicaContext getReplicaContext() {
        if (INTERNAL_REPLICA_CONTEXT == null) {
            throw new RayServeException("`Serve.getReplicaContext()` may only be called from within a Ray Serve deployment.");
        }
        return INTERNAL_REPLICA_CONTEXT;
    }

    public static ServeControllerClient getGlobalClient(boolean healthCheckController) {
        try {
            if (GLOBAL_CLIENT != null) {
                if (healthCheckController) {
                    ((PyActorHandle)GLOBAL_CLIENT.getController()).task(PyActorMethod.of("check_alive")).remote();
                }
                return GLOBAL_CLIENT;
            }
        }
        catch (RayActorException e) {
            LOGGER.info("The cached controller has died. Reconnecting.");
            Serve.setGlobalClient(null);
        }
        return Serve.connect();
    }

    public static ServeControllerClient getGlobalClient() {
        return Serve.getGlobalClient(false);
    }

    private static void setGlobalClient(ServeControllerClient client) {
        GLOBAL_CLIENT = client;
    }

    private static synchronized ServeControllerClient connect() {
        if (GLOBAL_CLIENT != null) {
            return GLOBAL_CLIENT;
        }
        if (!Ray.isInitialized()) {
            Serve.init();
        }
        Optional optional = Ray.getActor("SERVE_CONTROLLER_ACTOR", "serve");
        Preconditions.checkState(optional.isPresent(), MessageFormatter.format("There is no instance running on this Ray cluster. Please call `serve.start() to start one.", new Object[0]));
        LOGGER.info("Got controller handle with name `{}` in namespace `{}`.", (Object)"SERVE_CONTROLLER_ACTOR", (Object)"serve");
        ServeControllerClient client = new ServeControllerClient((BaseActorHandle)optional.get());
        Serve.setGlobalClient(client);
        return client;
    }

    @Deprecated
    public static Deployment getDeployment(String name) {
        LOGGER.warn("This API is deprecated and may be removed in future Ray releases. Please see https://docs.ray.io/en/latest/serve/index.html for more information.");
        DeploymentRoute deploymentRoute = Serve.getGlobalClient().getDeploymentInfo(name);
        if (deploymentRoute == null) {
            throw new RayServeException(MessageFormatter.format("Deployment {} was not found. Did you call Deployment.deploy?", name));
        }
        return new Deployment(name, deploymentRoute.getDeploymentInfo().getDeploymentConfig(), deploymentRoute.getDeploymentInfo().getReplicaConfig(), deploymentRoute.getDeploymentInfo().getVersion());
    }

    public static DeploymentHandle run(Application target) {
        return Serve.run(target, true, "default", null, null);
    }

    public static DeploymentHandle run(Application target, boolean blocking, String name, String routePrefix, Map<String, String> config) {
        if (StringUtils.isBlank(name)) {
            throw new RayServeException("Application name must a non-empty string.");
        }
        if (StringUtils.isNotBlank(routePrefix)) {
            Preconditions.checkArgument(routePrefix.startsWith("/"), "The route_prefix must start with a forward slash ('/')");
        } else {
            routePrefix = "/";
        }
        ServeControllerClient client = Serve.serveStart(config);
        List<Deployment> deployments = Graph.build(target.getInternalDagNode(), name);
        Deployment ingressDeployment = deployments.get(deployments.size() - 1);
        for (Deployment deployment : deployments) {
            deployment.getDeploymentConfig().setVersion(StringUtils.isNotBlank(deployment.getVersion()) ? deployment.getVersion() : RandomStringUtils.randomAlphabetic(6));
        }
        client.deployApplication(name, routePrefix, deployments, ingressDeployment.getName(), blocking);
        return client.getDeploymentHandle(ingressDeployment.getName(), name, true);
    }

    private static void init() {
        System.setProperty("ray.job.namespace", "serve");
        Ray.init();
    }

    public static DeploymentHandle getAppHandle(String name) {
        ServeControllerClient client = Serve.getGlobalClient();
        String ingress = (String)((PyActorHandle)client.getController()).task(PyActorMethod.of("get_ingress_deployment_name"), name).remote().get();
        if (StringUtils.isBlank(ingress)) {
            throw new RayServeException(MessageFormatter.format("Application '{}' does not exist.", ingress));
        }
        return client.getDeploymentHandle(ingress, name, false);
    }

    public static void delete(String name) {
        Serve.delete(name, true);
    }

    public static void delete(String name, boolean blocking) {
        Serve.getGlobalClient().deleteApps(Arrays.asList(name), blocking);
    }
}

