# -*- coding: utf-8 -*-
"""
@Author: HuangJingCan
@Date: 2020-06-02 14:32:40
@LastEditTime: 2020-07-07 16:03:23
@LastEditors: HuangJingCan
@Description: 枚举类
"""

from enum import Enum, unique


class AppBaseRedisKeyType(Enum):
    """
    redis用到的key
    """
    QqAccessToken = "qq_access_token:"  # QQ accessToken
    QqAccessTokenLock = "qq_access_token_lock:"  # QQ accessToken
    WxAccessToken = "wx_access_token:"  # QQ accessToken
    WxAccessTokenLock = "wx_access_token_lock:"  # QQ accessToken
    UserToken = "pt_app_user_token:"
    ThirdToken = "pt_app_third_token:"


class RedisKeyType(Enum):
    """
    redis用到的key
    """
    IdWorkKey = "pt_id_generator"  # ID生成器key值
    TelephoneCode = "pt_app_telephone_code:"  # 手机验证码
    TelephoneReq = "pt_app_telephone_req:"  # 手机验证码请求
    TelephoneLimit = "pt_app_telephone_limit:"  # 手机验证码请求限制
    SystemGiveDoll = "pt_system_give_doll"  # 系统赠送娃娃

    BaseInfoCache = "pt_base_info_cache"  # 基础信息缓存
    AdConfigCache = "pt_ad_config_cache"  # 广告配置缓存
    PtDollConfigCache = "pt_doll_config_cache"  # 娃娃游戏配置信息缓存
    PtUserFansCache = "pt_user_fans_cache" # 用户粉丝信息缓存
    PtUserFollowCache = "pt_user_follow_cache" # 用户关注信息缓存

    PtDollIncr = "pt_doll_incr"  # 娃娃领取数量，迁移时需要同步数据
    PtDollClothIncr = "pt_doll_cloth_incr"  # 娃娃服饰领取数量，迁移时需要同步数据


class OperationType(Enum):
    """
    @description: 用户操作日志类型
    """
    add = 1
    update = 2
    delete = 3


class ThirdChannelType(Enum):
    """
    第三方登录类型
    """
    NoSdk = 0  # noSdk登录
    QqMini = 1  # QQ小程序登录
    WxMini = 2  # 微信小程序登录


class UnionChannelType(Enum):
    """
    开放平台类型
    """
    QqConnect = 1  # QQ互联


class AppChannelType(Enum):
    """
    应用类型
    """
    NoSdk = 0  # noSdk
    QqMini = 1  # QQ小程序
    WxMini = 2  # 微信小程序


class UserTagType(Enum):
    """
    玩家身份标签
    """
    DollOwner = 1  # 娃名
    DollSeller = 2  # 娃太
    DollPainter = 3  # 画手


class StatisticsOrmType(Enum):
    """
    数据统计
    """
    RegisterUser = 1  # 注册人数
    BindUser = 2  # 绑定手机人数
    BindUserLogin = 3  # 绑定手机号登录
    DollUserLogin = 4  # 有娃用户登录
    ActivateDoll = 5  # 激活娃娃
    InteractComplete = 6  # 互动完成
    StoryEnter = 7  # 体验剧情
    StoryBarrage = 8  # 剧情弹幕
    Talk = 9  # 吐槽
    GraspDoll = 10  # 提起娃娃
    TransferDoll = 11  # 转赠娃娃


class ActionLogType(Enum):
    """
    操作日志枚举
    """
    # 娃娃
    ActivateDoll = 10001  # 激活娃娃
    DollModifyNick = 10002  # 娃娃改名
    # DollTransfer = 10003  # 转赠成功

    # 互动
    DollInteractRequest = 20001  # 娃娃发起互动请求
    DollInteractResult = 20002  # 是否成功进行互动

    # 剧情
    StoryEnter = 30001  # 进入剧情详情界面
    StoryPass = 30002  # 剧情结局
    StoryBarrage = 30003  # 剧情留言
    StoryUnlock = 30004  # 剧情解锁

    # 玩家概要信息
    Talk = 40001  # 吐槽
    ChiefGetLevelReward = 40002  # 领取等级奖励

    # 用户
    UserFreeze = 50001  # 封号解封
    ModifyNick = 50002  # 修改昵称
    ModifyUserInfo = 50003  # 修改用户信息
    ModifyTelephone = 50004  # 更换手机号

    # 农场
    FarmUnlockField = 60001  # 解锁地块
    FarmAddBuilding = 60002  # 增加建筑
    FarmAddHarvest = 60003  # 收割作物
    FarmMergeBuilding = 60004  # 合并建筑
    FarmGetOrderReward = 60005  # 领取订单奖励
    FarmDeleteBuilding = 60006  # 删除建筑

    # 服饰
    ClothBuy = 70001  # 购买服饰
    ClothChipDecompose = 70002  # 碎片分解

    # 冒险
    AdventureSpeedUp = 80001  # 冒险加速
    AdventureGetRewards = 80002  # 领取奖励

    # 背包
    BagComposeChip = 90001  # 碎片合成

    # 任务
    TaskGetRewards = 100001  # 领取任务奖励

    # gm指令
    GmAddItem = 1000001  # 增加道具


class DollGetType(Enum):
    """
    娃娃获得类型
    """
    Buy = 1  # 购买获得
    SystemGive = 2  # 系统赠送


class NoticeType(Enum):
    """
    通知类型
    """
    # 工厂订单
    FactoryOrderApply = 101  # 下单通知
    FactoryOrderQuote = 102  # 报价通知
    FactoryOrderProgress = 103  # 进度更新


class AssetType(Enum):
    """
    资产类型
    """
    Count = 1  # 次数
    Integral = 2  # 积分
    Gear = 3  # 档位


class AssetSourceType(Enum):
    """
    来源类型
    """
    Buy = 1  # 商场购买
    Task = 2  # 任务
    GmModify = 3  # 手动配置
    Draw = 4  # 抽奖
    BuyBack = 5  # 回购
    Adventure = 6  # 娃娃冒险
    DollLvUp = 7  # 娃娃升级
    BuyCloth = 8  # 购买服饰

    ## 游戏，从 10001 开始


class SmsSignType(Enum):
    StarHome = "sms-sign-IIKPSL48159"  # 厘米星球，国内签名
    StarInternational = "sms-sign-HiUUNh29125"  # 厘米星球，国际签名


class SmsTemplateType(Enum):
    StarHomeCode = "sms-tmpl-yFCOzU65414"  # 验证码
    StarHomeApply = "sms-tmpl-wchLwz23097"  # 打样申请
    StarHomeApplyPass = "sms-tmpl-RwSkJk48467"  # 打样申请通过
    StarHomeApplyFail = "sms-tmpl-DZWbLL44997"  # 打样申请失败
    StarHomeProgressChange = "sms-tmpl-PNXiyz79626"  # 订单进度更新
    StarHomeCollectOrderChange = "sms-tmpl-LgZjkl95184"  # 蹲的娃进度更新
