# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetOtherUcseFeatureResult',
    'AwaitableGetOtherUcseFeatureResult',
    'get_other_ucse_feature',
    'get_other_ucse_feature_output',
]

@pulumi.output_type
class GetOtherUcseFeatureResult:
    """
    A collection of values returned by getOtherUcseFeature.
    """
    def __init__(__self__, access_port_dedicated=None, access_port_shared_failover_type=None, access_port_shared_type=None, assign_priority=None, assign_priority_variable=None, bay=None, default_gateway=None, default_gateway_variable=None, description=None, feature_profile_id=None, id=None, interfaces=None, ipv4_address=None, ipv4_address_variable=None, name=None, slot=None, version=None, vlan_id=None, vlan_id_variable=None):
        if access_port_dedicated and not isinstance(access_port_dedicated, bool):
            raise TypeError("Expected argument 'access_port_dedicated' to be a bool")
        pulumi.set(__self__, "access_port_dedicated", access_port_dedicated)
        if access_port_shared_failover_type and not isinstance(access_port_shared_failover_type, str):
            raise TypeError("Expected argument 'access_port_shared_failover_type' to be a str")
        pulumi.set(__self__, "access_port_shared_failover_type", access_port_shared_failover_type)
        if access_port_shared_type and not isinstance(access_port_shared_type, str):
            raise TypeError("Expected argument 'access_port_shared_type' to be a str")
        pulumi.set(__self__, "access_port_shared_type", access_port_shared_type)
        if assign_priority and not isinstance(assign_priority, int):
            raise TypeError("Expected argument 'assign_priority' to be a int")
        pulumi.set(__self__, "assign_priority", assign_priority)
        if assign_priority_variable and not isinstance(assign_priority_variable, str):
            raise TypeError("Expected argument 'assign_priority_variable' to be a str")
        pulumi.set(__self__, "assign_priority_variable", assign_priority_variable)
        if bay and not isinstance(bay, int):
            raise TypeError("Expected argument 'bay' to be a int")
        pulumi.set(__self__, "bay", bay)
        if default_gateway and not isinstance(default_gateway, str):
            raise TypeError("Expected argument 'default_gateway' to be a str")
        pulumi.set(__self__, "default_gateway", default_gateway)
        if default_gateway_variable and not isinstance(default_gateway_variable, str):
            raise TypeError("Expected argument 'default_gateway_variable' to be a str")
        pulumi.set(__self__, "default_gateway_variable", default_gateway_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if feature_profile_id and not isinstance(feature_profile_id, str):
            raise TypeError("Expected argument 'feature_profile_id' to be a str")
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interfaces and not isinstance(interfaces, list):
            raise TypeError("Expected argument 'interfaces' to be a list")
        pulumi.set(__self__, "interfaces", interfaces)
        if ipv4_address and not isinstance(ipv4_address, str):
            raise TypeError("Expected argument 'ipv4_address' to be a str")
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_address_variable and not isinstance(ipv4_address_variable, str):
            raise TypeError("Expected argument 'ipv4_address_variable' to be a str")
        pulumi.set(__self__, "ipv4_address_variable", ipv4_address_variable)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if slot and not isinstance(slot, int):
            raise TypeError("Expected argument 'slot' to be a int")
        pulumi.set(__self__, "slot", slot)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)
        if vlan_id and not isinstance(vlan_id, int):
            raise TypeError("Expected argument 'vlan_id' to be a int")
        pulumi.set(__self__, "vlan_id", vlan_id)
        if vlan_id_variable and not isinstance(vlan_id_variable, str):
            raise TypeError("Expected argument 'vlan_id_variable' to be a str")
        pulumi.set(__self__, "vlan_id_variable", vlan_id_variable)

    @property
    @pulumi.getter(name="accessPortDedicated")
    def access_port_dedicated(self) -> builtins.bool:
        """
        Dedicated
        """
        return pulumi.get(self, "access_port_dedicated")

    @property
    @pulumi.getter(name="accessPortSharedFailoverType")
    def access_port_shared_failover_type(self) -> builtins.str:
        return pulumi.get(self, "access_port_shared_failover_type")

    @property
    @pulumi.getter(name="accessPortSharedType")
    def access_port_shared_type(self) -> builtins.str:
        return pulumi.get(self, "access_port_shared_type")

    @property
    @pulumi.getter(name="assignPriority")
    def assign_priority(self) -> builtins.int:
        """
        Assign priority
        """
        return pulumi.get(self, "assign_priority")

    @property
    @pulumi.getter(name="assignPriorityVariable")
    def assign_priority_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "assign_priority_variable")

    @property
    @pulumi.getter
    def bay(self) -> builtins.int:
        """
        Bay
        """
        return pulumi.get(self, "bay")

    @property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> builtins.str:
        """
        Assign default gateway
        """
        return pulumi.get(self, "default_gateway")

    @property
    @pulumi.getter(name="defaultGatewayVariable")
    def default_gateway_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "default_gateway_variable")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> builtins.str:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the Feature
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interfaces(self) -> Sequence['outputs.GetOtherUcseFeatureInterfaceResult']:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> builtins.str:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def slot(self) -> builtins.int:
        """
        Slot
        """
        return pulumi.get(self, "slot")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> builtins.int:
        """
        Assign Vlan Id
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vlanIdVariable")
    def vlan_id_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "vlan_id_variable")


class AwaitableGetOtherUcseFeatureResult(GetOtherUcseFeatureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOtherUcseFeatureResult(
            access_port_dedicated=self.access_port_dedicated,
            access_port_shared_failover_type=self.access_port_shared_failover_type,
            access_port_shared_type=self.access_port_shared_type,
            assign_priority=self.assign_priority,
            assign_priority_variable=self.assign_priority_variable,
            bay=self.bay,
            default_gateway=self.default_gateway,
            default_gateway_variable=self.default_gateway_variable,
            description=self.description,
            feature_profile_id=self.feature_profile_id,
            id=self.id,
            interfaces=self.interfaces,
            ipv4_address=self.ipv4_address,
            ipv4_address_variable=self.ipv4_address_variable,
            name=self.name,
            slot=self.slot,
            version=self.version,
            vlan_id=self.vlan_id,
            vlan_id_variable=self.vlan_id_variable)


def get_other_ucse_feature(feature_profile_id: Optional[builtins.str] = None,
                           id: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOtherUcseFeatureResult:
    """
    This data source can read the Other UCSE Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_other_ucse_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param builtins.str feature_profile_id: Feature Profile ID
    :param builtins.str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getOtherUcseFeature:getOtherUcseFeature', __args__, opts=opts, typ=GetOtherUcseFeatureResult).value

    return AwaitableGetOtherUcseFeatureResult(
        access_port_dedicated=pulumi.get(__ret__, 'access_port_dedicated'),
        access_port_shared_failover_type=pulumi.get(__ret__, 'access_port_shared_failover_type'),
        access_port_shared_type=pulumi.get(__ret__, 'access_port_shared_type'),
        assign_priority=pulumi.get(__ret__, 'assign_priority'),
        assign_priority_variable=pulumi.get(__ret__, 'assign_priority_variable'),
        bay=pulumi.get(__ret__, 'bay'),
        default_gateway=pulumi.get(__ret__, 'default_gateway'),
        default_gateway_variable=pulumi.get(__ret__, 'default_gateway_variable'),
        description=pulumi.get(__ret__, 'description'),
        feature_profile_id=pulumi.get(__ret__, 'feature_profile_id'),
        id=pulumi.get(__ret__, 'id'),
        interfaces=pulumi.get(__ret__, 'interfaces'),
        ipv4_address=pulumi.get(__ret__, 'ipv4_address'),
        ipv4_address_variable=pulumi.get(__ret__, 'ipv4_address_variable'),
        name=pulumi.get(__ret__, 'name'),
        slot=pulumi.get(__ret__, 'slot'),
        version=pulumi.get(__ret__, 'version'),
        vlan_id=pulumi.get(__ret__, 'vlan_id'),
        vlan_id_variable=pulumi.get(__ret__, 'vlan_id_variable'))
def get_other_ucse_feature_output(feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                                  id: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOtherUcseFeatureResult]:
    """
    This data source can read the Other UCSE Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_other_ucse_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param builtins.str feature_profile_id: Feature Profile ID
    :param builtins.str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getOtherUcseFeature:getOtherUcseFeature', __args__, opts=opts, typ=GetOtherUcseFeatureResult)
    return __ret__.apply(lambda __response__: GetOtherUcseFeatureResult(
        access_port_dedicated=pulumi.get(__response__, 'access_port_dedicated'),
        access_port_shared_failover_type=pulumi.get(__response__, 'access_port_shared_failover_type'),
        access_port_shared_type=pulumi.get(__response__, 'access_port_shared_type'),
        assign_priority=pulumi.get(__response__, 'assign_priority'),
        assign_priority_variable=pulumi.get(__response__, 'assign_priority_variable'),
        bay=pulumi.get(__response__, 'bay'),
        default_gateway=pulumi.get(__response__, 'default_gateway'),
        default_gateway_variable=pulumi.get(__response__, 'default_gateway_variable'),
        description=pulumi.get(__response__, 'description'),
        feature_profile_id=pulumi.get(__response__, 'feature_profile_id'),
        id=pulumi.get(__response__, 'id'),
        interfaces=pulumi.get(__response__, 'interfaces'),
        ipv4_address=pulumi.get(__response__, 'ipv4_address'),
        ipv4_address_variable=pulumi.get(__response__, 'ipv4_address_variable'),
        name=pulumi.get(__response__, 'name'),
        slot=pulumi.get(__response__, 'slot'),
        version=pulumi.get(__response__, 'version'),
        vlan_id=pulumi.get(__response__, 'vlan_id'),
        vlan_id_variable=pulumi.get(__response__, 'vlan_id_variable')))
