# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSystemSnmpFeatureResult',
    'AwaitableGetSystemSnmpFeatureResult',
    'get_system_snmp_feature',
    'get_system_snmp_feature_output',
]

@pulumi.output_type
class GetSystemSnmpFeatureResult:
    """
    A collection of values returned by getSystemSnmpFeature.
    """
    def __init__(__self__, communities=None, contact_person=None, contact_person_variable=None, description=None, feature_profile_id=None, groups=None, id=None, location_of_device=None, location_of_device_variable=None, name=None, shutdown=None, shutdown_variable=None, trap_target_servers=None, users=None, version=None, views=None):
        if communities and not isinstance(communities, list):
            raise TypeError("Expected argument 'communities' to be a list")
        pulumi.set(__self__, "communities", communities)
        if contact_person and not isinstance(contact_person, str):
            raise TypeError("Expected argument 'contact_person' to be a str")
        pulumi.set(__self__, "contact_person", contact_person)
        if contact_person_variable and not isinstance(contact_person_variable, str):
            raise TypeError("Expected argument 'contact_person_variable' to be a str")
        pulumi.set(__self__, "contact_person_variable", contact_person_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if feature_profile_id and not isinstance(feature_profile_id, str):
            raise TypeError("Expected argument 'feature_profile_id' to be a str")
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location_of_device and not isinstance(location_of_device, str):
            raise TypeError("Expected argument 'location_of_device' to be a str")
        pulumi.set(__self__, "location_of_device", location_of_device)
        if location_of_device_variable and not isinstance(location_of_device_variable, str):
            raise TypeError("Expected argument 'location_of_device_variable' to be a str")
        pulumi.set(__self__, "location_of_device_variable", location_of_device_variable)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if shutdown and not isinstance(shutdown, bool):
            raise TypeError("Expected argument 'shutdown' to be a bool")
        pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable and not isinstance(shutdown_variable, str):
            raise TypeError("Expected argument 'shutdown_variable' to be a str")
        pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if trap_target_servers and not isinstance(trap_target_servers, list):
            raise TypeError("Expected argument 'trap_target_servers' to be a list")
        pulumi.set(__self__, "trap_target_servers", trap_target_servers)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)
        if views and not isinstance(views, list):
            raise TypeError("Expected argument 'views' to be a list")
        pulumi.set(__self__, "views", views)

    @property
    @pulumi.getter
    def communities(self) -> Sequence['outputs.GetSystemSnmpFeatureCommunityResult']:
        """
        Configure SNMP community
        """
        return pulumi.get(self, "communities")

    @property
    @pulumi.getter(name="contactPerson")
    def contact_person(self) -> builtins.str:
        """
        Set the contact for this managed node
        """
        return pulumi.get(self, "contact_person")

    @property
    @pulumi.getter(name="contactPersonVariable")
    def contact_person_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "contact_person_variable")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> builtins.str:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetSystemSnmpFeatureGroupResult']:
        """
        Configure an SNMP group
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the Feature
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="locationOfDevice")
    def location_of_device(self) -> builtins.str:
        """
        Set the physical location of this managed node
        """
        return pulumi.get(self, "location_of_device")

    @property
    @pulumi.getter(name="locationOfDeviceVariable")
    def location_of_device_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "location_of_device_variable")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def shutdown(self) -> builtins.bool:
        """
        Enable or disable SNMP
        """
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @property
    @pulumi.getter(name="trapTargetServers")
    def trap_target_servers(self) -> Sequence['outputs.GetSystemSnmpFeatureTrapTargetServerResult']:
        """
        Configure SNMP server to receive SNMP traps
        """
        return pulumi.get(self, "trap_target_servers")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetSystemSnmpFeatureUserResult']:
        """
        Configure an SNMP user
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def views(self) -> Sequence['outputs.GetSystemSnmpFeatureViewResult']:
        """
        Configure a view record
        """
        return pulumi.get(self, "views")


class AwaitableGetSystemSnmpFeatureResult(GetSystemSnmpFeatureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSystemSnmpFeatureResult(
            communities=self.communities,
            contact_person=self.contact_person,
            contact_person_variable=self.contact_person_variable,
            description=self.description,
            feature_profile_id=self.feature_profile_id,
            groups=self.groups,
            id=self.id,
            location_of_device=self.location_of_device,
            location_of_device_variable=self.location_of_device_variable,
            name=self.name,
            shutdown=self.shutdown,
            shutdown_variable=self.shutdown_variable,
            trap_target_servers=self.trap_target_servers,
            users=self.users,
            version=self.version,
            views=self.views)


def get_system_snmp_feature(feature_profile_id: Optional[builtins.str] = None,
                            id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSystemSnmpFeatureResult:
    """
    This data source can read the System SNMP Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_system_snmp_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param builtins.str feature_profile_id: Feature Profile ID
    :param builtins.str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getSystemSnmpFeature:getSystemSnmpFeature', __args__, opts=opts, typ=GetSystemSnmpFeatureResult).value

    return AwaitableGetSystemSnmpFeatureResult(
        communities=pulumi.get(__ret__, 'communities'),
        contact_person=pulumi.get(__ret__, 'contact_person'),
        contact_person_variable=pulumi.get(__ret__, 'contact_person_variable'),
        description=pulumi.get(__ret__, 'description'),
        feature_profile_id=pulumi.get(__ret__, 'feature_profile_id'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        location_of_device=pulumi.get(__ret__, 'location_of_device'),
        location_of_device_variable=pulumi.get(__ret__, 'location_of_device_variable'),
        name=pulumi.get(__ret__, 'name'),
        shutdown=pulumi.get(__ret__, 'shutdown'),
        shutdown_variable=pulumi.get(__ret__, 'shutdown_variable'),
        trap_target_servers=pulumi.get(__ret__, 'trap_target_servers'),
        users=pulumi.get(__ret__, 'users'),
        version=pulumi.get(__ret__, 'version'),
        views=pulumi.get(__ret__, 'views'))
def get_system_snmp_feature_output(feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                                   id: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSystemSnmpFeatureResult]:
    """
    This data source can read the System SNMP Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_system_snmp_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param builtins.str feature_profile_id: Feature Profile ID
    :param builtins.str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getSystemSnmpFeature:getSystemSnmpFeature', __args__, opts=opts, typ=GetSystemSnmpFeatureResult)
    return __ret__.apply(lambda __response__: GetSystemSnmpFeatureResult(
        communities=pulumi.get(__response__, 'communities'),
        contact_person=pulumi.get(__response__, 'contact_person'),
        contact_person_variable=pulumi.get(__response__, 'contact_person_variable'),
        description=pulumi.get(__response__, 'description'),
        feature_profile_id=pulumi.get(__response__, 'feature_profile_id'),
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        location_of_device=pulumi.get(__response__, 'location_of_device'),
        location_of_device_variable=pulumi.get(__response__, 'location_of_device_variable'),
        name=pulumi.get(__response__, 'name'),
        shutdown=pulumi.get(__response__, 'shutdown'),
        shutdown_variable=pulumi.get(__response__, 'shutdown_variable'),
        trap_target_servers=pulumi.get(__response__, 'trap_target_servers'),
        users=pulumi.get(__response__, 'users'),
        version=pulumi.get(__response__, 'version'),
        views=pulumi.get(__response__, 'views')))
