# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SystemSecurityFeatureArgs', 'SystemSecurityFeature']

@pulumi.input_type
class SystemSecurityFeatureArgs:
    def __init__(__self__, *,
                 anti_replay_window: Optional[pulumi.Input[builtins.str]] = None,
                 anti_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 extended_anti_replay_window: Optional[pulumi.Input[builtins.int]] = None,
                 extended_anti_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 integrity_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 integrity_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipsec_pairwise_keying: Optional[pulumi.Input[builtins.bool]] = None,
                 ipsec_pairwise_keying_variable: Optional[pulumi.Input[builtins.str]] = None,
                 keychains: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeychainArgs']]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeyArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rekey: Optional[pulumi.Input[builtins.int]] = None,
                 rekey_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SystemSecurityFeature resource.
        :param pulumi.Input[builtins.str] anti_replay_window: Set the sliding replay window size - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192` - Default value:
               `512`
        :param pulumi.Input[builtins.str] anti_replay_window_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.int] extended_anti_replay_window: Extended Anti-Replay Window - Range: `10`-`2048` - Default value: `256`
        :param pulumi.Input[builtins.str] extended_anti_replay_window_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] integrity_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] integrity_types: Set the authentication type for DTLS connections
        :param pulumi.Input[builtins.bool] ipsec_pairwise_keying: Enable or disable IPsec pairwise-keying - Default value: `false`
        :param pulumi.Input[builtins.str] ipsec_pairwise_keying_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeychainArgs']]] keychains: Configure a Keychain
        :param pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeyArgs']]] keys: Configure a Key
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] rekey: Set how often to change the AES key for DTLS connections - Range: `10`-`1209600` - Default value: `86400`
        :param pulumi.Input[builtins.str] rekey_variable: Variable name
        """
        if anti_replay_window is not None:
            pulumi.set(__self__, "anti_replay_window", anti_replay_window)
        if anti_replay_window_variable is not None:
            pulumi.set(__self__, "anti_replay_window_variable", anti_replay_window_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if extended_anti_replay_window is not None:
            pulumi.set(__self__, "extended_anti_replay_window", extended_anti_replay_window)
        if extended_anti_replay_window_variable is not None:
            pulumi.set(__self__, "extended_anti_replay_window_variable", extended_anti_replay_window_variable)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if integrity_type_variable is not None:
            pulumi.set(__self__, "integrity_type_variable", integrity_type_variable)
        if integrity_types is not None:
            pulumi.set(__self__, "integrity_types", integrity_types)
        if ipsec_pairwise_keying is not None:
            pulumi.set(__self__, "ipsec_pairwise_keying", ipsec_pairwise_keying)
        if ipsec_pairwise_keying_variable is not None:
            pulumi.set(__self__, "ipsec_pairwise_keying_variable", ipsec_pairwise_keying_variable)
        if keychains is not None:
            pulumi.set(__self__, "keychains", keychains)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rekey is not None:
            pulumi.set(__self__, "rekey", rekey)
        if rekey_variable is not None:
            pulumi.set(__self__, "rekey_variable", rekey_variable)

    @property
    @pulumi.getter(name="antiReplayWindow")
    def anti_replay_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the sliding replay window size - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192` - Default value:
        `512`
        """
        return pulumi.get(self, "anti_replay_window")

    @anti_replay_window.setter
    def anti_replay_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "anti_replay_window", value)

    @property
    @pulumi.getter(name="antiReplayWindowVariable")
    def anti_replay_window_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "anti_replay_window_variable")

    @anti_replay_window_variable.setter
    def anti_replay_window_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "anti_replay_window_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="extendedAntiReplayWindow")
    def extended_anti_replay_window(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Extended Anti-Replay Window - Range: `10`-`2048` - Default value: `256`
        """
        return pulumi.get(self, "extended_anti_replay_window")

    @extended_anti_replay_window.setter
    def extended_anti_replay_window(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "extended_anti_replay_window", value)

    @property
    @pulumi.getter(name="extendedAntiReplayWindowVariable")
    def extended_anti_replay_window_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "extended_anti_replay_window_variable")

    @extended_anti_replay_window_variable.setter
    def extended_anti_replay_window_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "extended_anti_replay_window_variable", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="integrityTypeVariable")
    def integrity_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "integrity_type_variable")

    @integrity_type_variable.setter
    def integrity_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integrity_type_variable", value)

    @property
    @pulumi.getter(name="integrityTypes")
    def integrity_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set the authentication type for DTLS connections
        """
        return pulumi.get(self, "integrity_types")

    @integrity_types.setter
    def integrity_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "integrity_types", value)

    @property
    @pulumi.getter(name="ipsecPairwiseKeying")
    def ipsec_pairwise_keying(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable IPsec pairwise-keying - Default value: `false`
        """
        return pulumi.get(self, "ipsec_pairwise_keying")

    @ipsec_pairwise_keying.setter
    def ipsec_pairwise_keying(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ipsec_pairwise_keying", value)

    @property
    @pulumi.getter(name="ipsecPairwiseKeyingVariable")
    def ipsec_pairwise_keying_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_pairwise_keying_variable")

    @ipsec_pairwise_keying_variable.setter
    def ipsec_pairwise_keying_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_pairwise_keying_variable", value)

    @property
    @pulumi.getter
    def keychains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeychainArgs']]]]:
        """
        Configure a Keychain
        """
        return pulumi.get(self, "keychains")

    @keychains.setter
    def keychains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeychainArgs']]]]):
        pulumi.set(self, "keychains", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeyArgs']]]]:
        """
        Configure a Key
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeyArgs']]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rekey(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set how often to change the AES key for DTLS connections - Range: `10`-`1209600` - Default value: `86400`
        """
        return pulumi.get(self, "rekey")

    @rekey.setter
    def rekey(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rekey", value)

    @property
    @pulumi.getter(name="rekeyVariable")
    def rekey_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rekey_variable")

    @rekey_variable.setter
    def rekey_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rekey_variable", value)


@pulumi.input_type
class _SystemSecurityFeatureState:
    def __init__(__self__, *,
                 anti_replay_window: Optional[pulumi.Input[builtins.str]] = None,
                 anti_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 extended_anti_replay_window: Optional[pulumi.Input[builtins.int]] = None,
                 extended_anti_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 integrity_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 integrity_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipsec_pairwise_keying: Optional[pulumi.Input[builtins.bool]] = None,
                 ipsec_pairwise_keying_variable: Optional[pulumi.Input[builtins.str]] = None,
                 keychains: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeychainArgs']]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeyArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rekey: Optional[pulumi.Input[builtins.int]] = None,
                 rekey_variable: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering SystemSecurityFeature resources.
        :param pulumi.Input[builtins.str] anti_replay_window: Set the sliding replay window size - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192` - Default value:
               `512`
        :param pulumi.Input[builtins.str] anti_replay_window_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.int] extended_anti_replay_window: Extended Anti-Replay Window - Range: `10`-`2048` - Default value: `256`
        :param pulumi.Input[builtins.str] extended_anti_replay_window_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] integrity_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] integrity_types: Set the authentication type for DTLS connections
        :param pulumi.Input[builtins.bool] ipsec_pairwise_keying: Enable or disable IPsec pairwise-keying - Default value: `false`
        :param pulumi.Input[builtins.str] ipsec_pairwise_keying_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeychainArgs']]] keychains: Configure a Keychain
        :param pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeyArgs']]] keys: Configure a Key
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] rekey: Set how often to change the AES key for DTLS connections - Range: `10`-`1209600` - Default value: `86400`
        :param pulumi.Input[builtins.str] rekey_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        if anti_replay_window is not None:
            pulumi.set(__self__, "anti_replay_window", anti_replay_window)
        if anti_replay_window_variable is not None:
            pulumi.set(__self__, "anti_replay_window_variable", anti_replay_window_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if extended_anti_replay_window is not None:
            pulumi.set(__self__, "extended_anti_replay_window", extended_anti_replay_window)
        if extended_anti_replay_window_variable is not None:
            pulumi.set(__self__, "extended_anti_replay_window_variable", extended_anti_replay_window_variable)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if integrity_type_variable is not None:
            pulumi.set(__self__, "integrity_type_variable", integrity_type_variable)
        if integrity_types is not None:
            pulumi.set(__self__, "integrity_types", integrity_types)
        if ipsec_pairwise_keying is not None:
            pulumi.set(__self__, "ipsec_pairwise_keying", ipsec_pairwise_keying)
        if ipsec_pairwise_keying_variable is not None:
            pulumi.set(__self__, "ipsec_pairwise_keying_variable", ipsec_pairwise_keying_variable)
        if keychains is not None:
            pulumi.set(__self__, "keychains", keychains)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rekey is not None:
            pulumi.set(__self__, "rekey", rekey)
        if rekey_variable is not None:
            pulumi.set(__self__, "rekey_variable", rekey_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="antiReplayWindow")
    def anti_replay_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the sliding replay window size - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192` - Default value:
        `512`
        """
        return pulumi.get(self, "anti_replay_window")

    @anti_replay_window.setter
    def anti_replay_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "anti_replay_window", value)

    @property
    @pulumi.getter(name="antiReplayWindowVariable")
    def anti_replay_window_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "anti_replay_window_variable")

    @anti_replay_window_variable.setter
    def anti_replay_window_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "anti_replay_window_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="extendedAntiReplayWindow")
    def extended_anti_replay_window(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Extended Anti-Replay Window - Range: `10`-`2048` - Default value: `256`
        """
        return pulumi.get(self, "extended_anti_replay_window")

    @extended_anti_replay_window.setter
    def extended_anti_replay_window(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "extended_anti_replay_window", value)

    @property
    @pulumi.getter(name="extendedAntiReplayWindowVariable")
    def extended_anti_replay_window_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "extended_anti_replay_window_variable")

    @extended_anti_replay_window_variable.setter
    def extended_anti_replay_window_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "extended_anti_replay_window_variable", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="integrityTypeVariable")
    def integrity_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "integrity_type_variable")

    @integrity_type_variable.setter
    def integrity_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integrity_type_variable", value)

    @property
    @pulumi.getter(name="integrityTypes")
    def integrity_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set the authentication type for DTLS connections
        """
        return pulumi.get(self, "integrity_types")

    @integrity_types.setter
    def integrity_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "integrity_types", value)

    @property
    @pulumi.getter(name="ipsecPairwiseKeying")
    def ipsec_pairwise_keying(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable IPsec pairwise-keying - Default value: `false`
        """
        return pulumi.get(self, "ipsec_pairwise_keying")

    @ipsec_pairwise_keying.setter
    def ipsec_pairwise_keying(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ipsec_pairwise_keying", value)

    @property
    @pulumi.getter(name="ipsecPairwiseKeyingVariable")
    def ipsec_pairwise_keying_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_pairwise_keying_variable")

    @ipsec_pairwise_keying_variable.setter
    def ipsec_pairwise_keying_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipsec_pairwise_keying_variable", value)

    @property
    @pulumi.getter
    def keychains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeychainArgs']]]]:
        """
        Configure a Keychain
        """
        return pulumi.get(self, "keychains")

    @keychains.setter
    def keychains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeychainArgs']]]]):
        pulumi.set(self, "keychains", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeyArgs']]]]:
        """
        Configure a Key
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemSecurityFeatureKeyArgs']]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rekey(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set how often to change the AES key for DTLS connections - Range: `10`-`1209600` - Default value: `86400`
        """
        return pulumi.get(self, "rekey")

    @rekey.setter
    def rekey(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rekey", value)

    @property
    @pulumi.getter(name="rekeyVariable")
    def rekey_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rekey_variable")

    @rekey_variable.setter
    def rekey_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rekey_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


class SystemSecurityFeature(pulumi.CustomResource):

    pulumi_type = "sdwan:index/systemSecurityFeature:SystemSecurityFeature"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anti_replay_window: Optional[pulumi.Input[builtins.str]] = None,
                 anti_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 extended_anti_replay_window: Optional[pulumi.Input[builtins.int]] = None,
                 extended_anti_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 integrity_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 integrity_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipsec_pairwise_keying: Optional[pulumi.Input[builtins.bool]] = None,
                 ipsec_pairwise_keying_variable: Optional[pulumi.Input[builtins.str]] = None,
                 keychains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSecurityFeatureKeychainArgs', 'SystemSecurityFeatureKeychainArgsDict']]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSecurityFeatureKeyArgs', 'SystemSecurityFeatureKeyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rekey: Optional[pulumi.Input[builtins.int]] = None,
                 rekey_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a System Security Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "system_security_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemSecurityFeature:SystemSecurityFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] anti_replay_window: Set the sliding replay window size - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192` - Default value:
               `512`
        :param pulumi.Input[builtins.str] anti_replay_window_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.int] extended_anti_replay_window: Extended Anti-Replay Window - Range: `10`-`2048` - Default value: `256`
        :param pulumi.Input[builtins.str] extended_anti_replay_window_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] integrity_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] integrity_types: Set the authentication type for DTLS connections
        :param pulumi.Input[builtins.bool] ipsec_pairwise_keying: Enable or disable IPsec pairwise-keying - Default value: `false`
        :param pulumi.Input[builtins.str] ipsec_pairwise_keying_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSecurityFeatureKeychainArgs', 'SystemSecurityFeatureKeychainArgsDict']]]] keychains: Configure a Keychain
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSecurityFeatureKeyArgs', 'SystemSecurityFeatureKeyArgsDict']]]] keys: Configure a Key
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] rekey: Set how often to change the AES key for DTLS connections - Range: `10`-`1209600` - Default value: `86400`
        :param pulumi.Input[builtins.str] rekey_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SystemSecurityFeatureArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a System Security Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "system_security_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemSecurityFeature:SystemSecurityFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param SystemSecurityFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SystemSecurityFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anti_replay_window: Optional[pulumi.Input[builtins.str]] = None,
                 anti_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 extended_anti_replay_window: Optional[pulumi.Input[builtins.int]] = None,
                 extended_anti_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 integrity_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 integrity_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipsec_pairwise_keying: Optional[pulumi.Input[builtins.bool]] = None,
                 ipsec_pairwise_keying_variable: Optional[pulumi.Input[builtins.str]] = None,
                 keychains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSecurityFeatureKeychainArgs', 'SystemSecurityFeatureKeychainArgsDict']]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSecurityFeatureKeyArgs', 'SystemSecurityFeatureKeyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rekey: Optional[pulumi.Input[builtins.int]] = None,
                 rekey_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SystemSecurityFeatureArgs.__new__(SystemSecurityFeatureArgs)

            __props__.__dict__["anti_replay_window"] = anti_replay_window
            __props__.__dict__["anti_replay_window_variable"] = anti_replay_window_variable
            __props__.__dict__["description"] = description
            __props__.__dict__["extended_anti_replay_window"] = extended_anti_replay_window
            __props__.__dict__["extended_anti_replay_window_variable"] = extended_anti_replay_window_variable
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["integrity_type_variable"] = integrity_type_variable
            __props__.__dict__["integrity_types"] = integrity_types
            __props__.__dict__["ipsec_pairwise_keying"] = ipsec_pairwise_keying
            __props__.__dict__["ipsec_pairwise_keying_variable"] = ipsec_pairwise_keying_variable
            __props__.__dict__["keychains"] = keychains
            __props__.__dict__["keys"] = keys
            __props__.__dict__["name"] = name
            __props__.__dict__["rekey"] = rekey
            __props__.__dict__["rekey_variable"] = rekey_variable
            __props__.__dict__["version"] = None
        super(SystemSecurityFeature, __self__).__init__(
            'sdwan:index/systemSecurityFeature:SystemSecurityFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            anti_replay_window: Optional[pulumi.Input[builtins.str]] = None,
            anti_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            extended_anti_replay_window: Optional[pulumi.Input[builtins.int]] = None,
            extended_anti_replay_window_variable: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            integrity_type_variable: Optional[pulumi.Input[builtins.str]] = None,
            integrity_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ipsec_pairwise_keying: Optional[pulumi.Input[builtins.bool]] = None,
            ipsec_pairwise_keying_variable: Optional[pulumi.Input[builtins.str]] = None,
            keychains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSecurityFeatureKeychainArgs', 'SystemSecurityFeatureKeychainArgsDict']]]]] = None,
            keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemSecurityFeatureKeyArgs', 'SystemSecurityFeatureKeyArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            rekey: Optional[pulumi.Input[builtins.int]] = None,
            rekey_variable: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'SystemSecurityFeature':
        """
        Get an existing SystemSecurityFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] anti_replay_window: Set the sliding replay window size - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192` - Default value:
               `512`
        :param pulumi.Input[builtins.str] anti_replay_window_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.int] extended_anti_replay_window: Extended Anti-Replay Window - Range: `10`-`2048` - Default value: `256`
        :param pulumi.Input[builtins.str] extended_anti_replay_window_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] integrity_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] integrity_types: Set the authentication type for DTLS connections
        :param pulumi.Input[builtins.bool] ipsec_pairwise_keying: Enable or disable IPsec pairwise-keying - Default value: `false`
        :param pulumi.Input[builtins.str] ipsec_pairwise_keying_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSecurityFeatureKeychainArgs', 'SystemSecurityFeatureKeychainArgsDict']]]] keychains: Configure a Keychain
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemSecurityFeatureKeyArgs', 'SystemSecurityFeatureKeyArgsDict']]]] keys: Configure a Key
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] rekey: Set how often to change the AES key for DTLS connections - Range: `10`-`1209600` - Default value: `86400`
        :param pulumi.Input[builtins.str] rekey_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SystemSecurityFeatureState.__new__(_SystemSecurityFeatureState)

        __props__.__dict__["anti_replay_window"] = anti_replay_window
        __props__.__dict__["anti_replay_window_variable"] = anti_replay_window_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["extended_anti_replay_window"] = extended_anti_replay_window
        __props__.__dict__["extended_anti_replay_window_variable"] = extended_anti_replay_window_variable
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["integrity_type_variable"] = integrity_type_variable
        __props__.__dict__["integrity_types"] = integrity_types
        __props__.__dict__["ipsec_pairwise_keying"] = ipsec_pairwise_keying
        __props__.__dict__["ipsec_pairwise_keying_variable"] = ipsec_pairwise_keying_variable
        __props__.__dict__["keychains"] = keychains
        __props__.__dict__["keys"] = keys
        __props__.__dict__["name"] = name
        __props__.__dict__["rekey"] = rekey
        __props__.__dict__["rekey_variable"] = rekey_variable
        __props__.__dict__["version"] = version
        return SystemSecurityFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="antiReplayWindow")
    def anti_replay_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set the sliding replay window size - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192` - Default value:
        `512`
        """
        return pulumi.get(self, "anti_replay_window")

    @property
    @pulumi.getter(name="antiReplayWindowVariable")
    def anti_replay_window_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "anti_replay_window_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="extendedAntiReplayWindow")
    def extended_anti_replay_window(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Extended Anti-Replay Window - Range: `10`-`2048` - Default value: `256`
        """
        return pulumi.get(self, "extended_anti_replay_window")

    @property
    @pulumi.getter(name="extendedAntiReplayWindowVariable")
    def extended_anti_replay_window_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "extended_anti_replay_window_variable")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter(name="integrityTypeVariable")
    def integrity_type_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "integrity_type_variable")

    @property
    @pulumi.getter(name="integrityTypes")
    def integrity_types(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Set the authentication type for DTLS connections
        """
        return pulumi.get(self, "integrity_types")

    @property
    @pulumi.getter(name="ipsecPairwiseKeying")
    def ipsec_pairwise_keying(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable or disable IPsec pairwise-keying - Default value: `false`
        """
        return pulumi.get(self, "ipsec_pairwise_keying")

    @property
    @pulumi.getter(name="ipsecPairwiseKeyingVariable")
    def ipsec_pairwise_keying_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipsec_pairwise_keying_variable")

    @property
    @pulumi.getter
    def keychains(self) -> pulumi.Output[Optional[Sequence['outputs.SystemSecurityFeatureKeychain']]]:
        """
        Configure a Keychain
        """
        return pulumi.get(self, "keychains")

    @property
    @pulumi.getter
    def keys(self) -> pulumi.Output[Optional[Sequence['outputs.SystemSecurityFeatureKey']]]:
        """
        Configure a Key
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rekey(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set how often to change the AES key for DTLS connections - Range: `10`-`1209600` - Default value: `86400`
        """
        return pulumi.get(self, "rekey")

    @property
    @pulumi.getter(name="rekeyVariable")
    def rekey_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rekey_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

