# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AdvancedMalwareProtectionPolicyDefinitionArgs', 'AdvancedMalwareProtectionPolicyDefinition']

@pulumi.input_type
class AdvancedMalwareProtectionPolicyDefinitionArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 alert_log_level: Optional[pulumi.Input[builtins.str]] = None,
                 amp_cloud_region: Optional[pulumi.Input[builtins.str]] = None,
                 amp_cloud_region_est_server: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis: Optional[pulumi.Input[builtins.bool]] = None,
                 file_analysis_alert_log_level: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis_cloud_region: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis_file_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AdvancedMalwareProtectionPolicyDefinition resource.
        :param pulumi.Input[builtins.str] description: The description of the policy definition
        :param pulumi.Input[builtins.str] alert_log_level: File reputation alerts Log level - Choices: `critical`, `warning`, `info`
        :param pulumi.Input[builtins.str] amp_cloud_region: AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        :param pulumi.Input[builtins.str] amp_cloud_region_est_server: AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        :param pulumi.Input[builtins.bool] file_analysis: Should file analysis be enabled
        :param pulumi.Input[builtins.str] file_analysis_alert_log_level: File analysis alerts Log level - Choices: `critical`, `warning`, `info`
        :param pulumi.Input[builtins.str] file_analysis_cloud_region: TG Cloud Region - Choices: `nam`, `eu`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] file_analysis_file_types: List of file type
        :param pulumi.Input[builtins.bool] match_all_vpn: Should match all VPNs
        :param pulumi.Input[builtins.str] mode: The policy mode - Choices: `security`, `unified` - Default value: `security`
        :param pulumi.Input[builtins.str] name: The name of the policy definition
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_vpns: List of VPN IDs
        """
        pulumi.set(__self__, "description", description)
        if alert_log_level is not None:
            pulumi.set(__self__, "alert_log_level", alert_log_level)
        if amp_cloud_region is not None:
            pulumi.set(__self__, "amp_cloud_region", amp_cloud_region)
        if amp_cloud_region_est_server is not None:
            pulumi.set(__self__, "amp_cloud_region_est_server", amp_cloud_region_est_server)
        if file_analysis is not None:
            pulumi.set(__self__, "file_analysis", file_analysis)
        if file_analysis_alert_log_level is not None:
            pulumi.set(__self__, "file_analysis_alert_log_level", file_analysis_alert_log_level)
        if file_analysis_cloud_region is not None:
            pulumi.set(__self__, "file_analysis_cloud_region", file_analysis_cloud_region)
        if file_analysis_file_types is not None:
            pulumi.set(__self__, "file_analysis_file_types", file_analysis_file_types)
        if match_all_vpn is not None:
            pulumi.set(__self__, "match_all_vpn", match_all_vpn)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_vpns is not None:
            pulumi.set(__self__, "target_vpns", target_vpns)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the policy definition
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="alertLogLevel")
    def alert_log_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        File reputation alerts Log level - Choices: `critical`, `warning`, `info`
        """
        return pulumi.get(self, "alert_log_level")

    @alert_log_level.setter
    def alert_log_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alert_log_level", value)

    @property
    @pulumi.getter(name="ampCloudRegion")
    def amp_cloud_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        """
        return pulumi.get(self, "amp_cloud_region")

    @amp_cloud_region.setter
    def amp_cloud_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "amp_cloud_region", value)

    @property
    @pulumi.getter(name="ampCloudRegionEstServer")
    def amp_cloud_region_est_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        """
        return pulumi.get(self, "amp_cloud_region_est_server")

    @amp_cloud_region_est_server.setter
    def amp_cloud_region_est_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "amp_cloud_region_est_server", value)

    @property
    @pulumi.getter(name="fileAnalysis")
    def file_analysis(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should file analysis be enabled
        """
        return pulumi.get(self, "file_analysis")

    @file_analysis.setter
    def file_analysis(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "file_analysis", value)

    @property
    @pulumi.getter(name="fileAnalysisAlertLogLevel")
    def file_analysis_alert_log_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        File analysis alerts Log level - Choices: `critical`, `warning`, `info`
        """
        return pulumi.get(self, "file_analysis_alert_log_level")

    @file_analysis_alert_log_level.setter
    def file_analysis_alert_log_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_analysis_alert_log_level", value)

    @property
    @pulumi.getter(name="fileAnalysisCloudRegion")
    def file_analysis_cloud_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TG Cloud Region - Choices: `nam`, `eu`
        """
        return pulumi.get(self, "file_analysis_cloud_region")

    @file_analysis_cloud_region.setter
    def file_analysis_cloud_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_analysis_cloud_region", value)

    @property
    @pulumi.getter(name="fileAnalysisFileTypes")
    def file_analysis_file_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of file type
        """
        return pulumi.get(self, "file_analysis_file_types")

    @file_analysis_file_types.setter
    def file_analysis_file_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "file_analysis_file_types", value)

    @property
    @pulumi.getter(name="matchAllVpn")
    def match_all_vpn(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should match all VPNs
        """
        return pulumi.get(self, "match_all_vpn")

    @match_all_vpn.setter
    def match_all_vpn(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "match_all_vpn", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The policy mode - Choices: `security`, `unified` - Default value: `security`
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy definition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of VPN IDs
        """
        return pulumi.get(self, "target_vpns")

    @target_vpns.setter
    def target_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_vpns", value)


@pulumi.input_type
class _AdvancedMalwareProtectionPolicyDefinitionState:
    def __init__(__self__, *,
                 alert_log_level: Optional[pulumi.Input[builtins.str]] = None,
                 amp_cloud_region: Optional[pulumi.Input[builtins.str]] = None,
                 amp_cloud_region_est_server: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis: Optional[pulumi.Input[builtins.bool]] = None,
                 file_analysis_alert_log_level: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis_cloud_region: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis_file_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering AdvancedMalwareProtectionPolicyDefinition resources.
        :param pulumi.Input[builtins.str] alert_log_level: File reputation alerts Log level - Choices: `critical`, `warning`, `info`
        :param pulumi.Input[builtins.str] amp_cloud_region: AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        :param pulumi.Input[builtins.str] amp_cloud_region_est_server: AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        :param pulumi.Input[builtins.str] description: The description of the policy definition
        :param pulumi.Input[builtins.bool] file_analysis: Should file analysis be enabled
        :param pulumi.Input[builtins.str] file_analysis_alert_log_level: File analysis alerts Log level - Choices: `critical`, `warning`, `info`
        :param pulumi.Input[builtins.str] file_analysis_cloud_region: TG Cloud Region - Choices: `nam`, `eu`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] file_analysis_file_types: List of file type
        :param pulumi.Input[builtins.bool] match_all_vpn: Should match all VPNs
        :param pulumi.Input[builtins.str] mode: The policy mode - Choices: `security`, `unified` - Default value: `security`
        :param pulumi.Input[builtins.str] name: The name of the policy definition
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_vpns: List of VPN IDs
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        if alert_log_level is not None:
            pulumi.set(__self__, "alert_log_level", alert_log_level)
        if amp_cloud_region is not None:
            pulumi.set(__self__, "amp_cloud_region", amp_cloud_region)
        if amp_cloud_region_est_server is not None:
            pulumi.set(__self__, "amp_cloud_region_est_server", amp_cloud_region_est_server)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_analysis is not None:
            pulumi.set(__self__, "file_analysis", file_analysis)
        if file_analysis_alert_log_level is not None:
            pulumi.set(__self__, "file_analysis_alert_log_level", file_analysis_alert_log_level)
        if file_analysis_cloud_region is not None:
            pulumi.set(__self__, "file_analysis_cloud_region", file_analysis_cloud_region)
        if file_analysis_file_types is not None:
            pulumi.set(__self__, "file_analysis_file_types", file_analysis_file_types)
        if match_all_vpn is not None:
            pulumi.set(__self__, "match_all_vpn", match_all_vpn)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_vpns is not None:
            pulumi.set(__self__, "target_vpns", target_vpns)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="alertLogLevel")
    def alert_log_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        File reputation alerts Log level - Choices: `critical`, `warning`, `info`
        """
        return pulumi.get(self, "alert_log_level")

    @alert_log_level.setter
    def alert_log_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alert_log_level", value)

    @property
    @pulumi.getter(name="ampCloudRegion")
    def amp_cloud_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        """
        return pulumi.get(self, "amp_cloud_region")

    @amp_cloud_region.setter
    def amp_cloud_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "amp_cloud_region", value)

    @property
    @pulumi.getter(name="ampCloudRegionEstServer")
    def amp_cloud_region_est_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        """
        return pulumi.get(self, "amp_cloud_region_est_server")

    @amp_cloud_region_est_server.setter
    def amp_cloud_region_est_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "amp_cloud_region_est_server", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the policy definition
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileAnalysis")
    def file_analysis(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should file analysis be enabled
        """
        return pulumi.get(self, "file_analysis")

    @file_analysis.setter
    def file_analysis(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "file_analysis", value)

    @property
    @pulumi.getter(name="fileAnalysisAlertLogLevel")
    def file_analysis_alert_log_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        File analysis alerts Log level - Choices: `critical`, `warning`, `info`
        """
        return pulumi.get(self, "file_analysis_alert_log_level")

    @file_analysis_alert_log_level.setter
    def file_analysis_alert_log_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_analysis_alert_log_level", value)

    @property
    @pulumi.getter(name="fileAnalysisCloudRegion")
    def file_analysis_cloud_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TG Cloud Region - Choices: `nam`, `eu`
        """
        return pulumi.get(self, "file_analysis_cloud_region")

    @file_analysis_cloud_region.setter
    def file_analysis_cloud_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_analysis_cloud_region", value)

    @property
    @pulumi.getter(name="fileAnalysisFileTypes")
    def file_analysis_file_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of file type
        """
        return pulumi.get(self, "file_analysis_file_types")

    @file_analysis_file_types.setter
    def file_analysis_file_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "file_analysis_file_types", value)

    @property
    @pulumi.getter(name="matchAllVpn")
    def match_all_vpn(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should match all VPNs
        """
        return pulumi.get(self, "match_all_vpn")

    @match_all_vpn.setter
    def match_all_vpn(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "match_all_vpn", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The policy mode - Choices: `security`, `unified` - Default value: `security`
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy definition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of VPN IDs
        """
        return pulumi.get(self, "target_vpns")

    @target_vpns.setter
    def target_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_vpns", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


class AdvancedMalwareProtectionPolicyDefinition(pulumi.CustomResource):

    pulumi_type = "sdwan:index/advancedMalwareProtectionPolicyDefinition:AdvancedMalwareProtectionPolicyDefinition"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_log_level: Optional[pulumi.Input[builtins.str]] = None,
                 amp_cloud_region: Optional[pulumi.Input[builtins.str]] = None,
                 amp_cloud_region_est_server: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis: Optional[pulumi.Input[builtins.bool]] = None,
                 file_analysis_alert_log_level: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis_cloud_region: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis_file_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource can manage a Advanced Malware Protection Policy Definition .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.AdvancedMalwareProtectionPolicyDefinition("example",
            name="Example",
            description="My description",
            mode="security",
            match_all_vpn=False,
            target_vpns=["1"],
            alert_log_level="critical",
            amp_cloud_region="apjc",
            amp_cloud_region_est_server="apjc",
            file_analysis=False)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/advancedMalwareProtectionPolicyDefinition:AdvancedMalwareProtectionPolicyDefinition example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alert_log_level: File reputation alerts Log level - Choices: `critical`, `warning`, `info`
        :param pulumi.Input[builtins.str] amp_cloud_region: AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        :param pulumi.Input[builtins.str] amp_cloud_region_est_server: AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        :param pulumi.Input[builtins.str] description: The description of the policy definition
        :param pulumi.Input[builtins.bool] file_analysis: Should file analysis be enabled
        :param pulumi.Input[builtins.str] file_analysis_alert_log_level: File analysis alerts Log level - Choices: `critical`, `warning`, `info`
        :param pulumi.Input[builtins.str] file_analysis_cloud_region: TG Cloud Region - Choices: `nam`, `eu`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] file_analysis_file_types: List of file type
        :param pulumi.Input[builtins.bool] match_all_vpn: Should match all VPNs
        :param pulumi.Input[builtins.str] mode: The policy mode - Choices: `security`, `unified` - Default value: `security`
        :param pulumi.Input[builtins.str] name: The name of the policy definition
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_vpns: List of VPN IDs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdvancedMalwareProtectionPolicyDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Advanced Malware Protection Policy Definition .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.AdvancedMalwareProtectionPolicyDefinition("example",
            name="Example",
            description="My description",
            mode="security",
            match_all_vpn=False,
            target_vpns=["1"],
            alert_log_level="critical",
            amp_cloud_region="apjc",
            amp_cloud_region_est_server="apjc",
            file_analysis=False)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/advancedMalwareProtectionPolicyDefinition:AdvancedMalwareProtectionPolicyDefinition example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param AdvancedMalwareProtectionPolicyDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdvancedMalwareProtectionPolicyDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_log_level: Optional[pulumi.Input[builtins.str]] = None,
                 amp_cloud_region: Optional[pulumi.Input[builtins.str]] = None,
                 amp_cloud_region_est_server: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis: Optional[pulumi.Input[builtins.bool]] = None,
                 file_analysis_alert_log_level: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis_cloud_region: Optional[pulumi.Input[builtins.str]] = None,
                 file_analysis_file_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdvancedMalwareProtectionPolicyDefinitionArgs.__new__(AdvancedMalwareProtectionPolicyDefinitionArgs)

            __props__.__dict__["alert_log_level"] = alert_log_level
            __props__.__dict__["amp_cloud_region"] = amp_cloud_region
            __props__.__dict__["amp_cloud_region_est_server"] = amp_cloud_region_est_server
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["file_analysis"] = file_analysis
            __props__.__dict__["file_analysis_alert_log_level"] = file_analysis_alert_log_level
            __props__.__dict__["file_analysis_cloud_region"] = file_analysis_cloud_region
            __props__.__dict__["file_analysis_file_types"] = file_analysis_file_types
            __props__.__dict__["match_all_vpn"] = match_all_vpn
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["target_vpns"] = target_vpns
            __props__.__dict__["version"] = None
        super(AdvancedMalwareProtectionPolicyDefinition, __self__).__init__(
            'sdwan:index/advancedMalwareProtectionPolicyDefinition:AdvancedMalwareProtectionPolicyDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_log_level: Optional[pulumi.Input[builtins.str]] = None,
            amp_cloud_region: Optional[pulumi.Input[builtins.str]] = None,
            amp_cloud_region_est_server: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            file_analysis: Optional[pulumi.Input[builtins.bool]] = None,
            file_analysis_alert_log_level: Optional[pulumi.Input[builtins.str]] = None,
            file_analysis_cloud_region: Optional[pulumi.Input[builtins.str]] = None,
            file_analysis_file_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
            mode: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'AdvancedMalwareProtectionPolicyDefinition':
        """
        Get an existing AdvancedMalwareProtectionPolicyDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alert_log_level: File reputation alerts Log level - Choices: `critical`, `warning`, `info`
        :param pulumi.Input[builtins.str] amp_cloud_region: AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        :param pulumi.Input[builtins.str] amp_cloud_region_est_server: AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        :param pulumi.Input[builtins.str] description: The description of the policy definition
        :param pulumi.Input[builtins.bool] file_analysis: Should file analysis be enabled
        :param pulumi.Input[builtins.str] file_analysis_alert_log_level: File analysis alerts Log level - Choices: `critical`, `warning`, `info`
        :param pulumi.Input[builtins.str] file_analysis_cloud_region: TG Cloud Region - Choices: `nam`, `eu`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] file_analysis_file_types: List of file type
        :param pulumi.Input[builtins.bool] match_all_vpn: Should match all VPNs
        :param pulumi.Input[builtins.str] mode: The policy mode - Choices: `security`, `unified` - Default value: `security`
        :param pulumi.Input[builtins.str] name: The name of the policy definition
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_vpns: List of VPN IDs
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdvancedMalwareProtectionPolicyDefinitionState.__new__(_AdvancedMalwareProtectionPolicyDefinitionState)

        __props__.__dict__["alert_log_level"] = alert_log_level
        __props__.__dict__["amp_cloud_region"] = amp_cloud_region
        __props__.__dict__["amp_cloud_region_est_server"] = amp_cloud_region_est_server
        __props__.__dict__["description"] = description
        __props__.__dict__["file_analysis"] = file_analysis
        __props__.__dict__["file_analysis_alert_log_level"] = file_analysis_alert_log_level
        __props__.__dict__["file_analysis_cloud_region"] = file_analysis_cloud_region
        __props__.__dict__["file_analysis_file_types"] = file_analysis_file_types
        __props__.__dict__["match_all_vpn"] = match_all_vpn
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["target_vpns"] = target_vpns
        __props__.__dict__["version"] = version
        return AdvancedMalwareProtectionPolicyDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertLogLevel")
    def alert_log_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        File reputation alerts Log level - Choices: `critical`, `warning`, `info`
        """
        return pulumi.get(self, "alert_log_level")

    @property
    @pulumi.getter(name="ampCloudRegion")
    def amp_cloud_region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        """
        return pulumi.get(self, "amp_cloud_region")

    @property
    @pulumi.getter(name="ampCloudRegionEstServer")
    def amp_cloud_region_est_server(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AMP Cloud Region - Choices: `nam`, `eu`, `apjc`
        """
        return pulumi.get(self, "amp_cloud_region_est_server")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the policy definition
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fileAnalysis")
    def file_analysis(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should file analysis be enabled
        """
        return pulumi.get(self, "file_analysis")

    @property
    @pulumi.getter(name="fileAnalysisAlertLogLevel")
    def file_analysis_alert_log_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        File analysis alerts Log level - Choices: `critical`, `warning`, `info`
        """
        return pulumi.get(self, "file_analysis_alert_log_level")

    @property
    @pulumi.getter(name="fileAnalysisCloudRegion")
    def file_analysis_cloud_region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        TG Cloud Region - Choices: `nam`, `eu`
        """
        return pulumi.get(self, "file_analysis_cloud_region")

    @property
    @pulumi.getter(name="fileAnalysisFileTypes")
    def file_analysis_file_types(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of file type
        """
        return pulumi.get(self, "file_analysis_file_types")

    @property
    @pulumi.getter(name="matchAllVpn")
    def match_all_vpn(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should match all VPNs
        """
        return pulumi.get(self, "match_all_vpn")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[builtins.str]:
        """
        The policy mode - Choices: `security`, `unified` - Default value: `security`
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the policy definition
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of VPN IDs
        """
        return pulumi.get(self, "target_vpns")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

