# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CedgeAaaFeatureTemplateArgs', 'CedgeAaaFeatureTemplate']

@pulumi.input_type
class CedgeAaaFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAccountingRuleArgs']]]] = None,
                 authorization_config_commands: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_console: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAuthorizationRuleArgs']]]] = None,
                 dot1x_accounting: Optional[pulumi.Input[builtins.bool]] = None,
                 dot1x_accounting_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dot1x_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 dot1x_authentication_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 radius_clients: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusClientArgs']]]] = None,
                 radius_dynamic_author_authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_domain_stripping: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_domain_stripping_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_port: Optional[pulumi.Input[builtins.int]] = None,
                 radius_dynamic_author_port_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_server_key: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_server_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusServerGroupArgs']]]] = None,
                 radius_trustsec_cts_authorization_list: Optional[pulumi.Input[builtins.str]] = None,
                 radius_trustsec_cts_authorization_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_trustsec_group: Optional[pulumi.Input[builtins.str]] = None,
                 server_groups_priority_order: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateTacacsServerGroupArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateUserArgs']]]] = None):
        """
        The set of arguments for constructing a CedgeAaaFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAccountingRuleArgs']]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[builtins.bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAuthorizationRuleArgs']]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[builtins.bool] dot1x_accounting: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] dot1x_accounting_variable: Variable name
        :param pulumi.Input[builtins.bool] dot1x_authentication: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] dot1x_authentication_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusClientArgs']]] radius_clients: Specify a RADIUS client
        :param pulumi.Input[builtins.str] radius_dynamic_author_authentication_type: Authentication Type - Choices: `any`, `all`, `session-key` - Default value: `any`
        :param pulumi.Input[builtins.str] radius_dynamic_author_authentication_type_variable: Variable name
        :param pulumi.Input[builtins.str] radius_dynamic_author_domain_stripping: Domain Stripping - Choices: `yes`, `no`, `right-to-left` - Default value: `no`
        :param pulumi.Input[builtins.str] radius_dynamic_author_domain_stripping_variable: Variable name
        :param pulumi.Input[builtins.int] radius_dynamic_author_port: Specify Radius Dynamic Author Port - Range: `0`-`65535` - Default value: `1700`
        :param pulumi.Input[builtins.str] radius_dynamic_author_port_variable: Variable name
        :param pulumi.Input[builtins.str] radius_dynamic_author_server_key: Specify a radius dynamic author server-key
        :param pulumi.Input[builtins.str] radius_dynamic_author_server_key_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusServerGroupArgs']]] radius_server_groups: Configure the Radius serverGroup
        :param pulumi.Input[builtins.str] radius_trustsec_cts_authorization_list: CTS Authorization List
        :param pulumi.Input[builtins.str] radius_trustsec_cts_authorization_list_variable: Variable name
        :param pulumi.Input[builtins.str] radius_trustsec_group: RADIUS trustsec group
        :param pulumi.Input[builtins.str] server_groups_priority_order: ServerGroups priority order - Default value: `local`
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateTacacsServerGroupArgs']]] tacacs_server_groups: Configure the TACACS serverGroup
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateUserArgs']]] users: Create local login account
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if accounting_rules is not None:
            pulumi.set(__self__, "accounting_rules", accounting_rules)
        if authorization_config_commands is not None:
            pulumi.set(__self__, "authorization_config_commands", authorization_config_commands)
        if authorization_config_commands_variable is not None:
            pulumi.set(__self__, "authorization_config_commands_variable", authorization_config_commands_variable)
        if authorization_console is not None:
            pulumi.set(__self__, "authorization_console", authorization_console)
        if authorization_console_variable is not None:
            pulumi.set(__self__, "authorization_console_variable", authorization_console_variable)
        if authorization_rules is not None:
            pulumi.set(__self__, "authorization_rules", authorization_rules)
        if dot1x_accounting is not None:
            pulumi.set(__self__, "dot1x_accounting", dot1x_accounting)
        if dot1x_accounting_variable is not None:
            pulumi.set(__self__, "dot1x_accounting_variable", dot1x_accounting_variable)
        if dot1x_authentication is not None:
            pulumi.set(__self__, "dot1x_authentication", dot1x_authentication)
        if dot1x_authentication_variable is not None:
            pulumi.set(__self__, "dot1x_authentication_variable", dot1x_authentication_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if radius_clients is not None:
            pulumi.set(__self__, "radius_clients", radius_clients)
        if radius_dynamic_author_authentication_type is not None:
            pulumi.set(__self__, "radius_dynamic_author_authentication_type", radius_dynamic_author_authentication_type)
        if radius_dynamic_author_authentication_type_variable is not None:
            pulumi.set(__self__, "radius_dynamic_author_authentication_type_variable", radius_dynamic_author_authentication_type_variable)
        if radius_dynamic_author_domain_stripping is not None:
            pulumi.set(__self__, "radius_dynamic_author_domain_stripping", radius_dynamic_author_domain_stripping)
        if radius_dynamic_author_domain_stripping_variable is not None:
            pulumi.set(__self__, "radius_dynamic_author_domain_stripping_variable", radius_dynamic_author_domain_stripping_variable)
        if radius_dynamic_author_port is not None:
            pulumi.set(__self__, "radius_dynamic_author_port", radius_dynamic_author_port)
        if radius_dynamic_author_port_variable is not None:
            pulumi.set(__self__, "radius_dynamic_author_port_variable", radius_dynamic_author_port_variable)
        if radius_dynamic_author_server_key is not None:
            pulumi.set(__self__, "radius_dynamic_author_server_key", radius_dynamic_author_server_key)
        if radius_dynamic_author_server_key_variable is not None:
            pulumi.set(__self__, "radius_dynamic_author_server_key_variable", radius_dynamic_author_server_key_variable)
        if radius_server_groups is not None:
            pulumi.set(__self__, "radius_server_groups", radius_server_groups)
        if radius_trustsec_cts_authorization_list is not None:
            pulumi.set(__self__, "radius_trustsec_cts_authorization_list", radius_trustsec_cts_authorization_list)
        if radius_trustsec_cts_authorization_list_variable is not None:
            pulumi.set(__self__, "radius_trustsec_cts_authorization_list_variable", radius_trustsec_cts_authorization_list_variable)
        if radius_trustsec_group is not None:
            pulumi.set(__self__, "radius_trustsec_group", radius_trustsec_group)
        if server_groups_priority_order is not None:
            pulumi.set(__self__, "server_groups_priority_order", server_groups_priority_order)
        if tacacs_server_groups is not None:
            pulumi.set(__self__, "tacacs_server_groups", tacacs_server_groups)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="accountingRules")
    def accounting_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAccountingRuleArgs']]]]:
        """
        Configure the accounting rules
        """
        return pulumi.get(self, "accounting_rules")

    @accounting_rules.setter
    def accounting_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAccountingRuleArgs']]]]):
        pulumi.set(self, "accounting_rules", value)

    @property
    @pulumi.getter(name="authorizationConfigCommands")
    def authorization_config_commands(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For configuration mode commands. - Default value: `false`
        """
        return pulumi.get(self, "authorization_config_commands")

    @authorization_config_commands.setter
    def authorization_config_commands(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authorization_config_commands", value)

    @property
    @pulumi.getter(name="authorizationConfigCommandsVariable")
    def authorization_config_commands_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_config_commands_variable")

    @authorization_config_commands_variable.setter
    def authorization_config_commands_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_config_commands_variable", value)

    @property
    @pulumi.getter(name="authorizationConsole")
    def authorization_console(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For enabling console authorization - Default value: `false`
        """
        return pulumi.get(self, "authorization_console")

    @authorization_console.setter
    def authorization_console(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authorization_console", value)

    @property
    @pulumi.getter(name="authorizationConsoleVariable")
    def authorization_console_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_console_variable")

    @authorization_console_variable.setter
    def authorization_console_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_console_variable", value)

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAuthorizationRuleArgs']]]]:
        """
        Configure the Authorization Rules
        """
        return pulumi.get(self, "authorization_rules")

    @authorization_rules.setter
    def authorization_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAuthorizationRuleArgs']]]]):
        pulumi.set(self, "authorization_rules", value)

    @property
    @pulumi.getter(name="dot1xAccounting")
    def dot1x_accounting(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Accounting configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "dot1x_accounting")

    @dot1x_accounting.setter
    def dot1x_accounting(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dot1x_accounting", value)

    @property
    @pulumi.getter(name="dot1xAccountingVariable")
    def dot1x_accounting_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dot1x_accounting_variable")

    @dot1x_accounting_variable.setter
    def dot1x_accounting_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dot1x_accounting_variable", value)

    @property
    @pulumi.getter(name="dot1xAuthentication")
    def dot1x_authentication(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Authentication configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "dot1x_authentication")

    @dot1x_authentication.setter
    def dot1x_authentication(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dot1x_authentication", value)

    @property
    @pulumi.getter(name="dot1xAuthenticationVariable")
    def dot1x_authentication_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dot1x_authentication_variable")

    @dot1x_authentication_variable.setter
    def dot1x_authentication_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dot1x_authentication_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="radiusClients")
    def radius_clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusClientArgs']]]]:
        """
        Specify a RADIUS client
        """
        return pulumi.get(self, "radius_clients")

    @radius_clients.setter
    def radius_clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusClientArgs']]]]):
        pulumi.set(self, "radius_clients", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorAuthenticationType")
    def radius_dynamic_author_authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Authentication Type - Choices: `any`, `all`, `session-key` - Default value: `any`
        """
        return pulumi.get(self, "radius_dynamic_author_authentication_type")

    @radius_dynamic_author_authentication_type.setter
    def radius_dynamic_author_authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_authentication_type", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorAuthenticationTypeVariable")
    def radius_dynamic_author_authentication_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_authentication_type_variable")

    @radius_dynamic_author_authentication_type_variable.setter
    def radius_dynamic_author_authentication_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_authentication_type_variable", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorDomainStripping")
    def radius_dynamic_author_domain_stripping(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Domain Stripping - Choices: `yes`, `no`, `right-to-left` - Default value: `no`
        """
        return pulumi.get(self, "radius_dynamic_author_domain_stripping")

    @radius_dynamic_author_domain_stripping.setter
    def radius_dynamic_author_domain_stripping(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_domain_stripping", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorDomainStrippingVariable")
    def radius_dynamic_author_domain_stripping_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_domain_stripping_variable")

    @radius_dynamic_author_domain_stripping_variable.setter
    def radius_dynamic_author_domain_stripping_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_domain_stripping_variable", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorPort")
    def radius_dynamic_author_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specify Radius Dynamic Author Port - Range: `0`-`65535` - Default value: `1700`
        """
        return pulumi.get(self, "radius_dynamic_author_port")

    @radius_dynamic_author_port.setter
    def radius_dynamic_author_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "radius_dynamic_author_port", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorPortVariable")
    def radius_dynamic_author_port_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_port_variable")

    @radius_dynamic_author_port_variable.setter
    def radius_dynamic_author_port_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_port_variable", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorServerKey")
    def radius_dynamic_author_server_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify a radius dynamic author server-key
        """
        return pulumi.get(self, "radius_dynamic_author_server_key")

    @radius_dynamic_author_server_key.setter
    def radius_dynamic_author_server_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_server_key", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorServerKeyVariable")
    def radius_dynamic_author_server_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_server_key_variable")

    @radius_dynamic_author_server_key_variable.setter
    def radius_dynamic_author_server_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_server_key_variable", value)

    @property
    @pulumi.getter(name="radiusServerGroups")
    def radius_server_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusServerGroupArgs']]]]:
        """
        Configure the Radius serverGroup
        """
        return pulumi.get(self, "radius_server_groups")

    @radius_server_groups.setter
    def radius_server_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusServerGroupArgs']]]]):
        pulumi.set(self, "radius_server_groups", value)

    @property
    @pulumi.getter(name="radiusTrustsecCtsAuthorizationList")
    def radius_trustsec_cts_authorization_list(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CTS Authorization List
        """
        return pulumi.get(self, "radius_trustsec_cts_authorization_list")

    @radius_trustsec_cts_authorization_list.setter
    def radius_trustsec_cts_authorization_list(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_trustsec_cts_authorization_list", value)

    @property
    @pulumi.getter(name="radiusTrustsecCtsAuthorizationListVariable")
    def radius_trustsec_cts_authorization_list_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_trustsec_cts_authorization_list_variable")

    @radius_trustsec_cts_authorization_list_variable.setter
    def radius_trustsec_cts_authorization_list_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_trustsec_cts_authorization_list_variable", value)

    @property
    @pulumi.getter(name="radiusTrustsecGroup")
    def radius_trustsec_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        RADIUS trustsec group
        """
        return pulumi.get(self, "radius_trustsec_group")

    @radius_trustsec_group.setter
    def radius_trustsec_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_trustsec_group", value)

    @property
    @pulumi.getter(name="serverGroupsPriorityOrder")
    def server_groups_priority_order(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ServerGroups priority order - Default value: `local`
        """
        return pulumi.get(self, "server_groups_priority_order")

    @server_groups_priority_order.setter
    def server_groups_priority_order(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_groups_priority_order", value)

    @property
    @pulumi.getter(name="tacacsServerGroups")
    def tacacs_server_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateTacacsServerGroupArgs']]]]:
        """
        Configure the TACACS serverGroup
        """
        return pulumi.get(self, "tacacs_server_groups")

    @tacacs_server_groups.setter
    def tacacs_server_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateTacacsServerGroupArgs']]]]):
        pulumi.set(self, "tacacs_server_groups", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateUserArgs']]]]:
        """
        Create local login account
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _CedgeAaaFeatureTemplateState:
    def __init__(__self__, *,
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAccountingRuleArgs']]]] = None,
                 authorization_config_commands: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_console: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAuthorizationRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dot1x_accounting: Optional[pulumi.Input[builtins.bool]] = None,
                 dot1x_accounting_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dot1x_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 dot1x_authentication_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 radius_clients: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusClientArgs']]]] = None,
                 radius_dynamic_author_authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_domain_stripping: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_domain_stripping_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_port: Optional[pulumi.Input[builtins.int]] = None,
                 radius_dynamic_author_port_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_server_key: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_server_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusServerGroupArgs']]]] = None,
                 radius_trustsec_cts_authorization_list: Optional[pulumi.Input[builtins.str]] = None,
                 radius_trustsec_cts_authorization_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_trustsec_group: Optional[pulumi.Input[builtins.str]] = None,
                 server_groups_priority_order: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateTacacsServerGroupArgs']]]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateUserArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering CedgeAaaFeatureTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAccountingRuleArgs']]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[builtins.bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAuthorizationRuleArgs']]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] dot1x_accounting: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] dot1x_accounting_variable: Variable name
        :param pulumi.Input[builtins.bool] dot1x_authentication: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] dot1x_authentication_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusClientArgs']]] radius_clients: Specify a RADIUS client
        :param pulumi.Input[builtins.str] radius_dynamic_author_authentication_type: Authentication Type - Choices: `any`, `all`, `session-key` - Default value: `any`
        :param pulumi.Input[builtins.str] radius_dynamic_author_authentication_type_variable: Variable name
        :param pulumi.Input[builtins.str] radius_dynamic_author_domain_stripping: Domain Stripping - Choices: `yes`, `no`, `right-to-left` - Default value: `no`
        :param pulumi.Input[builtins.str] radius_dynamic_author_domain_stripping_variable: Variable name
        :param pulumi.Input[builtins.int] radius_dynamic_author_port: Specify Radius Dynamic Author Port - Range: `0`-`65535` - Default value: `1700`
        :param pulumi.Input[builtins.str] radius_dynamic_author_port_variable: Variable name
        :param pulumi.Input[builtins.str] radius_dynamic_author_server_key: Specify a radius dynamic author server-key
        :param pulumi.Input[builtins.str] radius_dynamic_author_server_key_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusServerGroupArgs']]] radius_server_groups: Configure the Radius serverGroup
        :param pulumi.Input[builtins.str] radius_trustsec_cts_authorization_list: CTS Authorization List
        :param pulumi.Input[builtins.str] radius_trustsec_cts_authorization_list_variable: Variable name
        :param pulumi.Input[builtins.str] radius_trustsec_group: RADIUS trustsec group
        :param pulumi.Input[builtins.str] server_groups_priority_order: ServerGroups priority order - Default value: `local`
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateTacacsServerGroupArgs']]] tacacs_server_groups: Configure the TACACS serverGroup
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateUserArgs']]] users: Create local login account
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        if accounting_rules is not None:
            pulumi.set(__self__, "accounting_rules", accounting_rules)
        if authorization_config_commands is not None:
            pulumi.set(__self__, "authorization_config_commands", authorization_config_commands)
        if authorization_config_commands_variable is not None:
            pulumi.set(__self__, "authorization_config_commands_variable", authorization_config_commands_variable)
        if authorization_console is not None:
            pulumi.set(__self__, "authorization_console", authorization_console)
        if authorization_console_variable is not None:
            pulumi.set(__self__, "authorization_console_variable", authorization_console_variable)
        if authorization_rules is not None:
            pulumi.set(__self__, "authorization_rules", authorization_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if dot1x_accounting is not None:
            pulumi.set(__self__, "dot1x_accounting", dot1x_accounting)
        if dot1x_accounting_variable is not None:
            pulumi.set(__self__, "dot1x_accounting_variable", dot1x_accounting_variable)
        if dot1x_authentication is not None:
            pulumi.set(__self__, "dot1x_authentication", dot1x_authentication)
        if dot1x_authentication_variable is not None:
            pulumi.set(__self__, "dot1x_authentication_variable", dot1x_authentication_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if radius_clients is not None:
            pulumi.set(__self__, "radius_clients", radius_clients)
        if radius_dynamic_author_authentication_type is not None:
            pulumi.set(__self__, "radius_dynamic_author_authentication_type", radius_dynamic_author_authentication_type)
        if radius_dynamic_author_authentication_type_variable is not None:
            pulumi.set(__self__, "radius_dynamic_author_authentication_type_variable", radius_dynamic_author_authentication_type_variable)
        if radius_dynamic_author_domain_stripping is not None:
            pulumi.set(__self__, "radius_dynamic_author_domain_stripping", radius_dynamic_author_domain_stripping)
        if radius_dynamic_author_domain_stripping_variable is not None:
            pulumi.set(__self__, "radius_dynamic_author_domain_stripping_variable", radius_dynamic_author_domain_stripping_variable)
        if radius_dynamic_author_port is not None:
            pulumi.set(__self__, "radius_dynamic_author_port", radius_dynamic_author_port)
        if radius_dynamic_author_port_variable is not None:
            pulumi.set(__self__, "radius_dynamic_author_port_variable", radius_dynamic_author_port_variable)
        if radius_dynamic_author_server_key is not None:
            pulumi.set(__self__, "radius_dynamic_author_server_key", radius_dynamic_author_server_key)
        if radius_dynamic_author_server_key_variable is not None:
            pulumi.set(__self__, "radius_dynamic_author_server_key_variable", radius_dynamic_author_server_key_variable)
        if radius_server_groups is not None:
            pulumi.set(__self__, "radius_server_groups", radius_server_groups)
        if radius_trustsec_cts_authorization_list is not None:
            pulumi.set(__self__, "radius_trustsec_cts_authorization_list", radius_trustsec_cts_authorization_list)
        if radius_trustsec_cts_authorization_list_variable is not None:
            pulumi.set(__self__, "radius_trustsec_cts_authorization_list_variable", radius_trustsec_cts_authorization_list_variable)
        if radius_trustsec_group is not None:
            pulumi.set(__self__, "radius_trustsec_group", radius_trustsec_group)
        if server_groups_priority_order is not None:
            pulumi.set(__self__, "server_groups_priority_order", server_groups_priority_order)
        if tacacs_server_groups is not None:
            pulumi.set(__self__, "tacacs_server_groups", tacacs_server_groups)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if users is not None:
            pulumi.set(__self__, "users", users)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="accountingRules")
    def accounting_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAccountingRuleArgs']]]]:
        """
        Configure the accounting rules
        """
        return pulumi.get(self, "accounting_rules")

    @accounting_rules.setter
    def accounting_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAccountingRuleArgs']]]]):
        pulumi.set(self, "accounting_rules", value)

    @property
    @pulumi.getter(name="authorizationConfigCommands")
    def authorization_config_commands(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For configuration mode commands. - Default value: `false`
        """
        return pulumi.get(self, "authorization_config_commands")

    @authorization_config_commands.setter
    def authorization_config_commands(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authorization_config_commands", value)

    @property
    @pulumi.getter(name="authorizationConfigCommandsVariable")
    def authorization_config_commands_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_config_commands_variable")

    @authorization_config_commands_variable.setter
    def authorization_config_commands_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_config_commands_variable", value)

    @property
    @pulumi.getter(name="authorizationConsole")
    def authorization_console(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For enabling console authorization - Default value: `false`
        """
        return pulumi.get(self, "authorization_console")

    @authorization_console.setter
    def authorization_console(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authorization_console", value)

    @property
    @pulumi.getter(name="authorizationConsoleVariable")
    def authorization_console_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_console_variable")

    @authorization_console_variable.setter
    def authorization_console_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_console_variable", value)

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAuthorizationRuleArgs']]]]:
        """
        Configure the Authorization Rules
        """
        return pulumi.get(self, "authorization_rules")

    @authorization_rules.setter
    def authorization_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateAuthorizationRuleArgs']]]]):
        pulumi.set(self, "authorization_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="dot1xAccounting")
    def dot1x_accounting(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Accounting configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "dot1x_accounting")

    @dot1x_accounting.setter
    def dot1x_accounting(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dot1x_accounting", value)

    @property
    @pulumi.getter(name="dot1xAccountingVariable")
    def dot1x_accounting_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dot1x_accounting_variable")

    @dot1x_accounting_variable.setter
    def dot1x_accounting_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dot1x_accounting_variable", value)

    @property
    @pulumi.getter(name="dot1xAuthentication")
    def dot1x_authentication(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Authentication configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "dot1x_authentication")

    @dot1x_authentication.setter
    def dot1x_authentication(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dot1x_authentication", value)

    @property
    @pulumi.getter(name="dot1xAuthenticationVariable")
    def dot1x_authentication_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dot1x_authentication_variable")

    @dot1x_authentication_variable.setter
    def dot1x_authentication_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dot1x_authentication_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="radiusClients")
    def radius_clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusClientArgs']]]]:
        """
        Specify a RADIUS client
        """
        return pulumi.get(self, "radius_clients")

    @radius_clients.setter
    def radius_clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusClientArgs']]]]):
        pulumi.set(self, "radius_clients", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorAuthenticationType")
    def radius_dynamic_author_authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Authentication Type - Choices: `any`, `all`, `session-key` - Default value: `any`
        """
        return pulumi.get(self, "radius_dynamic_author_authentication_type")

    @radius_dynamic_author_authentication_type.setter
    def radius_dynamic_author_authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_authentication_type", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorAuthenticationTypeVariable")
    def radius_dynamic_author_authentication_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_authentication_type_variable")

    @radius_dynamic_author_authentication_type_variable.setter
    def radius_dynamic_author_authentication_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_authentication_type_variable", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorDomainStripping")
    def radius_dynamic_author_domain_stripping(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Domain Stripping - Choices: `yes`, `no`, `right-to-left` - Default value: `no`
        """
        return pulumi.get(self, "radius_dynamic_author_domain_stripping")

    @radius_dynamic_author_domain_stripping.setter
    def radius_dynamic_author_domain_stripping(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_domain_stripping", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorDomainStrippingVariable")
    def radius_dynamic_author_domain_stripping_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_domain_stripping_variable")

    @radius_dynamic_author_domain_stripping_variable.setter
    def radius_dynamic_author_domain_stripping_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_domain_stripping_variable", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorPort")
    def radius_dynamic_author_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specify Radius Dynamic Author Port - Range: `0`-`65535` - Default value: `1700`
        """
        return pulumi.get(self, "radius_dynamic_author_port")

    @radius_dynamic_author_port.setter
    def radius_dynamic_author_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "radius_dynamic_author_port", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorPortVariable")
    def radius_dynamic_author_port_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_port_variable")

    @radius_dynamic_author_port_variable.setter
    def radius_dynamic_author_port_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_port_variable", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorServerKey")
    def radius_dynamic_author_server_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify a radius dynamic author server-key
        """
        return pulumi.get(self, "radius_dynamic_author_server_key")

    @radius_dynamic_author_server_key.setter
    def radius_dynamic_author_server_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_server_key", value)

    @property
    @pulumi.getter(name="radiusDynamicAuthorServerKeyVariable")
    def radius_dynamic_author_server_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_server_key_variable")

    @radius_dynamic_author_server_key_variable.setter
    def radius_dynamic_author_server_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_dynamic_author_server_key_variable", value)

    @property
    @pulumi.getter(name="radiusServerGroups")
    def radius_server_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusServerGroupArgs']]]]:
        """
        Configure the Radius serverGroup
        """
        return pulumi.get(self, "radius_server_groups")

    @radius_server_groups.setter
    def radius_server_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateRadiusServerGroupArgs']]]]):
        pulumi.set(self, "radius_server_groups", value)

    @property
    @pulumi.getter(name="radiusTrustsecCtsAuthorizationList")
    def radius_trustsec_cts_authorization_list(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CTS Authorization List
        """
        return pulumi.get(self, "radius_trustsec_cts_authorization_list")

    @radius_trustsec_cts_authorization_list.setter
    def radius_trustsec_cts_authorization_list(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_trustsec_cts_authorization_list", value)

    @property
    @pulumi.getter(name="radiusTrustsecCtsAuthorizationListVariable")
    def radius_trustsec_cts_authorization_list_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_trustsec_cts_authorization_list_variable")

    @radius_trustsec_cts_authorization_list_variable.setter
    def radius_trustsec_cts_authorization_list_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_trustsec_cts_authorization_list_variable", value)

    @property
    @pulumi.getter(name="radiusTrustsecGroup")
    def radius_trustsec_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        RADIUS trustsec group
        """
        return pulumi.get(self, "radius_trustsec_group")

    @radius_trustsec_group.setter
    def radius_trustsec_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "radius_trustsec_group", value)

    @property
    @pulumi.getter(name="serverGroupsPriorityOrder")
    def server_groups_priority_order(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ServerGroups priority order - Default value: `local`
        """
        return pulumi.get(self, "server_groups_priority_order")

    @server_groups_priority_order.setter
    def server_groups_priority_order(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_groups_priority_order", value)

    @property
    @pulumi.getter(name="tacacsServerGroups")
    def tacacs_server_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateTacacsServerGroupArgs']]]]:
        """
        Configure the TACACS serverGroup
        """
        return pulumi.get(self, "tacacs_server_groups")

    @tacacs_server_groups.setter
    def tacacs_server_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateTacacsServerGroupArgs']]]]):
        pulumi.set(self, "tacacs_server_groups", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateUserArgs']]]]:
        """
        Create local login account
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgeAaaFeatureTemplateUserArgs']]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


class CedgeAaaFeatureTemplate(pulumi.CustomResource):

    pulumi_type = "sdwan:index/cedgeAaaFeatureTemplate:CedgeAaaFeatureTemplate"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateAccountingRuleArgs', 'CedgeAaaFeatureTemplateAccountingRuleArgsDict']]]]] = None,
                 authorization_config_commands: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_console: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateAuthorizationRuleArgs', 'CedgeAaaFeatureTemplateAuthorizationRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dot1x_accounting: Optional[pulumi.Input[builtins.bool]] = None,
                 dot1x_accounting_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dot1x_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 dot1x_authentication_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 radius_clients: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateRadiusClientArgs', 'CedgeAaaFeatureTemplateRadiusClientArgsDict']]]]] = None,
                 radius_dynamic_author_authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_domain_stripping: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_domain_stripping_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_port: Optional[pulumi.Input[builtins.int]] = None,
                 radius_dynamic_author_port_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_server_key: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_server_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateRadiusServerGroupArgs', 'CedgeAaaFeatureTemplateRadiusServerGroupArgsDict']]]]] = None,
                 radius_trustsec_cts_authorization_list: Optional[pulumi.Input[builtins.str]] = None,
                 radius_trustsec_cts_authorization_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_trustsec_group: Optional[pulumi.Input[builtins.str]] = None,
                 server_groups_priority_order: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateTacacsServerGroupArgs', 'CedgeAaaFeatureTemplateTacacsServerGroupArgsDict']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateUserArgs', 'CedgeAaaFeatureTemplateUserArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a cEdge AAA feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/cedgeAaaFeatureTemplate:CedgeAaaFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateAccountingRuleArgs', 'CedgeAaaFeatureTemplateAccountingRuleArgsDict']]]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[builtins.bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateAuthorizationRuleArgs', 'CedgeAaaFeatureTemplateAuthorizationRuleArgsDict']]]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] dot1x_accounting: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] dot1x_accounting_variable: Variable name
        :param pulumi.Input[builtins.bool] dot1x_authentication: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] dot1x_authentication_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateRadiusClientArgs', 'CedgeAaaFeatureTemplateRadiusClientArgsDict']]]] radius_clients: Specify a RADIUS client
        :param pulumi.Input[builtins.str] radius_dynamic_author_authentication_type: Authentication Type - Choices: `any`, `all`, `session-key` - Default value: `any`
        :param pulumi.Input[builtins.str] radius_dynamic_author_authentication_type_variable: Variable name
        :param pulumi.Input[builtins.str] radius_dynamic_author_domain_stripping: Domain Stripping - Choices: `yes`, `no`, `right-to-left` - Default value: `no`
        :param pulumi.Input[builtins.str] radius_dynamic_author_domain_stripping_variable: Variable name
        :param pulumi.Input[builtins.int] radius_dynamic_author_port: Specify Radius Dynamic Author Port - Range: `0`-`65535` - Default value: `1700`
        :param pulumi.Input[builtins.str] radius_dynamic_author_port_variable: Variable name
        :param pulumi.Input[builtins.str] radius_dynamic_author_server_key: Specify a radius dynamic author server-key
        :param pulumi.Input[builtins.str] radius_dynamic_author_server_key_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateRadiusServerGroupArgs', 'CedgeAaaFeatureTemplateRadiusServerGroupArgsDict']]]] radius_server_groups: Configure the Radius serverGroup
        :param pulumi.Input[builtins.str] radius_trustsec_cts_authorization_list: CTS Authorization List
        :param pulumi.Input[builtins.str] radius_trustsec_cts_authorization_list_variable: Variable name
        :param pulumi.Input[builtins.str] radius_trustsec_group: RADIUS trustsec group
        :param pulumi.Input[builtins.str] server_groups_priority_order: ServerGroups priority order - Default value: `local`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateTacacsServerGroupArgs', 'CedgeAaaFeatureTemplateTacacsServerGroupArgsDict']]]] tacacs_server_groups: Configure the TACACS serverGroup
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateUserArgs', 'CedgeAaaFeatureTemplateUserArgsDict']]]] users: Create local login account
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CedgeAaaFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a cEdge AAA feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/cedgeAaaFeatureTemplate:CedgeAaaFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CedgeAaaFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CedgeAaaFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateAccountingRuleArgs', 'CedgeAaaFeatureTemplateAccountingRuleArgsDict']]]]] = None,
                 authorization_config_commands: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_console: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateAuthorizationRuleArgs', 'CedgeAaaFeatureTemplateAuthorizationRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dot1x_accounting: Optional[pulumi.Input[builtins.bool]] = None,
                 dot1x_accounting_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dot1x_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 dot1x_authentication_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 radius_clients: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateRadiusClientArgs', 'CedgeAaaFeatureTemplateRadiusClientArgsDict']]]]] = None,
                 radius_dynamic_author_authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_domain_stripping: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_domain_stripping_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_port: Optional[pulumi.Input[builtins.int]] = None,
                 radius_dynamic_author_port_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_server_key: Optional[pulumi.Input[builtins.str]] = None,
                 radius_dynamic_author_server_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateRadiusServerGroupArgs', 'CedgeAaaFeatureTemplateRadiusServerGroupArgsDict']]]]] = None,
                 radius_trustsec_cts_authorization_list: Optional[pulumi.Input[builtins.str]] = None,
                 radius_trustsec_cts_authorization_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 radius_trustsec_group: Optional[pulumi.Input[builtins.str]] = None,
                 server_groups_priority_order: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateTacacsServerGroupArgs', 'CedgeAaaFeatureTemplateTacacsServerGroupArgsDict']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateUserArgs', 'CedgeAaaFeatureTemplateUserArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CedgeAaaFeatureTemplateArgs.__new__(CedgeAaaFeatureTemplateArgs)

            __props__.__dict__["accounting_rules"] = accounting_rules
            __props__.__dict__["authorization_config_commands"] = authorization_config_commands
            __props__.__dict__["authorization_config_commands_variable"] = authorization_config_commands_variable
            __props__.__dict__["authorization_console"] = authorization_console
            __props__.__dict__["authorization_console_variable"] = authorization_console_variable
            __props__.__dict__["authorization_rules"] = authorization_rules
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["dot1x_accounting"] = dot1x_accounting
            __props__.__dict__["dot1x_accounting_variable"] = dot1x_accounting_variable
            __props__.__dict__["dot1x_authentication"] = dot1x_authentication
            __props__.__dict__["dot1x_authentication_variable"] = dot1x_authentication_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["radius_clients"] = radius_clients
            __props__.__dict__["radius_dynamic_author_authentication_type"] = radius_dynamic_author_authentication_type
            __props__.__dict__["radius_dynamic_author_authentication_type_variable"] = radius_dynamic_author_authentication_type_variable
            __props__.__dict__["radius_dynamic_author_domain_stripping"] = radius_dynamic_author_domain_stripping
            __props__.__dict__["radius_dynamic_author_domain_stripping_variable"] = radius_dynamic_author_domain_stripping_variable
            __props__.__dict__["radius_dynamic_author_port"] = radius_dynamic_author_port
            __props__.__dict__["radius_dynamic_author_port_variable"] = radius_dynamic_author_port_variable
            __props__.__dict__["radius_dynamic_author_server_key"] = radius_dynamic_author_server_key
            __props__.__dict__["radius_dynamic_author_server_key_variable"] = radius_dynamic_author_server_key_variable
            __props__.__dict__["radius_server_groups"] = radius_server_groups
            __props__.__dict__["radius_trustsec_cts_authorization_list"] = radius_trustsec_cts_authorization_list
            __props__.__dict__["radius_trustsec_cts_authorization_list_variable"] = radius_trustsec_cts_authorization_list_variable
            __props__.__dict__["radius_trustsec_group"] = radius_trustsec_group
            __props__.__dict__["server_groups_priority_order"] = server_groups_priority_order
            __props__.__dict__["tacacs_server_groups"] = tacacs_server_groups
            __props__.__dict__["users"] = users
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CedgeAaaFeatureTemplate, __self__).__init__(
            'sdwan:index/cedgeAaaFeatureTemplate:CedgeAaaFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateAccountingRuleArgs', 'CedgeAaaFeatureTemplateAccountingRuleArgsDict']]]]] = None,
            authorization_config_commands: Optional[pulumi.Input[builtins.bool]] = None,
            authorization_config_commands_variable: Optional[pulumi.Input[builtins.str]] = None,
            authorization_console: Optional[pulumi.Input[builtins.bool]] = None,
            authorization_console_variable: Optional[pulumi.Input[builtins.str]] = None,
            authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateAuthorizationRuleArgs', 'CedgeAaaFeatureTemplateAuthorizationRuleArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            dot1x_accounting: Optional[pulumi.Input[builtins.bool]] = None,
            dot1x_accounting_variable: Optional[pulumi.Input[builtins.str]] = None,
            dot1x_authentication: Optional[pulumi.Input[builtins.bool]] = None,
            dot1x_authentication_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            radius_clients: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateRadiusClientArgs', 'CedgeAaaFeatureTemplateRadiusClientArgsDict']]]]] = None,
            radius_dynamic_author_authentication_type: Optional[pulumi.Input[builtins.str]] = None,
            radius_dynamic_author_authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
            radius_dynamic_author_domain_stripping: Optional[pulumi.Input[builtins.str]] = None,
            radius_dynamic_author_domain_stripping_variable: Optional[pulumi.Input[builtins.str]] = None,
            radius_dynamic_author_port: Optional[pulumi.Input[builtins.int]] = None,
            radius_dynamic_author_port_variable: Optional[pulumi.Input[builtins.str]] = None,
            radius_dynamic_author_server_key: Optional[pulumi.Input[builtins.str]] = None,
            radius_dynamic_author_server_key_variable: Optional[pulumi.Input[builtins.str]] = None,
            radius_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateRadiusServerGroupArgs', 'CedgeAaaFeatureTemplateRadiusServerGroupArgsDict']]]]] = None,
            radius_trustsec_cts_authorization_list: Optional[pulumi.Input[builtins.str]] = None,
            radius_trustsec_cts_authorization_list_variable: Optional[pulumi.Input[builtins.str]] = None,
            radius_trustsec_group: Optional[pulumi.Input[builtins.str]] = None,
            server_groups_priority_order: Optional[pulumi.Input[builtins.str]] = None,
            tacacs_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateTacacsServerGroupArgs', 'CedgeAaaFeatureTemplateTacacsServerGroupArgsDict']]]]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateUserArgs', 'CedgeAaaFeatureTemplateUserArgsDict']]]]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'CedgeAaaFeatureTemplate':
        """
        Get an existing CedgeAaaFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateAccountingRuleArgs', 'CedgeAaaFeatureTemplateAccountingRuleArgsDict']]]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[builtins.bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateAuthorizationRuleArgs', 'CedgeAaaFeatureTemplateAuthorizationRuleArgsDict']]]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] dot1x_accounting: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] dot1x_accounting_variable: Variable name
        :param pulumi.Input[builtins.bool] dot1x_authentication: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] dot1x_authentication_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateRadiusClientArgs', 'CedgeAaaFeatureTemplateRadiusClientArgsDict']]]] radius_clients: Specify a RADIUS client
        :param pulumi.Input[builtins.str] radius_dynamic_author_authentication_type: Authentication Type - Choices: `any`, `all`, `session-key` - Default value: `any`
        :param pulumi.Input[builtins.str] radius_dynamic_author_authentication_type_variable: Variable name
        :param pulumi.Input[builtins.str] radius_dynamic_author_domain_stripping: Domain Stripping - Choices: `yes`, `no`, `right-to-left` - Default value: `no`
        :param pulumi.Input[builtins.str] radius_dynamic_author_domain_stripping_variable: Variable name
        :param pulumi.Input[builtins.int] radius_dynamic_author_port: Specify Radius Dynamic Author Port - Range: `0`-`65535` - Default value: `1700`
        :param pulumi.Input[builtins.str] radius_dynamic_author_port_variable: Variable name
        :param pulumi.Input[builtins.str] radius_dynamic_author_server_key: Specify a radius dynamic author server-key
        :param pulumi.Input[builtins.str] radius_dynamic_author_server_key_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateRadiusServerGroupArgs', 'CedgeAaaFeatureTemplateRadiusServerGroupArgsDict']]]] radius_server_groups: Configure the Radius serverGroup
        :param pulumi.Input[builtins.str] radius_trustsec_cts_authorization_list: CTS Authorization List
        :param pulumi.Input[builtins.str] radius_trustsec_cts_authorization_list_variable: Variable name
        :param pulumi.Input[builtins.str] radius_trustsec_group: RADIUS trustsec group
        :param pulumi.Input[builtins.str] server_groups_priority_order: ServerGroups priority order - Default value: `local`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateTacacsServerGroupArgs', 'CedgeAaaFeatureTemplateTacacsServerGroupArgsDict']]]] tacacs_server_groups: Configure the TACACS serverGroup
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgeAaaFeatureTemplateUserArgs', 'CedgeAaaFeatureTemplateUserArgsDict']]]] users: Create local login account
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CedgeAaaFeatureTemplateState.__new__(_CedgeAaaFeatureTemplateState)

        __props__.__dict__["accounting_rules"] = accounting_rules
        __props__.__dict__["authorization_config_commands"] = authorization_config_commands
        __props__.__dict__["authorization_config_commands_variable"] = authorization_config_commands_variable
        __props__.__dict__["authorization_console"] = authorization_console
        __props__.__dict__["authorization_console_variable"] = authorization_console_variable
        __props__.__dict__["authorization_rules"] = authorization_rules
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["dot1x_accounting"] = dot1x_accounting
        __props__.__dict__["dot1x_accounting_variable"] = dot1x_accounting_variable
        __props__.__dict__["dot1x_authentication"] = dot1x_authentication
        __props__.__dict__["dot1x_authentication_variable"] = dot1x_authentication_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["radius_clients"] = radius_clients
        __props__.__dict__["radius_dynamic_author_authentication_type"] = radius_dynamic_author_authentication_type
        __props__.__dict__["radius_dynamic_author_authentication_type_variable"] = radius_dynamic_author_authentication_type_variable
        __props__.__dict__["radius_dynamic_author_domain_stripping"] = radius_dynamic_author_domain_stripping
        __props__.__dict__["radius_dynamic_author_domain_stripping_variable"] = radius_dynamic_author_domain_stripping_variable
        __props__.__dict__["radius_dynamic_author_port"] = radius_dynamic_author_port
        __props__.__dict__["radius_dynamic_author_port_variable"] = radius_dynamic_author_port_variable
        __props__.__dict__["radius_dynamic_author_server_key"] = radius_dynamic_author_server_key
        __props__.__dict__["radius_dynamic_author_server_key_variable"] = radius_dynamic_author_server_key_variable
        __props__.__dict__["radius_server_groups"] = radius_server_groups
        __props__.__dict__["radius_trustsec_cts_authorization_list"] = radius_trustsec_cts_authorization_list
        __props__.__dict__["radius_trustsec_cts_authorization_list_variable"] = radius_trustsec_cts_authorization_list_variable
        __props__.__dict__["radius_trustsec_group"] = radius_trustsec_group
        __props__.__dict__["server_groups_priority_order"] = server_groups_priority_order
        __props__.__dict__["tacacs_server_groups"] = tacacs_server_groups
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["users"] = users
        __props__.__dict__["version"] = version
        return CedgeAaaFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountingRules")
    def accounting_rules(self) -> pulumi.Output[Optional[Sequence['outputs.CedgeAaaFeatureTemplateAccountingRule']]]:
        """
        Configure the accounting rules
        """
        return pulumi.get(self, "accounting_rules")

    @property
    @pulumi.getter(name="authorizationConfigCommands")
    def authorization_config_commands(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        For configuration mode commands. - Default value: `false`
        """
        return pulumi.get(self, "authorization_config_commands")

    @property
    @pulumi.getter(name="authorizationConfigCommandsVariable")
    def authorization_config_commands_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_config_commands_variable")

    @property
    @pulumi.getter(name="authorizationConsole")
    def authorization_console(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        For enabling console authorization - Default value: `false`
        """
        return pulumi.get(self, "authorization_console")

    @property
    @pulumi.getter(name="authorizationConsoleVariable")
    def authorization_console_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_console_variable")

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> pulumi.Output[Optional[Sequence['outputs.CedgeAaaFeatureTemplateAuthorizationRule']]]:
        """
        Configure the Authorization Rules
        """
        return pulumi.get(self, "authorization_rules")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="dot1xAccounting")
    def dot1x_accounting(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Accounting configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "dot1x_accounting")

    @property
    @pulumi.getter(name="dot1xAccountingVariable")
    def dot1x_accounting_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dot1x_accounting_variable")

    @property
    @pulumi.getter(name="dot1xAuthentication")
    def dot1x_authentication(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Authentication configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "dot1x_authentication")

    @property
    @pulumi.getter(name="dot1xAuthenticationVariable")
    def dot1x_authentication_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dot1x_authentication_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="radiusClients")
    def radius_clients(self) -> pulumi.Output[Optional[Sequence['outputs.CedgeAaaFeatureTemplateRadiusClient']]]:
        """
        Specify a RADIUS client
        """
        return pulumi.get(self, "radius_clients")

    @property
    @pulumi.getter(name="radiusDynamicAuthorAuthenticationType")
    def radius_dynamic_author_authentication_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Authentication Type - Choices: `any`, `all`, `session-key` - Default value: `any`
        """
        return pulumi.get(self, "radius_dynamic_author_authentication_type")

    @property
    @pulumi.getter(name="radiusDynamicAuthorAuthenticationTypeVariable")
    def radius_dynamic_author_authentication_type_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_authentication_type_variable")

    @property
    @pulumi.getter(name="radiusDynamicAuthorDomainStripping")
    def radius_dynamic_author_domain_stripping(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Domain Stripping - Choices: `yes`, `no`, `right-to-left` - Default value: `no`
        """
        return pulumi.get(self, "radius_dynamic_author_domain_stripping")

    @property
    @pulumi.getter(name="radiusDynamicAuthorDomainStrippingVariable")
    def radius_dynamic_author_domain_stripping_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_domain_stripping_variable")

    @property
    @pulumi.getter(name="radiusDynamicAuthorPort")
    def radius_dynamic_author_port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specify Radius Dynamic Author Port - Range: `0`-`65535` - Default value: `1700`
        """
        return pulumi.get(self, "radius_dynamic_author_port")

    @property
    @pulumi.getter(name="radiusDynamicAuthorPortVariable")
    def radius_dynamic_author_port_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_port_variable")

    @property
    @pulumi.getter(name="radiusDynamicAuthorServerKey")
    def radius_dynamic_author_server_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify a radius dynamic author server-key
        """
        return pulumi.get(self, "radius_dynamic_author_server_key")

    @property
    @pulumi.getter(name="radiusDynamicAuthorServerKeyVariable")
    def radius_dynamic_author_server_key_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_dynamic_author_server_key_variable")

    @property
    @pulumi.getter(name="radiusServerGroups")
    def radius_server_groups(self) -> pulumi.Output[Optional[Sequence['outputs.CedgeAaaFeatureTemplateRadiusServerGroup']]]:
        """
        Configure the Radius serverGroup
        """
        return pulumi.get(self, "radius_server_groups")

    @property
    @pulumi.getter(name="radiusTrustsecCtsAuthorizationList")
    def radius_trustsec_cts_authorization_list(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        CTS Authorization List
        """
        return pulumi.get(self, "radius_trustsec_cts_authorization_list")

    @property
    @pulumi.getter(name="radiusTrustsecCtsAuthorizationListVariable")
    def radius_trustsec_cts_authorization_list_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "radius_trustsec_cts_authorization_list_variable")

    @property
    @pulumi.getter(name="radiusTrustsecGroup")
    def radius_trustsec_group(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        RADIUS trustsec group
        """
        return pulumi.get(self, "radius_trustsec_group")

    @property
    @pulumi.getter(name="serverGroupsPriorityOrder")
    def server_groups_priority_order(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ServerGroups priority order - Default value: `local`
        """
        return pulumi.get(self, "server_groups_priority_order")

    @property
    @pulumi.getter(name="tacacsServerGroups")
    def tacacs_server_groups(self) -> pulumi.Output[Optional[Sequence['outputs.CedgeAaaFeatureTemplateTacacsServerGroup']]]:
        """
        Configure the TACACS serverGroup
        """
        return pulumi.get(self, "tacacs_server_groups")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.CedgeAaaFeatureTemplateUser']]]:
        """
        Create local login account
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

