# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetTransportGpsFeatureResult',
    'AwaitableGetTransportGpsFeatureResult',
    'get_transport_gps_feature',
    'get_transport_gps_feature_output',
]

@pulumi.output_type
class GetTransportGpsFeatureResult:
    """
    A collection of values returned by getTransportGpsFeature.
    """
    def __init__(__self__, description=None, feature_profile_id=None, gps_enable=None, gps_enable_variable=None, gps_mode=None, gps_mode_variable=None, id=None, name=None, nmea_destination_address=None, nmea_destination_address_variable=None, nmea_destination_port=None, nmea_destination_port_variable=None, nmea_enable=None, nmea_enable_variable=None, nmea_source_address=None, nmea_source_address_variable=None, version=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if feature_profile_id and not isinstance(feature_profile_id, str):
            raise TypeError("Expected argument 'feature_profile_id' to be a str")
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if gps_enable and not isinstance(gps_enable, bool):
            raise TypeError("Expected argument 'gps_enable' to be a bool")
        pulumi.set(__self__, "gps_enable", gps_enable)
        if gps_enable_variable and not isinstance(gps_enable_variable, str):
            raise TypeError("Expected argument 'gps_enable_variable' to be a str")
        pulumi.set(__self__, "gps_enable_variable", gps_enable_variable)
        if gps_mode and not isinstance(gps_mode, str):
            raise TypeError("Expected argument 'gps_mode' to be a str")
        pulumi.set(__self__, "gps_mode", gps_mode)
        if gps_mode_variable and not isinstance(gps_mode_variable, str):
            raise TypeError("Expected argument 'gps_mode_variable' to be a str")
        pulumi.set(__self__, "gps_mode_variable", gps_mode_variable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nmea_destination_address and not isinstance(nmea_destination_address, str):
            raise TypeError("Expected argument 'nmea_destination_address' to be a str")
        pulumi.set(__self__, "nmea_destination_address", nmea_destination_address)
        if nmea_destination_address_variable and not isinstance(nmea_destination_address_variable, str):
            raise TypeError("Expected argument 'nmea_destination_address_variable' to be a str")
        pulumi.set(__self__, "nmea_destination_address_variable", nmea_destination_address_variable)
        if nmea_destination_port and not isinstance(nmea_destination_port, int):
            raise TypeError("Expected argument 'nmea_destination_port' to be a int")
        pulumi.set(__self__, "nmea_destination_port", nmea_destination_port)
        if nmea_destination_port_variable and not isinstance(nmea_destination_port_variable, str):
            raise TypeError("Expected argument 'nmea_destination_port_variable' to be a str")
        pulumi.set(__self__, "nmea_destination_port_variable", nmea_destination_port_variable)
        if nmea_enable and not isinstance(nmea_enable, bool):
            raise TypeError("Expected argument 'nmea_enable' to be a bool")
        pulumi.set(__self__, "nmea_enable", nmea_enable)
        if nmea_enable_variable and not isinstance(nmea_enable_variable, str):
            raise TypeError("Expected argument 'nmea_enable_variable' to be a str")
        pulumi.set(__self__, "nmea_enable_variable", nmea_enable_variable)
        if nmea_source_address and not isinstance(nmea_source_address, str):
            raise TypeError("Expected argument 'nmea_source_address' to be a str")
        pulumi.set(__self__, "nmea_source_address", nmea_source_address)
        if nmea_source_address_variable and not isinstance(nmea_source_address_variable, str):
            raise TypeError("Expected argument 'nmea_source_address_variable' to be a str")
        pulumi.set(__self__, "nmea_source_address_variable", nmea_source_address_variable)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> builtins.str:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter(name="gpsEnable")
    def gps_enable(self) -> builtins.bool:
        """
        Enable/disable GPS
        """
        return pulumi.get(self, "gps_enable")

    @property
    @pulumi.getter(name="gpsEnableVariable")
    def gps_enable_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "gps_enable_variable")

    @property
    @pulumi.getter(name="gpsMode")
    def gps_mode(self) -> builtins.str:
        """
        Select GPS mode
        """
        return pulumi.get(self, "gps_mode")

    @property
    @pulumi.getter(name="gpsModeVariable")
    def gps_mode_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "gps_mode_variable")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the Feature
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nmeaDestinationAddress")
    def nmea_destination_address(self) -> builtins.str:
        """
        Destination address
        """
        return pulumi.get(self, "nmea_destination_address")

    @property
    @pulumi.getter(name="nmeaDestinationAddressVariable")
    def nmea_destination_address_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "nmea_destination_address_variable")

    @property
    @pulumi.getter(name="nmeaDestinationPort")
    def nmea_destination_port(self) -> builtins.int:
        """
        Destination port
        """
        return pulumi.get(self, "nmea_destination_port")

    @property
    @pulumi.getter(name="nmeaDestinationPortVariable")
    def nmea_destination_port_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "nmea_destination_port_variable")

    @property
    @pulumi.getter(name="nmeaEnable")
    def nmea_enable(self) -> builtins.bool:
        """
        Enable/disable NMEA data
        """
        return pulumi.get(self, "nmea_enable")

    @property
    @pulumi.getter(name="nmeaEnableVariable")
    def nmea_enable_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "nmea_enable_variable")

    @property
    @pulumi.getter(name="nmeaSourceAddress")
    def nmea_source_address(self) -> builtins.str:
        """
        Source address
        """
        return pulumi.get(self, "nmea_source_address")

    @property
    @pulumi.getter(name="nmeaSourceAddressVariable")
    def nmea_source_address_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "nmea_source_address_variable")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")


class AwaitableGetTransportGpsFeatureResult(GetTransportGpsFeatureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransportGpsFeatureResult(
            description=self.description,
            feature_profile_id=self.feature_profile_id,
            gps_enable=self.gps_enable,
            gps_enable_variable=self.gps_enable_variable,
            gps_mode=self.gps_mode,
            gps_mode_variable=self.gps_mode_variable,
            id=self.id,
            name=self.name,
            nmea_destination_address=self.nmea_destination_address,
            nmea_destination_address_variable=self.nmea_destination_address_variable,
            nmea_destination_port=self.nmea_destination_port,
            nmea_destination_port_variable=self.nmea_destination_port_variable,
            nmea_enable=self.nmea_enable,
            nmea_enable_variable=self.nmea_enable_variable,
            nmea_source_address=self.nmea_source_address,
            nmea_source_address_variable=self.nmea_source_address_variable,
            version=self.version)


def get_transport_gps_feature(feature_profile_id: Optional[builtins.str] = None,
                              id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransportGpsFeatureResult:
    """
    This data source can read the Transport GPS Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_transport_gps_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param builtins.str feature_profile_id: Feature Profile ID
    :param builtins.str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getTransportGpsFeature:getTransportGpsFeature', __args__, opts=opts, typ=GetTransportGpsFeatureResult).value

    return AwaitableGetTransportGpsFeatureResult(
        description=pulumi.get(__ret__, 'description'),
        feature_profile_id=pulumi.get(__ret__, 'feature_profile_id'),
        gps_enable=pulumi.get(__ret__, 'gps_enable'),
        gps_enable_variable=pulumi.get(__ret__, 'gps_enable_variable'),
        gps_mode=pulumi.get(__ret__, 'gps_mode'),
        gps_mode_variable=pulumi.get(__ret__, 'gps_mode_variable'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        nmea_destination_address=pulumi.get(__ret__, 'nmea_destination_address'),
        nmea_destination_address_variable=pulumi.get(__ret__, 'nmea_destination_address_variable'),
        nmea_destination_port=pulumi.get(__ret__, 'nmea_destination_port'),
        nmea_destination_port_variable=pulumi.get(__ret__, 'nmea_destination_port_variable'),
        nmea_enable=pulumi.get(__ret__, 'nmea_enable'),
        nmea_enable_variable=pulumi.get(__ret__, 'nmea_enable_variable'),
        nmea_source_address=pulumi.get(__ret__, 'nmea_source_address'),
        nmea_source_address_variable=pulumi.get(__ret__, 'nmea_source_address_variable'),
        version=pulumi.get(__ret__, 'version'))
def get_transport_gps_feature_output(feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                                     id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTransportGpsFeatureResult]:
    """
    This data source can read the Transport GPS Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_transport_gps_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param builtins.str feature_profile_id: Feature Profile ID
    :param builtins.str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getTransportGpsFeature:getTransportGpsFeature', __args__, opts=opts, typ=GetTransportGpsFeatureResult)
    return __ret__.apply(lambda __response__: GetTransportGpsFeatureResult(
        description=pulumi.get(__response__, 'description'),
        feature_profile_id=pulumi.get(__response__, 'feature_profile_id'),
        gps_enable=pulumi.get(__response__, 'gps_enable'),
        gps_enable_variable=pulumi.get(__response__, 'gps_enable_variable'),
        gps_mode=pulumi.get(__response__, 'gps_mode'),
        gps_mode_variable=pulumi.get(__response__, 'gps_mode_variable'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        nmea_destination_address=pulumi.get(__response__, 'nmea_destination_address'),
        nmea_destination_address_variable=pulumi.get(__response__, 'nmea_destination_address_variable'),
        nmea_destination_port=pulumi.get(__response__, 'nmea_destination_port'),
        nmea_destination_port_variable=pulumi.get(__response__, 'nmea_destination_port_variable'),
        nmea_enable=pulumi.get(__response__, 'nmea_enable'),
        nmea_enable_variable=pulumi.get(__response__, 'nmea_enable_variable'),
        nmea_source_address=pulumi.get(__response__, 'nmea_source_address'),
        nmea_source_address_variable=pulumi.get(__response__, 'nmea_source_address_variable'),
        version=pulumi.get(__response__, 'version')))
