# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from onfido.models.webhook_event_type import WebhookEventType
from typing import Optional, Set
from typing_extensions import Self

class Webhook(BaseModel):
    """
    Webhook
    """ # noqa: E501
    enabled: Optional[StrictBool] = Field(default=None, description="Determine if the webhook is active.")
    events: Optional[List[WebhookEventType]] = Field(default=None, description="The events that will be published to the webhook. If the events parameter is omitted all the events will be subscribed. ")
    environments: Optional[List[StrictStr]] = Field(default=None, description="The environments from which the webhook will receive events. Allowed values are “sandbox” and “live”. If the environments parameter is omitted the webhook will receive events from both environments. ")
    payload_version: Optional[StrictInt] = Field(default=None, description="Webhook version used to control the payload object when sending webhooks.")
    oauth_enabled: Optional[StrictBool] = Field(default=None, description="Determines if the webhook will fetch OAuth access tokens to send in the Authorization header.")
    oauth_server_url: Optional[StrictStr] = Field(default=None, description="The url to fetch the OAuth access token using client credentials grant.")
    oauth_server_client_id: Optional[StrictStr] = Field(default=None, description="The client id to authenticate the client credentials grant.")
    oauth_server_client_secret: Optional[StrictStr] = Field(default=None, description="The client secret to authenticate the client credentials grant.")
    oauth_server_scope: Optional[StrictStr] = Field(default=None, description="The scopes to be sent when requesting the access token.")
    id: StrictStr = Field(description="The unique identifier of the webhook.")
    url: Optional[StrictStr] = Field(default=None, description="The url that will listen to notifications (must be https).")
    token: Optional[StrictStr] = Field(default=None, description="Webhook secret token used to sign the webhook's payload.")
    href: Optional[StrictStr] = Field(default=None, description="The API endpoint to retrieve the webhook.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["enabled", "events", "environments", "payload_version", "oauth_enabled", "oauth_server_url", "oauth_server_client_id", "oauth_server_client_secret", "oauth_server_scope", "id", "url", "token", "href"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Webhook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Webhook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enabled": obj.get("enabled"),
            "events": obj.get("events"),
            "environments": obj.get("environments"),
            "payload_version": obj.get("payload_version"),
            "oauth_enabled": obj.get("oauth_enabled"),
            "oauth_server_url": obj.get("oauth_server_url"),
            "oauth_server_client_id": obj.get("oauth_server_client_id"),
            "oauth_server_client_secret": obj.get("oauth_server_client_secret"),
            "oauth_server_scope": obj.get("oauth_server_scope"),
            "id": obj.get("id"),
            "url": obj.get("url"),
            "token": obj.get("token"),
            "href": obj.get("href")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


