#!python
# cython: language_level=3
# cython: boundscheck=False
# cython: wraparound=False
# cython: initializedcheck=False
# cython: cdivision=True
import numpy
cimport numpy
from libc.math cimport exp, fabs, log, sin, cos, tan, asin, acos, atan, isnan, isinf
from libc.math cimport NAN as nan
from libc.math cimport INFINITY as inf
from libc.stdio cimport *
from libc.stdlib cimport *
import cython
from cpython.mem cimport PyMem_Malloc
from cpython.mem cimport PyMem_Realloc
from cpython.mem cimport PyMem_Free
from hydpy.cythons.autogen cimport annutils
from hydpy.cythons.autogen cimport configutils
from hydpy.cythons.autogen import pointerutils
from hydpy.cythons.autogen cimport pointerutils
from hydpy.cythons.autogen cimport quadutils
from hydpy.cythons.autogen cimport rootutils
from hydpy.cythons.autogen cimport smoothutils
cdef public numpy.int32_t SIED_D = 1
cdef public numpy.int32_t SIED_L = 2
cdef public numpy.int32_t VERS = 3
cdef public numpy.int32_t ACKER = 4
cdef public numpy.int32_t WEINB = 5
cdef public numpy.int32_t OBSTB = 6
cdef public numpy.int32_t BODEN = 7
cdef public numpy.int32_t GLETS = 8
cdef public numpy.int32_t GRUE_I = 9
cdef public numpy.int32_t FEUCHT = 10
cdef public numpy.int32_t GRUE_E = 11
cdef public numpy.int32_t BAUMB = 12
cdef public numpy.int32_t NADELW = 13
cdef public numpy.int32_t LAUBW = 14
cdef public numpy.int32_t MISCHW = 15
cdef public numpy.int32_t WASSER = 16
cdef public numpy.int32_t FLUSS = 17
cdef public numpy.int32_t SEE = 18
@cython.final
cdef class Parameters:
    cdef public ControlParameters control
    cdef public DerivedParameters derived
    cdef public FixedParameters fixed
@cython.final
cdef class ControlParameters:
    cdef public double latitude
    cdef public double longitude
    cdef public double ft
    cdef public numpy.int32_t nhru
    cdef public numpy.int32_t[:] lnk
    cdef public double[:] fhru
    cdef public double[:] kg
    cdef public double[:] kt
    cdef public double[:] angstromconstant
    cdef public double[:] angstromfactor
    cdef public double[:] angstromalternative
    cdef public double p1strahl
    cdef public double p2strahl
    cdef public double[:,:] albedo
    cdef public double albedo0snow
    cdef public double snowagingfactor
    cdef public double turb0
    cdef public double turb1
    cdef public double emissivity
    cdef public double measuringheightwindspeed
    cdef public double p1wind
    cdef public double p2wind
    cdef public double[:,:] lai
    cdef public double hinz
    cdef public double p1simax
    cdef public double p2simax
    cdef public double p1sirate
    cdef public double p2sirate
    cdef public double p3sirate
    cdef public double[:] trefn
    cdef public double[:] tgr
    cdef public double[:] tsp
    cdef public double[:] pwmax
    cdef public numpy.int32_t refreezeflag
    cdef public double ktschnee
    cdef public double[:] wg2z
    cdef public double[:,:] cropheight
    cdef public double[:,:] surfaceresistance
    cdef public double[:] wmax
    cdef public double[:] fk
    cdef public double[:] pwp
    cdef public double[:] py
    cdef public double[:] bsf
    cdef public double fvf
    cdef public double bsff
    cdef public double[:] dmin
    cdef public double[:] dmax
    cdef public double[:] beta
    cdef public double[:] fbeta
    cdef public double[:] kapmax
    cdef public double[:,:] kapgrenz
    cdef public bint rbeta
    cdef public double volbmax
    cdef public double gsbmax
    cdef public double gsbgrad1
    cdef public double gsbgrad2
    cdef public double a1
    cdef public double a2
    cdef public double tind
    cdef public double eqb
    cdef public double eqi1
    cdef public double eqi2
    cdef public double eqd1
    cdef public double eqd2
    cdef public bint negq
@cython.final
cdef class DerivedParameters:
    cdef public numpy.int32_t[:] moy
    cdef public numpy.int32_t[:] doy
    cdef public double seconds
    cdef public double hours
    cdef public double days
    cdef public double[:] sct
    cdef public numpy.int32_t utclongitude
    cdef public numpy.int32_t nmblogentries
    cdef public double latituderad
    cdef public double[:] absfhru
    cdef public double[:,:] kinz
    cdef public double[:] heatoffusion
    cdef public double[:,:] fr
    cdef public double[:] nfk
    cdef public double kb
    cdef public double ki1
    cdef public double ki2
    cdef public double kd1
    cdef public double kd2
    cdef public double qbgamax
    cdef public double qfactor
@cython.final
cdef class FixedParameters:
    cdef public double cpwasser
    cdef public double cpeis
    cdef public double rschmelz
    cdef public double pi
    cdef public double z
    cdef public double[:] bowa2z
    cdef public double lambdag
    cdef public double sigma
    cdef public double rdryair
    cdef public double rwatervapour
    cdef public double lw
    cdef public double lwe
    cdef public double cpluft
    cdef public double psy
    cdef public double psyinv
    cdef public double z0
    cdef public double sol
    cdef public double fratm
    cdef public double cg
@cython.final
cdef class Sequences:
    cdef public InletSequences inlets
    cdef public InputSequences inputs
    cdef public FluxSequences fluxes
    cdef public StateSequences states
    cdef public LogSequences logs
    cdef public AideSequences aides
    cdef public OutletSequences outlets
    cdef public StateSequences old_states
    cdef public StateSequences new_states
@cython.final
cdef class InletSequences:
    cdef double **q
    cdef public int len_q
    cdef public numpy.int32_t[:] _q_ready
    cdef public int _q_ndim
    cdef public int _q_length
    cdef public int _q_length_0
    cpdef inline alloc(self, name, numpy.int32_t length):
        if name == "q":
            self._q_length_0 = length
            self._q_ready = numpy.full(length, 0, dtype=numpy.int32)
            self.q = <double**> PyMem_Malloc(length * sizeof(double*))
    cpdef inline dealloc(self, name):
        if name == "q":
            PyMem_Free(self.q)
    cpdef inline set_pointer1d(self, str name, pointerutils.Double value, int idx):
        cdef pointerutils.PDouble pointer = pointerutils.PDouble(value)
        if name == "q":
            self.q[idx] = pointer.p_value
            self._q_ready[idx] = 1
    cpdef get_value(self, str name):
        cdef int idx
        if name == "q":
            values = numpy.empty(self.len_q)
            for idx in range(self.len_q):
                pointerutils.check0(self._q_length_0)
                if self._q_ready[idx] == 0:
                    pointerutils.check1(self._q_length_0, idx)
                    pointerutils.check2(self._q_ready, idx)
                values[idx] = self.q[idx][0]
            return values
    cpdef set_value(self, str name, value):
        if name == "q":
            for idx in range(self.len_q):
                pointerutils.check0(self._q_length_0)
                if self._q_ready[idx] == 0:
                    pointerutils.check1(self._q_length_0, idx)
                    pointerutils.check2(self._q_ready, idx)
                self.q[idx][0] = value[idx]
@cython.final
cdef class InputSequences:
    cdef public double nied
    cdef public int _nied_ndim
    cdef public int _nied_length
    cdef public bint _nied_diskflag
    cdef public str _nied_path
    cdef FILE *_nied_file
    cdef public bint _nied_ramflag
    cdef public double[:] _nied_array
    cdef public bint _nied_inputflag
    cdef double *_nied_inputpointer
    cdef public double teml
    cdef public int _teml_ndim
    cdef public int _teml_length
    cdef public bint _teml_diskflag
    cdef public str _teml_path
    cdef FILE *_teml_file
    cdef public bint _teml_ramflag
    cdef public double[:] _teml_array
    cdef public bint _teml_inputflag
    cdef double *_teml_inputpointer
    cdef public double sunshineduration
    cdef public int _sunshineduration_ndim
    cdef public int _sunshineduration_length
    cdef public bint _sunshineduration_diskflag
    cdef public str _sunshineduration_path
    cdef FILE *_sunshineduration_file
    cdef public bint _sunshineduration_ramflag
    cdef public double[:] _sunshineduration_array
    cdef public bint _sunshineduration_inputflag
    cdef double *_sunshineduration_inputpointer
    cdef public double relativehumidity
    cdef public int _relativehumidity_ndim
    cdef public int _relativehumidity_length
    cdef public bint _relativehumidity_diskflag
    cdef public str _relativehumidity_path
    cdef FILE *_relativehumidity_file
    cdef public bint _relativehumidity_ramflag
    cdef public double[:] _relativehumidity_array
    cdef public bint _relativehumidity_inputflag
    cdef double *_relativehumidity_inputpointer
    cdef public double windspeed
    cdef public int _windspeed_ndim
    cdef public int _windspeed_length
    cdef public bint _windspeed_diskflag
    cdef public str _windspeed_path
    cdef FILE *_windspeed_file
    cdef public bint _windspeed_ramflag
    cdef public double[:] _windspeed_array
    cdef public bint _windspeed_inputflag
    cdef double *_windspeed_inputpointer
    cdef public double atmosphericpressure
    cdef public int _atmosphericpressure_ndim
    cdef public int _atmosphericpressure_length
    cdef public bint _atmosphericpressure_diskflag
    cdef public str _atmosphericpressure_path
    cdef FILE *_atmosphericpressure_file
    cdef public bint _atmosphericpressure_ramflag
    cdef public double[:] _atmosphericpressure_array
    cdef public bint _atmosphericpressure_inputflag
    cdef double *_atmosphericpressure_inputpointer
    cpdef open_files(self, int idx):
        if self._nied_diskflag:
            self._nied_file = fopen(str(self._nied_path).encode(), "rb+")
            fseek(self._nied_file, idx*8, SEEK_SET)
        if self._teml_diskflag:
            self._teml_file = fopen(str(self._teml_path).encode(), "rb+")
            fseek(self._teml_file, idx*8, SEEK_SET)
        if self._sunshineduration_diskflag:
            self._sunshineduration_file = fopen(str(self._sunshineduration_path).encode(), "rb+")
            fseek(self._sunshineduration_file, idx*8, SEEK_SET)
        if self._relativehumidity_diskflag:
            self._relativehumidity_file = fopen(str(self._relativehumidity_path).encode(), "rb+")
            fseek(self._relativehumidity_file, idx*8, SEEK_SET)
        if self._windspeed_diskflag:
            self._windspeed_file = fopen(str(self._windspeed_path).encode(), "rb+")
            fseek(self._windspeed_file, idx*8, SEEK_SET)
        if self._atmosphericpressure_diskflag:
            self._atmosphericpressure_file = fopen(str(self._atmosphericpressure_path).encode(), "rb+")
            fseek(self._atmosphericpressure_file, idx*8, SEEK_SET)
    cpdef inline close_files(self):
        if self._nied_diskflag:
            fclose(self._nied_file)
        if self._teml_diskflag:
            fclose(self._teml_file)
        if self._sunshineduration_diskflag:
            fclose(self._sunshineduration_file)
        if self._relativehumidity_diskflag:
            fclose(self._relativehumidity_file)
        if self._windspeed_diskflag:
            fclose(self._windspeed_file)
        if self._atmosphericpressure_diskflag:
            fclose(self._atmosphericpressure_file)
    cpdef inline void load_data(self, int idx)  nogil:
        cdef int jdx0, jdx1, jdx2, jdx3, jdx4, jdx5
        if self._nied_inputflag:
            self.nied = self._nied_inputpointer[0]
        elif self._nied_diskflag:
            fread(&self.nied, 8, 1, self._nied_file)
        elif self._nied_ramflag:
            self.nied = self._nied_array[idx]
        if self._teml_inputflag:
            self.teml = self._teml_inputpointer[0]
        elif self._teml_diskflag:
            fread(&self.teml, 8, 1, self._teml_file)
        elif self._teml_ramflag:
            self.teml = self._teml_array[idx]
        if self._sunshineduration_inputflag:
            self.sunshineduration = self._sunshineduration_inputpointer[0]
        elif self._sunshineduration_diskflag:
            fread(&self.sunshineduration, 8, 1, self._sunshineduration_file)
        elif self._sunshineduration_ramflag:
            self.sunshineduration = self._sunshineduration_array[idx]
        if self._relativehumidity_inputflag:
            self.relativehumidity = self._relativehumidity_inputpointer[0]
        elif self._relativehumidity_diskflag:
            fread(&self.relativehumidity, 8, 1, self._relativehumidity_file)
        elif self._relativehumidity_ramflag:
            self.relativehumidity = self._relativehumidity_array[idx]
        if self._windspeed_inputflag:
            self.windspeed = self._windspeed_inputpointer[0]
        elif self._windspeed_diskflag:
            fread(&self.windspeed, 8, 1, self._windspeed_file)
        elif self._windspeed_ramflag:
            self.windspeed = self._windspeed_array[idx]
        if self._atmosphericpressure_inputflag:
            self.atmosphericpressure = self._atmosphericpressure_inputpointer[0]
        elif self._atmosphericpressure_diskflag:
            fread(&self.atmosphericpressure, 8, 1, self._atmosphericpressure_file)
        elif self._atmosphericpressure_ramflag:
            self.atmosphericpressure = self._atmosphericpressure_array[idx]
    cpdef inline void save_data(self, int idx)  nogil:
        cdef int jdx0, jdx1, jdx2, jdx3, jdx4, jdx5
        if self._nied_inputflag:
            if self._nied_diskflag:
                fwrite(&self.nied, 8, 1, self._nied_file)
            elif self._nied_ramflag:
                self._nied_array[idx] = self.nied
        if self._teml_inputflag:
            if self._teml_diskflag:
                fwrite(&self.teml, 8, 1, self._teml_file)
            elif self._teml_ramflag:
                self._teml_array[idx] = self.teml
        if self._sunshineduration_inputflag:
            if self._sunshineduration_diskflag:
                fwrite(&self.sunshineduration, 8, 1, self._sunshineduration_file)
            elif self._sunshineduration_ramflag:
                self._sunshineduration_array[idx] = self.sunshineduration
        if self._relativehumidity_inputflag:
            if self._relativehumidity_diskflag:
                fwrite(&self.relativehumidity, 8, 1, self._relativehumidity_file)
            elif self._relativehumidity_ramflag:
                self._relativehumidity_array[idx] = self.relativehumidity
        if self._windspeed_inputflag:
            if self._windspeed_diskflag:
                fwrite(&self.windspeed, 8, 1, self._windspeed_file)
            elif self._windspeed_ramflag:
                self._windspeed_array[idx] = self.windspeed
        if self._atmosphericpressure_inputflag:
            if self._atmosphericpressure_diskflag:
                fwrite(&self.atmosphericpressure, 8, 1, self._atmosphericpressure_file)
            elif self._atmosphericpressure_ramflag:
                self._atmosphericpressure_array[idx] = self.atmosphericpressure
    cpdef inline set_pointerinput(self, str name, pointerutils.PDouble value):
        if name == "nied":
            self._nied_inputpointer = value.p_value
        if name == "teml":
            self._teml_inputpointer = value.p_value
        if name == "sunshineduration":
            self._sunshineduration_inputpointer = value.p_value
        if name == "relativehumidity":
            self._relativehumidity_inputpointer = value.p_value
        if name == "windspeed":
            self._windspeed_inputpointer = value.p_value
        if name == "atmosphericpressure":
            self._atmosphericpressure_inputpointer = value.p_value
@cython.final
cdef class FluxSequences:
    cdef public double qz
    cdef public int _qz_ndim
    cdef public int _qz_length
    cdef public bint _qz_diskflag
    cdef public str _qz_path
    cdef FILE *_qz_file
    cdef public bint _qz_ramflag
    cdef public double[:] _qz_array
    cdef public bint _qz_outputflag
    cdef double *_qz_outputpointer
    cdef public double qzh
    cdef public int _qzh_ndim
    cdef public int _qzh_length
    cdef public bint _qzh_diskflag
    cdef public str _qzh_path
    cdef FILE *_qzh_file
    cdef public bint _qzh_ramflag
    cdef public double[:] _qzh_array
    cdef public bint _qzh_outputflag
    cdef double *_qzh_outputpointer
    cdef public double temltag
    cdef public int _temltag_ndim
    cdef public int _temltag_length
    cdef public bint _temltag_diskflag
    cdef public str _temltag_path
    cdef FILE *_temltag_file
    cdef public bint _temltag_ramflag
    cdef public double[:] _temltag_array
    cdef public bint _temltag_outputflag
    cdef double *_temltag_outputpointer
    cdef public double dailyrelativehumidity
    cdef public int _dailyrelativehumidity_ndim
    cdef public int _dailyrelativehumidity_length
    cdef public bint _dailyrelativehumidity_diskflag
    cdef public str _dailyrelativehumidity_path
    cdef FILE *_dailyrelativehumidity_file
    cdef public bint _dailyrelativehumidity_ramflag
    cdef public double[:] _dailyrelativehumidity_array
    cdef public bint _dailyrelativehumidity_outputflag
    cdef double *_dailyrelativehumidity_outputpointer
    cdef public double dailysunshineduration
    cdef public int _dailysunshineduration_ndim
    cdef public int _dailysunshineduration_length
    cdef public bint _dailysunshineduration_diskflag
    cdef public str _dailysunshineduration_path
    cdef FILE *_dailysunshineduration_file
    cdef public bint _dailysunshineduration_ramflag
    cdef public double[:] _dailysunshineduration_array
    cdef public bint _dailysunshineduration_outputflag
    cdef double *_dailysunshineduration_outputpointer
    cdef public double[:] nkor
    cdef public int _nkor_ndim
    cdef public int _nkor_length
    cdef public int _nkor_length_0
    cdef public bint _nkor_diskflag
    cdef public str _nkor_path
    cdef FILE *_nkor_file
    cdef public bint _nkor_ramflag
    cdef public double[:,:] _nkor_array
    cdef public bint _nkor_outputflag
    cdef double *_nkor_outputpointer
    cdef public double[:] tkor
    cdef public int _tkor_ndim
    cdef public int _tkor_length
    cdef public int _tkor_length_0
    cdef public bint _tkor_diskflag
    cdef public str _tkor_path
    cdef FILE *_tkor_file
    cdef public bint _tkor_ramflag
    cdef public double[:,:] _tkor_array
    cdef public bint _tkor_outputflag
    cdef double *_tkor_outputpointer
    cdef public double[:] tkortag
    cdef public int _tkortag_ndim
    cdef public int _tkortag_length
    cdef public int _tkortag_length_0
    cdef public bint _tkortag_diskflag
    cdef public str _tkortag_path
    cdef FILE *_tkortag_file
    cdef public bint _tkortag_ramflag
    cdef public double[:,:] _tkortag_array
    cdef public bint _tkortag_outputflag
    cdef double *_tkortag_outputpointer
    cdef public double windspeed2m
    cdef public int _windspeed2m_ndim
    cdef public int _windspeed2m_length
    cdef public bint _windspeed2m_diskflag
    cdef public str _windspeed2m_path
    cdef FILE *_windspeed2m_file
    cdef public bint _windspeed2m_ramflag
    cdef public double[:] _windspeed2m_array
    cdef public bint _windspeed2m_outputflag
    cdef double *_windspeed2m_outputpointer
    cdef public double dailywindspeed2m
    cdef public int _dailywindspeed2m_ndim
    cdef public int _dailywindspeed2m_length
    cdef public bint _dailywindspeed2m_diskflag
    cdef public str _dailywindspeed2m_path
    cdef FILE *_dailywindspeed2m_file
    cdef public bint _dailywindspeed2m_ramflag
    cdef public double[:] _dailywindspeed2m_array
    cdef public bint _dailywindspeed2m_outputflag
    cdef double *_dailywindspeed2m_outputpointer
    cdef public double[:] reducedwindspeed2m
    cdef public int _reducedwindspeed2m_ndim
    cdef public int _reducedwindspeed2m_length
    cdef public int _reducedwindspeed2m_length_0
    cdef public bint _reducedwindspeed2m_diskflag
    cdef public str _reducedwindspeed2m_path
    cdef FILE *_reducedwindspeed2m_file
    cdef public bint _reducedwindspeed2m_ramflag
    cdef public double[:,:] _reducedwindspeed2m_array
    cdef public bint _reducedwindspeed2m_outputflag
    cdef double *_reducedwindspeed2m_outputpointer
    cdef public double windspeed10m
    cdef public int _windspeed10m_ndim
    cdef public int _windspeed10m_length
    cdef public bint _windspeed10m_diskflag
    cdef public str _windspeed10m_path
    cdef FILE *_windspeed10m_file
    cdef public bint _windspeed10m_ramflag
    cdef public double[:] _windspeed10m_array
    cdef public bint _windspeed10m_outputflag
    cdef double *_windspeed10m_outputpointer
    cdef public double[:] saturationvapourpressure
    cdef public int _saturationvapourpressure_ndim
    cdef public int _saturationvapourpressure_length
    cdef public int _saturationvapourpressure_length_0
    cdef public bint _saturationvapourpressure_diskflag
    cdef public str _saturationvapourpressure_path
    cdef FILE *_saturationvapourpressure_file
    cdef public bint _saturationvapourpressure_ramflag
    cdef public double[:,:] _saturationvapourpressure_array
    cdef public bint _saturationvapourpressure_outputflag
    cdef double *_saturationvapourpressure_outputpointer
    cdef public double[:] dailysaturationvapourpressure
    cdef public int _dailysaturationvapourpressure_ndim
    cdef public int _dailysaturationvapourpressure_length
    cdef public int _dailysaturationvapourpressure_length_0
    cdef public bint _dailysaturationvapourpressure_diskflag
    cdef public str _dailysaturationvapourpressure_path
    cdef FILE *_dailysaturationvapourpressure_file
    cdef public bint _dailysaturationvapourpressure_ramflag
    cdef public double[:,:] _dailysaturationvapourpressure_array
    cdef public bint _dailysaturationvapourpressure_outputflag
    cdef double *_dailysaturationvapourpressure_outputpointer
    cdef public double[:] saturationvapourpressureinz
    cdef public int _saturationvapourpressureinz_ndim
    cdef public int _saturationvapourpressureinz_length
    cdef public int _saturationvapourpressureinz_length_0
    cdef public bint _saturationvapourpressureinz_diskflag
    cdef public str _saturationvapourpressureinz_path
    cdef FILE *_saturationvapourpressureinz_file
    cdef public bint _saturationvapourpressureinz_ramflag
    cdef public double[:,:] _saturationvapourpressureinz_array
    cdef public bint _saturationvapourpressureinz_outputflag
    cdef double *_saturationvapourpressureinz_outputpointer
    cdef public double[:] saturationvapourpressuresnow
    cdef public int _saturationvapourpressuresnow_ndim
    cdef public int _saturationvapourpressuresnow_length
    cdef public int _saturationvapourpressuresnow_length_0
    cdef public bint _saturationvapourpressuresnow_diskflag
    cdef public str _saturationvapourpressuresnow_path
    cdef FILE *_saturationvapourpressuresnow_file
    cdef public bint _saturationvapourpressuresnow_ramflag
    cdef public double[:,:] _saturationvapourpressuresnow_array
    cdef public bint _saturationvapourpressuresnow_outputflag
    cdef double *_saturationvapourpressuresnow_outputpointer
    cdef public double[:] saturationvapourpressureslope
    cdef public int _saturationvapourpressureslope_ndim
    cdef public int _saturationvapourpressureslope_length
    cdef public int _saturationvapourpressureslope_length_0
    cdef public bint _saturationvapourpressureslope_diskflag
    cdef public str _saturationvapourpressureslope_path
    cdef FILE *_saturationvapourpressureslope_file
    cdef public bint _saturationvapourpressureslope_ramflag
    cdef public double[:,:] _saturationvapourpressureslope_array
    cdef public bint _saturationvapourpressureslope_outputflag
    cdef double *_saturationvapourpressureslope_outputpointer
    cdef public double[:] dailysaturationvapourpressureslope
    cdef public int _dailysaturationvapourpressureslope_ndim
    cdef public int _dailysaturationvapourpressureslope_length
    cdef public int _dailysaturationvapourpressureslope_length_0
    cdef public bint _dailysaturationvapourpressureslope_diskflag
    cdef public str _dailysaturationvapourpressureslope_path
    cdef FILE *_dailysaturationvapourpressureslope_file
    cdef public bint _dailysaturationvapourpressureslope_ramflag
    cdef public double[:,:] _dailysaturationvapourpressureslope_array
    cdef public bint _dailysaturationvapourpressureslope_outputflag
    cdef double *_dailysaturationvapourpressureslope_outputpointer
    cdef public double[:] actualvapourpressure
    cdef public int _actualvapourpressure_ndim
    cdef public int _actualvapourpressure_length
    cdef public int _actualvapourpressure_length_0
    cdef public bint _actualvapourpressure_diskflag
    cdef public str _actualvapourpressure_path
    cdef FILE *_actualvapourpressure_file
    cdef public bint _actualvapourpressure_ramflag
    cdef public double[:,:] _actualvapourpressure_array
    cdef public bint _actualvapourpressure_outputflag
    cdef double *_actualvapourpressure_outputpointer
    cdef public double[:] dailyactualvapourpressure
    cdef public int _dailyactualvapourpressure_ndim
    cdef public int _dailyactualvapourpressure_length
    cdef public int _dailyactualvapourpressure_length_0
    cdef public bint _dailyactualvapourpressure_diskflag
    cdef public str _dailyactualvapourpressure_path
    cdef FILE *_dailyactualvapourpressure_file
    cdef public bint _dailyactualvapourpressure_ramflag
    cdef public double[:,:] _dailyactualvapourpressure_array
    cdef public bint _dailyactualvapourpressure_outputflag
    cdef double *_dailyactualvapourpressure_outputpointer
    cdef public double[:] dryairpressure
    cdef public int _dryairpressure_ndim
    cdef public int _dryairpressure_length
    cdef public int _dryairpressure_length_0
    cdef public bint _dryairpressure_diskflag
    cdef public str _dryairpressure_path
    cdef FILE *_dryairpressure_file
    cdef public bint _dryairpressure_ramflag
    cdef public double[:,:] _dryairpressure_array
    cdef public bint _dryairpressure_outputflag
    cdef double *_dryairpressure_outputpointer
    cdef public double[:] densityair
    cdef public int _densityair_ndim
    cdef public int _densityair_length
    cdef public int _densityair_length_0
    cdef public bint _densityair_diskflag
    cdef public str _densityair_path
    cdef FILE *_densityair_file
    cdef public bint _densityair_ramflag
    cdef public double[:,:] _densityair_array
    cdef public bint _densityair_outputflag
    cdef double *_densityair_outputpointer
    cdef public double solardeclination
    cdef public int _solardeclination_ndim
    cdef public int _solardeclination_length
    cdef public bint _solardeclination_diskflag
    cdef public str _solardeclination_path
    cdef FILE *_solardeclination_file
    cdef public bint _solardeclination_ramflag
    cdef public double[:] _solardeclination_array
    cdef public bint _solardeclination_outputflag
    cdef double *_solardeclination_outputpointer
    cdef public double tsa
    cdef public int _tsa_ndim
    cdef public int _tsa_length
    cdef public bint _tsa_diskflag
    cdef public str _tsa_path
    cdef FILE *_tsa_file
    cdef public bint _tsa_ramflag
    cdef public double[:] _tsa_array
    cdef public bint _tsa_outputflag
    cdef double *_tsa_outputpointer
    cdef public double tsu
    cdef public int _tsu_ndim
    cdef public int _tsu_length
    cdef public bint _tsu_diskflag
    cdef public str _tsu_path
    cdef FILE *_tsu_file
    cdef public bint _tsu_ramflag
    cdef public double[:] _tsu_array
    cdef public bint _tsu_outputflag
    cdef double *_tsu_outputpointer
    cdef public double earthsundistance
    cdef public int _earthsundistance_ndim
    cdef public int _earthsundistance_length
    cdef public bint _earthsundistance_diskflag
    cdef public str _earthsundistance_path
    cdef FILE *_earthsundistance_file
    cdef public bint _earthsundistance_ramflag
    cdef public double[:] _earthsundistance_array
    cdef public bint _earthsundistance_outputflag
    cdef double *_earthsundistance_outputpointer
    cdef public double extraterrestrialradiation
    cdef public int _extraterrestrialradiation_ndim
    cdef public int _extraterrestrialradiation_length
    cdef public bint _extraterrestrialradiation_diskflag
    cdef public str _extraterrestrialradiation_path
    cdef FILE *_extraterrestrialradiation_file
    cdef public bint _extraterrestrialradiation_ramflag
    cdef public double[:] _extraterrestrialradiation_array
    cdef public bint _extraterrestrialradiation_outputflag
    cdef double *_extraterrestrialradiation_outputpointer
    cdef public double possiblesunshineduration
    cdef public int _possiblesunshineduration_ndim
    cdef public int _possiblesunshineduration_length
    cdef public bint _possiblesunshineduration_diskflag
    cdef public str _possiblesunshineduration_path
    cdef FILE *_possiblesunshineduration_file
    cdef public bint _possiblesunshineduration_ramflag
    cdef public double[:] _possiblesunshineduration_array
    cdef public bint _possiblesunshineduration_outputflag
    cdef double *_possiblesunshineduration_outputpointer
    cdef public double dailypossiblesunshineduration
    cdef public int _dailypossiblesunshineduration_ndim
    cdef public int _dailypossiblesunshineduration_length
    cdef public bint _dailypossiblesunshineduration_diskflag
    cdef public str _dailypossiblesunshineduration_path
    cdef FILE *_dailypossiblesunshineduration_file
    cdef public bint _dailypossiblesunshineduration_ramflag
    cdef public double[:] _dailypossiblesunshineduration_array
    cdef public bint _dailypossiblesunshineduration_outputflag
    cdef double *_dailypossiblesunshineduration_outputpointer
    cdef public double dailyglobalradiation
    cdef public int _dailyglobalradiation_ndim
    cdef public int _dailyglobalradiation_length
    cdef public bint _dailyglobalradiation_diskflag
    cdef public str _dailyglobalradiation_path
    cdef FILE *_dailyglobalradiation_file
    cdef public bint _dailyglobalradiation_ramflag
    cdef public double[:] _dailyglobalradiation_array
    cdef public bint _dailyglobalradiation_outputflag
    cdef double *_dailyglobalradiation_outputpointer
    cdef public double sp
    cdef public int _sp_ndim
    cdef public int _sp_length
    cdef public bint _sp_diskflag
    cdef public str _sp_path
    cdef FILE *_sp_file
    cdef public bint _sp_ramflag
    cdef public double[:] _sp_array
    cdef public bint _sp_outputflag
    cdef double *_sp_outputpointer
    cdef public double globalradiation
    cdef public int _globalradiation_ndim
    cdef public int _globalradiation_length
    cdef public bint _globalradiation_diskflag
    cdef public str _globalradiation_path
    cdef FILE *_globalradiation_file
    cdef public bint _globalradiation_ramflag
    cdef public double[:] _globalradiation_array
    cdef public bint _globalradiation_outputflag
    cdef double *_globalradiation_outputpointer
    cdef public double adjustedglobalradiation
    cdef public int _adjustedglobalradiation_ndim
    cdef public int _adjustedglobalradiation_length
    cdef public bint _adjustedglobalradiation_diskflag
    cdef public str _adjustedglobalradiation_path
    cdef FILE *_adjustedglobalradiation_file
    cdef public bint _adjustedglobalradiation_ramflag
    cdef public double[:] _adjustedglobalradiation_array
    cdef public bint _adjustedglobalradiation_outputflag
    cdef double *_adjustedglobalradiation_outputpointer
    cdef public double[:] g
    cdef public int _g_ndim
    cdef public int _g_length
    cdef public int _g_length_0
    cdef public bint _g_diskflag
    cdef public str _g_path
    cdef FILE *_g_file
    cdef public bint _g_ramflag
    cdef public double[:,:] _g_array
    cdef public bint _g_outputflag
    cdef double *_g_outputpointer
    cdef public double[:] tz
    cdef public int _tz_ndim
    cdef public int _tz_length
    cdef public int _tz_length_0
    cdef public bint _tz_diskflag
    cdef public str _tz_path
    cdef FILE *_tz_file
    cdef public bint _tz_ramflag
    cdef public double[:,:] _tz_array
    cdef public bint _tz_outputflag
    cdef double *_tz_outputpointer
    cdef public double[:] wg
    cdef public int _wg_ndim
    cdef public int _wg_length
    cdef public int _wg_length_0
    cdef public bint _wg_diskflag
    cdef public str _wg_path
    cdef FILE *_wg_file
    cdef public bint _wg_ramflag
    cdef public double[:,:] _wg_array
    cdef public bint _wg_outputflag
    cdef double *_wg_outputpointer
    cdef public double[:] netshortwaveradiation
    cdef public int _netshortwaveradiation_ndim
    cdef public int _netshortwaveradiation_length
    cdef public int _netshortwaveradiation_length_0
    cdef public bint _netshortwaveradiation_diskflag
    cdef public str _netshortwaveradiation_path
    cdef FILE *_netshortwaveradiation_file
    cdef public bint _netshortwaveradiation_ramflag
    cdef public double[:,:] _netshortwaveradiation_array
    cdef public bint _netshortwaveradiation_outputflag
    cdef double *_netshortwaveradiation_outputpointer
    cdef public double[:] netshortwaveradiationinz
    cdef public int _netshortwaveradiationinz_ndim
    cdef public int _netshortwaveradiationinz_length
    cdef public int _netshortwaveradiationinz_length_0
    cdef public bint _netshortwaveradiationinz_diskflag
    cdef public str _netshortwaveradiationinz_path
    cdef FILE *_netshortwaveradiationinz_file
    cdef public bint _netshortwaveradiationinz_ramflag
    cdef public double[:,:] _netshortwaveradiationinz_array
    cdef public bint _netshortwaveradiationinz_outputflag
    cdef double *_netshortwaveradiationinz_outputpointer
    cdef public double[:] netshortwaveradiationsnow
    cdef public int _netshortwaveradiationsnow_ndim
    cdef public int _netshortwaveradiationsnow_length
    cdef public int _netshortwaveradiationsnow_length_0
    cdef public bint _netshortwaveradiationsnow_diskflag
    cdef public str _netshortwaveradiationsnow_path
    cdef FILE *_netshortwaveradiationsnow_file
    cdef public bint _netshortwaveradiationsnow_ramflag
    cdef public double[:,:] _netshortwaveradiationsnow_array
    cdef public bint _netshortwaveradiationsnow_outputflag
    cdef double *_netshortwaveradiationsnow_outputpointer
    cdef public double[:] dailynetshortwaveradiation
    cdef public int _dailynetshortwaveradiation_ndim
    cdef public int _dailynetshortwaveradiation_length
    cdef public int _dailynetshortwaveradiation_length_0
    cdef public bint _dailynetshortwaveradiation_diskflag
    cdef public str _dailynetshortwaveradiation_path
    cdef FILE *_dailynetshortwaveradiation_file
    cdef public bint _dailynetshortwaveradiation_ramflag
    cdef public double[:,:] _dailynetshortwaveradiation_array
    cdef public bint _dailynetshortwaveradiation_outputflag
    cdef double *_dailynetshortwaveradiation_outputpointer
    cdef public double[:] dailynetlongwaveradiation
    cdef public int _dailynetlongwaveradiation_ndim
    cdef public int _dailynetlongwaveradiation_length
    cdef public int _dailynetlongwaveradiation_length_0
    cdef public bint _dailynetlongwaveradiation_diskflag
    cdef public str _dailynetlongwaveradiation_path
    cdef FILE *_dailynetlongwaveradiation_file
    cdef public bint _dailynetlongwaveradiation_ramflag
    cdef public double[:,:] _dailynetlongwaveradiation_array
    cdef public bint _dailynetlongwaveradiation_outputflag
    cdef double *_dailynetlongwaveradiation_outputpointer
    cdef public double[:] netlongwaveradiationinz
    cdef public int _netlongwaveradiationinz_ndim
    cdef public int _netlongwaveradiationinz_length
    cdef public int _netlongwaveradiationinz_length_0
    cdef public bint _netlongwaveradiationinz_diskflag
    cdef public str _netlongwaveradiationinz_path
    cdef FILE *_netlongwaveradiationinz_file
    cdef public bint _netlongwaveradiationinz_ramflag
    cdef public double[:,:] _netlongwaveradiationinz_array
    cdef public bint _netlongwaveradiationinz_outputflag
    cdef double *_netlongwaveradiationinz_outputpointer
    cdef public double[:] netlongwaveradiationsnow
    cdef public int _netlongwaveradiationsnow_ndim
    cdef public int _netlongwaveradiationsnow_length
    cdef public int _netlongwaveradiationsnow_length_0
    cdef public bint _netlongwaveradiationsnow_diskflag
    cdef public str _netlongwaveradiationsnow_path
    cdef FILE *_netlongwaveradiationsnow_file
    cdef public bint _netlongwaveradiationsnow_ramflag
    cdef public double[:,:] _netlongwaveradiationsnow_array
    cdef public bint _netlongwaveradiationsnow_outputflag
    cdef double *_netlongwaveradiationsnow_outputpointer
    cdef public double[:] netradiation
    cdef public int _netradiation_ndim
    cdef public int _netradiation_length
    cdef public int _netradiation_length_0
    cdef public bint _netradiation_diskflag
    cdef public str _netradiation_path
    cdef FILE *_netradiation_file
    cdef public bint _netradiation_ramflag
    cdef public double[:,:] _netradiation_array
    cdef public bint _netradiation_outputflag
    cdef double *_netradiation_outputpointer
    cdef public double[:] netradiationinz
    cdef public int _netradiationinz_ndim
    cdef public int _netradiationinz_length
    cdef public int _netradiationinz_length_0
    cdef public bint _netradiationinz_diskflag
    cdef public str _netradiationinz_path
    cdef FILE *_netradiationinz_file
    cdef public bint _netradiationinz_ramflag
    cdef public double[:,:] _netradiationinz_array
    cdef public bint _netradiationinz_outputflag
    cdef double *_netradiationinz_outputpointer
    cdef public double[:] netradiationsnow
    cdef public int _netradiationsnow_ndim
    cdef public int _netradiationsnow_length
    cdef public int _netradiationsnow_length_0
    cdef public bint _netradiationsnow_diskflag
    cdef public str _netradiationsnow_path
    cdef FILE *_netradiationsnow_file
    cdef public bint _netradiationsnow_ramflag
    cdef public double[:,:] _netradiationsnow_array
    cdef public bint _netradiationsnow_outputflag
    cdef double *_netradiationsnow_outputpointer
    cdef public double[:] dailynetradiation
    cdef public int _dailynetradiation_ndim
    cdef public int _dailynetradiation_length
    cdef public int _dailynetradiation_length_0
    cdef public bint _dailynetradiation_diskflag
    cdef public str _dailynetradiation_path
    cdef FILE *_dailynetradiation_file
    cdef public bint _dailynetradiation_ramflag
    cdef public double[:,:] _dailynetradiation_array
    cdef public bint _dailynetradiation_outputflag
    cdef double *_dailynetradiation_outputpointer
    cdef public double[:] aerodynamicresistance
    cdef public int _aerodynamicresistance_ndim
    cdef public int _aerodynamicresistance_length
    cdef public int _aerodynamicresistance_length_0
    cdef public bint _aerodynamicresistance_diskflag
    cdef public str _aerodynamicresistance_path
    cdef FILE *_aerodynamicresistance_file
    cdef public bint _aerodynamicresistance_ramflag
    cdef public double[:,:] _aerodynamicresistance_array
    cdef public bint _aerodynamicresistance_outputflag
    cdef double *_aerodynamicresistance_outputpointer
    cdef public double[:] soilsurfaceresistance
    cdef public int _soilsurfaceresistance_ndim
    cdef public int _soilsurfaceresistance_length
    cdef public int _soilsurfaceresistance_length_0
    cdef public bint _soilsurfaceresistance_diskflag
    cdef public str _soilsurfaceresistance_path
    cdef FILE *_soilsurfaceresistance_file
    cdef public bint _soilsurfaceresistance_ramflag
    cdef public double[:,:] _soilsurfaceresistance_array
    cdef public bint _soilsurfaceresistance_outputflag
    cdef double *_soilsurfaceresistance_outputpointer
    cdef public double[:] landusesurfaceresistance
    cdef public int _landusesurfaceresistance_ndim
    cdef public int _landusesurfaceresistance_length
    cdef public int _landusesurfaceresistance_length_0
    cdef public bint _landusesurfaceresistance_diskflag
    cdef public str _landusesurfaceresistance_path
    cdef FILE *_landusesurfaceresistance_file
    cdef public bint _landusesurfaceresistance_ramflag
    cdef public double[:,:] _landusesurfaceresistance_array
    cdef public bint _landusesurfaceresistance_outputflag
    cdef double *_landusesurfaceresistance_outputpointer
    cdef public double[:] actualsurfaceresistance
    cdef public int _actualsurfaceresistance_ndim
    cdef public int _actualsurfaceresistance_length
    cdef public int _actualsurfaceresistance_length_0
    cdef public bint _actualsurfaceresistance_diskflag
    cdef public str _actualsurfaceresistance_path
    cdef FILE *_actualsurfaceresistance_file
    cdef public bint _actualsurfaceresistance_ramflag
    cdef public double[:,:] _actualsurfaceresistance_array
    cdef public bint _actualsurfaceresistance_outputflag
    cdef double *_actualsurfaceresistance_outputpointer
    cdef public double[:] nbes
    cdef public int _nbes_ndim
    cdef public int _nbes_length
    cdef public int _nbes_length_0
    cdef public bint _nbes_diskflag
    cdef public str _nbes_path
    cdef FILE *_nbes_file
    cdef public bint _nbes_ramflag
    cdef public double[:,:] _nbes_array
    cdef public bint _nbes_outputflag
    cdef double *_nbes_outputpointer
    cdef public double[:] sbes
    cdef public int _sbes_ndim
    cdef public int _sbes_length
    cdef public int _sbes_length_0
    cdef public bint _sbes_diskflag
    cdef public str _sbes_path
    cdef FILE *_sbes_file
    cdef public bint _sbes_ramflag
    cdef public double[:,:] _sbes_array
    cdef public bint _sbes_outputflag
    cdef double *_sbes_outputpointer
    cdef public double[:] snowintmax
    cdef public int _snowintmax_ndim
    cdef public int _snowintmax_length
    cdef public int _snowintmax_length_0
    cdef public bint _snowintmax_diskflag
    cdef public str _snowintmax_path
    cdef FILE *_snowintmax_file
    cdef public bint _snowintmax_ramflag
    cdef public double[:,:] _snowintmax_array
    cdef public bint _snowintmax_outputflag
    cdef double *_snowintmax_outputpointer
    cdef public double[:] snowintrate
    cdef public int _snowintrate_ndim
    cdef public int _snowintrate_length
    cdef public int _snowintrate_length_0
    cdef public bint _snowintrate_diskflag
    cdef public str _snowintrate_path
    cdef FILE *_snowintrate_file
    cdef public bint _snowintrate_ramflag
    cdef public double[:,:] _snowintrate_array
    cdef public bint _snowintrate_outputflag
    cdef double *_snowintrate_outputpointer
    cdef public double[:] nbesinz
    cdef public int _nbesinz_ndim
    cdef public int _nbesinz_length
    cdef public int _nbesinz_length_0
    cdef public bint _nbesinz_diskflag
    cdef public str _nbesinz_path
    cdef FILE *_nbesinz_file
    cdef public bint _nbesinz_ramflag
    cdef public double[:,:] _nbesinz_array
    cdef public bint _nbesinz_outputflag
    cdef double *_nbesinz_outputpointer
    cdef public double[:] sbesinz
    cdef public int _sbesinz_ndim
    cdef public int _sbesinz_length
    cdef public int _sbesinz_length_0
    cdef public bint _sbesinz_diskflag
    cdef public str _sbesinz_path
    cdef FILE *_sbesinz_file
    cdef public bint _sbesinz_ramflag
    cdef public double[:,:] _sbesinz_array
    cdef public bint _sbesinz_outputflag
    cdef double *_sbesinz_outputpointer
    cdef public double[:] wniedinz
    cdef public int _wniedinz_ndim
    cdef public int _wniedinz_length
    cdef public int _wniedinz_length_0
    cdef public bint _wniedinz_diskflag
    cdef public str _wniedinz_path
    cdef FILE *_wniedinz_file
    cdef public bint _wniedinz_ramflag
    cdef public double[:,:] _wniedinz_array
    cdef public bint _wniedinz_outputflag
    cdef double *_wniedinz_outputpointer
    cdef public double[:] actualalbedoinz
    cdef public int _actualalbedoinz_ndim
    cdef public int _actualalbedoinz_length
    cdef public int _actualalbedoinz_length_0
    cdef public bint _actualalbedoinz_diskflag
    cdef public str _actualalbedoinz_path
    cdef FILE *_actualalbedoinz_file
    cdef public bint _actualalbedoinz_ramflag
    cdef public double[:,:] _actualalbedoinz_array
    cdef public bint _actualalbedoinz_outputflag
    cdef double *_actualalbedoinz_outputpointer
    cdef public double[:] wadainz
    cdef public int _wadainz_ndim
    cdef public int _wadainz_length
    cdef public int _wadainz_length_0
    cdef public bint _wadainz_diskflag
    cdef public str _wadainz_path
    cdef FILE *_wadainz_file
    cdef public bint _wadainz_ramflag
    cdef public double[:,:] _wadainz_array
    cdef public bint _wadainz_outputflag
    cdef double *_wadainz_outputpointer
    cdef public double[:] schmpotinz
    cdef public int _schmpotinz_ndim
    cdef public int _schmpotinz_length
    cdef public int _schmpotinz_length_0
    cdef public bint _schmpotinz_diskflag
    cdef public str _schmpotinz_path
    cdef FILE *_schmpotinz_file
    cdef public bint _schmpotinz_ramflag
    cdef public double[:,:] _schmpotinz_array
    cdef public bint _schmpotinz_outputflag
    cdef double *_schmpotinz_outputpointer
    cdef public double[:] schminz
    cdef public int _schminz_ndim
    cdef public int _schminz_length
    cdef public int _schminz_length_0
    cdef public bint _schminz_diskflag
    cdef public str _schminz_path
    cdef FILE *_schminz_file
    cdef public bint _schminz_ramflag
    cdef public double[:,:] _schminz_array
    cdef public bint _schminz_outputflag
    cdef double *_schminz_outputpointer
    cdef public double[:] gefrpotinz
    cdef public int _gefrpotinz_ndim
    cdef public int _gefrpotinz_length
    cdef public int _gefrpotinz_length_0
    cdef public bint _gefrpotinz_diskflag
    cdef public str _gefrpotinz_path
    cdef FILE *_gefrpotinz_file
    cdef public bint _gefrpotinz_ramflag
    cdef public double[:,:] _gefrpotinz_array
    cdef public bint _gefrpotinz_outputflag
    cdef double *_gefrpotinz_outputpointer
    cdef public double[:] gefrinz
    cdef public int _gefrinz_ndim
    cdef public int _gefrinz_length
    cdef public int _gefrinz_length_0
    cdef public bint _gefrinz_diskflag
    cdef public str _gefrinz_path
    cdef FILE *_gefrinz_file
    cdef public bint _gefrinz_ramflag
    cdef public double[:,:] _gefrinz_array
    cdef public bint _gefrinz_outputflag
    cdef double *_gefrinz_outputpointer
    cdef public double[:] evsinz
    cdef public int _evsinz_ndim
    cdef public int _evsinz_length
    cdef public int _evsinz_length_0
    cdef public bint _evsinz_diskflag
    cdef public str _evsinz_path
    cdef FILE *_evsinz_file
    cdef public bint _evsinz_ramflag
    cdef public double[:,:] _evsinz_array
    cdef public bint _evsinz_outputflag
    cdef double *_evsinz_outputpointer
    cdef public double[:] evpo
    cdef public int _evpo_ndim
    cdef public int _evpo_length
    cdef public int _evpo_length_0
    cdef public bint _evpo_diskflag
    cdef public str _evpo_path
    cdef FILE *_evpo_file
    cdef public bint _evpo_ramflag
    cdef public double[:,:] _evpo_array
    cdef public bint _evpo_outputflag
    cdef double *_evpo_outputpointer
    cdef public double[:] evi
    cdef public int _evi_ndim
    cdef public int _evi_length
    cdef public int _evi_length_0
    cdef public bint _evi_diskflag
    cdef public str _evi_path
    cdef FILE *_evi_file
    cdef public bint _evi_ramflag
    cdef public double[:,:] _evi_array
    cdef public bint _evi_outputflag
    cdef double *_evi_outputpointer
    cdef public double[:] evb
    cdef public int _evb_ndim
    cdef public int _evb_length
    cdef public int _evb_length_0
    cdef public bint _evb_diskflag
    cdef public str _evb_path
    cdef FILE *_evb_file
    cdef public bint _evb_ramflag
    cdef public double[:,:] _evb_array
    cdef public bint _evb_outputflag
    cdef double *_evb_outputpointer
    cdef public double[:] evs
    cdef public int _evs_ndim
    cdef public int _evs_length
    cdef public int _evs_length_0
    cdef public bint _evs_diskflag
    cdef public str _evs_path
    cdef FILE *_evs_file
    cdef public bint _evs_ramflag
    cdef public double[:,:] _evs_array
    cdef public bint _evs_outputflag
    cdef double *_evs_outputpointer
    cdef public double[:] wnied
    cdef public int _wnied_ndim
    cdef public int _wnied_length
    cdef public int _wnied_length_0
    cdef public bint _wnied_diskflag
    cdef public str _wnied_path
    cdef FILE *_wnied_file
    cdef public bint _wnied_ramflag
    cdef public double[:,:] _wnied_array
    cdef public bint _wnied_outputflag
    cdef double *_wnied_outputpointer
    cdef public double[:] tempssurface
    cdef public int _tempssurface_ndim
    cdef public int _tempssurface_length
    cdef public int _tempssurface_length_0
    cdef public bint _tempssurface_diskflag
    cdef public str _tempssurface_path
    cdef FILE *_tempssurface_file
    cdef public bint _tempssurface_ramflag
    cdef public double[:,:] _tempssurface_array
    cdef public bint _tempssurface_outputflag
    cdef double *_tempssurface_outputpointer
    cdef public double[:] actualalbedo
    cdef public int _actualalbedo_ndim
    cdef public int _actualalbedo_length
    cdef public int _actualalbedo_length_0
    cdef public bint _actualalbedo_diskflag
    cdef public str _actualalbedo_path
    cdef FILE *_actualalbedo_file
    cdef public bint _actualalbedo_ramflag
    cdef public double[:,:] _actualalbedo_array
    cdef public bint _actualalbedo_outputflag
    cdef double *_actualalbedo_outputpointer
    cdef public double[:] schmpot
    cdef public int _schmpot_ndim
    cdef public int _schmpot_length
    cdef public int _schmpot_length_0
    cdef public bint _schmpot_diskflag
    cdef public str _schmpot_path
    cdef FILE *_schmpot_file
    cdef public bint _schmpot_ramflag
    cdef public double[:,:] _schmpot_array
    cdef public bint _schmpot_outputflag
    cdef double *_schmpot_outputpointer
    cdef public double[:] schm
    cdef public int _schm_ndim
    cdef public int _schm_length
    cdef public int _schm_length_0
    cdef public bint _schm_diskflag
    cdef public str _schm_path
    cdef FILE *_schm_file
    cdef public bint _schm_ramflag
    cdef public double[:,:] _schm_array
    cdef public bint _schm_outputflag
    cdef double *_schm_outputpointer
    cdef public double[:] gefrpot
    cdef public int _gefrpot_ndim
    cdef public int _gefrpot_length
    cdef public int _gefrpot_length_0
    cdef public bint _gefrpot_diskflag
    cdef public str _gefrpot_path
    cdef FILE *_gefrpot_file
    cdef public bint _gefrpot_ramflag
    cdef public double[:,:] _gefrpot_array
    cdef public bint _gefrpot_outputflag
    cdef double *_gefrpot_outputpointer
    cdef public double[:] gefr
    cdef public int _gefr_ndim
    cdef public int _gefr_length
    cdef public int _gefr_length_0
    cdef public bint _gefr_diskflag
    cdef public str _gefr_path
    cdef FILE *_gefr_file
    cdef public bint _gefr_ramflag
    cdef public double[:,:] _gefr_array
    cdef public bint _gefr_outputflag
    cdef double *_gefr_outputpointer
    cdef public double[:] wlatinz
    cdef public int _wlatinz_ndim
    cdef public int _wlatinz_length
    cdef public int _wlatinz_length_0
    cdef public bint _wlatinz_diskflag
    cdef public str _wlatinz_path
    cdef FILE *_wlatinz_file
    cdef public bint _wlatinz_ramflag
    cdef public double[:,:] _wlatinz_array
    cdef public bint _wlatinz_outputflag
    cdef double *_wlatinz_outputpointer
    cdef public double[:] wlatsnow
    cdef public int _wlatsnow_ndim
    cdef public int _wlatsnow_length
    cdef public int _wlatsnow_length_0
    cdef public bint _wlatsnow_diskflag
    cdef public str _wlatsnow_path
    cdef FILE *_wlatsnow_file
    cdef public bint _wlatsnow_ramflag
    cdef public double[:,:] _wlatsnow_array
    cdef public bint _wlatsnow_outputflag
    cdef double *_wlatsnow_outputpointer
    cdef public double[:] wsensinz
    cdef public int _wsensinz_ndim
    cdef public int _wsensinz_length
    cdef public int _wsensinz_length_0
    cdef public bint _wsensinz_diskflag
    cdef public str _wsensinz_path
    cdef FILE *_wsensinz_file
    cdef public bint _wsensinz_ramflag
    cdef public double[:,:] _wsensinz_array
    cdef public bint _wsensinz_outputflag
    cdef double *_wsensinz_outputpointer
    cdef public double[:] wsenssnow
    cdef public int _wsenssnow_ndim
    cdef public int _wsenssnow_length
    cdef public int _wsenssnow_length_0
    cdef public bint _wsenssnow_diskflag
    cdef public str _wsenssnow_path
    cdef FILE *_wsenssnow_file
    cdef public bint _wsenssnow_ramflag
    cdef public double[:,:] _wsenssnow_array
    cdef public bint _wsenssnow_outputflag
    cdef double *_wsenssnow_outputpointer
    cdef public double[:] wsurfinz
    cdef public int _wsurfinz_ndim
    cdef public int _wsurfinz_length
    cdef public int _wsurfinz_length_0
    cdef public bint _wsurfinz_diskflag
    cdef public str _wsurfinz_path
    cdef FILE *_wsurfinz_file
    cdef public bint _wsurfinz_ramflag
    cdef public double[:,:] _wsurfinz_array
    cdef public bint _wsurfinz_outputflag
    cdef double *_wsurfinz_outputpointer
    cdef public double[:] wsurf
    cdef public int _wsurf_ndim
    cdef public int _wsurf_length
    cdef public int _wsurf_length_0
    cdef public bint _wsurf_diskflag
    cdef public str _wsurf_path
    cdef FILE *_wsurf_file
    cdef public bint _wsurf_ramflag
    cdef public double[:,:] _wsurf_array
    cdef public bint _wsurf_outputflag
    cdef double *_wsurf_outputpointer
    cdef public double[:] sff
    cdef public int _sff_ndim
    cdef public int _sff_length
    cdef public int _sff_length_0
    cdef public bint _sff_diskflag
    cdef public str _sff_path
    cdef FILE *_sff_file
    cdef public bint _sff_ramflag
    cdef public double[:,:] _sff_array
    cdef public bint _sff_outputflag
    cdef double *_sff_outputpointer
    cdef public double[:] fvg
    cdef public int _fvg_ndim
    cdef public int _fvg_length
    cdef public int _fvg_length_0
    cdef public bint _fvg_diskflag
    cdef public str _fvg_path
    cdef FILE *_fvg_file
    cdef public bint _fvg_ramflag
    cdef public double[:,:] _fvg_array
    cdef public bint _fvg_outputflag
    cdef double *_fvg_outputpointer
    cdef public double[:] wada
    cdef public int _wada_ndim
    cdef public int _wada_length
    cdef public int _wada_length_0
    cdef public bint _wada_diskflag
    cdef public str _wada_path
    cdef FILE *_wada_file
    cdef public bint _wada_ramflag
    cdef public double[:,:] _wada_array
    cdef public bint _wada_outputflag
    cdef double *_wada_outputpointer
    cdef public double[:] qdb
    cdef public int _qdb_ndim
    cdef public int _qdb_length
    cdef public int _qdb_length_0
    cdef public bint _qdb_diskflag
    cdef public str _qdb_path
    cdef FILE *_qdb_file
    cdef public bint _qdb_ramflag
    cdef public double[:,:] _qdb_array
    cdef public bint _qdb_outputflag
    cdef double *_qdb_outputpointer
    cdef public double[:] qib1
    cdef public int _qib1_ndim
    cdef public int _qib1_length
    cdef public int _qib1_length_0
    cdef public bint _qib1_diskflag
    cdef public str _qib1_path
    cdef FILE *_qib1_file
    cdef public bint _qib1_ramflag
    cdef public double[:,:] _qib1_array
    cdef public bint _qib1_outputflag
    cdef double *_qib1_outputpointer
    cdef public double[:] qib2
    cdef public int _qib2_ndim
    cdef public int _qib2_length
    cdef public int _qib2_length_0
    cdef public bint _qib2_diskflag
    cdef public str _qib2_path
    cdef FILE *_qib2_file
    cdef public bint _qib2_ramflag
    cdef public double[:,:] _qib2_array
    cdef public bint _qib2_outputflag
    cdef double *_qib2_outputpointer
    cdef public double[:] qbb
    cdef public int _qbb_ndim
    cdef public int _qbb_length
    cdef public int _qbb_length_0
    cdef public bint _qbb_diskflag
    cdef public str _qbb_path
    cdef FILE *_qbb_file
    cdef public bint _qbb_ramflag
    cdef public double[:,:] _qbb_array
    cdef public bint _qbb_outputflag
    cdef double *_qbb_outputpointer
    cdef public double[:] qkap
    cdef public int _qkap_ndim
    cdef public int _qkap_length
    cdef public int _qkap_length_0
    cdef public bint _qkap_diskflag
    cdef public str _qkap_path
    cdef FILE *_qkap_file
    cdef public bint _qkap_ramflag
    cdef public double[:,:] _qkap_array
    cdef public bint _qkap_outputflag
    cdef double *_qkap_outputpointer
    cdef public double qdgz
    cdef public int _qdgz_ndim
    cdef public int _qdgz_length
    cdef public bint _qdgz_diskflag
    cdef public str _qdgz_path
    cdef FILE *_qdgz_file
    cdef public bint _qdgz_ramflag
    cdef public double[:] _qdgz_array
    cdef public bint _qdgz_outputflag
    cdef double *_qdgz_outputpointer
    cdef public double qah
    cdef public int _qah_ndim
    cdef public int _qah_length
    cdef public bint _qah_diskflag
    cdef public str _qah_path
    cdef FILE *_qah_file
    cdef public bint _qah_ramflag
    cdef public double[:] _qah_array
    cdef public bint _qah_outputflag
    cdef double *_qah_outputpointer
    cdef public double qa
    cdef public int _qa_ndim
    cdef public int _qa_length
    cdef public bint _qa_diskflag
    cdef public str _qa_path
    cdef FILE *_qa_file
    cdef public bint _qa_ramflag
    cdef public double[:] _qa_array
    cdef public bint _qa_outputflag
    cdef double *_qa_outputpointer
    cpdef open_files(self, int idx):
        if self._qz_diskflag:
            self._qz_file = fopen(str(self._qz_path).encode(), "rb+")
            fseek(self._qz_file, idx*8, SEEK_SET)
        if self._qzh_diskflag:
            self._qzh_file = fopen(str(self._qzh_path).encode(), "rb+")
            fseek(self._qzh_file, idx*8, SEEK_SET)
        if self._temltag_diskflag:
            self._temltag_file = fopen(str(self._temltag_path).encode(), "rb+")
            fseek(self._temltag_file, idx*8, SEEK_SET)
        if self._dailyrelativehumidity_diskflag:
            self._dailyrelativehumidity_file = fopen(str(self._dailyrelativehumidity_path).encode(), "rb+")
            fseek(self._dailyrelativehumidity_file, idx*8, SEEK_SET)
        if self._dailysunshineduration_diskflag:
            self._dailysunshineduration_file = fopen(str(self._dailysunshineduration_path).encode(), "rb+")
            fseek(self._dailysunshineduration_file, idx*8, SEEK_SET)
        if self._nkor_diskflag:
            self._nkor_file = fopen(str(self._nkor_path).encode(), "rb+")
            fseek(self._nkor_file, idx*self._nkor_length*8, SEEK_SET)
        if self._tkor_diskflag:
            self._tkor_file = fopen(str(self._tkor_path).encode(), "rb+")
            fseek(self._tkor_file, idx*self._tkor_length*8, SEEK_SET)
        if self._tkortag_diskflag:
            self._tkortag_file = fopen(str(self._tkortag_path).encode(), "rb+")
            fseek(self._tkortag_file, idx*self._tkortag_length*8, SEEK_SET)
        if self._windspeed2m_diskflag:
            self._windspeed2m_file = fopen(str(self._windspeed2m_path).encode(), "rb+")
            fseek(self._windspeed2m_file, idx*8, SEEK_SET)
        if self._dailywindspeed2m_diskflag:
            self._dailywindspeed2m_file = fopen(str(self._dailywindspeed2m_path).encode(), "rb+")
            fseek(self._dailywindspeed2m_file, idx*8, SEEK_SET)
        if self._reducedwindspeed2m_diskflag:
            self._reducedwindspeed2m_file = fopen(str(self._reducedwindspeed2m_path).encode(), "rb+")
            fseek(self._reducedwindspeed2m_file, idx*self._reducedwindspeed2m_length*8, SEEK_SET)
        if self._windspeed10m_diskflag:
            self._windspeed10m_file = fopen(str(self._windspeed10m_path).encode(), "rb+")
            fseek(self._windspeed10m_file, idx*8, SEEK_SET)
        if self._saturationvapourpressure_diskflag:
            self._saturationvapourpressure_file = fopen(str(self._saturationvapourpressure_path).encode(), "rb+")
            fseek(self._saturationvapourpressure_file, idx*self._saturationvapourpressure_length*8, SEEK_SET)
        if self._dailysaturationvapourpressure_diskflag:
            self._dailysaturationvapourpressure_file = fopen(str(self._dailysaturationvapourpressure_path).encode(), "rb+")
            fseek(self._dailysaturationvapourpressure_file, idx*self._dailysaturationvapourpressure_length*8, SEEK_SET)
        if self._saturationvapourpressureinz_diskflag:
            self._saturationvapourpressureinz_file = fopen(str(self._saturationvapourpressureinz_path).encode(), "rb+")
            fseek(self._saturationvapourpressureinz_file, idx*self._saturationvapourpressureinz_length*8, SEEK_SET)
        if self._saturationvapourpressuresnow_diskflag:
            self._saturationvapourpressuresnow_file = fopen(str(self._saturationvapourpressuresnow_path).encode(), "rb+")
            fseek(self._saturationvapourpressuresnow_file, idx*self._saturationvapourpressuresnow_length*8, SEEK_SET)
        if self._saturationvapourpressureslope_diskflag:
            self._saturationvapourpressureslope_file = fopen(str(self._saturationvapourpressureslope_path).encode(), "rb+")
            fseek(self._saturationvapourpressureslope_file, idx*self._saturationvapourpressureslope_length*8, SEEK_SET)
        if self._dailysaturationvapourpressureslope_diskflag:
            self._dailysaturationvapourpressureslope_file = fopen(str(self._dailysaturationvapourpressureslope_path).encode(), "rb+")
            fseek(self._dailysaturationvapourpressureslope_file, idx*self._dailysaturationvapourpressureslope_length*8, SEEK_SET)
        if self._actualvapourpressure_diskflag:
            self._actualvapourpressure_file = fopen(str(self._actualvapourpressure_path).encode(), "rb+")
            fseek(self._actualvapourpressure_file, idx*self._actualvapourpressure_length*8, SEEK_SET)
        if self._dailyactualvapourpressure_diskflag:
            self._dailyactualvapourpressure_file = fopen(str(self._dailyactualvapourpressure_path).encode(), "rb+")
            fseek(self._dailyactualvapourpressure_file, idx*self._dailyactualvapourpressure_length*8, SEEK_SET)
        if self._dryairpressure_diskflag:
            self._dryairpressure_file = fopen(str(self._dryairpressure_path).encode(), "rb+")
            fseek(self._dryairpressure_file, idx*self._dryairpressure_length*8, SEEK_SET)
        if self._densityair_diskflag:
            self._densityair_file = fopen(str(self._densityair_path).encode(), "rb+")
            fseek(self._densityair_file, idx*self._densityair_length*8, SEEK_SET)
        if self._solardeclination_diskflag:
            self._solardeclination_file = fopen(str(self._solardeclination_path).encode(), "rb+")
            fseek(self._solardeclination_file, idx*8, SEEK_SET)
        if self._tsa_diskflag:
            self._tsa_file = fopen(str(self._tsa_path).encode(), "rb+")
            fseek(self._tsa_file, idx*8, SEEK_SET)
        if self._tsu_diskflag:
            self._tsu_file = fopen(str(self._tsu_path).encode(), "rb+")
            fseek(self._tsu_file, idx*8, SEEK_SET)
        if self._earthsundistance_diskflag:
            self._earthsundistance_file = fopen(str(self._earthsundistance_path).encode(), "rb+")
            fseek(self._earthsundistance_file, idx*8, SEEK_SET)
        if self._extraterrestrialradiation_diskflag:
            self._extraterrestrialradiation_file = fopen(str(self._extraterrestrialradiation_path).encode(), "rb+")
            fseek(self._extraterrestrialradiation_file, idx*8, SEEK_SET)
        if self._possiblesunshineduration_diskflag:
            self._possiblesunshineduration_file = fopen(str(self._possiblesunshineduration_path).encode(), "rb+")
            fseek(self._possiblesunshineduration_file, idx*8, SEEK_SET)
        if self._dailypossiblesunshineduration_diskflag:
            self._dailypossiblesunshineduration_file = fopen(str(self._dailypossiblesunshineduration_path).encode(), "rb+")
            fseek(self._dailypossiblesunshineduration_file, idx*8, SEEK_SET)
        if self._dailyglobalradiation_diskflag:
            self._dailyglobalradiation_file = fopen(str(self._dailyglobalradiation_path).encode(), "rb+")
            fseek(self._dailyglobalradiation_file, idx*8, SEEK_SET)
        if self._sp_diskflag:
            self._sp_file = fopen(str(self._sp_path).encode(), "rb+")
            fseek(self._sp_file, idx*8, SEEK_SET)
        if self._globalradiation_diskflag:
            self._globalradiation_file = fopen(str(self._globalradiation_path).encode(), "rb+")
            fseek(self._globalradiation_file, idx*8, SEEK_SET)
        if self._adjustedglobalradiation_diskflag:
            self._adjustedglobalradiation_file = fopen(str(self._adjustedglobalradiation_path).encode(), "rb+")
            fseek(self._adjustedglobalradiation_file, idx*8, SEEK_SET)
        if self._g_diskflag:
            self._g_file = fopen(str(self._g_path).encode(), "rb+")
            fseek(self._g_file, idx*self._g_length*8, SEEK_SET)
        if self._tz_diskflag:
            self._tz_file = fopen(str(self._tz_path).encode(), "rb+")
            fseek(self._tz_file, idx*self._tz_length*8, SEEK_SET)
        if self._wg_diskflag:
            self._wg_file = fopen(str(self._wg_path).encode(), "rb+")
            fseek(self._wg_file, idx*self._wg_length*8, SEEK_SET)
        if self._netshortwaveradiation_diskflag:
            self._netshortwaveradiation_file = fopen(str(self._netshortwaveradiation_path).encode(), "rb+")
            fseek(self._netshortwaveradiation_file, idx*self._netshortwaveradiation_length*8, SEEK_SET)
        if self._netshortwaveradiationinz_diskflag:
            self._netshortwaveradiationinz_file = fopen(str(self._netshortwaveradiationinz_path).encode(), "rb+")
            fseek(self._netshortwaveradiationinz_file, idx*self._netshortwaveradiationinz_length*8, SEEK_SET)
        if self._netshortwaveradiationsnow_diskflag:
            self._netshortwaveradiationsnow_file = fopen(str(self._netshortwaveradiationsnow_path).encode(), "rb+")
            fseek(self._netshortwaveradiationsnow_file, idx*self._netshortwaveradiationsnow_length*8, SEEK_SET)
        if self._dailynetshortwaveradiation_diskflag:
            self._dailynetshortwaveradiation_file = fopen(str(self._dailynetshortwaveradiation_path).encode(), "rb+")
            fseek(self._dailynetshortwaveradiation_file, idx*self._dailynetshortwaveradiation_length*8, SEEK_SET)
        if self._dailynetlongwaveradiation_diskflag:
            self._dailynetlongwaveradiation_file = fopen(str(self._dailynetlongwaveradiation_path).encode(), "rb+")
            fseek(self._dailynetlongwaveradiation_file, idx*self._dailynetlongwaveradiation_length*8, SEEK_SET)
        if self._netlongwaveradiationinz_diskflag:
            self._netlongwaveradiationinz_file = fopen(str(self._netlongwaveradiationinz_path).encode(), "rb+")
            fseek(self._netlongwaveradiationinz_file, idx*self._netlongwaveradiationinz_length*8, SEEK_SET)
        if self._netlongwaveradiationsnow_diskflag:
            self._netlongwaveradiationsnow_file = fopen(str(self._netlongwaveradiationsnow_path).encode(), "rb+")
            fseek(self._netlongwaveradiationsnow_file, idx*self._netlongwaveradiationsnow_length*8, SEEK_SET)
        if self._netradiation_diskflag:
            self._netradiation_file = fopen(str(self._netradiation_path).encode(), "rb+")
            fseek(self._netradiation_file, idx*self._netradiation_length*8, SEEK_SET)
        if self._netradiationinz_diskflag:
            self._netradiationinz_file = fopen(str(self._netradiationinz_path).encode(), "rb+")
            fseek(self._netradiationinz_file, idx*self._netradiationinz_length*8, SEEK_SET)
        if self._netradiationsnow_diskflag:
            self._netradiationsnow_file = fopen(str(self._netradiationsnow_path).encode(), "rb+")
            fseek(self._netradiationsnow_file, idx*self._netradiationsnow_length*8, SEEK_SET)
        if self._dailynetradiation_diskflag:
            self._dailynetradiation_file = fopen(str(self._dailynetradiation_path).encode(), "rb+")
            fseek(self._dailynetradiation_file, idx*self._dailynetradiation_length*8, SEEK_SET)
        if self._aerodynamicresistance_diskflag:
            self._aerodynamicresistance_file = fopen(str(self._aerodynamicresistance_path).encode(), "rb+")
            fseek(self._aerodynamicresistance_file, idx*self._aerodynamicresistance_length*8, SEEK_SET)
        if self._soilsurfaceresistance_diskflag:
            self._soilsurfaceresistance_file = fopen(str(self._soilsurfaceresistance_path).encode(), "rb+")
            fseek(self._soilsurfaceresistance_file, idx*self._soilsurfaceresistance_length*8, SEEK_SET)
        if self._landusesurfaceresistance_diskflag:
            self._landusesurfaceresistance_file = fopen(str(self._landusesurfaceresistance_path).encode(), "rb+")
            fseek(self._landusesurfaceresistance_file, idx*self._landusesurfaceresistance_length*8, SEEK_SET)
        if self._actualsurfaceresistance_diskflag:
            self._actualsurfaceresistance_file = fopen(str(self._actualsurfaceresistance_path).encode(), "rb+")
            fseek(self._actualsurfaceresistance_file, idx*self._actualsurfaceresistance_length*8, SEEK_SET)
        if self._nbes_diskflag:
            self._nbes_file = fopen(str(self._nbes_path).encode(), "rb+")
            fseek(self._nbes_file, idx*self._nbes_length*8, SEEK_SET)
        if self._sbes_diskflag:
            self._sbes_file = fopen(str(self._sbes_path).encode(), "rb+")
            fseek(self._sbes_file, idx*self._sbes_length*8, SEEK_SET)
        if self._snowintmax_diskflag:
            self._snowintmax_file = fopen(str(self._snowintmax_path).encode(), "rb+")
            fseek(self._snowintmax_file, idx*self._snowintmax_length*8, SEEK_SET)
        if self._snowintrate_diskflag:
            self._snowintrate_file = fopen(str(self._snowintrate_path).encode(), "rb+")
            fseek(self._snowintrate_file, idx*self._snowintrate_length*8, SEEK_SET)
        if self._nbesinz_diskflag:
            self._nbesinz_file = fopen(str(self._nbesinz_path).encode(), "rb+")
            fseek(self._nbesinz_file, idx*self._nbesinz_length*8, SEEK_SET)
        if self._sbesinz_diskflag:
            self._sbesinz_file = fopen(str(self._sbesinz_path).encode(), "rb+")
            fseek(self._sbesinz_file, idx*self._sbesinz_length*8, SEEK_SET)
        if self._wniedinz_diskflag:
            self._wniedinz_file = fopen(str(self._wniedinz_path).encode(), "rb+")
            fseek(self._wniedinz_file, idx*self._wniedinz_length*8, SEEK_SET)
        if self._actualalbedoinz_diskflag:
            self._actualalbedoinz_file = fopen(str(self._actualalbedoinz_path).encode(), "rb+")
            fseek(self._actualalbedoinz_file, idx*self._actualalbedoinz_length*8, SEEK_SET)
        if self._wadainz_diskflag:
            self._wadainz_file = fopen(str(self._wadainz_path).encode(), "rb+")
            fseek(self._wadainz_file, idx*self._wadainz_length*8, SEEK_SET)
        if self._schmpotinz_diskflag:
            self._schmpotinz_file = fopen(str(self._schmpotinz_path).encode(), "rb+")
            fseek(self._schmpotinz_file, idx*self._schmpotinz_length*8, SEEK_SET)
        if self._schminz_diskflag:
            self._schminz_file = fopen(str(self._schminz_path).encode(), "rb+")
            fseek(self._schminz_file, idx*self._schminz_length*8, SEEK_SET)
        if self._gefrpotinz_diskflag:
            self._gefrpotinz_file = fopen(str(self._gefrpotinz_path).encode(), "rb+")
            fseek(self._gefrpotinz_file, idx*self._gefrpotinz_length*8, SEEK_SET)
        if self._gefrinz_diskflag:
            self._gefrinz_file = fopen(str(self._gefrinz_path).encode(), "rb+")
            fseek(self._gefrinz_file, idx*self._gefrinz_length*8, SEEK_SET)
        if self._evsinz_diskflag:
            self._evsinz_file = fopen(str(self._evsinz_path).encode(), "rb+")
            fseek(self._evsinz_file, idx*self._evsinz_length*8, SEEK_SET)
        if self._evpo_diskflag:
            self._evpo_file = fopen(str(self._evpo_path).encode(), "rb+")
            fseek(self._evpo_file, idx*self._evpo_length*8, SEEK_SET)
        if self._evi_diskflag:
            self._evi_file = fopen(str(self._evi_path).encode(), "rb+")
            fseek(self._evi_file, idx*self._evi_length*8, SEEK_SET)
        if self._evb_diskflag:
            self._evb_file = fopen(str(self._evb_path).encode(), "rb+")
            fseek(self._evb_file, idx*self._evb_length*8, SEEK_SET)
        if self._evs_diskflag:
            self._evs_file = fopen(str(self._evs_path).encode(), "rb+")
            fseek(self._evs_file, idx*self._evs_length*8, SEEK_SET)
        if self._wnied_diskflag:
            self._wnied_file = fopen(str(self._wnied_path).encode(), "rb+")
            fseek(self._wnied_file, idx*self._wnied_length*8, SEEK_SET)
        if self._tempssurface_diskflag:
            self._tempssurface_file = fopen(str(self._tempssurface_path).encode(), "rb+")
            fseek(self._tempssurface_file, idx*self._tempssurface_length*8, SEEK_SET)
        if self._actualalbedo_diskflag:
            self._actualalbedo_file = fopen(str(self._actualalbedo_path).encode(), "rb+")
            fseek(self._actualalbedo_file, idx*self._actualalbedo_length*8, SEEK_SET)
        if self._schmpot_diskflag:
            self._schmpot_file = fopen(str(self._schmpot_path).encode(), "rb+")
            fseek(self._schmpot_file, idx*self._schmpot_length*8, SEEK_SET)
        if self._schm_diskflag:
            self._schm_file = fopen(str(self._schm_path).encode(), "rb+")
            fseek(self._schm_file, idx*self._schm_length*8, SEEK_SET)
        if self._gefrpot_diskflag:
            self._gefrpot_file = fopen(str(self._gefrpot_path).encode(), "rb+")
            fseek(self._gefrpot_file, idx*self._gefrpot_length*8, SEEK_SET)
        if self._gefr_diskflag:
            self._gefr_file = fopen(str(self._gefr_path).encode(), "rb+")
            fseek(self._gefr_file, idx*self._gefr_length*8, SEEK_SET)
        if self._wlatinz_diskflag:
            self._wlatinz_file = fopen(str(self._wlatinz_path).encode(), "rb+")
            fseek(self._wlatinz_file, idx*self._wlatinz_length*8, SEEK_SET)
        if self._wlatsnow_diskflag:
            self._wlatsnow_file = fopen(str(self._wlatsnow_path).encode(), "rb+")
            fseek(self._wlatsnow_file, idx*self._wlatsnow_length*8, SEEK_SET)
        if self._wsensinz_diskflag:
            self._wsensinz_file = fopen(str(self._wsensinz_path).encode(), "rb+")
            fseek(self._wsensinz_file, idx*self._wsensinz_length*8, SEEK_SET)
        if self._wsenssnow_diskflag:
            self._wsenssnow_file = fopen(str(self._wsenssnow_path).encode(), "rb+")
            fseek(self._wsenssnow_file, idx*self._wsenssnow_length*8, SEEK_SET)
        if self._wsurfinz_diskflag:
            self._wsurfinz_file = fopen(str(self._wsurfinz_path).encode(), "rb+")
            fseek(self._wsurfinz_file, idx*self._wsurfinz_length*8, SEEK_SET)
        if self._wsurf_diskflag:
            self._wsurf_file = fopen(str(self._wsurf_path).encode(), "rb+")
            fseek(self._wsurf_file, idx*self._wsurf_length*8, SEEK_SET)
        if self._sff_diskflag:
            self._sff_file = fopen(str(self._sff_path).encode(), "rb+")
            fseek(self._sff_file, idx*self._sff_length*8, SEEK_SET)
        if self._fvg_diskflag:
            self._fvg_file = fopen(str(self._fvg_path).encode(), "rb+")
            fseek(self._fvg_file, idx*self._fvg_length*8, SEEK_SET)
        if self._wada_diskflag:
            self._wada_file = fopen(str(self._wada_path).encode(), "rb+")
            fseek(self._wada_file, idx*self._wada_length*8, SEEK_SET)
        if self._qdb_diskflag:
            self._qdb_file = fopen(str(self._qdb_path).encode(), "rb+")
            fseek(self._qdb_file, idx*self._qdb_length*8, SEEK_SET)
        if self._qib1_diskflag:
            self._qib1_file = fopen(str(self._qib1_path).encode(), "rb+")
            fseek(self._qib1_file, idx*self._qib1_length*8, SEEK_SET)
        if self._qib2_diskflag:
            self._qib2_file = fopen(str(self._qib2_path).encode(), "rb+")
            fseek(self._qib2_file, idx*self._qib2_length*8, SEEK_SET)
        if self._qbb_diskflag:
            self._qbb_file = fopen(str(self._qbb_path).encode(), "rb+")
            fseek(self._qbb_file, idx*self._qbb_length*8, SEEK_SET)
        if self._qkap_diskflag:
            self._qkap_file = fopen(str(self._qkap_path).encode(), "rb+")
            fseek(self._qkap_file, idx*self._qkap_length*8, SEEK_SET)
        if self._qdgz_diskflag:
            self._qdgz_file = fopen(str(self._qdgz_path).encode(), "rb+")
            fseek(self._qdgz_file, idx*8, SEEK_SET)
        if self._qah_diskflag:
            self._qah_file = fopen(str(self._qah_path).encode(), "rb+")
            fseek(self._qah_file, idx*8, SEEK_SET)
        if self._qa_diskflag:
            self._qa_file = fopen(str(self._qa_path).encode(), "rb+")
            fseek(self._qa_file, idx*8, SEEK_SET)
    cpdef inline close_files(self):
        if self._qz_diskflag:
            fclose(self._qz_file)
        if self._qzh_diskflag:
            fclose(self._qzh_file)
        if self._temltag_diskflag:
            fclose(self._temltag_file)
        if self._dailyrelativehumidity_diskflag:
            fclose(self._dailyrelativehumidity_file)
        if self._dailysunshineduration_diskflag:
            fclose(self._dailysunshineduration_file)
        if self._nkor_diskflag:
            fclose(self._nkor_file)
        if self._tkor_diskflag:
            fclose(self._tkor_file)
        if self._tkortag_diskflag:
            fclose(self._tkortag_file)
        if self._windspeed2m_diskflag:
            fclose(self._windspeed2m_file)
        if self._dailywindspeed2m_diskflag:
            fclose(self._dailywindspeed2m_file)
        if self._reducedwindspeed2m_diskflag:
            fclose(self._reducedwindspeed2m_file)
        if self._windspeed10m_diskflag:
            fclose(self._windspeed10m_file)
        if self._saturationvapourpressure_diskflag:
            fclose(self._saturationvapourpressure_file)
        if self._dailysaturationvapourpressure_diskflag:
            fclose(self._dailysaturationvapourpressure_file)
        if self._saturationvapourpressureinz_diskflag:
            fclose(self._saturationvapourpressureinz_file)
        if self._saturationvapourpressuresnow_diskflag:
            fclose(self._saturationvapourpressuresnow_file)
        if self._saturationvapourpressureslope_diskflag:
            fclose(self._saturationvapourpressureslope_file)
        if self._dailysaturationvapourpressureslope_diskflag:
            fclose(self._dailysaturationvapourpressureslope_file)
        if self._actualvapourpressure_diskflag:
            fclose(self._actualvapourpressure_file)
        if self._dailyactualvapourpressure_diskflag:
            fclose(self._dailyactualvapourpressure_file)
        if self._dryairpressure_diskflag:
            fclose(self._dryairpressure_file)
        if self._densityair_diskflag:
            fclose(self._densityair_file)
        if self._solardeclination_diskflag:
            fclose(self._solardeclination_file)
        if self._tsa_diskflag:
            fclose(self._tsa_file)
        if self._tsu_diskflag:
            fclose(self._tsu_file)
        if self._earthsundistance_diskflag:
            fclose(self._earthsundistance_file)
        if self._extraterrestrialradiation_diskflag:
            fclose(self._extraterrestrialradiation_file)
        if self._possiblesunshineduration_diskflag:
            fclose(self._possiblesunshineduration_file)
        if self._dailypossiblesunshineduration_diskflag:
            fclose(self._dailypossiblesunshineduration_file)
        if self._dailyglobalradiation_diskflag:
            fclose(self._dailyglobalradiation_file)
        if self._sp_diskflag:
            fclose(self._sp_file)
        if self._globalradiation_diskflag:
            fclose(self._globalradiation_file)
        if self._adjustedglobalradiation_diskflag:
            fclose(self._adjustedglobalradiation_file)
        if self._g_diskflag:
            fclose(self._g_file)
        if self._tz_diskflag:
            fclose(self._tz_file)
        if self._wg_diskflag:
            fclose(self._wg_file)
        if self._netshortwaveradiation_diskflag:
            fclose(self._netshortwaveradiation_file)
        if self._netshortwaveradiationinz_diskflag:
            fclose(self._netshortwaveradiationinz_file)
        if self._netshortwaveradiationsnow_diskflag:
            fclose(self._netshortwaveradiationsnow_file)
        if self._dailynetshortwaveradiation_diskflag:
            fclose(self._dailynetshortwaveradiation_file)
        if self._dailynetlongwaveradiation_diskflag:
            fclose(self._dailynetlongwaveradiation_file)
        if self._netlongwaveradiationinz_diskflag:
            fclose(self._netlongwaveradiationinz_file)
        if self._netlongwaveradiationsnow_diskflag:
            fclose(self._netlongwaveradiationsnow_file)
        if self._netradiation_diskflag:
            fclose(self._netradiation_file)
        if self._netradiationinz_diskflag:
            fclose(self._netradiationinz_file)
        if self._netradiationsnow_diskflag:
            fclose(self._netradiationsnow_file)
        if self._dailynetradiation_diskflag:
            fclose(self._dailynetradiation_file)
        if self._aerodynamicresistance_diskflag:
            fclose(self._aerodynamicresistance_file)
        if self._soilsurfaceresistance_diskflag:
            fclose(self._soilsurfaceresistance_file)
        if self._landusesurfaceresistance_diskflag:
            fclose(self._landusesurfaceresistance_file)
        if self._actualsurfaceresistance_diskflag:
            fclose(self._actualsurfaceresistance_file)
        if self._nbes_diskflag:
            fclose(self._nbes_file)
        if self._sbes_diskflag:
            fclose(self._sbes_file)
        if self._snowintmax_diskflag:
            fclose(self._snowintmax_file)
        if self._snowintrate_diskflag:
            fclose(self._snowintrate_file)
        if self._nbesinz_diskflag:
            fclose(self._nbesinz_file)
        if self._sbesinz_diskflag:
            fclose(self._sbesinz_file)
        if self._wniedinz_diskflag:
            fclose(self._wniedinz_file)
        if self._actualalbedoinz_diskflag:
            fclose(self._actualalbedoinz_file)
        if self._wadainz_diskflag:
            fclose(self._wadainz_file)
        if self._schmpotinz_diskflag:
            fclose(self._schmpotinz_file)
        if self._schminz_diskflag:
            fclose(self._schminz_file)
        if self._gefrpotinz_diskflag:
            fclose(self._gefrpotinz_file)
        if self._gefrinz_diskflag:
            fclose(self._gefrinz_file)
        if self._evsinz_diskflag:
            fclose(self._evsinz_file)
        if self._evpo_diskflag:
            fclose(self._evpo_file)
        if self._evi_diskflag:
            fclose(self._evi_file)
        if self._evb_diskflag:
            fclose(self._evb_file)
        if self._evs_diskflag:
            fclose(self._evs_file)
        if self._wnied_diskflag:
            fclose(self._wnied_file)
        if self._tempssurface_diskflag:
            fclose(self._tempssurface_file)
        if self._actualalbedo_diskflag:
            fclose(self._actualalbedo_file)
        if self._schmpot_diskflag:
            fclose(self._schmpot_file)
        if self._schm_diskflag:
            fclose(self._schm_file)
        if self._gefrpot_diskflag:
            fclose(self._gefrpot_file)
        if self._gefr_diskflag:
            fclose(self._gefr_file)
        if self._wlatinz_diskflag:
            fclose(self._wlatinz_file)
        if self._wlatsnow_diskflag:
            fclose(self._wlatsnow_file)
        if self._wsensinz_diskflag:
            fclose(self._wsensinz_file)
        if self._wsenssnow_diskflag:
            fclose(self._wsenssnow_file)
        if self._wsurfinz_diskflag:
            fclose(self._wsurfinz_file)
        if self._wsurf_diskflag:
            fclose(self._wsurf_file)
        if self._sff_diskflag:
            fclose(self._sff_file)
        if self._fvg_diskflag:
            fclose(self._fvg_file)
        if self._wada_diskflag:
            fclose(self._wada_file)
        if self._qdb_diskflag:
            fclose(self._qdb_file)
        if self._qib1_diskflag:
            fclose(self._qib1_file)
        if self._qib2_diskflag:
            fclose(self._qib2_file)
        if self._qbb_diskflag:
            fclose(self._qbb_file)
        if self._qkap_diskflag:
            fclose(self._qkap_file)
        if self._qdgz_diskflag:
            fclose(self._qdgz_file)
        if self._qah_diskflag:
            fclose(self._qah_file)
        if self._qa_diskflag:
            fclose(self._qa_file)
    cpdef inline void load_data(self, int idx)  nogil:
        cdef int jdx0, jdx1, jdx2, jdx3, jdx4, jdx5
        if self._qz_diskflag:
            fread(&self.qz, 8, 1, self._qz_file)
        elif self._qz_ramflag:
            self.qz = self._qz_array[idx]
        if self._qzh_diskflag:
            fread(&self.qzh, 8, 1, self._qzh_file)
        elif self._qzh_ramflag:
            self.qzh = self._qzh_array[idx]
        if self._temltag_diskflag:
            fread(&self.temltag, 8, 1, self._temltag_file)
        elif self._temltag_ramflag:
            self.temltag = self._temltag_array[idx]
        if self._dailyrelativehumidity_diskflag:
            fread(&self.dailyrelativehumidity, 8, 1, self._dailyrelativehumidity_file)
        elif self._dailyrelativehumidity_ramflag:
            self.dailyrelativehumidity = self._dailyrelativehumidity_array[idx]
        if self._dailysunshineduration_diskflag:
            fread(&self.dailysunshineduration, 8, 1, self._dailysunshineduration_file)
        elif self._dailysunshineduration_ramflag:
            self.dailysunshineduration = self._dailysunshineduration_array[idx]
        if self._nkor_diskflag:
            fread(&self.nkor[0], 8, self._nkor_length, self._nkor_file)
        elif self._nkor_ramflag:
            for jdx0 in range(self._nkor_length_0):
                self.nkor[jdx0] = self._nkor_array[idx, jdx0]
        if self._tkor_diskflag:
            fread(&self.tkor[0], 8, self._tkor_length, self._tkor_file)
        elif self._tkor_ramflag:
            for jdx0 in range(self._tkor_length_0):
                self.tkor[jdx0] = self._tkor_array[idx, jdx0]
        if self._tkortag_diskflag:
            fread(&self.tkortag[0], 8, self._tkortag_length, self._tkortag_file)
        elif self._tkortag_ramflag:
            for jdx0 in range(self._tkortag_length_0):
                self.tkortag[jdx0] = self._tkortag_array[idx, jdx0]
        if self._windspeed2m_diskflag:
            fread(&self.windspeed2m, 8, 1, self._windspeed2m_file)
        elif self._windspeed2m_ramflag:
            self.windspeed2m = self._windspeed2m_array[idx]
        if self._dailywindspeed2m_diskflag:
            fread(&self.dailywindspeed2m, 8, 1, self._dailywindspeed2m_file)
        elif self._dailywindspeed2m_ramflag:
            self.dailywindspeed2m = self._dailywindspeed2m_array[idx]
        if self._reducedwindspeed2m_diskflag:
            fread(&self.reducedwindspeed2m[0], 8, self._reducedwindspeed2m_length, self._reducedwindspeed2m_file)
        elif self._reducedwindspeed2m_ramflag:
            for jdx0 in range(self._reducedwindspeed2m_length_0):
                self.reducedwindspeed2m[jdx0] = self._reducedwindspeed2m_array[idx, jdx0]
        if self._windspeed10m_diskflag:
            fread(&self.windspeed10m, 8, 1, self._windspeed10m_file)
        elif self._windspeed10m_ramflag:
            self.windspeed10m = self._windspeed10m_array[idx]
        if self._saturationvapourpressure_diskflag:
            fread(&self.saturationvapourpressure[0], 8, self._saturationvapourpressure_length, self._saturationvapourpressure_file)
        elif self._saturationvapourpressure_ramflag:
            for jdx0 in range(self._saturationvapourpressure_length_0):
                self.saturationvapourpressure[jdx0] = self._saturationvapourpressure_array[idx, jdx0]
        if self._dailysaturationvapourpressure_diskflag:
            fread(&self.dailysaturationvapourpressure[0], 8, self._dailysaturationvapourpressure_length, self._dailysaturationvapourpressure_file)
        elif self._dailysaturationvapourpressure_ramflag:
            for jdx0 in range(self._dailysaturationvapourpressure_length_0):
                self.dailysaturationvapourpressure[jdx0] = self._dailysaturationvapourpressure_array[idx, jdx0]
        if self._saturationvapourpressureinz_diskflag:
            fread(&self.saturationvapourpressureinz[0], 8, self._saturationvapourpressureinz_length, self._saturationvapourpressureinz_file)
        elif self._saturationvapourpressureinz_ramflag:
            for jdx0 in range(self._saturationvapourpressureinz_length_0):
                self.saturationvapourpressureinz[jdx0] = self._saturationvapourpressureinz_array[idx, jdx0]
        if self._saturationvapourpressuresnow_diskflag:
            fread(&self.saturationvapourpressuresnow[0], 8, self._saturationvapourpressuresnow_length, self._saturationvapourpressuresnow_file)
        elif self._saturationvapourpressuresnow_ramflag:
            for jdx0 in range(self._saturationvapourpressuresnow_length_0):
                self.saturationvapourpressuresnow[jdx0] = self._saturationvapourpressuresnow_array[idx, jdx0]
        if self._saturationvapourpressureslope_diskflag:
            fread(&self.saturationvapourpressureslope[0], 8, self._saturationvapourpressureslope_length, self._saturationvapourpressureslope_file)
        elif self._saturationvapourpressureslope_ramflag:
            for jdx0 in range(self._saturationvapourpressureslope_length_0):
                self.saturationvapourpressureslope[jdx0] = self._saturationvapourpressureslope_array[idx, jdx0]
        if self._dailysaturationvapourpressureslope_diskflag:
            fread(&self.dailysaturationvapourpressureslope[0], 8, self._dailysaturationvapourpressureslope_length, self._dailysaturationvapourpressureslope_file)
        elif self._dailysaturationvapourpressureslope_ramflag:
            for jdx0 in range(self._dailysaturationvapourpressureslope_length_0):
                self.dailysaturationvapourpressureslope[jdx0] = self._dailysaturationvapourpressureslope_array[idx, jdx0]
        if self._actualvapourpressure_diskflag:
            fread(&self.actualvapourpressure[0], 8, self._actualvapourpressure_length, self._actualvapourpressure_file)
        elif self._actualvapourpressure_ramflag:
            for jdx0 in range(self._actualvapourpressure_length_0):
                self.actualvapourpressure[jdx0] = self._actualvapourpressure_array[idx, jdx0]
        if self._dailyactualvapourpressure_diskflag:
            fread(&self.dailyactualvapourpressure[0], 8, self._dailyactualvapourpressure_length, self._dailyactualvapourpressure_file)
        elif self._dailyactualvapourpressure_ramflag:
            for jdx0 in range(self._dailyactualvapourpressure_length_0):
                self.dailyactualvapourpressure[jdx0] = self._dailyactualvapourpressure_array[idx, jdx0]
        if self._dryairpressure_diskflag:
            fread(&self.dryairpressure[0], 8, self._dryairpressure_length, self._dryairpressure_file)
        elif self._dryairpressure_ramflag:
            for jdx0 in range(self._dryairpressure_length_0):
                self.dryairpressure[jdx0] = self._dryairpressure_array[idx, jdx0]
        if self._densityair_diskflag:
            fread(&self.densityair[0], 8, self._densityair_length, self._densityair_file)
        elif self._densityair_ramflag:
            for jdx0 in range(self._densityair_length_0):
                self.densityair[jdx0] = self._densityair_array[idx, jdx0]
        if self._solardeclination_diskflag:
            fread(&self.solardeclination, 8, 1, self._solardeclination_file)
        elif self._solardeclination_ramflag:
            self.solardeclination = self._solardeclination_array[idx]
        if self._tsa_diskflag:
            fread(&self.tsa, 8, 1, self._tsa_file)
        elif self._tsa_ramflag:
            self.tsa = self._tsa_array[idx]
        if self._tsu_diskflag:
            fread(&self.tsu, 8, 1, self._tsu_file)
        elif self._tsu_ramflag:
            self.tsu = self._tsu_array[idx]
        if self._earthsundistance_diskflag:
            fread(&self.earthsundistance, 8, 1, self._earthsundistance_file)
        elif self._earthsundistance_ramflag:
            self.earthsundistance = self._earthsundistance_array[idx]
        if self._extraterrestrialradiation_diskflag:
            fread(&self.extraterrestrialradiation, 8, 1, self._extraterrestrialradiation_file)
        elif self._extraterrestrialradiation_ramflag:
            self.extraterrestrialradiation = self._extraterrestrialradiation_array[idx]
        if self._possiblesunshineduration_diskflag:
            fread(&self.possiblesunshineduration, 8, 1, self._possiblesunshineduration_file)
        elif self._possiblesunshineduration_ramflag:
            self.possiblesunshineduration = self._possiblesunshineduration_array[idx]
        if self._dailypossiblesunshineduration_diskflag:
            fread(&self.dailypossiblesunshineduration, 8, 1, self._dailypossiblesunshineduration_file)
        elif self._dailypossiblesunshineduration_ramflag:
            self.dailypossiblesunshineduration = self._dailypossiblesunshineduration_array[idx]
        if self._dailyglobalradiation_diskflag:
            fread(&self.dailyglobalradiation, 8, 1, self._dailyglobalradiation_file)
        elif self._dailyglobalradiation_ramflag:
            self.dailyglobalradiation = self._dailyglobalradiation_array[idx]
        if self._sp_diskflag:
            fread(&self.sp, 8, 1, self._sp_file)
        elif self._sp_ramflag:
            self.sp = self._sp_array[idx]
        if self._globalradiation_diskflag:
            fread(&self.globalradiation, 8, 1, self._globalradiation_file)
        elif self._globalradiation_ramflag:
            self.globalradiation = self._globalradiation_array[idx]
        if self._adjustedglobalradiation_diskflag:
            fread(&self.adjustedglobalradiation, 8, 1, self._adjustedglobalradiation_file)
        elif self._adjustedglobalradiation_ramflag:
            self.adjustedglobalradiation = self._adjustedglobalradiation_array[idx]
        if self._g_diskflag:
            fread(&self.g[0], 8, self._g_length, self._g_file)
        elif self._g_ramflag:
            for jdx0 in range(self._g_length_0):
                self.g[jdx0] = self._g_array[idx, jdx0]
        if self._tz_diskflag:
            fread(&self.tz[0], 8, self._tz_length, self._tz_file)
        elif self._tz_ramflag:
            for jdx0 in range(self._tz_length_0):
                self.tz[jdx0] = self._tz_array[idx, jdx0]
        if self._wg_diskflag:
            fread(&self.wg[0], 8, self._wg_length, self._wg_file)
        elif self._wg_ramflag:
            for jdx0 in range(self._wg_length_0):
                self.wg[jdx0] = self._wg_array[idx, jdx0]
        if self._netshortwaveradiation_diskflag:
            fread(&self.netshortwaveradiation[0], 8, self._netshortwaveradiation_length, self._netshortwaveradiation_file)
        elif self._netshortwaveradiation_ramflag:
            for jdx0 in range(self._netshortwaveradiation_length_0):
                self.netshortwaveradiation[jdx0] = self._netshortwaveradiation_array[idx, jdx0]
        if self._netshortwaveradiationinz_diskflag:
            fread(&self.netshortwaveradiationinz[0], 8, self._netshortwaveradiationinz_length, self._netshortwaveradiationinz_file)
        elif self._netshortwaveradiationinz_ramflag:
            for jdx0 in range(self._netshortwaveradiationinz_length_0):
                self.netshortwaveradiationinz[jdx0] = self._netshortwaveradiationinz_array[idx, jdx0]
        if self._netshortwaveradiationsnow_diskflag:
            fread(&self.netshortwaveradiationsnow[0], 8, self._netshortwaveradiationsnow_length, self._netshortwaveradiationsnow_file)
        elif self._netshortwaveradiationsnow_ramflag:
            for jdx0 in range(self._netshortwaveradiationsnow_length_0):
                self.netshortwaveradiationsnow[jdx0] = self._netshortwaveradiationsnow_array[idx, jdx0]
        if self._dailynetshortwaveradiation_diskflag:
            fread(&self.dailynetshortwaveradiation[0], 8, self._dailynetshortwaveradiation_length, self._dailynetshortwaveradiation_file)
        elif self._dailynetshortwaveradiation_ramflag:
            for jdx0 in range(self._dailynetshortwaveradiation_length_0):
                self.dailynetshortwaveradiation[jdx0] = self._dailynetshortwaveradiation_array[idx, jdx0]
        if self._dailynetlongwaveradiation_diskflag:
            fread(&self.dailynetlongwaveradiation[0], 8, self._dailynetlongwaveradiation_length, self._dailynetlongwaveradiation_file)
        elif self._dailynetlongwaveradiation_ramflag:
            for jdx0 in range(self._dailynetlongwaveradiation_length_0):
                self.dailynetlongwaveradiation[jdx0] = self._dailynetlongwaveradiation_array[idx, jdx0]
        if self._netlongwaveradiationinz_diskflag:
            fread(&self.netlongwaveradiationinz[0], 8, self._netlongwaveradiationinz_length, self._netlongwaveradiationinz_file)
        elif self._netlongwaveradiationinz_ramflag:
            for jdx0 in range(self._netlongwaveradiationinz_length_0):
                self.netlongwaveradiationinz[jdx0] = self._netlongwaveradiationinz_array[idx, jdx0]
        if self._netlongwaveradiationsnow_diskflag:
            fread(&self.netlongwaveradiationsnow[0], 8, self._netlongwaveradiationsnow_length, self._netlongwaveradiationsnow_file)
        elif self._netlongwaveradiationsnow_ramflag:
            for jdx0 in range(self._netlongwaveradiationsnow_length_0):
                self.netlongwaveradiationsnow[jdx0] = self._netlongwaveradiationsnow_array[idx, jdx0]
        if self._netradiation_diskflag:
            fread(&self.netradiation[0], 8, self._netradiation_length, self._netradiation_file)
        elif self._netradiation_ramflag:
            for jdx0 in range(self._netradiation_length_0):
                self.netradiation[jdx0] = self._netradiation_array[idx, jdx0]
        if self._netradiationinz_diskflag:
            fread(&self.netradiationinz[0], 8, self._netradiationinz_length, self._netradiationinz_file)
        elif self._netradiationinz_ramflag:
            for jdx0 in range(self._netradiationinz_length_0):
                self.netradiationinz[jdx0] = self._netradiationinz_array[idx, jdx0]
        if self._netradiationsnow_diskflag:
            fread(&self.netradiationsnow[0], 8, self._netradiationsnow_length, self._netradiationsnow_file)
        elif self._netradiationsnow_ramflag:
            for jdx0 in range(self._netradiationsnow_length_0):
                self.netradiationsnow[jdx0] = self._netradiationsnow_array[idx, jdx0]
        if self._dailynetradiation_diskflag:
            fread(&self.dailynetradiation[0], 8, self._dailynetradiation_length, self._dailynetradiation_file)
        elif self._dailynetradiation_ramflag:
            for jdx0 in range(self._dailynetradiation_length_0):
                self.dailynetradiation[jdx0] = self._dailynetradiation_array[idx, jdx0]
        if self._aerodynamicresistance_diskflag:
            fread(&self.aerodynamicresistance[0], 8, self._aerodynamicresistance_length, self._aerodynamicresistance_file)
        elif self._aerodynamicresistance_ramflag:
            for jdx0 in range(self._aerodynamicresistance_length_0):
                self.aerodynamicresistance[jdx0] = self._aerodynamicresistance_array[idx, jdx0]
        if self._soilsurfaceresistance_diskflag:
            fread(&self.soilsurfaceresistance[0], 8, self._soilsurfaceresistance_length, self._soilsurfaceresistance_file)
        elif self._soilsurfaceresistance_ramflag:
            for jdx0 in range(self._soilsurfaceresistance_length_0):
                self.soilsurfaceresistance[jdx0] = self._soilsurfaceresistance_array[idx, jdx0]
        if self._landusesurfaceresistance_diskflag:
            fread(&self.landusesurfaceresistance[0], 8, self._landusesurfaceresistance_length, self._landusesurfaceresistance_file)
        elif self._landusesurfaceresistance_ramflag:
            for jdx0 in range(self._landusesurfaceresistance_length_0):
                self.landusesurfaceresistance[jdx0] = self._landusesurfaceresistance_array[idx, jdx0]
        if self._actualsurfaceresistance_diskflag:
            fread(&self.actualsurfaceresistance[0], 8, self._actualsurfaceresistance_length, self._actualsurfaceresistance_file)
        elif self._actualsurfaceresistance_ramflag:
            for jdx0 in range(self._actualsurfaceresistance_length_0):
                self.actualsurfaceresistance[jdx0] = self._actualsurfaceresistance_array[idx, jdx0]
        if self._nbes_diskflag:
            fread(&self.nbes[0], 8, self._nbes_length, self._nbes_file)
        elif self._nbes_ramflag:
            for jdx0 in range(self._nbes_length_0):
                self.nbes[jdx0] = self._nbes_array[idx, jdx0]
        if self._sbes_diskflag:
            fread(&self.sbes[0], 8, self._sbes_length, self._sbes_file)
        elif self._sbes_ramflag:
            for jdx0 in range(self._sbes_length_0):
                self.sbes[jdx0] = self._sbes_array[idx, jdx0]
        if self._snowintmax_diskflag:
            fread(&self.snowintmax[0], 8, self._snowintmax_length, self._snowintmax_file)
        elif self._snowintmax_ramflag:
            for jdx0 in range(self._snowintmax_length_0):
                self.snowintmax[jdx0] = self._snowintmax_array[idx, jdx0]
        if self._snowintrate_diskflag:
            fread(&self.snowintrate[0], 8, self._snowintrate_length, self._snowintrate_file)
        elif self._snowintrate_ramflag:
            for jdx0 in range(self._snowintrate_length_0):
                self.snowintrate[jdx0] = self._snowintrate_array[idx, jdx0]
        if self._nbesinz_diskflag:
            fread(&self.nbesinz[0], 8, self._nbesinz_length, self._nbesinz_file)
        elif self._nbesinz_ramflag:
            for jdx0 in range(self._nbesinz_length_0):
                self.nbesinz[jdx0] = self._nbesinz_array[idx, jdx0]
        if self._sbesinz_diskflag:
            fread(&self.sbesinz[0], 8, self._sbesinz_length, self._sbesinz_file)
        elif self._sbesinz_ramflag:
            for jdx0 in range(self._sbesinz_length_0):
                self.sbesinz[jdx0] = self._sbesinz_array[idx, jdx0]
        if self._wniedinz_diskflag:
            fread(&self.wniedinz[0], 8, self._wniedinz_length, self._wniedinz_file)
        elif self._wniedinz_ramflag:
            for jdx0 in range(self._wniedinz_length_0):
                self.wniedinz[jdx0] = self._wniedinz_array[idx, jdx0]
        if self._actualalbedoinz_diskflag:
            fread(&self.actualalbedoinz[0], 8, self._actualalbedoinz_length, self._actualalbedoinz_file)
        elif self._actualalbedoinz_ramflag:
            for jdx0 in range(self._actualalbedoinz_length_0):
                self.actualalbedoinz[jdx0] = self._actualalbedoinz_array[idx, jdx0]
        if self._wadainz_diskflag:
            fread(&self.wadainz[0], 8, self._wadainz_length, self._wadainz_file)
        elif self._wadainz_ramflag:
            for jdx0 in range(self._wadainz_length_0):
                self.wadainz[jdx0] = self._wadainz_array[idx, jdx0]
        if self._schmpotinz_diskflag:
            fread(&self.schmpotinz[0], 8, self._schmpotinz_length, self._schmpotinz_file)
        elif self._schmpotinz_ramflag:
            for jdx0 in range(self._schmpotinz_length_0):
                self.schmpotinz[jdx0] = self._schmpotinz_array[idx, jdx0]
        if self._schminz_diskflag:
            fread(&self.schminz[0], 8, self._schminz_length, self._schminz_file)
        elif self._schminz_ramflag:
            for jdx0 in range(self._schminz_length_0):
                self.schminz[jdx0] = self._schminz_array[idx, jdx0]
        if self._gefrpotinz_diskflag:
            fread(&self.gefrpotinz[0], 8, self._gefrpotinz_length, self._gefrpotinz_file)
        elif self._gefrpotinz_ramflag:
            for jdx0 in range(self._gefrpotinz_length_0):
                self.gefrpotinz[jdx0] = self._gefrpotinz_array[idx, jdx0]
        if self._gefrinz_diskflag:
            fread(&self.gefrinz[0], 8, self._gefrinz_length, self._gefrinz_file)
        elif self._gefrinz_ramflag:
            for jdx0 in range(self._gefrinz_length_0):
                self.gefrinz[jdx0] = self._gefrinz_array[idx, jdx0]
        if self._evsinz_diskflag:
            fread(&self.evsinz[0], 8, self._evsinz_length, self._evsinz_file)
        elif self._evsinz_ramflag:
            for jdx0 in range(self._evsinz_length_0):
                self.evsinz[jdx0] = self._evsinz_array[idx, jdx0]
        if self._evpo_diskflag:
            fread(&self.evpo[0], 8, self._evpo_length, self._evpo_file)
        elif self._evpo_ramflag:
            for jdx0 in range(self._evpo_length_0):
                self.evpo[jdx0] = self._evpo_array[idx, jdx0]
        if self._evi_diskflag:
            fread(&self.evi[0], 8, self._evi_length, self._evi_file)
        elif self._evi_ramflag:
            for jdx0 in range(self._evi_length_0):
                self.evi[jdx0] = self._evi_array[idx, jdx0]
        if self._evb_diskflag:
            fread(&self.evb[0], 8, self._evb_length, self._evb_file)
        elif self._evb_ramflag:
            for jdx0 in range(self._evb_length_0):
                self.evb[jdx0] = self._evb_array[idx, jdx0]
        if self._evs_diskflag:
            fread(&self.evs[0], 8, self._evs_length, self._evs_file)
        elif self._evs_ramflag:
            for jdx0 in range(self._evs_length_0):
                self.evs[jdx0] = self._evs_array[idx, jdx0]
        if self._wnied_diskflag:
            fread(&self.wnied[0], 8, self._wnied_length, self._wnied_file)
        elif self._wnied_ramflag:
            for jdx0 in range(self._wnied_length_0):
                self.wnied[jdx0] = self._wnied_array[idx, jdx0]
        if self._tempssurface_diskflag:
            fread(&self.tempssurface[0], 8, self._tempssurface_length, self._tempssurface_file)
        elif self._tempssurface_ramflag:
            for jdx0 in range(self._tempssurface_length_0):
                self.tempssurface[jdx0] = self._tempssurface_array[idx, jdx0]
        if self._actualalbedo_diskflag:
            fread(&self.actualalbedo[0], 8, self._actualalbedo_length, self._actualalbedo_file)
        elif self._actualalbedo_ramflag:
            for jdx0 in range(self._actualalbedo_length_0):
                self.actualalbedo[jdx0] = self._actualalbedo_array[idx, jdx0]
        if self._schmpot_diskflag:
            fread(&self.schmpot[0], 8, self._schmpot_length, self._schmpot_file)
        elif self._schmpot_ramflag:
            for jdx0 in range(self._schmpot_length_0):
                self.schmpot[jdx0] = self._schmpot_array[idx, jdx0]
        if self._schm_diskflag:
            fread(&self.schm[0], 8, self._schm_length, self._schm_file)
        elif self._schm_ramflag:
            for jdx0 in range(self._schm_length_0):
                self.schm[jdx0] = self._schm_array[idx, jdx0]
        if self._gefrpot_diskflag:
            fread(&self.gefrpot[0], 8, self._gefrpot_length, self._gefrpot_file)
        elif self._gefrpot_ramflag:
            for jdx0 in range(self._gefrpot_length_0):
                self.gefrpot[jdx0] = self._gefrpot_array[idx, jdx0]
        if self._gefr_diskflag:
            fread(&self.gefr[0], 8, self._gefr_length, self._gefr_file)
        elif self._gefr_ramflag:
            for jdx0 in range(self._gefr_length_0):
                self.gefr[jdx0] = self._gefr_array[idx, jdx0]
        if self._wlatinz_diskflag:
            fread(&self.wlatinz[0], 8, self._wlatinz_length, self._wlatinz_file)
        elif self._wlatinz_ramflag:
            for jdx0 in range(self._wlatinz_length_0):
                self.wlatinz[jdx0] = self._wlatinz_array[idx, jdx0]
        if self._wlatsnow_diskflag:
            fread(&self.wlatsnow[0], 8, self._wlatsnow_length, self._wlatsnow_file)
        elif self._wlatsnow_ramflag:
            for jdx0 in range(self._wlatsnow_length_0):
                self.wlatsnow[jdx0] = self._wlatsnow_array[idx, jdx0]
        if self._wsensinz_diskflag:
            fread(&self.wsensinz[0], 8, self._wsensinz_length, self._wsensinz_file)
        elif self._wsensinz_ramflag:
            for jdx0 in range(self._wsensinz_length_0):
                self.wsensinz[jdx0] = self._wsensinz_array[idx, jdx0]
        if self._wsenssnow_diskflag:
            fread(&self.wsenssnow[0], 8, self._wsenssnow_length, self._wsenssnow_file)
        elif self._wsenssnow_ramflag:
            for jdx0 in range(self._wsenssnow_length_0):
                self.wsenssnow[jdx0] = self._wsenssnow_array[idx, jdx0]
        if self._wsurfinz_diskflag:
            fread(&self.wsurfinz[0], 8, self._wsurfinz_length, self._wsurfinz_file)
        elif self._wsurfinz_ramflag:
            for jdx0 in range(self._wsurfinz_length_0):
                self.wsurfinz[jdx0] = self._wsurfinz_array[idx, jdx0]
        if self._wsurf_diskflag:
            fread(&self.wsurf[0], 8, self._wsurf_length, self._wsurf_file)
        elif self._wsurf_ramflag:
            for jdx0 in range(self._wsurf_length_0):
                self.wsurf[jdx0] = self._wsurf_array[idx, jdx0]
        if self._sff_diskflag:
            fread(&self.sff[0], 8, self._sff_length, self._sff_file)
        elif self._sff_ramflag:
            for jdx0 in range(self._sff_length_0):
                self.sff[jdx0] = self._sff_array[idx, jdx0]
        if self._fvg_diskflag:
            fread(&self.fvg[0], 8, self._fvg_length, self._fvg_file)
        elif self._fvg_ramflag:
            for jdx0 in range(self._fvg_length_0):
                self.fvg[jdx0] = self._fvg_array[idx, jdx0]
        if self._wada_diskflag:
            fread(&self.wada[0], 8, self._wada_length, self._wada_file)
        elif self._wada_ramflag:
            for jdx0 in range(self._wada_length_0):
                self.wada[jdx0] = self._wada_array[idx, jdx0]
        if self._qdb_diskflag:
            fread(&self.qdb[0], 8, self._qdb_length, self._qdb_file)
        elif self._qdb_ramflag:
            for jdx0 in range(self._qdb_length_0):
                self.qdb[jdx0] = self._qdb_array[idx, jdx0]
        if self._qib1_diskflag:
            fread(&self.qib1[0], 8, self._qib1_length, self._qib1_file)
        elif self._qib1_ramflag:
            for jdx0 in range(self._qib1_length_0):
                self.qib1[jdx0] = self._qib1_array[idx, jdx0]
        if self._qib2_diskflag:
            fread(&self.qib2[0], 8, self._qib2_length, self._qib2_file)
        elif self._qib2_ramflag:
            for jdx0 in range(self._qib2_length_0):
                self.qib2[jdx0] = self._qib2_array[idx, jdx0]
        if self._qbb_diskflag:
            fread(&self.qbb[0], 8, self._qbb_length, self._qbb_file)
        elif self._qbb_ramflag:
            for jdx0 in range(self._qbb_length_0):
                self.qbb[jdx0] = self._qbb_array[idx, jdx0]
        if self._qkap_diskflag:
            fread(&self.qkap[0], 8, self._qkap_length, self._qkap_file)
        elif self._qkap_ramflag:
            for jdx0 in range(self._qkap_length_0):
                self.qkap[jdx0] = self._qkap_array[idx, jdx0]
        if self._qdgz_diskflag:
            fread(&self.qdgz, 8, 1, self._qdgz_file)
        elif self._qdgz_ramflag:
            self.qdgz = self._qdgz_array[idx]
        if self._qah_diskflag:
            fread(&self.qah, 8, 1, self._qah_file)
        elif self._qah_ramflag:
            self.qah = self._qah_array[idx]
        if self._qa_diskflag:
            fread(&self.qa, 8, 1, self._qa_file)
        elif self._qa_ramflag:
            self.qa = self._qa_array[idx]
    cpdef inline void save_data(self, int idx)  nogil:
        cdef int jdx0, jdx1, jdx2, jdx3, jdx4, jdx5
        if self._qz_diskflag:
            fwrite(&self.qz, 8, 1, self._qz_file)
        elif self._qz_ramflag:
            self._qz_array[idx] = self.qz
        if self._qzh_diskflag:
            fwrite(&self.qzh, 8, 1, self._qzh_file)
        elif self._qzh_ramflag:
            self._qzh_array[idx] = self.qzh
        if self._temltag_diskflag:
            fwrite(&self.temltag, 8, 1, self._temltag_file)
        elif self._temltag_ramflag:
            self._temltag_array[idx] = self.temltag
        if self._dailyrelativehumidity_diskflag:
            fwrite(&self.dailyrelativehumidity, 8, 1, self._dailyrelativehumidity_file)
        elif self._dailyrelativehumidity_ramflag:
            self._dailyrelativehumidity_array[idx] = self.dailyrelativehumidity
        if self._dailysunshineduration_diskflag:
            fwrite(&self.dailysunshineduration, 8, 1, self._dailysunshineduration_file)
        elif self._dailysunshineduration_ramflag:
            self._dailysunshineduration_array[idx] = self.dailysunshineduration
        if self._nkor_diskflag:
            fwrite(&self.nkor[0], 8, self._nkor_length, self._nkor_file)
        elif self._nkor_ramflag:
            for jdx0 in range(self._nkor_length_0):
                self._nkor_array[idx, jdx0] = self.nkor[jdx0]
        if self._tkor_diskflag:
            fwrite(&self.tkor[0], 8, self._tkor_length, self._tkor_file)
        elif self._tkor_ramflag:
            for jdx0 in range(self._tkor_length_0):
                self._tkor_array[idx, jdx0] = self.tkor[jdx0]
        if self._tkortag_diskflag:
            fwrite(&self.tkortag[0], 8, self._tkortag_length, self._tkortag_file)
        elif self._tkortag_ramflag:
            for jdx0 in range(self._tkortag_length_0):
                self._tkortag_array[idx, jdx0] = self.tkortag[jdx0]
        if self._windspeed2m_diskflag:
            fwrite(&self.windspeed2m, 8, 1, self._windspeed2m_file)
        elif self._windspeed2m_ramflag:
            self._windspeed2m_array[idx] = self.windspeed2m
        if self._dailywindspeed2m_diskflag:
            fwrite(&self.dailywindspeed2m, 8, 1, self._dailywindspeed2m_file)
        elif self._dailywindspeed2m_ramflag:
            self._dailywindspeed2m_array[idx] = self.dailywindspeed2m
        if self._reducedwindspeed2m_diskflag:
            fwrite(&self.reducedwindspeed2m[0], 8, self._reducedwindspeed2m_length, self._reducedwindspeed2m_file)
        elif self._reducedwindspeed2m_ramflag:
            for jdx0 in range(self._reducedwindspeed2m_length_0):
                self._reducedwindspeed2m_array[idx, jdx0] = self.reducedwindspeed2m[jdx0]
        if self._windspeed10m_diskflag:
            fwrite(&self.windspeed10m, 8, 1, self._windspeed10m_file)
        elif self._windspeed10m_ramflag:
            self._windspeed10m_array[idx] = self.windspeed10m
        if self._saturationvapourpressure_diskflag:
            fwrite(&self.saturationvapourpressure[0], 8, self._saturationvapourpressure_length, self._saturationvapourpressure_file)
        elif self._saturationvapourpressure_ramflag:
            for jdx0 in range(self._saturationvapourpressure_length_0):
                self._saturationvapourpressure_array[idx, jdx0] = self.saturationvapourpressure[jdx0]
        if self._dailysaturationvapourpressure_diskflag:
            fwrite(&self.dailysaturationvapourpressure[0], 8, self._dailysaturationvapourpressure_length, self._dailysaturationvapourpressure_file)
        elif self._dailysaturationvapourpressure_ramflag:
            for jdx0 in range(self._dailysaturationvapourpressure_length_0):
                self._dailysaturationvapourpressure_array[idx, jdx0] = self.dailysaturationvapourpressure[jdx0]
        if self._saturationvapourpressureinz_diskflag:
            fwrite(&self.saturationvapourpressureinz[0], 8, self._saturationvapourpressureinz_length, self._saturationvapourpressureinz_file)
        elif self._saturationvapourpressureinz_ramflag:
            for jdx0 in range(self._saturationvapourpressureinz_length_0):
                self._saturationvapourpressureinz_array[idx, jdx0] = self.saturationvapourpressureinz[jdx0]
        if self._saturationvapourpressuresnow_diskflag:
            fwrite(&self.saturationvapourpressuresnow[0], 8, self._saturationvapourpressuresnow_length, self._saturationvapourpressuresnow_file)
        elif self._saturationvapourpressuresnow_ramflag:
            for jdx0 in range(self._saturationvapourpressuresnow_length_0):
                self._saturationvapourpressuresnow_array[idx, jdx0] = self.saturationvapourpressuresnow[jdx0]
        if self._saturationvapourpressureslope_diskflag:
            fwrite(&self.saturationvapourpressureslope[0], 8, self._saturationvapourpressureslope_length, self._saturationvapourpressureslope_file)
        elif self._saturationvapourpressureslope_ramflag:
            for jdx0 in range(self._saturationvapourpressureslope_length_0):
                self._saturationvapourpressureslope_array[idx, jdx0] = self.saturationvapourpressureslope[jdx0]
        if self._dailysaturationvapourpressureslope_diskflag:
            fwrite(&self.dailysaturationvapourpressureslope[0], 8, self._dailysaturationvapourpressureslope_length, self._dailysaturationvapourpressureslope_file)
        elif self._dailysaturationvapourpressureslope_ramflag:
            for jdx0 in range(self._dailysaturationvapourpressureslope_length_0):
                self._dailysaturationvapourpressureslope_array[idx, jdx0] = self.dailysaturationvapourpressureslope[jdx0]
        if self._actualvapourpressure_diskflag:
            fwrite(&self.actualvapourpressure[0], 8, self._actualvapourpressure_length, self._actualvapourpressure_file)
        elif self._actualvapourpressure_ramflag:
            for jdx0 in range(self._actualvapourpressure_length_0):
                self._actualvapourpressure_array[idx, jdx0] = self.actualvapourpressure[jdx0]
        if self._dailyactualvapourpressure_diskflag:
            fwrite(&self.dailyactualvapourpressure[0], 8, self._dailyactualvapourpressure_length, self._dailyactualvapourpressure_file)
        elif self._dailyactualvapourpressure_ramflag:
            for jdx0 in range(self._dailyactualvapourpressure_length_0):
                self._dailyactualvapourpressure_array[idx, jdx0] = self.dailyactualvapourpressure[jdx0]
        if self._dryairpressure_diskflag:
            fwrite(&self.dryairpressure[0], 8, self._dryairpressure_length, self._dryairpressure_file)
        elif self._dryairpressure_ramflag:
            for jdx0 in range(self._dryairpressure_length_0):
                self._dryairpressure_array[idx, jdx0] = self.dryairpressure[jdx0]
        if self._densityair_diskflag:
            fwrite(&self.densityair[0], 8, self._densityair_length, self._densityair_file)
        elif self._densityair_ramflag:
            for jdx0 in range(self._densityair_length_0):
                self._densityair_array[idx, jdx0] = self.densityair[jdx0]
        if self._solardeclination_diskflag:
            fwrite(&self.solardeclination, 8, 1, self._solardeclination_file)
        elif self._solardeclination_ramflag:
            self._solardeclination_array[idx] = self.solardeclination
        if self._tsa_diskflag:
            fwrite(&self.tsa, 8, 1, self._tsa_file)
        elif self._tsa_ramflag:
            self._tsa_array[idx] = self.tsa
        if self._tsu_diskflag:
            fwrite(&self.tsu, 8, 1, self._tsu_file)
        elif self._tsu_ramflag:
            self._tsu_array[idx] = self.tsu
        if self._earthsundistance_diskflag:
            fwrite(&self.earthsundistance, 8, 1, self._earthsundistance_file)
        elif self._earthsundistance_ramflag:
            self._earthsundistance_array[idx] = self.earthsundistance
        if self._extraterrestrialradiation_diskflag:
            fwrite(&self.extraterrestrialradiation, 8, 1, self._extraterrestrialradiation_file)
        elif self._extraterrestrialradiation_ramflag:
            self._extraterrestrialradiation_array[idx] = self.extraterrestrialradiation
        if self._possiblesunshineduration_diskflag:
            fwrite(&self.possiblesunshineduration, 8, 1, self._possiblesunshineduration_file)
        elif self._possiblesunshineduration_ramflag:
            self._possiblesunshineduration_array[idx] = self.possiblesunshineduration
        if self._dailypossiblesunshineduration_diskflag:
            fwrite(&self.dailypossiblesunshineduration, 8, 1, self._dailypossiblesunshineduration_file)
        elif self._dailypossiblesunshineduration_ramflag:
            self._dailypossiblesunshineduration_array[idx] = self.dailypossiblesunshineduration
        if self._dailyglobalradiation_diskflag:
            fwrite(&self.dailyglobalradiation, 8, 1, self._dailyglobalradiation_file)
        elif self._dailyglobalradiation_ramflag:
            self._dailyglobalradiation_array[idx] = self.dailyglobalradiation
        if self._sp_diskflag:
            fwrite(&self.sp, 8, 1, self._sp_file)
        elif self._sp_ramflag:
            self._sp_array[idx] = self.sp
        if self._globalradiation_diskflag:
            fwrite(&self.globalradiation, 8, 1, self._globalradiation_file)
        elif self._globalradiation_ramflag:
            self._globalradiation_array[idx] = self.globalradiation
        if self._adjustedglobalradiation_diskflag:
            fwrite(&self.adjustedglobalradiation, 8, 1, self._adjustedglobalradiation_file)
        elif self._adjustedglobalradiation_ramflag:
            self._adjustedglobalradiation_array[idx] = self.adjustedglobalradiation
        if self._g_diskflag:
            fwrite(&self.g[0], 8, self._g_length, self._g_file)
        elif self._g_ramflag:
            for jdx0 in range(self._g_length_0):
                self._g_array[idx, jdx0] = self.g[jdx0]
        if self._tz_diskflag:
            fwrite(&self.tz[0], 8, self._tz_length, self._tz_file)
        elif self._tz_ramflag:
            for jdx0 in range(self._tz_length_0):
                self._tz_array[idx, jdx0] = self.tz[jdx0]
        if self._wg_diskflag:
            fwrite(&self.wg[0], 8, self._wg_length, self._wg_file)
        elif self._wg_ramflag:
            for jdx0 in range(self._wg_length_0):
                self._wg_array[idx, jdx0] = self.wg[jdx0]
        if self._netshortwaveradiation_diskflag:
            fwrite(&self.netshortwaveradiation[0], 8, self._netshortwaveradiation_length, self._netshortwaveradiation_file)
        elif self._netshortwaveradiation_ramflag:
            for jdx0 in range(self._netshortwaveradiation_length_0):
                self._netshortwaveradiation_array[idx, jdx0] = self.netshortwaveradiation[jdx0]
        if self._netshortwaveradiationinz_diskflag:
            fwrite(&self.netshortwaveradiationinz[0], 8, self._netshortwaveradiationinz_length, self._netshortwaveradiationinz_file)
        elif self._netshortwaveradiationinz_ramflag:
            for jdx0 in range(self._netshortwaveradiationinz_length_0):
                self._netshortwaveradiationinz_array[idx, jdx0] = self.netshortwaveradiationinz[jdx0]
        if self._netshortwaveradiationsnow_diskflag:
            fwrite(&self.netshortwaveradiationsnow[0], 8, self._netshortwaveradiationsnow_length, self._netshortwaveradiationsnow_file)
        elif self._netshortwaveradiationsnow_ramflag:
            for jdx0 in range(self._netshortwaveradiationsnow_length_0):
                self._netshortwaveradiationsnow_array[idx, jdx0] = self.netshortwaveradiationsnow[jdx0]
        if self._dailynetshortwaveradiation_diskflag:
            fwrite(&self.dailynetshortwaveradiation[0], 8, self._dailynetshortwaveradiation_length, self._dailynetshortwaveradiation_file)
        elif self._dailynetshortwaveradiation_ramflag:
            for jdx0 in range(self._dailynetshortwaveradiation_length_0):
                self._dailynetshortwaveradiation_array[idx, jdx0] = self.dailynetshortwaveradiation[jdx0]
        if self._dailynetlongwaveradiation_diskflag:
            fwrite(&self.dailynetlongwaveradiation[0], 8, self._dailynetlongwaveradiation_length, self._dailynetlongwaveradiation_file)
        elif self._dailynetlongwaveradiation_ramflag:
            for jdx0 in range(self._dailynetlongwaveradiation_length_0):
                self._dailynetlongwaveradiation_array[idx, jdx0] = self.dailynetlongwaveradiation[jdx0]
        if self._netlongwaveradiationinz_diskflag:
            fwrite(&self.netlongwaveradiationinz[0], 8, self._netlongwaveradiationinz_length, self._netlongwaveradiationinz_file)
        elif self._netlongwaveradiationinz_ramflag:
            for jdx0 in range(self._netlongwaveradiationinz_length_0):
                self._netlongwaveradiationinz_array[idx, jdx0] = self.netlongwaveradiationinz[jdx0]
        if self._netlongwaveradiationsnow_diskflag:
            fwrite(&self.netlongwaveradiationsnow[0], 8, self._netlongwaveradiationsnow_length, self._netlongwaveradiationsnow_file)
        elif self._netlongwaveradiationsnow_ramflag:
            for jdx0 in range(self._netlongwaveradiationsnow_length_0):
                self._netlongwaveradiationsnow_array[idx, jdx0] = self.netlongwaveradiationsnow[jdx0]
        if self._netradiation_diskflag:
            fwrite(&self.netradiation[0], 8, self._netradiation_length, self._netradiation_file)
        elif self._netradiation_ramflag:
            for jdx0 in range(self._netradiation_length_0):
                self._netradiation_array[idx, jdx0] = self.netradiation[jdx0]
        if self._netradiationinz_diskflag:
            fwrite(&self.netradiationinz[0], 8, self._netradiationinz_length, self._netradiationinz_file)
        elif self._netradiationinz_ramflag:
            for jdx0 in range(self._netradiationinz_length_0):
                self._netradiationinz_array[idx, jdx0] = self.netradiationinz[jdx0]
        if self._netradiationsnow_diskflag:
            fwrite(&self.netradiationsnow[0], 8, self._netradiationsnow_length, self._netradiationsnow_file)
        elif self._netradiationsnow_ramflag:
            for jdx0 in range(self._netradiationsnow_length_0):
                self._netradiationsnow_array[idx, jdx0] = self.netradiationsnow[jdx0]
        if self._dailynetradiation_diskflag:
            fwrite(&self.dailynetradiation[0], 8, self._dailynetradiation_length, self._dailynetradiation_file)
        elif self._dailynetradiation_ramflag:
            for jdx0 in range(self._dailynetradiation_length_0):
                self._dailynetradiation_array[idx, jdx0] = self.dailynetradiation[jdx0]
        if self._aerodynamicresistance_diskflag:
            fwrite(&self.aerodynamicresistance[0], 8, self._aerodynamicresistance_length, self._aerodynamicresistance_file)
        elif self._aerodynamicresistance_ramflag:
            for jdx0 in range(self._aerodynamicresistance_length_0):
                self._aerodynamicresistance_array[idx, jdx0] = self.aerodynamicresistance[jdx0]
        if self._soilsurfaceresistance_diskflag:
            fwrite(&self.soilsurfaceresistance[0], 8, self._soilsurfaceresistance_length, self._soilsurfaceresistance_file)
        elif self._soilsurfaceresistance_ramflag:
            for jdx0 in range(self._soilsurfaceresistance_length_0):
                self._soilsurfaceresistance_array[idx, jdx0] = self.soilsurfaceresistance[jdx0]
        if self._landusesurfaceresistance_diskflag:
            fwrite(&self.landusesurfaceresistance[0], 8, self._landusesurfaceresistance_length, self._landusesurfaceresistance_file)
        elif self._landusesurfaceresistance_ramflag:
            for jdx0 in range(self._landusesurfaceresistance_length_0):
                self._landusesurfaceresistance_array[idx, jdx0] = self.landusesurfaceresistance[jdx0]
        if self._actualsurfaceresistance_diskflag:
            fwrite(&self.actualsurfaceresistance[0], 8, self._actualsurfaceresistance_length, self._actualsurfaceresistance_file)
        elif self._actualsurfaceresistance_ramflag:
            for jdx0 in range(self._actualsurfaceresistance_length_0):
                self._actualsurfaceresistance_array[idx, jdx0] = self.actualsurfaceresistance[jdx0]
        if self._nbes_diskflag:
            fwrite(&self.nbes[0], 8, self._nbes_length, self._nbes_file)
        elif self._nbes_ramflag:
            for jdx0 in range(self._nbes_length_0):
                self._nbes_array[idx, jdx0] = self.nbes[jdx0]
        if self._sbes_diskflag:
            fwrite(&self.sbes[0], 8, self._sbes_length, self._sbes_file)
        elif self._sbes_ramflag:
            for jdx0 in range(self._sbes_length_0):
                self._sbes_array[idx, jdx0] = self.sbes[jdx0]
        if self._snowintmax_diskflag:
            fwrite(&self.snowintmax[0], 8, self._snowintmax_length, self._snowintmax_file)
        elif self._snowintmax_ramflag:
            for jdx0 in range(self._snowintmax_length_0):
                self._snowintmax_array[idx, jdx0] = self.snowintmax[jdx0]
        if self._snowintrate_diskflag:
            fwrite(&self.snowintrate[0], 8, self._snowintrate_length, self._snowintrate_file)
        elif self._snowintrate_ramflag:
            for jdx0 in range(self._snowintrate_length_0):
                self._snowintrate_array[idx, jdx0] = self.snowintrate[jdx0]
        if self._nbesinz_diskflag:
            fwrite(&self.nbesinz[0], 8, self._nbesinz_length, self._nbesinz_file)
        elif self._nbesinz_ramflag:
            for jdx0 in range(self._nbesinz_length_0):
                self._nbesinz_array[idx, jdx0] = self.nbesinz[jdx0]
        if self._sbesinz_diskflag:
            fwrite(&self.sbesinz[0], 8, self._sbesinz_length, self._sbesinz_file)
        elif self._sbesinz_ramflag:
            for jdx0 in range(self._sbesinz_length_0):
                self._sbesinz_array[idx, jdx0] = self.sbesinz[jdx0]
        if self._wniedinz_diskflag:
            fwrite(&self.wniedinz[0], 8, self._wniedinz_length, self._wniedinz_file)
        elif self._wniedinz_ramflag:
            for jdx0 in range(self._wniedinz_length_0):
                self._wniedinz_array[idx, jdx0] = self.wniedinz[jdx0]
        if self._actualalbedoinz_diskflag:
            fwrite(&self.actualalbedoinz[0], 8, self._actualalbedoinz_length, self._actualalbedoinz_file)
        elif self._actualalbedoinz_ramflag:
            for jdx0 in range(self._actualalbedoinz_length_0):
                self._actualalbedoinz_array[idx, jdx0] = self.actualalbedoinz[jdx0]
        if self._wadainz_diskflag:
            fwrite(&self.wadainz[0], 8, self._wadainz_length, self._wadainz_file)
        elif self._wadainz_ramflag:
            for jdx0 in range(self._wadainz_length_0):
                self._wadainz_array[idx, jdx0] = self.wadainz[jdx0]
        if self._schmpotinz_diskflag:
            fwrite(&self.schmpotinz[0], 8, self._schmpotinz_length, self._schmpotinz_file)
        elif self._schmpotinz_ramflag:
            for jdx0 in range(self._schmpotinz_length_0):
                self._schmpotinz_array[idx, jdx0] = self.schmpotinz[jdx0]
        if self._schminz_diskflag:
            fwrite(&self.schminz[0], 8, self._schminz_length, self._schminz_file)
        elif self._schminz_ramflag:
            for jdx0 in range(self._schminz_length_0):
                self._schminz_array[idx, jdx0] = self.schminz[jdx0]
        if self._gefrpotinz_diskflag:
            fwrite(&self.gefrpotinz[0], 8, self._gefrpotinz_length, self._gefrpotinz_file)
        elif self._gefrpotinz_ramflag:
            for jdx0 in range(self._gefrpotinz_length_0):
                self._gefrpotinz_array[idx, jdx0] = self.gefrpotinz[jdx0]
        if self._gefrinz_diskflag:
            fwrite(&self.gefrinz[0], 8, self._gefrinz_length, self._gefrinz_file)
        elif self._gefrinz_ramflag:
            for jdx0 in range(self._gefrinz_length_0):
                self._gefrinz_array[idx, jdx0] = self.gefrinz[jdx0]
        if self._evsinz_diskflag:
            fwrite(&self.evsinz[0], 8, self._evsinz_length, self._evsinz_file)
        elif self._evsinz_ramflag:
            for jdx0 in range(self._evsinz_length_0):
                self._evsinz_array[idx, jdx0] = self.evsinz[jdx0]
        if self._evpo_diskflag:
            fwrite(&self.evpo[0], 8, self._evpo_length, self._evpo_file)
        elif self._evpo_ramflag:
            for jdx0 in range(self._evpo_length_0):
                self._evpo_array[idx, jdx0] = self.evpo[jdx0]
        if self._evi_diskflag:
            fwrite(&self.evi[0], 8, self._evi_length, self._evi_file)
        elif self._evi_ramflag:
            for jdx0 in range(self._evi_length_0):
                self._evi_array[idx, jdx0] = self.evi[jdx0]
        if self._evb_diskflag:
            fwrite(&self.evb[0], 8, self._evb_length, self._evb_file)
        elif self._evb_ramflag:
            for jdx0 in range(self._evb_length_0):
                self._evb_array[idx, jdx0] = self.evb[jdx0]
        if self._evs_diskflag:
            fwrite(&self.evs[0], 8, self._evs_length, self._evs_file)
        elif self._evs_ramflag:
            for jdx0 in range(self._evs_length_0):
                self._evs_array[idx, jdx0] = self.evs[jdx0]
        if self._wnied_diskflag:
            fwrite(&self.wnied[0], 8, self._wnied_length, self._wnied_file)
        elif self._wnied_ramflag:
            for jdx0 in range(self._wnied_length_0):
                self._wnied_array[idx, jdx0] = self.wnied[jdx0]
        if self._tempssurface_diskflag:
            fwrite(&self.tempssurface[0], 8, self._tempssurface_length, self._tempssurface_file)
        elif self._tempssurface_ramflag:
            for jdx0 in range(self._tempssurface_length_0):
                self._tempssurface_array[idx, jdx0] = self.tempssurface[jdx0]
        if self._actualalbedo_diskflag:
            fwrite(&self.actualalbedo[0], 8, self._actualalbedo_length, self._actualalbedo_file)
        elif self._actualalbedo_ramflag:
            for jdx0 in range(self._actualalbedo_length_0):
                self._actualalbedo_array[idx, jdx0] = self.actualalbedo[jdx0]
        if self._schmpot_diskflag:
            fwrite(&self.schmpot[0], 8, self._schmpot_length, self._schmpot_file)
        elif self._schmpot_ramflag:
            for jdx0 in range(self._schmpot_length_0):
                self._schmpot_array[idx, jdx0] = self.schmpot[jdx0]
        if self._schm_diskflag:
            fwrite(&self.schm[0], 8, self._schm_length, self._schm_file)
        elif self._schm_ramflag:
            for jdx0 in range(self._schm_length_0):
                self._schm_array[idx, jdx0] = self.schm[jdx0]
        if self._gefrpot_diskflag:
            fwrite(&self.gefrpot[0], 8, self._gefrpot_length, self._gefrpot_file)
        elif self._gefrpot_ramflag:
            for jdx0 in range(self._gefrpot_length_0):
                self._gefrpot_array[idx, jdx0] = self.gefrpot[jdx0]
        if self._gefr_diskflag:
            fwrite(&self.gefr[0], 8, self._gefr_length, self._gefr_file)
        elif self._gefr_ramflag:
            for jdx0 in range(self._gefr_length_0):
                self._gefr_array[idx, jdx0] = self.gefr[jdx0]
        if self._wlatinz_diskflag:
            fwrite(&self.wlatinz[0], 8, self._wlatinz_length, self._wlatinz_file)
        elif self._wlatinz_ramflag:
            for jdx0 in range(self._wlatinz_length_0):
                self._wlatinz_array[idx, jdx0] = self.wlatinz[jdx0]
        if self._wlatsnow_diskflag:
            fwrite(&self.wlatsnow[0], 8, self._wlatsnow_length, self._wlatsnow_file)
        elif self._wlatsnow_ramflag:
            for jdx0 in range(self._wlatsnow_length_0):
                self._wlatsnow_array[idx, jdx0] = self.wlatsnow[jdx0]
        if self._wsensinz_diskflag:
            fwrite(&self.wsensinz[0], 8, self._wsensinz_length, self._wsensinz_file)
        elif self._wsensinz_ramflag:
            for jdx0 in range(self._wsensinz_length_0):
                self._wsensinz_array[idx, jdx0] = self.wsensinz[jdx0]
        if self._wsenssnow_diskflag:
            fwrite(&self.wsenssnow[0], 8, self._wsenssnow_length, self._wsenssnow_file)
        elif self._wsenssnow_ramflag:
            for jdx0 in range(self._wsenssnow_length_0):
                self._wsenssnow_array[idx, jdx0] = self.wsenssnow[jdx0]
        if self._wsurfinz_diskflag:
            fwrite(&self.wsurfinz[0], 8, self._wsurfinz_length, self._wsurfinz_file)
        elif self._wsurfinz_ramflag:
            for jdx0 in range(self._wsurfinz_length_0):
                self._wsurfinz_array[idx, jdx0] = self.wsurfinz[jdx0]
        if self._wsurf_diskflag:
            fwrite(&self.wsurf[0], 8, self._wsurf_length, self._wsurf_file)
        elif self._wsurf_ramflag:
            for jdx0 in range(self._wsurf_length_0):
                self._wsurf_array[idx, jdx0] = self.wsurf[jdx0]
        if self._sff_diskflag:
            fwrite(&self.sff[0], 8, self._sff_length, self._sff_file)
        elif self._sff_ramflag:
            for jdx0 in range(self._sff_length_0):
                self._sff_array[idx, jdx0] = self.sff[jdx0]
        if self._fvg_diskflag:
            fwrite(&self.fvg[0], 8, self._fvg_length, self._fvg_file)
        elif self._fvg_ramflag:
            for jdx0 in range(self._fvg_length_0):
                self._fvg_array[idx, jdx0] = self.fvg[jdx0]
        if self._wada_diskflag:
            fwrite(&self.wada[0], 8, self._wada_length, self._wada_file)
        elif self._wada_ramflag:
            for jdx0 in range(self._wada_length_0):
                self._wada_array[idx, jdx0] = self.wada[jdx0]
        if self._qdb_diskflag:
            fwrite(&self.qdb[0], 8, self._qdb_length, self._qdb_file)
        elif self._qdb_ramflag:
            for jdx0 in range(self._qdb_length_0):
                self._qdb_array[idx, jdx0] = self.qdb[jdx0]
        if self._qib1_diskflag:
            fwrite(&self.qib1[0], 8, self._qib1_length, self._qib1_file)
        elif self._qib1_ramflag:
            for jdx0 in range(self._qib1_length_0):
                self._qib1_array[idx, jdx0] = self.qib1[jdx0]
        if self._qib2_diskflag:
            fwrite(&self.qib2[0], 8, self._qib2_length, self._qib2_file)
        elif self._qib2_ramflag:
            for jdx0 in range(self._qib2_length_0):
                self._qib2_array[idx, jdx0] = self.qib2[jdx0]
        if self._qbb_diskflag:
            fwrite(&self.qbb[0], 8, self._qbb_length, self._qbb_file)
        elif self._qbb_ramflag:
            for jdx0 in range(self._qbb_length_0):
                self._qbb_array[idx, jdx0] = self.qbb[jdx0]
        if self._qkap_diskflag:
            fwrite(&self.qkap[0], 8, self._qkap_length, self._qkap_file)
        elif self._qkap_ramflag:
            for jdx0 in range(self._qkap_length_0):
                self._qkap_array[idx, jdx0] = self.qkap[jdx0]
        if self._qdgz_diskflag:
            fwrite(&self.qdgz, 8, 1, self._qdgz_file)
        elif self._qdgz_ramflag:
            self._qdgz_array[idx] = self.qdgz
        if self._qah_diskflag:
            fwrite(&self.qah, 8, 1, self._qah_file)
        elif self._qah_ramflag:
            self._qah_array[idx] = self.qah
        if self._qa_diskflag:
            fwrite(&self.qa, 8, 1, self._qa_file)
        elif self._qa_ramflag:
            self._qa_array[idx] = self.qa
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value):
        if name == "qz":
            self._qz_outputpointer = value.p_value
        if name == "qzh":
            self._qzh_outputpointer = value.p_value
        if name == "temltag":
            self._temltag_outputpointer = value.p_value
        if name == "dailyrelativehumidity":
            self._dailyrelativehumidity_outputpointer = value.p_value
        if name == "dailysunshineduration":
            self._dailysunshineduration_outputpointer = value.p_value
        if name == "windspeed2m":
            self._windspeed2m_outputpointer = value.p_value
        if name == "dailywindspeed2m":
            self._dailywindspeed2m_outputpointer = value.p_value
        if name == "windspeed10m":
            self._windspeed10m_outputpointer = value.p_value
        if name == "solardeclination":
            self._solardeclination_outputpointer = value.p_value
        if name == "tsa":
            self._tsa_outputpointer = value.p_value
        if name == "tsu":
            self._tsu_outputpointer = value.p_value
        if name == "earthsundistance":
            self._earthsundistance_outputpointer = value.p_value
        if name == "extraterrestrialradiation":
            self._extraterrestrialradiation_outputpointer = value.p_value
        if name == "possiblesunshineduration":
            self._possiblesunshineduration_outputpointer = value.p_value
        if name == "dailypossiblesunshineduration":
            self._dailypossiblesunshineduration_outputpointer = value.p_value
        if name == "dailyglobalradiation":
            self._dailyglobalradiation_outputpointer = value.p_value
        if name == "sp":
            self._sp_outputpointer = value.p_value
        if name == "globalradiation":
            self._globalradiation_outputpointer = value.p_value
        if name == "adjustedglobalradiation":
            self._adjustedglobalradiation_outputpointer = value.p_value
        if name == "qdgz":
            self._qdgz_outputpointer = value.p_value
        if name == "qah":
            self._qah_outputpointer = value.p_value
        if name == "qa":
            self._qa_outputpointer = value.p_value
    cpdef inline void update_outputs(self) nogil:
        if self._qz_outputflag:
            self._qz_outputpointer[0] = self.qz
        if self._qzh_outputflag:
            self._qzh_outputpointer[0] = self.qzh
        if self._temltag_outputflag:
            self._temltag_outputpointer[0] = self.temltag
        if self._dailyrelativehumidity_outputflag:
            self._dailyrelativehumidity_outputpointer[0] = self.dailyrelativehumidity
        if self._dailysunshineduration_outputflag:
            self._dailysunshineduration_outputpointer[0] = self.dailysunshineduration
        if self._windspeed2m_outputflag:
            self._windspeed2m_outputpointer[0] = self.windspeed2m
        if self._dailywindspeed2m_outputflag:
            self._dailywindspeed2m_outputpointer[0] = self.dailywindspeed2m
        if self._windspeed10m_outputflag:
            self._windspeed10m_outputpointer[0] = self.windspeed10m
        if self._solardeclination_outputflag:
            self._solardeclination_outputpointer[0] = self.solardeclination
        if self._tsa_outputflag:
            self._tsa_outputpointer[0] = self.tsa
        if self._tsu_outputflag:
            self._tsu_outputpointer[0] = self.tsu
        if self._earthsundistance_outputflag:
            self._earthsundistance_outputpointer[0] = self.earthsundistance
        if self._extraterrestrialradiation_outputflag:
            self._extraterrestrialradiation_outputpointer[0] = self.extraterrestrialradiation
        if self._possiblesunshineduration_outputflag:
            self._possiblesunshineduration_outputpointer[0] = self.possiblesunshineduration
        if self._dailypossiblesunshineduration_outputflag:
            self._dailypossiblesunshineduration_outputpointer[0] = self.dailypossiblesunshineduration
        if self._dailyglobalradiation_outputflag:
            self._dailyglobalradiation_outputpointer[0] = self.dailyglobalradiation
        if self._sp_outputflag:
            self._sp_outputpointer[0] = self.sp
        if self._globalradiation_outputflag:
            self._globalradiation_outputpointer[0] = self.globalradiation
        if self._adjustedglobalradiation_outputflag:
            self._adjustedglobalradiation_outputpointer[0] = self.adjustedglobalradiation
        if self._qdgz_outputflag:
            self._qdgz_outputpointer[0] = self.qdgz
        if self._qah_outputflag:
            self._qah_outputpointer[0] = self.qah
        if self._qa_outputflag:
            self._qa_outputpointer[0] = self.qa
@cython.final
cdef class StateSequences:
    cdef public double[:] inzp
    cdef public int _inzp_ndim
    cdef public int _inzp_length
    cdef public int _inzp_length_0
    cdef public bint _inzp_diskflag
    cdef public str _inzp_path
    cdef FILE *_inzp_file
    cdef public bint _inzp_ramflag
    cdef public double[:,:] _inzp_array
    cdef public bint _inzp_outputflag
    cdef double *_inzp_outputpointer
    cdef public double[:] stinz
    cdef public int _stinz_ndim
    cdef public int _stinz_length
    cdef public int _stinz_length_0
    cdef public bint _stinz_diskflag
    cdef public str _stinz_path
    cdef FILE *_stinz_file
    cdef public bint _stinz_ramflag
    cdef public double[:,:] _stinz_array
    cdef public bint _stinz_outputflag
    cdef double *_stinz_outputpointer
    cdef public double[:] sinz
    cdef public int _sinz_ndim
    cdef public int _sinz_length
    cdef public int _sinz_length_0
    cdef public bint _sinz_diskflag
    cdef public str _sinz_path
    cdef FILE *_sinz_file
    cdef public bint _sinz_ramflag
    cdef public double[:,:] _sinz_array
    cdef public bint _sinz_outputflag
    cdef double *_sinz_outputpointer
    cdef public double[:] esnowinz
    cdef public int _esnowinz_ndim
    cdef public int _esnowinz_length
    cdef public int _esnowinz_length_0
    cdef public bint _esnowinz_diskflag
    cdef public str _esnowinz_path
    cdef FILE *_esnowinz_file
    cdef public bint _esnowinz_ramflag
    cdef public double[:,:] _esnowinz_array
    cdef public bint _esnowinz_outputflag
    cdef double *_esnowinz_outputpointer
    cdef public double[:] asinz
    cdef public int _asinz_ndim
    cdef public int _asinz_length
    cdef public int _asinz_length_0
    cdef public bint _asinz_diskflag
    cdef public str _asinz_path
    cdef FILE *_asinz_file
    cdef public bint _asinz_ramflag
    cdef public double[:,:] _asinz_array
    cdef public bint _asinz_outputflag
    cdef double *_asinz_outputpointer
    cdef public double[:] wats
    cdef public int _wats_ndim
    cdef public int _wats_length
    cdef public int _wats_length_0
    cdef public bint _wats_diskflag
    cdef public str _wats_path
    cdef FILE *_wats_file
    cdef public bint _wats_ramflag
    cdef public double[:,:] _wats_array
    cdef public bint _wats_outputflag
    cdef double *_wats_outputpointer
    cdef public double[:] waes
    cdef public int _waes_ndim
    cdef public int _waes_length
    cdef public int _waes_length_0
    cdef public bint _waes_diskflag
    cdef public str _waes_path
    cdef FILE *_waes_file
    cdef public bint _waes_ramflag
    cdef public double[:,:] _waes_array
    cdef public bint _waes_outputflag
    cdef double *_waes_outputpointer
    cdef public double[:] esnow
    cdef public int _esnow_ndim
    cdef public int _esnow_length
    cdef public int _esnow_length_0
    cdef public bint _esnow_diskflag
    cdef public str _esnow_path
    cdef FILE *_esnow_file
    cdef public bint _esnow_ramflag
    cdef public double[:,:] _esnow_array
    cdef public bint _esnow_outputflag
    cdef double *_esnow_outputpointer
    cdef public double[:] taus
    cdef public int _taus_ndim
    cdef public int _taus_length
    cdef public int _taus_length_0
    cdef public bint _taus_diskflag
    cdef public str _taus_path
    cdef FILE *_taus_file
    cdef public bint _taus_ramflag
    cdef public double[:,:] _taus_array
    cdef public bint _taus_outputflag
    cdef double *_taus_outputpointer
    cdef public double[:] ebdn
    cdef public int _ebdn_ndim
    cdef public int _ebdn_length
    cdef public int _ebdn_length_0
    cdef public bint _ebdn_diskflag
    cdef public str _ebdn_path
    cdef FILE *_ebdn_file
    cdef public bint _ebdn_ramflag
    cdef public double[:,:] _ebdn_array
    cdef public bint _ebdn_outputflag
    cdef double *_ebdn_outputpointer
    cdef public double[:] bowa
    cdef public int _bowa_ndim
    cdef public int _bowa_length
    cdef public int _bowa_length_0
    cdef public bint _bowa_diskflag
    cdef public str _bowa_path
    cdef FILE *_bowa_file
    cdef public bint _bowa_ramflag
    cdef public double[:,:] _bowa_array
    cdef public bint _bowa_outputflag
    cdef double *_bowa_outputpointer
    cdef public double qdgz1
    cdef public int _qdgz1_ndim
    cdef public int _qdgz1_length
    cdef public bint _qdgz1_diskflag
    cdef public str _qdgz1_path
    cdef FILE *_qdgz1_file
    cdef public bint _qdgz1_ramflag
    cdef public double[:] _qdgz1_array
    cdef public bint _qdgz1_outputflag
    cdef double *_qdgz1_outputpointer
    cdef public double qdgz2
    cdef public int _qdgz2_ndim
    cdef public int _qdgz2_length
    cdef public bint _qdgz2_diskflag
    cdef public str _qdgz2_path
    cdef FILE *_qdgz2_file
    cdef public bint _qdgz2_ramflag
    cdef public double[:] _qdgz2_array
    cdef public bint _qdgz2_outputflag
    cdef double *_qdgz2_outputpointer
    cdef public double qigz1
    cdef public int _qigz1_ndim
    cdef public int _qigz1_length
    cdef public bint _qigz1_diskflag
    cdef public str _qigz1_path
    cdef FILE *_qigz1_file
    cdef public bint _qigz1_ramflag
    cdef public double[:] _qigz1_array
    cdef public bint _qigz1_outputflag
    cdef double *_qigz1_outputpointer
    cdef public double qigz2
    cdef public int _qigz2_ndim
    cdef public int _qigz2_length
    cdef public bint _qigz2_diskflag
    cdef public str _qigz2_path
    cdef FILE *_qigz2_file
    cdef public bint _qigz2_ramflag
    cdef public double[:] _qigz2_array
    cdef public bint _qigz2_outputflag
    cdef double *_qigz2_outputpointer
    cdef public double qbgz
    cdef public int _qbgz_ndim
    cdef public int _qbgz_length
    cdef public bint _qbgz_diskflag
    cdef public str _qbgz_path
    cdef FILE *_qbgz_file
    cdef public bint _qbgz_ramflag
    cdef public double[:] _qbgz_array
    cdef public bint _qbgz_outputflag
    cdef double *_qbgz_outputpointer
    cdef public double qdga1
    cdef public int _qdga1_ndim
    cdef public int _qdga1_length
    cdef public bint _qdga1_diskflag
    cdef public str _qdga1_path
    cdef FILE *_qdga1_file
    cdef public bint _qdga1_ramflag
    cdef public double[:] _qdga1_array
    cdef public bint _qdga1_outputflag
    cdef double *_qdga1_outputpointer
    cdef public double qdga2
    cdef public int _qdga2_ndim
    cdef public int _qdga2_length
    cdef public bint _qdga2_diskflag
    cdef public str _qdga2_path
    cdef FILE *_qdga2_file
    cdef public bint _qdga2_ramflag
    cdef public double[:] _qdga2_array
    cdef public bint _qdga2_outputflag
    cdef double *_qdga2_outputpointer
    cdef public double qiga1
    cdef public int _qiga1_ndim
    cdef public int _qiga1_length
    cdef public bint _qiga1_diskflag
    cdef public str _qiga1_path
    cdef FILE *_qiga1_file
    cdef public bint _qiga1_ramflag
    cdef public double[:] _qiga1_array
    cdef public bint _qiga1_outputflag
    cdef double *_qiga1_outputpointer
    cdef public double qiga2
    cdef public int _qiga2_ndim
    cdef public int _qiga2_length
    cdef public bint _qiga2_diskflag
    cdef public str _qiga2_path
    cdef FILE *_qiga2_file
    cdef public bint _qiga2_ramflag
    cdef public double[:] _qiga2_array
    cdef public bint _qiga2_outputflag
    cdef double *_qiga2_outputpointer
    cdef public double qbga
    cdef public int _qbga_ndim
    cdef public int _qbga_length
    cdef public bint _qbga_diskflag
    cdef public str _qbga_path
    cdef FILE *_qbga_file
    cdef public bint _qbga_ramflag
    cdef public double[:] _qbga_array
    cdef public bint _qbga_outputflag
    cdef double *_qbga_outputpointer
    cpdef open_files(self, int idx):
        if self._inzp_diskflag:
            self._inzp_file = fopen(str(self._inzp_path).encode(), "rb+")
            fseek(self._inzp_file, idx*self._inzp_length*8, SEEK_SET)
        if self._stinz_diskflag:
            self._stinz_file = fopen(str(self._stinz_path).encode(), "rb+")
            fseek(self._stinz_file, idx*self._stinz_length*8, SEEK_SET)
        if self._sinz_diskflag:
            self._sinz_file = fopen(str(self._sinz_path).encode(), "rb+")
            fseek(self._sinz_file, idx*self._sinz_length*8, SEEK_SET)
        if self._esnowinz_diskflag:
            self._esnowinz_file = fopen(str(self._esnowinz_path).encode(), "rb+")
            fseek(self._esnowinz_file, idx*self._esnowinz_length*8, SEEK_SET)
        if self._asinz_diskflag:
            self._asinz_file = fopen(str(self._asinz_path).encode(), "rb+")
            fseek(self._asinz_file, idx*self._asinz_length*8, SEEK_SET)
        if self._wats_diskflag:
            self._wats_file = fopen(str(self._wats_path).encode(), "rb+")
            fseek(self._wats_file, idx*self._wats_length*8, SEEK_SET)
        if self._waes_diskflag:
            self._waes_file = fopen(str(self._waes_path).encode(), "rb+")
            fseek(self._waes_file, idx*self._waes_length*8, SEEK_SET)
        if self._esnow_diskflag:
            self._esnow_file = fopen(str(self._esnow_path).encode(), "rb+")
            fseek(self._esnow_file, idx*self._esnow_length*8, SEEK_SET)
        if self._taus_diskflag:
            self._taus_file = fopen(str(self._taus_path).encode(), "rb+")
            fseek(self._taus_file, idx*self._taus_length*8, SEEK_SET)
        if self._ebdn_diskflag:
            self._ebdn_file = fopen(str(self._ebdn_path).encode(), "rb+")
            fseek(self._ebdn_file, idx*self._ebdn_length*8, SEEK_SET)
        if self._bowa_diskflag:
            self._bowa_file = fopen(str(self._bowa_path).encode(), "rb+")
            fseek(self._bowa_file, idx*self._bowa_length*8, SEEK_SET)
        if self._qdgz1_diskflag:
            self._qdgz1_file = fopen(str(self._qdgz1_path).encode(), "rb+")
            fseek(self._qdgz1_file, idx*8, SEEK_SET)
        if self._qdgz2_diskflag:
            self._qdgz2_file = fopen(str(self._qdgz2_path).encode(), "rb+")
            fseek(self._qdgz2_file, idx*8, SEEK_SET)
        if self._qigz1_diskflag:
            self._qigz1_file = fopen(str(self._qigz1_path).encode(), "rb+")
            fseek(self._qigz1_file, idx*8, SEEK_SET)
        if self._qigz2_diskflag:
            self._qigz2_file = fopen(str(self._qigz2_path).encode(), "rb+")
            fseek(self._qigz2_file, idx*8, SEEK_SET)
        if self._qbgz_diskflag:
            self._qbgz_file = fopen(str(self._qbgz_path).encode(), "rb+")
            fseek(self._qbgz_file, idx*8, SEEK_SET)
        if self._qdga1_diskflag:
            self._qdga1_file = fopen(str(self._qdga1_path).encode(), "rb+")
            fseek(self._qdga1_file, idx*8, SEEK_SET)
        if self._qdga2_diskflag:
            self._qdga2_file = fopen(str(self._qdga2_path).encode(), "rb+")
            fseek(self._qdga2_file, idx*8, SEEK_SET)
        if self._qiga1_diskflag:
            self._qiga1_file = fopen(str(self._qiga1_path).encode(), "rb+")
            fseek(self._qiga1_file, idx*8, SEEK_SET)
        if self._qiga2_diskflag:
            self._qiga2_file = fopen(str(self._qiga2_path).encode(), "rb+")
            fseek(self._qiga2_file, idx*8, SEEK_SET)
        if self._qbga_diskflag:
            self._qbga_file = fopen(str(self._qbga_path).encode(), "rb+")
            fseek(self._qbga_file, idx*8, SEEK_SET)
    cpdef inline close_files(self):
        if self._inzp_diskflag:
            fclose(self._inzp_file)
        if self._stinz_diskflag:
            fclose(self._stinz_file)
        if self._sinz_diskflag:
            fclose(self._sinz_file)
        if self._esnowinz_diskflag:
            fclose(self._esnowinz_file)
        if self._asinz_diskflag:
            fclose(self._asinz_file)
        if self._wats_diskflag:
            fclose(self._wats_file)
        if self._waes_diskflag:
            fclose(self._waes_file)
        if self._esnow_diskflag:
            fclose(self._esnow_file)
        if self._taus_diskflag:
            fclose(self._taus_file)
        if self._ebdn_diskflag:
            fclose(self._ebdn_file)
        if self._bowa_diskflag:
            fclose(self._bowa_file)
        if self._qdgz1_diskflag:
            fclose(self._qdgz1_file)
        if self._qdgz2_diskflag:
            fclose(self._qdgz2_file)
        if self._qigz1_diskflag:
            fclose(self._qigz1_file)
        if self._qigz2_diskflag:
            fclose(self._qigz2_file)
        if self._qbgz_diskflag:
            fclose(self._qbgz_file)
        if self._qdga1_diskflag:
            fclose(self._qdga1_file)
        if self._qdga2_diskflag:
            fclose(self._qdga2_file)
        if self._qiga1_diskflag:
            fclose(self._qiga1_file)
        if self._qiga2_diskflag:
            fclose(self._qiga2_file)
        if self._qbga_diskflag:
            fclose(self._qbga_file)
    cpdef inline void load_data(self, int idx)  nogil:
        cdef int jdx0, jdx1, jdx2, jdx3, jdx4, jdx5
        if self._inzp_diskflag:
            fread(&self.inzp[0], 8, self._inzp_length, self._inzp_file)
        elif self._inzp_ramflag:
            for jdx0 in range(self._inzp_length_0):
                self.inzp[jdx0] = self._inzp_array[idx, jdx0]
        if self._stinz_diskflag:
            fread(&self.stinz[0], 8, self._stinz_length, self._stinz_file)
        elif self._stinz_ramflag:
            for jdx0 in range(self._stinz_length_0):
                self.stinz[jdx0] = self._stinz_array[idx, jdx0]
        if self._sinz_diskflag:
            fread(&self.sinz[0], 8, self._sinz_length, self._sinz_file)
        elif self._sinz_ramflag:
            for jdx0 in range(self._sinz_length_0):
                self.sinz[jdx0] = self._sinz_array[idx, jdx0]
        if self._esnowinz_diskflag:
            fread(&self.esnowinz[0], 8, self._esnowinz_length, self._esnowinz_file)
        elif self._esnowinz_ramflag:
            for jdx0 in range(self._esnowinz_length_0):
                self.esnowinz[jdx0] = self._esnowinz_array[idx, jdx0]
        if self._asinz_diskflag:
            fread(&self.asinz[0], 8, self._asinz_length, self._asinz_file)
        elif self._asinz_ramflag:
            for jdx0 in range(self._asinz_length_0):
                self.asinz[jdx0] = self._asinz_array[idx, jdx0]
        if self._wats_diskflag:
            fread(&self.wats[0], 8, self._wats_length, self._wats_file)
        elif self._wats_ramflag:
            for jdx0 in range(self._wats_length_0):
                self.wats[jdx0] = self._wats_array[idx, jdx0]
        if self._waes_diskflag:
            fread(&self.waes[0], 8, self._waes_length, self._waes_file)
        elif self._waes_ramflag:
            for jdx0 in range(self._waes_length_0):
                self.waes[jdx0] = self._waes_array[idx, jdx0]
        if self._esnow_diskflag:
            fread(&self.esnow[0], 8, self._esnow_length, self._esnow_file)
        elif self._esnow_ramflag:
            for jdx0 in range(self._esnow_length_0):
                self.esnow[jdx0] = self._esnow_array[idx, jdx0]
        if self._taus_diskflag:
            fread(&self.taus[0], 8, self._taus_length, self._taus_file)
        elif self._taus_ramflag:
            for jdx0 in range(self._taus_length_0):
                self.taus[jdx0] = self._taus_array[idx, jdx0]
        if self._ebdn_diskflag:
            fread(&self.ebdn[0], 8, self._ebdn_length, self._ebdn_file)
        elif self._ebdn_ramflag:
            for jdx0 in range(self._ebdn_length_0):
                self.ebdn[jdx0] = self._ebdn_array[idx, jdx0]
        if self._bowa_diskflag:
            fread(&self.bowa[0], 8, self._bowa_length, self._bowa_file)
        elif self._bowa_ramflag:
            for jdx0 in range(self._bowa_length_0):
                self.bowa[jdx0] = self._bowa_array[idx, jdx0]
        if self._qdgz1_diskflag:
            fread(&self.qdgz1, 8, 1, self._qdgz1_file)
        elif self._qdgz1_ramflag:
            self.qdgz1 = self._qdgz1_array[idx]
        if self._qdgz2_diskflag:
            fread(&self.qdgz2, 8, 1, self._qdgz2_file)
        elif self._qdgz2_ramflag:
            self.qdgz2 = self._qdgz2_array[idx]
        if self._qigz1_diskflag:
            fread(&self.qigz1, 8, 1, self._qigz1_file)
        elif self._qigz1_ramflag:
            self.qigz1 = self._qigz1_array[idx]
        if self._qigz2_diskflag:
            fread(&self.qigz2, 8, 1, self._qigz2_file)
        elif self._qigz2_ramflag:
            self.qigz2 = self._qigz2_array[idx]
        if self._qbgz_diskflag:
            fread(&self.qbgz, 8, 1, self._qbgz_file)
        elif self._qbgz_ramflag:
            self.qbgz = self._qbgz_array[idx]
        if self._qdga1_diskflag:
            fread(&self.qdga1, 8, 1, self._qdga1_file)
        elif self._qdga1_ramflag:
            self.qdga1 = self._qdga1_array[idx]
        if self._qdga2_diskflag:
            fread(&self.qdga2, 8, 1, self._qdga2_file)
        elif self._qdga2_ramflag:
            self.qdga2 = self._qdga2_array[idx]
        if self._qiga1_diskflag:
            fread(&self.qiga1, 8, 1, self._qiga1_file)
        elif self._qiga1_ramflag:
            self.qiga1 = self._qiga1_array[idx]
        if self._qiga2_diskflag:
            fread(&self.qiga2, 8, 1, self._qiga2_file)
        elif self._qiga2_ramflag:
            self.qiga2 = self._qiga2_array[idx]
        if self._qbga_diskflag:
            fread(&self.qbga, 8, 1, self._qbga_file)
        elif self._qbga_ramflag:
            self.qbga = self._qbga_array[idx]
    cpdef inline void save_data(self, int idx)  nogil:
        cdef int jdx0, jdx1, jdx2, jdx3, jdx4, jdx5
        if self._inzp_diskflag:
            fwrite(&self.inzp[0], 8, self._inzp_length, self._inzp_file)
        elif self._inzp_ramflag:
            for jdx0 in range(self._inzp_length_0):
                self._inzp_array[idx, jdx0] = self.inzp[jdx0]
        if self._stinz_diskflag:
            fwrite(&self.stinz[0], 8, self._stinz_length, self._stinz_file)
        elif self._stinz_ramflag:
            for jdx0 in range(self._stinz_length_0):
                self._stinz_array[idx, jdx0] = self.stinz[jdx0]
        if self._sinz_diskflag:
            fwrite(&self.sinz[0], 8, self._sinz_length, self._sinz_file)
        elif self._sinz_ramflag:
            for jdx0 in range(self._sinz_length_0):
                self._sinz_array[idx, jdx0] = self.sinz[jdx0]
        if self._esnowinz_diskflag:
            fwrite(&self.esnowinz[0], 8, self._esnowinz_length, self._esnowinz_file)
        elif self._esnowinz_ramflag:
            for jdx0 in range(self._esnowinz_length_0):
                self._esnowinz_array[idx, jdx0] = self.esnowinz[jdx0]
        if self._asinz_diskflag:
            fwrite(&self.asinz[0], 8, self._asinz_length, self._asinz_file)
        elif self._asinz_ramflag:
            for jdx0 in range(self._asinz_length_0):
                self._asinz_array[idx, jdx0] = self.asinz[jdx0]
        if self._wats_diskflag:
            fwrite(&self.wats[0], 8, self._wats_length, self._wats_file)
        elif self._wats_ramflag:
            for jdx0 in range(self._wats_length_0):
                self._wats_array[idx, jdx0] = self.wats[jdx0]
        if self._waes_diskflag:
            fwrite(&self.waes[0], 8, self._waes_length, self._waes_file)
        elif self._waes_ramflag:
            for jdx0 in range(self._waes_length_0):
                self._waes_array[idx, jdx0] = self.waes[jdx0]
        if self._esnow_diskflag:
            fwrite(&self.esnow[0], 8, self._esnow_length, self._esnow_file)
        elif self._esnow_ramflag:
            for jdx0 in range(self._esnow_length_0):
                self._esnow_array[idx, jdx0] = self.esnow[jdx0]
        if self._taus_diskflag:
            fwrite(&self.taus[0], 8, self._taus_length, self._taus_file)
        elif self._taus_ramflag:
            for jdx0 in range(self._taus_length_0):
                self._taus_array[idx, jdx0] = self.taus[jdx0]
        if self._ebdn_diskflag:
            fwrite(&self.ebdn[0], 8, self._ebdn_length, self._ebdn_file)
        elif self._ebdn_ramflag:
            for jdx0 in range(self._ebdn_length_0):
                self._ebdn_array[idx, jdx0] = self.ebdn[jdx0]
        if self._bowa_diskflag:
            fwrite(&self.bowa[0], 8, self._bowa_length, self._bowa_file)
        elif self._bowa_ramflag:
            for jdx0 in range(self._bowa_length_0):
                self._bowa_array[idx, jdx0] = self.bowa[jdx0]
        if self._qdgz1_diskflag:
            fwrite(&self.qdgz1, 8, 1, self._qdgz1_file)
        elif self._qdgz1_ramflag:
            self._qdgz1_array[idx] = self.qdgz1
        if self._qdgz2_diskflag:
            fwrite(&self.qdgz2, 8, 1, self._qdgz2_file)
        elif self._qdgz2_ramflag:
            self._qdgz2_array[idx] = self.qdgz2
        if self._qigz1_diskflag:
            fwrite(&self.qigz1, 8, 1, self._qigz1_file)
        elif self._qigz1_ramflag:
            self._qigz1_array[idx] = self.qigz1
        if self._qigz2_diskflag:
            fwrite(&self.qigz2, 8, 1, self._qigz2_file)
        elif self._qigz2_ramflag:
            self._qigz2_array[idx] = self.qigz2
        if self._qbgz_diskflag:
            fwrite(&self.qbgz, 8, 1, self._qbgz_file)
        elif self._qbgz_ramflag:
            self._qbgz_array[idx] = self.qbgz
        if self._qdga1_diskflag:
            fwrite(&self.qdga1, 8, 1, self._qdga1_file)
        elif self._qdga1_ramflag:
            self._qdga1_array[idx] = self.qdga1
        if self._qdga2_diskflag:
            fwrite(&self.qdga2, 8, 1, self._qdga2_file)
        elif self._qdga2_ramflag:
            self._qdga2_array[idx] = self.qdga2
        if self._qiga1_diskflag:
            fwrite(&self.qiga1, 8, 1, self._qiga1_file)
        elif self._qiga1_ramflag:
            self._qiga1_array[idx] = self.qiga1
        if self._qiga2_diskflag:
            fwrite(&self.qiga2, 8, 1, self._qiga2_file)
        elif self._qiga2_ramflag:
            self._qiga2_array[idx] = self.qiga2
        if self._qbga_diskflag:
            fwrite(&self.qbga, 8, 1, self._qbga_file)
        elif self._qbga_ramflag:
            self._qbga_array[idx] = self.qbga
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value):
        if name == "qdgz1":
            self._qdgz1_outputpointer = value.p_value
        if name == "qdgz2":
            self._qdgz2_outputpointer = value.p_value
        if name == "qigz1":
            self._qigz1_outputpointer = value.p_value
        if name == "qigz2":
            self._qigz2_outputpointer = value.p_value
        if name == "qbgz":
            self._qbgz_outputpointer = value.p_value
        if name == "qdga1":
            self._qdga1_outputpointer = value.p_value
        if name == "qdga2":
            self._qdga2_outputpointer = value.p_value
        if name == "qiga1":
            self._qiga1_outputpointer = value.p_value
        if name == "qiga2":
            self._qiga2_outputpointer = value.p_value
        if name == "qbga":
            self._qbga_outputpointer = value.p_value
    cpdef inline void update_outputs(self) nogil:
        if self._qdgz1_outputflag:
            self._qdgz1_outputpointer[0] = self.qdgz1
        if self._qdgz2_outputflag:
            self._qdgz2_outputpointer[0] = self.qdgz2
        if self._qigz1_outputflag:
            self._qigz1_outputpointer[0] = self.qigz1
        if self._qigz2_outputflag:
            self._qigz2_outputpointer[0] = self.qigz2
        if self._qbgz_outputflag:
            self._qbgz_outputpointer[0] = self.qbgz
        if self._qdga1_outputflag:
            self._qdga1_outputpointer[0] = self.qdga1
        if self._qdga2_outputflag:
            self._qdga2_outputpointer[0] = self.qdga2
        if self._qiga1_outputflag:
            self._qiga1_outputpointer[0] = self.qiga1
        if self._qiga2_outputflag:
            self._qiga2_outputpointer[0] = self.qiga2
        if self._qbga_outputflag:
            self._qbga_outputpointer[0] = self.qbga
@cython.final
cdef class LogSequences:
    cdef public double[:] loggedteml
    cdef public int _loggedteml_ndim
    cdef public int _loggedteml_length
    cdef public int _loggedteml_length_0
    cdef public double[:] loggedrelativehumidity
    cdef public int _loggedrelativehumidity_ndim
    cdef public int _loggedrelativehumidity_length
    cdef public int _loggedrelativehumidity_length_0
    cdef public double[:] loggedsunshineduration
    cdef public int _loggedsunshineduration_ndim
    cdef public int _loggedsunshineduration_length
    cdef public int _loggedsunshineduration_length_0
    cdef public double[:] loggedglobalradiation
    cdef public int _loggedglobalradiation_ndim
    cdef public int _loggedglobalradiation_length
    cdef public int _loggedglobalradiation_length_0
    cdef public double[:] loggedwindspeed2m
    cdef public int _loggedwindspeed2m_ndim
    cdef public int _loggedwindspeed2m_length
    cdef public int _loggedwindspeed2m_length_0
@cython.final
cdef class AideSequences:
    cdef public double[:] snratio
    cdef public int _snratio_ndim
    cdef public int _snratio_length
    cdef public int _snratio_length_0
    cdef public double[:] rlatm
    cdef public int _rlatm_ndim
    cdef public int _rlatm_length
    cdef public int _rlatm_length_0
    cdef public double[:] temps
    cdef public int _temps_ndim
    cdef public int _temps_length
    cdef public int _temps_length_0
    cdef public double[:] tempsinz
    cdef public int _tempsinz_ndim
    cdef public int _tempsinz_length
    cdef public int _tempsinz_length_0
@cython.final
cdef class OutletSequences:
    cdef double *q
    cdef public int _q_ndim
    cdef public int _q_length
    cpdef inline set_pointer0d(self, str name, pointerutils.Double value):
        cdef pointerutils.PDouble pointer = pointerutils.PDouble(value)
        if name == "q":
            self.q = pointer.p_value
    cpdef get_value(self, str name):
        cdef int idx
        if name == "q":
            return self.q[0]
    cpdef set_value(self, str name, value):
        if name == "q":
            self.q[0] = value

@cython.final
cdef class PegasusESnowInz(rootutils.PegasusBase):
    cpdef public Model model
    def __init__(self, Model model):
        self.model = model
    cpdef double apply_method0(self, double x) nogil:
        return self.model.return_backwardeulererrorinz_v1(x)
@cython.final
cdef class PegasusESnow(rootutils.PegasusBase):
    cpdef public Model model
    def __init__(self, Model model):
        self.model = model
    cpdef double apply_method0(self, double x) nogil:
        return self.model.return_backwardeulererror_v1(x)
@cython.final
cdef class PegasusTempSSurface(rootutils.PegasusBase):
    cpdef public Model model
    def __init__(self, Model model):
        self.model = model
    cpdef double apply_method0(self, double x) nogil:
        return self.model.return_energygainsnowsurface_v1(x)
@cython.final
cdef class Model:
    cdef public int idx_hru
    cdef public int idx_sim
    cdef public Parameters parameters
    cdef public Sequences sequences
    cdef public PegasusESnowInz pegasusesnowinz
    cdef public PegasusESnow pegasusesnow
    cdef public PegasusTempSSurface pegasustempssurface
    def __init__(self):
        self.pegasusesnowinz = PegasusESnowInz(self)
        self.pegasusesnow = PegasusESnow(self)
        self.pegasustempssurface = PegasusTempSSurface(self)
    cpdef inline void simulate(self, int idx)  nogil:
        self.idx_sim = idx
        self.load_data()
        self.update_inlets()
        self.run()
        self.new2old()
        self.update_outlets()
        self.update_outputs()
    cpdef inline void open_files(self):
        self.sequences.inputs.open_files(self.idx_sim)
        self.sequences.fluxes.open_files(self.idx_sim)
        self.sequences.states.open_files(self.idx_sim)
    cpdef inline void close_files(self):
        self.sequences.inputs.close_files()
        self.sequences.fluxes.close_files()
        self.sequences.states.close_files()
    cpdef inline void load_data(self) nogil:
        self.sequences.inputs.load_data(self.idx_sim)
    cpdef inline void save_data(self, int idx) nogil:
        self.sequences.inputs.save_data(self.idx_sim)
        self.sequences.fluxes.save_data(self.idx_sim)
        self.sequences.states.save_data(self.idx_sim)
    cpdef inline void new2old(self) nogil:
        cdef int jdx0, jdx1, jdx2, jdx3, jdx4, jdx5
        for jdx0 in range(self.sequences.states._inzp_length_0):
            self.sequences.old_states.inzp[jdx0] = self.sequences.new_states.inzp[jdx0]
        for jdx0 in range(self.sequences.states._stinz_length_0):
            self.sequences.old_states.stinz[jdx0] = self.sequences.new_states.stinz[jdx0]
        for jdx0 in range(self.sequences.states._sinz_length_0):
            self.sequences.old_states.sinz[jdx0] = self.sequences.new_states.sinz[jdx0]
        for jdx0 in range(self.sequences.states._esnowinz_length_0):
            self.sequences.old_states.esnowinz[jdx0] = self.sequences.new_states.esnowinz[jdx0]
        for jdx0 in range(self.sequences.states._asinz_length_0):
            self.sequences.old_states.asinz[jdx0] = self.sequences.new_states.asinz[jdx0]
        for jdx0 in range(self.sequences.states._wats_length_0):
            self.sequences.old_states.wats[jdx0] = self.sequences.new_states.wats[jdx0]
        for jdx0 in range(self.sequences.states._waes_length_0):
            self.sequences.old_states.waes[jdx0] = self.sequences.new_states.waes[jdx0]
        for jdx0 in range(self.sequences.states._esnow_length_0):
            self.sequences.old_states.esnow[jdx0] = self.sequences.new_states.esnow[jdx0]
        for jdx0 in range(self.sequences.states._taus_length_0):
            self.sequences.old_states.taus[jdx0] = self.sequences.new_states.taus[jdx0]
        for jdx0 in range(self.sequences.states._ebdn_length_0):
            self.sequences.old_states.ebdn[jdx0] = self.sequences.new_states.ebdn[jdx0]
        for jdx0 in range(self.sequences.states._bowa_length_0):
            self.sequences.old_states.bowa[jdx0] = self.sequences.new_states.bowa[jdx0]
        self.sequences.old_states.qdgz1 = self.sequences.new_states.qdgz1
        self.sequences.old_states.qdgz2 = self.sequences.new_states.qdgz2
        self.sequences.old_states.qigz1 = self.sequences.new_states.qigz1
        self.sequences.old_states.qigz2 = self.sequences.new_states.qigz2
        self.sequences.old_states.qbgz = self.sequences.new_states.qbgz
        self.sequences.old_states.qdga1 = self.sequences.new_states.qdga1
        self.sequences.old_states.qdga2 = self.sequences.new_states.qdga2
        self.sequences.old_states.qiga1 = self.sequences.new_states.qiga1
        self.sequences.old_states.qiga2 = self.sequences.new_states.qiga2
        self.sequences.old_states.qbga = self.sequences.new_states.qbga
    cpdef inline void run(self) nogil:
        self.calc_qzh_v1()
        self.update_loggedteml_v1()
        self.calc_temltag_v1()
        self.update_loggedrelativehumidity_v1()
        self.calc_dailyrelativehumidity_v1()
        self.update_loggedsunshineduration_v1()
        self.calc_nkor_v1()
        self.calc_tkor_v1()
        self.calc_tkortag_v1()
        self.calc_windspeed2m_v1()
        self.calc_reducedwindspeed2m_v1()
        self.update_loggedwindspeed2m_v1()
        self.calc_dailywindspeed2m_v1()
        self.calc_windspeed10m_v1()
        self.calc_solardeclination_v1()
        self.calc_tsa_tsu_v1()
        self.calc_dailysunshineduration_v1()
        self.calc_earthsundistance_v1()
        self.calc_extraterrestrialradiation_v1()
        self.calc_possiblesunshineduration_v1()
        self.calc_dailypossiblesunshineduration_v1()
        self.calc_sp_v1()
        self.calc_globalradiation_v1()
        self.update_loggedglobalradiation_v1()
        self.calc_dailyglobalradiation_v1()
        self.calc_adjustedglobalradiation_v1()
        self.calc_saturationvapourpressure_v1()
        self.calc_dailysaturationvapourpressure_v1()
        self.calc_saturationvapourpressureslope_v1()
        self.calc_dailysaturationvapourpressureslope_v1()
        self.calc_actualvapourpressure_v1()
        self.calc_dailyactualvapourpressure_v1()
        self.calc_nbes_inzp_v1()
        self.calc_snratio_v1()
        self.calc_sbes_v1()
        self.calc_snowintmax_v1()
        self.calc_snowintrate_v1()
        self.calc_nbesinz_v1()
        self.calc_sbesinz_v1()
        self.calc_stinz_v1()
        self.calc_wadainz_sinz_v1()
        self.calc_wniedinz_esnowinz_v1()
        self.calc_tempsinz_v1()
        self.update_asinz_v1()
        self.calc_actualalbedoinz_v1()
        self.calc_netshortwaveradiationinz_v1()
        self.calc_rlatm_v1()
        self.update_esnowinz_v1()
        self.calc_schmpotinz_v1()
        self.calc_schminz_stinz_v1()
        self.calc_gefrpotinz_v1()
        self.calc_gefrinz_stinz_v1()
        self.calc_evsinz_sinz_stinz_v1()
        self.update_wadainz_sinz_v1()
        self.update_esnowinz_v2()
        self.calc_wats_v2()
        self.calc_wada_waes_v2()
        self.calc_wnied_esnow_v1()
        self.calc_temps_v1()
        self.update_taus_v1()
        self.calc_actualalbedo_v1()
        self.calc_netshortwaveradiationsnow_v1()
        self.calc_tz_v1()
        self.calc_wg_v1()
        self.update_esnow_v1()
        self.calc_schmpot_v2()
        self.calc_schm_wats_v1()
        self.calc_gefrpot_v1()
        self.calc_gefr_wats_v1()
        self.calc_evs_waes_wats_v1()
        self.update_wada_waes_v1()
        self.update_esnow_v2()
        self.calc_netshortwaveradiation_v1()
        self.calc_dailynetshortwaveradiation_v1()
        self.calc_dailynetlongwaveradiation_v1()
        self.calc_netradiation_v1()
        self.calc_dailynetradiation_v1()
        self.calc_dryairpressure_v1()
        self.calc_densityair_v1()
        self.calc_aerodynamicresistance_v1()
        self.calc_soilsurfaceresistance_v1()
        self.calc_landusesurfaceresistance_v1()
        self.calc_actualsurfaceresistance_v1()
        self.calc_g_v2()
        self.calc_evpo_v2()
        self.calc_evi_inzp_v3()
        self.calc_evb_v2()
        self.update_ebdn_v1()
        self.calc_sff_v1()
        self.calc_fvg_v1()
        self.calc_qkap_v1()
        self.calc_qbb_v1()
        self.calc_qib1_v1()
        self.calc_qib2_v1()
        self.calc_qdb_v1()
        self.update_qdb_v1()
        self.calc_bowa_v1()
        self.calc_qbgz_v1()
        self.calc_qigz1_v1()
        self.calc_qigz2_v1()
        self.calc_qdgz_v1()
        self.calc_qbga_v1()
        self.update_qdgz_qbgz_qbga_v1()
        self.update_qdgz_qbgz_qbga_v2()
        self.calc_qiga1_v1()
        self.calc_qiga2_v1()
        self.calc_qdgz1_qdgz2_v1()
        self.calc_qdga1_v1()
        self.calc_qdga2_v1()
        self.calc_qah_v1()
        self.calc_qa_v1()
    cpdef inline void update_inlets(self) nogil:
        self.pick_qz_v1()
    cpdef inline void update_outlets(self) nogil:
        self.pass_qa_v1()
    cpdef inline void update_receivers(self, int idx) nogil:
        self.idx_sim = idx
        pass
    cpdef inline void update_senders(self, int idx) nogil:
        self.idx_sim = idx
        pass
    cpdef inline void update_outputs(self) nogil:
        self.sequences.fluxes.update_outputs()
        self.sequences.states.update_outputs()

    cpdef inline void pick_qz_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.qz = 0.0
        for idx in range(self.sequences.inlets.len_q):
            self.sequences.fluxes.qz = self.sequences.fluxes.qz + (self.sequences.inlets.q[idx][0])
    cpdef inline void pick_qz(self)  nogil:
        cdef int idx
        self.sequences.fluxes.qz = 0.0
        for idx in range(self.sequences.inlets.len_q):
            self.sequences.fluxes.qz = self.sequences.fluxes.qz + (self.sequences.inlets.q[idx][0])
    cpdef inline void calc_qzh_v1(self)  nogil:
        self.sequences.fluxes.qzh = self.sequences.fluxes.qz / self.parameters.derived.qfactor
    cpdef inline void update_loggedteml_v1(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedteml[idx] = self.sequences.logs.loggedteml[idx - 1]
        self.sequences.logs.loggedteml[0] = self.sequences.inputs.teml
    cpdef inline void calc_temltag_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.temltag = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.temltag = self.sequences.fluxes.temltag + (self.sequences.logs.loggedteml[idx])
        self.sequences.fluxes.temltag = self.sequences.fluxes.temltag / (self.parameters.derived.nmblogentries)
    cpdef inline void update_loggedrelativehumidity_v1(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedrelativehumidity[idx] = self.sequences.logs.loggedrelativehumidity[idx - 1]
        self.sequences.logs.loggedrelativehumidity[0] = self.sequences.inputs.relativehumidity
    cpdef inline void calc_dailyrelativehumidity_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailyrelativehumidity = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailyrelativehumidity = self.sequences.fluxes.dailyrelativehumidity + (self.sequences.logs.loggedrelativehumidity[idx])
        self.sequences.fluxes.dailyrelativehumidity = self.sequences.fluxes.dailyrelativehumidity / (self.parameters.derived.nmblogentries)
    cpdef inline void update_loggedsunshineduration_v1(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedsunshineduration[idx] = self.sequences.logs.loggedsunshineduration[idx - 1]
        self.sequences.logs.loggedsunshineduration[0] = self.sequences.inputs.sunshineduration
    cpdef inline void calc_nkor_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.nkor[k] = self.parameters.control.kg[k] * self.sequences.inputs.nied
    cpdef inline void calc_tkor_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.tkor[k] = self.parameters.control.kt[k] + self.sequences.inputs.teml
    cpdef inline void calc_tkortag_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.tkortag[k] = self.parameters.control.kt[k] + self.sequences.fluxes.temltag
    cpdef inline void calc_windspeed2m_v1(self)  nogil:
        self.sequences.fluxes.windspeed2m = self.return_adjustedwindspeed_v1(2.0)
    cpdef inline void calc_reducedwindspeed2m_v1(self)  nogil:
        cdef double d_lai
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                self.sequences.fluxes.reducedwindspeed2m[k] = (                    max(self.parameters.control.p1wind - self.parameters.control.p2wind * d_lai, 0.0) * self.sequences.fluxes.windspeed2m                )
            else:
                self.sequences.fluxes.reducedwindspeed2m[k] = self.sequences.fluxes.windspeed2m
    cpdef inline void update_loggedwindspeed2m_v1(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedwindspeed2m[idx] = self.sequences.logs.loggedwindspeed2m[idx - 1]
        self.sequences.logs.loggedwindspeed2m[0] = self.sequences.fluxes.windspeed2m
    cpdef inline void calc_dailywindspeed2m_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailywindspeed2m = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailywindspeed2m = self.sequences.fluxes.dailywindspeed2m + (self.sequences.logs.loggedwindspeed2m[idx])
        self.sequences.fluxes.dailywindspeed2m = self.sequences.fluxes.dailywindspeed2m / (self.parameters.derived.nmblogentries)
    cpdef inline void calc_windspeed10m_v1(self)  nogil:
        self.sequences.fluxes.windspeed10m = self.return_adjustedwindspeed_v1(10.0)
    cpdef inline void calc_solardeclination_v1(self)  nogil:
        self.sequences.fluxes.solardeclination = 0.41 * cos(            2.0 * self.parameters.fixed.pi * (self.parameters.derived.doy[self.idx_sim] - 171.0) / 365.0        )
    cpdef inline void calc_tsa_tsu_v1(self)  nogil:
        cdef double d_dt
        self.sequences.fluxes.tsa = (            12.0            / self.parameters.fixed.pi            * acos(                tan(self.sequences.fluxes.solardeclination) * tan(self.parameters.derived.latituderad)                + 0.0145                / cos(self.sequences.fluxes.solardeclination)                / cos(self.parameters.derived.latituderad)            )        )
        self.sequences.fluxes.tsu = 24.0 - self.sequences.fluxes.tsa
        d_dt = (self.parameters.derived.utclongitude - self.parameters.control.longitude) * 4.0 / 60.0
        self.sequences.fluxes.tsa = self.sequences.fluxes.tsa + (d_dt)
        self.sequences.fluxes.tsu = self.sequences.fluxes.tsu + (d_dt)
    cpdef inline void calc_dailysunshineduration_v1(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailysunshineduration = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailysunshineduration = self.sequences.fluxes.dailysunshineduration + (self.sequences.logs.loggedsunshineduration[idx])
    cpdef inline void calc_earthsundistance_v1(self)  nogil:
        self.sequences.fluxes.earthsundistance = 1.0 + 0.033 * cos(            2 * self.parameters.fixed.pi / 366.0 * (self.parameters.derived.doy[self.idx_sim] + 1)        )
    cpdef inline void calc_extraterrestrialradiation_v1(self)  nogil:
        cdef double d_sunsethourangle
        d_sunsethourangle = (self.sequences.fluxes.tsu - self.sequences.fluxes.tsa) * self.parameters.fixed.pi / 24.0
        self.sequences.fluxes.extraterrestrialradiation = (            self.parameters.fixed.sol            * self.sequences.fluxes.earthsundistance            / self.parameters.fixed.pi            * (                d_sunsethourangle                * sin(self.sequences.fluxes.solardeclination)                * sin(self.parameters.derived.latituderad)                + cos(self.sequences.fluxes.solardeclination)                * cos(self.parameters.derived.latituderad)                * sin(d_sunsethourangle)            )        )
    cpdef inline void calc_possiblesunshineduration_v1(self)  nogil:
        cdef double d_t1
        cdef double d_t0
        cdef double d_tc
        d_tc = self.parameters.derived.sct[self.idx_sim]
        d_t0 = max((d_tc - self.parameters.derived.hours / 2.0), self.sequences.fluxes.tsa)
        d_t1 = min((d_tc + self.parameters.derived.hours / 2.0), self.sequences.fluxes.tsu)
        self.sequences.fluxes.possiblesunshineduration = max(d_t1 - d_t0, 0.0)
    cpdef inline void calc_dailypossiblesunshineduration_v1(self)  nogil:
        self.sequences.fluxes.dailypossiblesunshineduration = self.sequences.fluxes.tsu - self.sequences.fluxes.tsa
    cpdef inline void calc_sp_v1(self)  nogil:
        cdef double d_temp
        cdef double d_sp
        cdef double d_tlp
        cdef double d_dt
        cdef int i
        cdef double d_fac
        d_fac = 2.0 * self.parameters.fixed.pi / 360.0
        self.sequences.fluxes.sp = 0.0
        for i in range(2):
            if i:
                d_dt = self.parameters.derived.hours / 2.0
            else:
                d_dt = -self.parameters.derived.hours / 2.0
            d_tlp = (                100.0                * d_fac                * ((self.parameters.derived.sct[self.idx_sim] + d_dt - self.sequences.fluxes.tsa) / (self.sequences.fluxes.tsu - self.sequences.fluxes.tsa))            )
            if d_tlp <= 0.0:
                d_sp = 0.0
            elif d_tlp < 100.0 * d_fac:
                d_sp = 50.0 - 50.0 * cos(1.8 * d_tlp)
                d_temp = 3.4 * sin(3.6 * d_tlp) ** 2
                if d_tlp <= 50.0 * d_fac:
                    d_sp = d_sp - (d_temp)
                else:
                    d_sp = d_sp + (d_temp)
            else:
                d_sp = 100.0
            if i:
                self.sequences.fluxes.sp = self.sequences.fluxes.sp + (d_sp)
            else:
                self.sequences.fluxes.sp = self.sequences.fluxes.sp - (d_sp)
    cpdef inline void calc_globalradiation_v1(self)  nogil:
        cdef double d_pos
        cdef double d_act
        if self.sequences.fluxes.possiblesunshineduration > 0.0:
            d_act = self.sequences.inputs.sunshineduration
            d_pos = self.sequences.fluxes.possiblesunshineduration
        else:
            d_act = self.sequences.fluxes.dailysunshineduration
            d_pos = self.sequences.fluxes.dailypossiblesunshineduration
        self.sequences.fluxes.globalradiation = (            self.sequences.fluxes.sp / 100.0 * self.return_dailyglobalradiation_v1(d_act, d_pos)        )
    cpdef inline void update_loggedglobalradiation_v1(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedglobalradiation[idx] = self.sequences.logs.loggedglobalradiation[idx - 1]
        self.sequences.logs.loggedglobalradiation[0] = self.sequences.fluxes.globalradiation
    cpdef inline void calc_dailyglobalradiation_v1(self)  nogil:
        self.sequences.fluxes.dailyglobalradiation = self.return_dailyglobalradiation_v1(            self.sequences.fluxes.dailysunshineduration, self.sequences.fluxes.dailypossiblesunshineduration        )
    cpdef inline void calc_adjustedglobalradiation_v1(self)  nogil:
        cdef int idx
        cdef double d_glob_sum
        d_glob_sum = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            d_glob_sum = d_glob_sum + (self.sequences.logs.loggedglobalradiation[idx])
        self.sequences.fluxes.adjustedglobalradiation = (            self.sequences.fluxes.globalradiation * self.sequences.fluxes.dailyglobalradiation / d_glob_sum        )
    cpdef inline void calc_saturationvapourpressure_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.saturationvapourpressure[k] = self.return_saturationvapourpressure_v1(                self.sequences.fluxes.tkor[k]            )
    cpdef inline void calc_dailysaturationvapourpressure_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailysaturationvapourpressure[                k            ] = self.return_saturationvapourpressure_v1(self.sequences.fluxes.tkortag[k])
    cpdef inline void calc_saturationvapourpressureslope_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.saturationvapourpressureslope[                k            ] = self.return_saturationvapourpressureslope_v1(self.sequences.fluxes.tkor[k])
    cpdef inline void calc_dailysaturationvapourpressureslope_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailysaturationvapourpressureslope[                k            ] = self.return_saturationvapourpressureslope_v1(self.sequences.fluxes.tkortag[k])
    cpdef inline void calc_actualvapourpressure_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.actualvapourpressure[k] = self.return_actualvapourpressure_v1(                self.sequences.fluxes.saturationvapourpressure[k], self.sequences.inputs.relativehumidity            )
    cpdef inline void calc_dailyactualvapourpressure_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailyactualvapourpressure[k] = self.return_actualvapourpressure_v1(                self.sequences.fluxes.dailysaturationvapourpressure[k],                self.sequences.fluxes.dailyrelativehumidity,            )
    cpdef inline void calc_nbes_inzp_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.nbes[k] = 0.0
                self.sequences.states.inzp[k] = 0.0
            else:
                self.sequences.fluxes.nbes[k] = max(                    self.sequences.fluxes.nkor[k]                    + self.sequences.states.inzp[k]                    - self.parameters.derived.kinz[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]],                    0.0,                )
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] + (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.nbes[k])
    cpdef inline void calc_snratio_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.fluxes.tkor[k] >= (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 0.0
            elif self.sequences.fluxes.tkor[k] <= (self.parameters.control.tgr[k] - self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 1.0
            else:
                self.sequences.aides.snratio[k] = (                    (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0) - self.sequences.fluxes.tkor[k]                ) / self.parameters.control.tsp[k]
    cpdef inline void calc_sbes_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.sbes[k] = self.sequences.aides.snratio[k] * self.sequences.fluxes.nbes[k]
    cpdef inline void calc_snowintmax_v1(self)  nogil:
        cdef double d_lai
        cdef int k
        cdef int idx
        idx = self.parameters.derived.moy[self.idx_sim]
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, idx]
                self.sequences.fluxes.snowintmax[k] = self.parameters.control.p1simax + self.parameters.control.p2simax * d_lai
                if self.sequences.fluxes.tkor[k] >= -1.0:
                    self.sequences.fluxes.snowintmax[k] = self.sequences.fluxes.snowintmax[k] * (2)
                elif self.sequences.fluxes.tkor[k] > -3.0:
                    self.sequences.fluxes.snowintmax[k] = self.sequences.fluxes.snowintmax[k] * (2.5 + 0.5 * self.sequences.fluxes.tkor[k])
            else:
                self.sequences.fluxes.snowintmax[k] = 0.0
    cpdef inline void calc_snowintrate_v1(self)  nogil:
        cdef double d_lai
        cdef int k
        cdef int idx
        idx = self.parameters.derived.moy[self.idx_sim]
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, idx]
                self.sequences.fluxes.snowintrate[k] = min(                    self.parameters.control.p1sirate + self.parameters.control.p2sirate * d_lai + self.parameters.control.p3sirate * self.sequences.states.sinz[k],                    1.0,                )
            else:
                self.sequences.fluxes.snowintrate[k] = 0.0
    cpdef inline void calc_nbesinz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.fluxes.nbesinz[k] = min(                    self.sequences.fluxes.snowintrate[k] * self.sequences.fluxes.nbes[k],                    max(self.sequences.fluxes.snowintmax[k] - self.sequences.states.sinz[k], 0.0),                )
            else:
                self.sequences.fluxes.nbesinz[k] = 0.0
    cpdef inline void calc_sbesinz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.fluxes.sbesinz[k] = self.sequences.aides.snratio[k] * self.sequences.fluxes.nbesinz[k]
            else:
                self.sequences.fluxes.sbesinz[k] = 0.0
    cpdef inline void calc_stinz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.states.stinz[k] = self.sequences.states.stinz[k] + (self.sequences.fluxes.sbesinz[k])
            else:
                self.sequences.states.stinz[k] = 0.0
    cpdef inline void calc_wadainz_sinz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.states.sinz[k] = self.sequences.states.sinz[k] + (self.sequences.fluxes.nbesinz[k])
                self.sequences.fluxes.wadainz[k] = max(self.sequences.states.sinz[k] - self.parameters.control.pwmax[k] * self.sequences.states.stinz[k], 0.0)
                self.sequences.states.sinz[k] = self.sequences.states.sinz[k] - (self.sequences.fluxes.wadainz[k])
            else:
                self.sequences.fluxes.wadainz[k] = 0.0
                self.sequences.states.sinz[k] = 0.0
    cpdef inline void calc_wniedinz_esnowinz_v1(self)  nogil:
        cdef double d_water
        cdef double d_ice
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_ice = self.parameters.fixed.cpeis * self.sequences.fluxes.sbesinz[k]
                d_water = self.parameters.fixed.cpwasser * (                    self.sequences.fluxes.nbesinz[k] - self.sequences.fluxes.sbesinz[k] - self.sequences.fluxes.wadainz[k]                )
                self.sequences.fluxes.wniedinz[k] = (self.sequences.fluxes.tkor[k] - self.parameters.control.trefn[k]) * (d_ice + d_water)
                self.sequences.states.esnowinz[k] = self.sequences.states.esnowinz[k] + (self.sequences.fluxes.wniedinz[k])
            else:
                self.sequences.fluxes.wniedinz[k] = 0.0
                self.sequences.states.esnowinz[k] = 0.0
    cpdef inline void calc_tempsinz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.aides.tempsinz[k] = self.return_tempsinz_v1(k)
    cpdef inline void update_asinz_v1(self)  nogil:
        cdef double d_r2
        cdef double d_r1
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.sinz[k] > 0:
                if isnan(self.sequences.states.asinz[k]):
                    self.sequences.states.asinz[k] = 0.0
                d_r1 = exp(                    5000.0 * (1 / 273.15 - 1.0 / (273.15 + self.sequences.aides.tempsinz[k]))                )
                d_r2 = min(d_r1 ** 10, 1.0)
                self.sequences.states.asinz[k] = self.sequences.states.asinz[k] * (max(1 - 0.1 * self.sequences.fluxes.sbesinz[k], 0.0))
                self.sequences.states.asinz[k] = self.sequences.states.asinz[k] + ((d_r1 + d_r2 + 0.03) / 1e6 * self.parameters.derived.seconds)
            else:
                self.sequences.states.asinz[k] = nan
    cpdef inline void calc_actualalbedoinz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.sinz[k] > 0.0:
                self.sequences.fluxes.actualalbedoinz[k] = self.parameters.control.albedo0snow * (                    1.0 - self.parameters.control.snowagingfactor * self.sequences.states.asinz[k] / (1.0 + self.sequences.states.asinz[k])                )
            else:
                self.sequences.fluxes.actualalbedoinz[k] = nan
    cpdef inline void calc_netshortwaveradiationinz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.fluxes.netshortwaveradiationinz[k] = (                    (1.0 - self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]])                    * (1.0 - self.sequences.fluxes.actualalbedoinz[k])                    * self.sequences.fluxes.adjustedglobalradiation                )
            else:
                self.sequences.fluxes.netshortwaveradiationinz[k] = 0.0
    cpdef inline void calc_rlatm_v1(self)  nogil:
        cdef double d_t
        cdef int k
        cdef double d_common
        cdef double d_rs
        d_rs = self.sequences.fluxes.dailysunshineduration / self.sequences.fluxes.dailypossiblesunshineduration
        d_common = self.parameters.fixed.fratm * self.parameters.fixed.sigma * self.parameters.derived.days * (1.0 + 0.22 * (1.0 - d_rs) ** 2)
        for k in range(self.parameters.control.nhru):
            d_t = self.sequences.fluxes.tkor[k] + 273.15
            self.sequences.aides.rlatm[k] = d_common * (                d_t ** 4 * (self.sequences.fluxes.actualvapourpressure[k] * 10.0 / d_t) ** (1.0 / 7.0)            )
    cpdef inline void update_esnowinz_v1(self)  nogil:
        cdef double d_esnowinz
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.sinz[k] > 0.0:
                self.idx_hru = k
                d_esnowinz = self.sequences.states.esnowinz[k]
                self.sequences.states.esnowinz[k] = self.pegasusesnowinz.find_x(                    self.return_esnowinz_v1(k, -30.0),                    self.return_esnowinz_v1(k, 100.0),                    -100.0,                    100.0,                    0.0,                    1e-8,                    10,                )
                if self.sequences.states.esnowinz[k] > 0.0:
                    self.sequences.aides.tempsinz[k] = 0.0
                    self.sequences.states.esnowinz[k] = d_esnowinz - self.return_wsurfinz_v1(k)
            else:
                self.sequences.states.esnowinz[k] = 0.0
                self.sequences.aides.tempsinz[k] = nan
                self.sequences.fluxes.netlongwaveradiationinz[k] = 0.0
                self.sequences.fluxes.netradiationinz[k] = 0.0
                self.sequences.fluxes.saturationvapourpressureinz[k] = 0.0
                self.sequences.fluxes.wsensinz[k] = 0.0
                self.sequences.fluxes.wlatinz[k] = 0.0
                self.sequences.fluxes.wsurfinz[k] = 0.0
    cpdef inline void calc_schmpotinz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.sinz[k] > 0.0:
                self.sequences.fluxes.schmpotinz[k] = max(self.sequences.states.esnowinz[k] / self.parameters.fixed.rschmelz, 0.0)
            else:
                self.sequences.fluxes.schmpotinz[k] = 0.0
    cpdef inline void calc_schminz_stinz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.fluxes.schminz[k] = min(self.sequences.fluxes.schmpotinz[k], self.sequences.states.stinz[k])
                self.sequences.states.stinz[k] = self.sequences.states.stinz[k] - (self.sequences.fluxes.schminz[k])
            else:
                self.sequences.fluxes.schminz[k] = 0.0
    cpdef inline void calc_gefrpotinz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.sinz[k] > 0:
                self.sequences.fluxes.gefrpotinz[k] = max(-self.sequences.states.esnowinz[k] / self.parameters.fixed.rschmelz, 0)
            else:
                self.sequences.fluxes.gefrpotinz[k] = 0.0
    cpdef inline void calc_gefrinz_stinz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW) and self.parameters.control.refreezeflag:
                self.sequences.fluxes.gefrinz[k] = min(self.sequences.fluxes.gefrpotinz[k], (self.sequences.states.sinz[k] - self.sequences.states.stinz[k]))
                self.sequences.states.stinz[k] = self.sequences.states.stinz[k] + (self.sequences.fluxes.gefrinz[k])
            else:
                self.sequences.fluxes.gefrinz[k] = 0.0
    cpdef inline void calc_evsinz_sinz_stinz_v1(self)  nogil:
        cdef double d_frac
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW) and (self.sequences.states.sinz[k] > 0.0):
                self.sequences.fluxes.evsinz[k] = min(self.sequences.fluxes.wlatinz[k] / self.parameters.fixed.lwe, self.sequences.states.sinz[k])
                d_frac = (self.sequences.states.sinz[k] - self.sequences.fluxes.evsinz[k]) / self.sequences.states.sinz[k]
                self.sequences.states.sinz[k] = self.sequences.states.sinz[k] * (d_frac)
                self.sequences.states.stinz[k] = self.sequences.states.stinz[k] * (d_frac)
            else:
                self.sequences.fluxes.evsinz[k] = 0.0
                self.sequences.states.sinz[k] = 0.0
                self.sequences.states.stinz[k] = 0.0
    cpdef inline void update_wadainz_sinz_v1(self)  nogil:
        cdef double d_wadainz_corr
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_wadainz_corr = max(self.sequences.states.sinz[k] - self.parameters.control.pwmax[k] * self.sequences.states.stinz[k], 0.0)
                self.sequences.fluxes.wadainz[k] = self.sequences.fluxes.wadainz[k] + (d_wadainz_corr)
                self.sequences.states.sinz[k] = self.sequences.states.sinz[k] - (d_wadainz_corr)
    cpdef inline void update_esnowinz_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW) and self.sequences.states.sinz[k] > 0.0:
                self.sequences.states.esnowinz[k] = self.sequences.states.esnowinz[k] + (self.parameters.fixed.rschmelz * (self.sequences.fluxes.gefrinz[k] - self.sequences.fluxes.schminz[k]))
            else:
                self.sequences.states.esnowinz[k] = 0.0
    cpdef inline void calc_wats_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.wats[k] = 0.0
            elif self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.sbes[k] - self.sequences.fluxes.sbesinz[k])
            else:
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.sbes[k])
    cpdef inline void calc_wada_waes_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.waes[k] = 0.0
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.nbes[k] - self.sequences.fluxes.nbesinz[k] + self.sequences.fluxes.wadainz[k]
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.states.waes[k] = self.sequences.states.waes[k] + (self.sequences.fluxes.nbes[k])
                self.sequences.fluxes.wada[k] = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (self.sequences.fluxes.wada[k])
            else:
                self.sequences.states.waes[k] = self.sequences.states.waes[k] + (self.sequences.fluxes.nbes[k] - self.sequences.fluxes.nbesinz[k] + self.sequences.fluxes.wadainz[k])
                self.sequences.fluxes.wada[k] = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (self.sequences.fluxes.wada[k])
    cpdef inline void calc_wnied_esnow_v1(self)  nogil:
        cdef double d_water
        cdef double d_ice
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.wnied[k] = 0.0
                self.sequences.states.esnow[k] = 0.0
            else:
                d_ice = self.parameters.fixed.cpeis * self.sequences.fluxes.sbes[k]
                d_water = self.parameters.fixed.cpwasser * (self.sequences.fluxes.nbes[k] - self.sequences.fluxes.sbes[k] - self.sequences.fluxes.wada[k])
                self.sequences.fluxes.wnied[k] = (self.sequences.fluxes.tkor[k] - self.parameters.control.trefn[k]) * (d_ice + d_water)
                self.sequences.states.esnow[k] = self.sequences.states.esnow[k] + (self.sequences.fluxes.wnied[k])
    cpdef inline void calc_temps_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.aides.temps[k] = self.return_temps_v1(k)
    cpdef inline void update_taus_v1(self)  nogil:
        cdef double d_r2
        cdef double d_r1
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0:
                if isnan(self.sequences.states.taus[k]):
                    self.sequences.states.taus[k] = 0.0
                d_r1 = exp(                    5000.0 * (1 / 273.15 - 1.0 / (273.15 + self.sequences.aides.temps[k]))                )
                d_r2 = min(d_r1 ** 10, 1.0)
                self.sequences.states.taus[k] = self.sequences.states.taus[k] * (max(1 - 0.1 * self.sequences.fluxes.sbes[k], 0.0))
                self.sequences.states.taus[k] = self.sequences.states.taus[k] + ((d_r1 + d_r2 + 0.03) / 1e6 * self.parameters.derived.seconds)
            else:
                self.sequences.states.taus[k] = nan
    cpdef inline void calc_actualalbedo_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0.0:
                self.sequences.fluxes.actualalbedo[k] = self.parameters.control.albedo0snow * (                    1.0 - self.parameters.control.snowagingfactor * self.sequences.states.taus[k] / (1.0 + self.sequences.states.taus[k])                )
            else:
                self.sequences.fluxes.actualalbedo[k] = self.parameters.control.albedo[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
    cpdef inline void calc_netshortwaveradiationsnow_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netshortwaveradiationsnow[k] = (                self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]                * (1.0 - self.sequences.fluxes.actualalbedo[k])                * self.sequences.fluxes.adjustedglobalradiation            )
    cpdef inline void calc_tz_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.tz[k] = nan
            elif self.sequences.states.ebdn[k] < 0.0:
                self.sequences.fluxes.tz[k] = self.sequences.states.ebdn[k] / (2.0 * self.parameters.fixed.z * self.parameters.fixed.cg)
            elif self.sequences.states.ebdn[k] < self.parameters.derived.heatoffusion[k]:
                self.sequences.fluxes.tz[k] = 0.0
            else:
                self.sequences.fluxes.tz[k] = (self.sequences.states.ebdn[k] - self.parameters.derived.heatoffusion[k]) / (2.0 * self.parameters.fixed.z * self.parameters.fixed.cg)
    cpdef inline void calc_wg_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (FLUSS, SEE, WASSER):
                self.sequences.fluxes.wg[k] = 0.0
            else:
                self.sequences.fluxes.wg[k] = self.return_wg_v1(k)
    cpdef inline void update_esnow_v1(self)  nogil:
        cdef double d_esnow
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0.0:
                self.idx_hru = k
                d_esnow = self.sequences.states.esnow[k]
                self.sequences.states.esnow[k] = self.pegasusesnow.find_x(                    self.return_esnow_v1(k, -30.0),                    self.return_esnow_v1(k, 100.0),                    -100.0,                    100.0,                    0.0,                    1e-8,                    10,                )
                if self.sequences.states.esnow[k] > 0.0:
                    self.sequences.aides.temps[k] = 0.0
                    self.sequences.fluxes.tempssurface[k] = self.return_tempssurface(k)
                    self.sequences.fluxes.wg[k] = self.return_wg_v1(k)
                    self.sequences.states.esnow[k] = d_esnow + self.sequences.fluxes.wg[k] - self.sequences.fluxes.wsurf[k]
            else:
                self.sequences.states.esnow[k] = 0.0
                self.sequences.aides.temps[k] = nan
                self.sequences.fluxes.tempssurface[k] = nan
                self.sequences.fluxes.netlongwaveradiationsnow[k] = 0.0
                self.sequences.fluxes.netradiationsnow[k] = 0.0
                self.sequences.fluxes.saturationvapourpressuresnow[k] = 0.0
                self.sequences.fluxes.wsenssnow[k] = 0.0
                self.sequences.fluxes.wlatsnow[k] = 0.0
                self.sequences.fluxes.wsurf[k] = 0.0
    cpdef inline void calc_schmpot_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0.0:
                self.sequences.fluxes.schmpot[k] = max(self.sequences.states.esnow[k] / self.parameters.fixed.rschmelz, 0.0)
            else:
                self.sequences.fluxes.schmpot[k] = 0.0
    cpdef inline void calc_schm_wats_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.schm[k] = 0.0
            else:
                self.sequences.fluxes.schm[k] = min(self.sequences.fluxes.schmpot[k], self.sequences.states.wats[k])
                self.sequences.states.wats[k] = self.sequences.states.wats[k] - (self.sequences.fluxes.schm[k])
    cpdef inline void calc_gefrpot_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0:
                self.sequences.fluxes.gefrpot[k] = max(-self.sequences.states.esnow[k] / self.parameters.fixed.rschmelz, 0)
            else:
                self.sequences.fluxes.gefrpot[k] = 0.0
    cpdef inline void calc_gefr_wats_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE) or not self.parameters.control.refreezeflag:
                self.sequences.fluxes.gefr[k] = 0.0
            else:
                self.sequences.fluxes.gefr[k] = min(self.sequences.fluxes.gefrpot[k], (self.sequences.states.waes[k] - self.sequences.states.wats[k]))
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.gefr[k])
    cpdef inline void calc_evs_waes_wats_v1(self)  nogil:
        cdef double d_frac
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, SEE, FLUSS) or (self.sequences.states.waes[k] <= 0.0):
                self.sequences.fluxes.evs[k] = 0.0
                self.sequences.states.waes[k] = 0.0
                self.sequences.states.wats[k] = 0.0
            else:
                self.sequences.fluxes.evs[k] = min(self.sequences.fluxes.wlatsnow[k] / self.parameters.fixed.lwe, self.sequences.states.waes[k])
                d_frac = (self.sequences.states.waes[k] - self.sequences.fluxes.evs[k]) / self.sequences.states.waes[k]
                self.sequences.states.waes[k] = self.sequences.states.waes[k] * (d_frac)
                self.sequences.states.wats[k] = self.sequences.states.wats[k] * (d_frac)
    cpdef inline void update_wada_waes_v1(self)  nogil:
        cdef double d_wada_corr
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] not in (WASSER, FLUSS, SEE):
                d_wada_corr = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] + (d_wada_corr)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (d_wada_corr)
    cpdef inline void update_esnow_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE)) or (self.sequences.states.waes[k] <= 0.0):
                self.sequences.states.esnow[k] = 0.0
            else:
                self.sequences.states.esnow[k] = self.sequences.states.esnow[k] + (self.parameters.fixed.rschmelz * (self.sequences.fluxes.gefr[k] - self.sequences.fluxes.schm[k]))
    cpdef inline void calc_netshortwaveradiation_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netshortwaveradiation[k] = (                1.0 - self.sequences.fluxes.actualalbedo[k]            ) * self.sequences.fluxes.adjustedglobalradiation
    cpdef inline void calc_dailynetshortwaveradiation_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailynetshortwaveradiation[k] = (                1.0 - self.sequences.fluxes.actualalbedo[k]            ) * self.sequences.fluxes.dailyglobalradiation
    cpdef inline void calc_dailynetlongwaveradiation_v1(self)  nogil:
        cdef double d_temp
        cdef int k
        cdef double d_relsunshine
        d_relsunshine = self.sequences.fluxes.dailysunshineduration / self.sequences.fluxes.dailypossiblesunshineduration
        for k in range(self.parameters.control.nhru):
            d_temp = self.sequences.fluxes.tkortag[k] + 273.15
            self.sequences.fluxes.dailynetlongwaveradiation[k] = (                (0.2 + 0.8 * d_relsunshine)                * self.parameters.fixed.sigma                * d_temp ** 4                * (                    self.parameters.control.emissivity                    - self.parameters.fixed.fratm                    * (self.sequences.fluxes.dailyactualvapourpressure[k] * 10.0 / d_temp) ** (1.0 / 7.0)                )            )
    cpdef inline void calc_netradiation_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netradiation[k] = self.return_netradiation_v1(                self.sequences.fluxes.netshortwaveradiation[k],                self.sequences.fluxes.dailynetlongwaveradiation[k] * self.parameters.derived.days,            )
    cpdef inline void calc_dailynetradiation_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailynetradiation[k] = self.return_netradiation_v1(                self.sequences.fluxes.dailynetshortwaveradiation[k],                self.sequences.fluxes.dailynetlongwaveradiation[k],            )
    cpdef inline void calc_dryairpressure_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dryairpressure[k] = (                self.sequences.inputs.atmosphericpressure - self.sequences.fluxes.actualvapourpressure[k]            )
    cpdef inline void calc_densityair_v1(self)  nogil:
        cdef double d_t
        cdef int k
        for k in range(self.parameters.control.nhru):
            d_t = self.sequences.fluxes.tkor[k] + 273.15
            self.sequences.fluxes.densityair[k] = self.sequences.fluxes.dryairpressure[k] / (                self.parameters.fixed.rdryair * d_t            ) + self.sequences.fluxes.actualvapourpressure[k] / (self.parameters.fixed.rwatervapour * d_t)
    cpdef inline void calc_aerodynamicresistance_v1(self)  nogil:
        cdef double d_z0
        cdef double d_ch
        cdef int k
        if self.sequences.fluxes.windspeed10m > 0.0:
            for k in range(self.parameters.control.nhru):
                d_ch = self.parameters.control.cropheight[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                if d_ch < 10.0:
                    d_z0 = 0.021 + 0.163 * d_ch
                    self.sequences.fluxes.aerodynamicresistance[k] = (                        6.25 / self.sequences.fluxes.windspeed10m * log(10.0 / d_z0) ** 2                    )
                else:
                    self.sequences.fluxes.aerodynamicresistance[k] = 94.0 / self.sequences.fluxes.windspeed10m
        else:
            for k in range(self.parameters.control.nhru):
                self.sequences.fluxes.aerodynamicresistance[k] = inf
    cpdef inline void calc_soilsurfaceresistance_v1(self)  nogil:
        cdef double d_free
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, FLUSS, SEE, WASSER):
                self.sequences.fluxes.soilsurfaceresistance[k] = nan
            elif self.parameters.derived.nfk[k] > 20.0:
                self.sequences.fluxes.soilsurfaceresistance[k] = 100.0
            elif self.parameters.derived.nfk[k] > 0.0:
                d_free = min(max(self.sequences.states.bowa[k] - self.parameters.control.pwp[k], 0.0), self.parameters.derived.nfk[k])
                self.sequences.fluxes.soilsurfaceresistance[k] = (                    100.0 * self.parameters.derived.nfk[k] / (d_free + 0.01 * self.parameters.derived.nfk[k])                )
            else:
                self.sequences.fluxes.soilsurfaceresistance[k] = inf
    cpdef inline void calc_landusesurfaceresistance_v1(self)  nogil:
        cdef double d_def
        cdef double d_res
        cdef int k
        for k in range(self.parameters.control.nhru):
            d_res = self.parameters.control.surfaceresistance[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
            if self.parameters.control.lnk[k] == NADELW:
                d_def = self.sequences.fluxes.saturationvapourpressure[k] - self.sequences.fluxes.actualvapourpressure[k]
                if (self.sequences.fluxes.tkor[k] <= -5.0) or (d_def >= 2.0):
                    self.sequences.fluxes.landusesurfaceresistance[k] = 10000.0
                elif self.sequences.fluxes.tkor[k] < 20.0:
                    self.sequences.fluxes.landusesurfaceresistance[k] = min(                        (25.0 * d_res) / (self.sequences.fluxes.tkor[k] + 5.0) / (1.0 - 0.5 * d_def),                        10000.0,                    )
                else:
                    self.sequences.fluxes.landusesurfaceresistance[k] = min(                        d_res / (1.0 - 0.5 * d_def), 10000.0                    )
            else:
                self.sequences.fluxes.landusesurfaceresistance[k] = d_res
            if self.parameters.control.lnk[k] not in (WASSER, FLUSS, SEE, VERS):
                if self.sequences.states.bowa[k] <= 0.0:
                    self.sequences.fluxes.landusesurfaceresistance[k] = inf
                elif self.sequences.states.bowa[k] < self.parameters.control.py[k]:
                    self.sequences.fluxes.landusesurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k] * (3.5 * (                        1.0 - self.sequences.states.bowa[k] / self.parameters.control.py[k]                    ) + exp(0.2 * self.parameters.control.py[k] / self.sequences.states.bowa[k]))
                else:
                    self.sequences.fluxes.landusesurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k] * (exp(0.2))
    cpdef inline void calc_actualsurfaceresistance_v1(self)  nogil:
        cdef double d_invrestnight
        cdef double d_invrestday
        cdef double d_lai
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, FLUSS, SEE, WASSER):
                self.sequences.fluxes.actualsurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k]
            else:
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                d_invrestday = (                    (1.0 - 0.7 ** d_lai) / self.sequences.fluxes.landusesurfaceresistance[k]                ) + 0.7 ** d_lai / self.sequences.fluxes.soilsurfaceresistance[k]
                d_invrestnight = d_lai / 2500.0 + 1.0 / self.sequences.fluxes.soilsurfaceresistance[k]
                self.sequences.fluxes.actualsurfaceresistance[k] = 1.0 / (                    (                        self.sequences.fluxes.possiblesunshineduration / self.parameters.derived.hours * d_invrestday                        + (1.0 - self.sequences.fluxes.possiblesunshineduration / self.parameters.derived.hours)                        * d_invrestnight                    )                )
    cpdef inline void calc_g_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (FLUSS, SEE, WASSER):
                self.sequences.fluxes.g[k] = 0.0
            else:
                self.sequences.fluxes.g[k] = self.parameters.derived.days * self.parameters.control.wg2z[self.parameters.derived.moy[self.idx_sim]]
    cpdef inline void calc_evpo_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, SEE, FLUSS):
                self.sequences.fluxes.evpo[k] = self.return_penman_v1(k)
            else:
                self.sequences.fluxes.evpo[k] = self.return_penmanmonteith_v1(k, 0.0)
    cpdef inline void calc_evi_inzp_v3(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.evi[k] = self.sequences.fluxes.evpo[k]
                self.sequences.states.inzp[k] = 0.0
            elif self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                if self.sequences.states.sinz[k] == 0.0:
                    self.sequences.fluxes.evi[k] = min(self.sequences.fluxes.evpo[k], self.sequences.states.inzp[k])
                    self.sequences.states.inzp[k] = self.sequences.states.inzp[k] - (self.sequences.fluxes.evi[k])
                else:
                    self.sequences.fluxes.evi[k] = 0.0
            elif self.sequences.states.waes[k] == 0.0:
                self.sequences.fluxes.evi[k] = min(self.sequences.fluxes.evpo[k], self.sequences.states.inzp[k])
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] - (self.sequences.fluxes.evi[k])
            else:
                self.sequences.fluxes.evi[k] = 0.0
    cpdef inline void calc_evb_v2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or ((self.parameters.control.lnk[k] not in (LAUBW, MISCHW, NADELW) and self.sequences.states.waes[k] > 0.0))                or (self.sequences.fluxes.evpo[k] == 0.0)            ):
                self.sequences.fluxes.evb[k] = 0.0
            else:
                self.sequences.fluxes.evb[k] = (                    (self.sequences.fluxes.evpo[k] - self.sequences.fluxes.evi[k])                    / self.sequences.fluxes.evpo[k]                    * self.return_penmanmonteith_v1(                        k,                        self.sequences.fluxes.actualsurfaceresistance[k],                    )                )
    cpdef inline void update_ebdn_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.ebdn[k] = 0.0
            else:
                self.sequences.states.ebdn[k] = self.sequences.states.ebdn[k] + (self.parameters.control.wg2z[self.parameters.derived.moy[self.idx_sim]] * self.parameters.derived.days - self.sequences.fluxes.wg[k])
    cpdef inline void calc_sff_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.fluxes.sff[k] = 0.0
            else:
                self.sequences.fluxes.sff[k] = min(                    max(                        1.0 - self.sequences.states.ebdn[k] / (self.parameters.fixed.bowa2z[k] * self.parameters.fixed.rschmelz),                        0.0,                    ),                    1.0,                )
    cpdef inline void calc_fvg_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.fluxes.fvg[k] = 0.0
            else:
                self.sequences.fluxes.fvg[k] = min(self.parameters.control.fvf * self.sequences.fluxes.sff[k] ** self.parameters.control.bsff, 1.0)
    cpdef inline void calc_qkap_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qkap[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 0]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k]
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 1]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k] * (                    1.0                    - (self.sequences.states.bowa[k] - self.parameters.control.kapgrenz[k, 0])                    / (self.parameters.control.kapgrenz[k, 1] - self.parameters.control.kapgrenz[k, 0])                )
            else:
                self.sequences.fluxes.qkap[k] = 0
    cpdef inline void calc_qbb_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.pwp[k])                or (self.parameters.control.wmax[k] <= 0.0)            ):
                self.sequences.fluxes.qbb[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.fk[k]:
                if self.parameters.control.rbeta:
                    self.sequences.fluxes.qbb[k] = 0.0
                else:
                    self.sequences.fluxes.qbb[k] = self.parameters.control.beta[k] * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])
            else:
                self.sequences.fluxes.qbb[k] = (                    self.parameters.control.beta[k]                    * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])                    * (                        1.0                        + (self.parameters.control.fbeta[k] - 1.0)                        * (self.sequences.states.bowa[k] - self.parameters.control.fk[k])                        / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                    )                )
    cpdef inline void calc_qib1_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (                self.sequences.states.bowa[k] <= self.parameters.control.pwp[k]            ):
                self.sequences.fluxes.qib1[k] = 0.0
            else:
                self.sequences.fluxes.qib1[k] = self.parameters.control.dmin[k] * (self.sequences.states.bowa[k] / self.parameters.control.wmax[k])
    cpdef inline void calc_qib2_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.fk[k])                or (self.parameters.control.wmax[k] <= self.parameters.control.fk[k])            ):
                self.sequences.fluxes.qib2[k] = 0.0
            else:
                self.sequences.fluxes.qib2[k] = (self.parameters.control.dmax[k] - self.parameters.control.dmin[k]) * (                    (self.sequences.states.bowa[k] - self.parameters.control.fk[k]) / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                ) ** 1.5
    cpdef inline void calc_qdb_v1(self)  nogil:
        cdef double d_exz
        cdef double d_sfa
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qdb[k] = 0.0
            elif (self.parameters.control.lnk[k] in (VERS, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qdb[k] = self.sequences.fluxes.wada[k]
            else:
                if self.sequences.states.bowa[k] < self.parameters.control.wmax[k]:
                    d_sfa = (1.0 - self.sequences.states.bowa[k] / self.parameters.control.wmax[k]) ** (                        1.0 / (self.parameters.control.bsf[k] + 1.0)                    ) - (self.sequences.fluxes.wada[k] / ((self.parameters.control.bsf[k] + 1.0) * self.parameters.control.wmax[k]))
                else:
                    d_sfa = 0.0
                d_exz = self.sequences.states.bowa[k] + self.sequences.fluxes.wada[k] - self.parameters.control.wmax[k]
                self.sequences.fluxes.qdb[k] = d_exz
                if d_sfa > 0.0:
                    self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + (d_sfa ** (self.parameters.control.bsf[k] + 1.0) * self.parameters.control.wmax[k])
                self.sequences.fluxes.qdb[k] = max(self.sequences.fluxes.qdb[k], 0.0)
    cpdef inline void update_qdb_v1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + (self.sequences.fluxes.fvg[k] * (self.sequences.fluxes.wada[k] - self.sequences.fluxes.qdb[k]))
    cpdef inline void calc_bowa_v1(self)  nogil:
        cdef double d_factor
        cdef double d_rvl
        cdef double d_incr
        cdef double d_decr
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.states.bowa[k] = 0.0
            else:
                d_decr = self.sequences.fluxes.qbb[k] + self.sequences.fluxes.qib1[k] + self.sequences.fluxes.qib2[k] + self.sequences.fluxes.qdb[k]
                d_incr = self.sequences.fluxes.wada[k] + self.sequences.fluxes.qkap[k]
                if self.sequences.fluxes.evb[k] > 0.0:
                    d_decr = d_decr + (self.sequences.fluxes.evb[k])
                else:
                    d_incr = d_incr - (self.sequences.fluxes.evb[k])
                if d_decr > self.sequences.states.bowa[k] + d_incr:
                    d_rvl = (self.sequences.states.bowa[k] + d_incr) / d_decr
                    if self.sequences.fluxes.evb[k] > 0.0:
                        self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_rvl)
                    self.sequences.fluxes.qbb[k] = self.sequences.fluxes.qbb[k] * (d_rvl)
                    self.sequences.fluxes.qib1[k] = self.sequences.fluxes.qib1[k] * (d_rvl)
                    self.sequences.fluxes.qib2[k] = self.sequences.fluxes.qib2[k] * (d_rvl)
                    self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] * (d_rvl)
                    self.sequences.states.bowa[k] = 0.0
                else:
                    self.sequences.states.bowa[k] = (self.sequences.states.bowa[k] + d_incr) - d_decr
                    if self.sequences.states.bowa[k] > self.parameters.control.wmax[k]:
                        d_factor = (self.sequences.states.bowa[k] - self.parameters.control.wmax[k]) / d_incr
                        if self.sequences.fluxes.evb[k] < 0.0:
                            self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_factor)
                        self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] * (d_factor)
                        self.sequences.fluxes.qkap[k] = self.sequences.fluxes.qkap[k] * (d_factor)
                        self.sequences.states.bowa[k] = self.parameters.control.wmax[k]
    cpdef inline void calc_qbgz_v1(self)  nogil:
        cdef int k
        self.sequences.states.qbgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == SEE:
                self.sequences.states.qbgz = self.sequences.states.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, FLUSS, VERS):
                self.sequences.states.qbgz = self.sequences.states.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.qbb[k] - self.sequences.fluxes.qkap[k]))
    cpdef inline void calc_qigz1_v1(self)  nogil:
        cdef int k
        self.sequences.states.qigz1 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.states.qigz1 = self.sequences.states.qigz1 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib1[k])
    cpdef inline void calc_qigz2_v1(self)  nogil:
        cdef int k
        self.sequences.states.qigz2 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.states.qigz2 = self.sequences.states.qigz2 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib2[k])
    cpdef inline void calc_qdgz_v1(self)  nogil:
        cdef int k
        self.sequences.fluxes.qdgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == FLUSS:
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, SEE):
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * self.sequences.fluxes.qdb[k])
    cpdef inline void calc_qbga_v1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kb <= 0.0:
            self.sequences.new_states.qbga = self.sequences.new_states.qbgz
        elif self.parameters.derived.kb > 1e200:
            self.sequences.new_states.qbga = self.sequences.old_states.qbga + self.sequences.new_states.qbgz - self.sequences.old_states.qbgz
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kb)
            self.sequences.new_states.qbga = (                self.sequences.old_states.qbga                + (self.sequences.old_states.qbgz - self.sequences.old_states.qbga) * d_temp                + (self.sequences.new_states.qbgz - self.sequences.old_states.qbgz) * (1.0 - self.parameters.derived.kb * d_temp)            )
    cpdef inline void update_qdgz_qbgz_qbga_v1(self)  nogil:
        cdef double d_qbgz_adj
        cdef double d_temp
        if self.sequences.new_states.qbga > self.parameters.derived.qbgamax:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kb)
            d_qbgz_adj = self.sequences.old_states.qbgz + (                (self.parameters.derived.qbgamax - self.sequences.old_states.qbga - (self.sequences.old_states.qbgz - self.sequences.old_states.qbga) * d_temp)                / (1.0 - self.parameters.derived.kb * d_temp)            )
            self.sequences.new_states.qbga = self.parameters.derived.qbgamax
            self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.sequences.new_states.qbgz - d_qbgz_adj)
            self.sequences.new_states.qbgz = d_qbgz_adj
    cpdef inline void update_qdgz_qbgz_qbga_v2(self)  nogil:
        cdef double d_qbgz_exc
        cdef double d_grad
        d_grad = self.parameters.derived.kb * (self.sequences.new_states.qbga - self.sequences.old_states.qbga)
        if d_grad > self.parameters.control.gsbgrad1:
            if d_grad < self.parameters.control.gsbgrad2:
                d_qbgz_exc = self.sequences.new_states.qbgz * (                    (d_grad - self.parameters.control.gsbgrad1) / (self.parameters.control.gsbgrad2 - self.parameters.control.gsbgrad1)                )
            else:
                d_qbgz_exc = self.sequences.new_states.qbgz
            self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (d_qbgz_exc)
            self.sequences.new_states.qbgz = self.sequences.new_states.qbgz - (d_qbgz_exc)
            self.calc_qbga_v1()
    cpdef inline void calc_qiga1_v1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.ki1 <= 0.0:
            self.sequences.new_states.qiga1 = self.sequences.new_states.qigz1
        elif self.parameters.derived.ki1 > 1e200:
            self.sequences.new_states.qiga1 = self.sequences.old_states.qiga1 + self.sequences.new_states.qigz1 - self.sequences.old_states.qigz1
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.ki1)
            self.sequences.new_states.qiga1 = (                self.sequences.old_states.qiga1                + (self.sequences.old_states.qigz1 - self.sequences.old_states.qiga1) * d_temp                + (self.sequences.new_states.qigz1 - self.sequences.old_states.qigz1) * (1.0 - self.parameters.derived.ki1 * d_temp)            )
    cpdef inline void calc_qiga2_v1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.ki2 <= 0.0:
            self.sequences.new_states.qiga2 = self.sequences.new_states.qigz2
        elif self.parameters.derived.ki2 > 1e200:
            self.sequences.new_states.qiga2 = self.sequences.old_states.qiga2 + self.sequences.new_states.qigz2 - self.sequences.old_states.qigz2
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.ki2)
            self.sequences.new_states.qiga2 = (                self.sequences.old_states.qiga2                + (self.sequences.old_states.qigz2 - self.sequences.old_states.qiga2) * d_temp                + (self.sequences.new_states.qigz2 - self.sequences.old_states.qigz2) * (1.0 - self.parameters.derived.ki2 * d_temp)            )
    cpdef inline void calc_qdgz1_qdgz2_v1(self)  nogil:
        if self.sequences.fluxes.qdgz > self.parameters.control.a2:
            self.sequences.states.qdgz2 = (self.sequences.fluxes.qdgz - self.parameters.control.a2) ** 2 / (self.sequences.fluxes.qdgz + self.parameters.control.a1 - self.parameters.control.a2)
            self.sequences.states.qdgz1 = self.sequences.fluxes.qdgz - self.sequences.states.qdgz2
        else:
            self.sequences.states.qdgz2 = 0.0
            self.sequences.states.qdgz1 = self.sequences.fluxes.qdgz
    cpdef inline void calc_qdga1_v1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kd1 <= 0.0:
            self.sequences.new_states.qdga1 = self.sequences.new_states.qdgz1
        elif self.parameters.derived.kd1 > 1e200:
            self.sequences.new_states.qdga1 = self.sequences.old_states.qdga1 + self.sequences.new_states.qdgz1 - self.sequences.old_states.qdgz1
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kd1)
            self.sequences.new_states.qdga1 = (                self.sequences.old_states.qdga1                + (self.sequences.old_states.qdgz1 - self.sequences.old_states.qdga1) * d_temp                + (self.sequences.new_states.qdgz1 - self.sequences.old_states.qdgz1) * (1.0 - self.parameters.derived.kd1 * d_temp)            )
    cpdef inline void calc_qdga2_v1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kd2 <= 0.0:
            self.sequences.new_states.qdga2 = self.sequences.new_states.qdgz2
        elif self.parameters.derived.kd2 > 1e200:
            self.sequences.new_states.qdga2 = self.sequences.old_states.qdga2 + self.sequences.new_states.qdgz2 - self.sequences.old_states.qdgz2
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kd2)
            self.sequences.new_states.qdga2 = (                self.sequences.old_states.qdga2                + (self.sequences.old_states.qdgz2 - self.sequences.old_states.qdga2) * d_temp                + (self.sequences.new_states.qdgz2 - self.sequences.old_states.qdgz2) * (1.0 - self.parameters.derived.kd2 * d_temp)            )
    cpdef inline void calc_qah_v1(self)  nogil:
        cdef double d_epw
        cdef int k
        cdef double d_area
        self.sequences.fluxes.qah = self.sequences.fluxes.qzh + self.sequences.states.qbga + self.sequences.states.qiga1 + self.sequences.states.qiga2 + self.sequences.states.qdga1 + self.sequences.states.qdga2
        if (not self.parameters.control.negq) and (self.sequences.fluxes.qah < 0.0):
            d_area = 0.0
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] in (FLUSS, SEE):
                    d_area = d_area + (self.parameters.control.fhru[k])
            if d_area > 0.0:
                for k in range(self.parameters.control.nhru):
                    if self.parameters.control.lnk[k] in (FLUSS, SEE):
                        self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] + (self.sequences.fluxes.qah / d_area)
            self.sequences.fluxes.qah = 0.0
        d_epw = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qah = self.sequences.fluxes.qah + (self.parameters.control.fhru[k] * self.sequences.fluxes.nkor[k])
                d_epw = d_epw + (self.parameters.control.fhru[k] * self.sequences.fluxes.evi[k])
        if (self.sequences.fluxes.qah > d_epw) or self.parameters.control.negq:
            self.sequences.fluxes.qah = self.sequences.fluxes.qah - (d_epw)
        elif d_epw > 0.0:
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] == WASSER:
                    self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] * (self.sequences.fluxes.qah / d_epw)
            self.sequences.fluxes.qah = 0.0
    cpdef inline void calc_qa_v1(self)  nogil:
        self.sequences.fluxes.qa = self.parameters.derived.qfactor * self.sequences.fluxes.qah
    cpdef inline void calc_qzh(self)  nogil:
        self.sequences.fluxes.qzh = self.sequences.fluxes.qz / self.parameters.derived.qfactor
    cpdef inline void update_loggedteml(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedteml[idx] = self.sequences.logs.loggedteml[idx - 1]
        self.sequences.logs.loggedteml[0] = self.sequences.inputs.teml
    cpdef inline void calc_temltag(self)  nogil:
        cdef int idx
        self.sequences.fluxes.temltag = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.temltag = self.sequences.fluxes.temltag + (self.sequences.logs.loggedteml[idx])
        self.sequences.fluxes.temltag = self.sequences.fluxes.temltag / (self.parameters.derived.nmblogentries)
    cpdef inline void update_loggedrelativehumidity(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedrelativehumidity[idx] = self.sequences.logs.loggedrelativehumidity[idx - 1]
        self.sequences.logs.loggedrelativehumidity[0] = self.sequences.inputs.relativehumidity
    cpdef inline void calc_dailyrelativehumidity(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailyrelativehumidity = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailyrelativehumidity = self.sequences.fluxes.dailyrelativehumidity + (self.sequences.logs.loggedrelativehumidity[idx])
        self.sequences.fluxes.dailyrelativehumidity = self.sequences.fluxes.dailyrelativehumidity / (self.parameters.derived.nmblogentries)
    cpdef inline void update_loggedsunshineduration(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedsunshineduration[idx] = self.sequences.logs.loggedsunshineduration[idx - 1]
        self.sequences.logs.loggedsunshineduration[0] = self.sequences.inputs.sunshineduration
    cpdef inline void calc_nkor(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.nkor[k] = self.parameters.control.kg[k] * self.sequences.inputs.nied
    cpdef inline void calc_tkor(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.tkor[k] = self.parameters.control.kt[k] + self.sequences.inputs.teml
    cpdef inline void calc_tkortag(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.tkortag[k] = self.parameters.control.kt[k] + self.sequences.fluxes.temltag
    cpdef inline void calc_windspeed2m(self)  nogil:
        self.sequences.fluxes.windspeed2m = self.return_adjustedwindspeed_v1(2.0)
    cpdef inline void calc_reducedwindspeed2m(self)  nogil:
        cdef double d_lai
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                self.sequences.fluxes.reducedwindspeed2m[k] = (                    max(self.parameters.control.p1wind - self.parameters.control.p2wind * d_lai, 0.0) * self.sequences.fluxes.windspeed2m                )
            else:
                self.sequences.fluxes.reducedwindspeed2m[k] = self.sequences.fluxes.windspeed2m
    cpdef inline void update_loggedwindspeed2m(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedwindspeed2m[idx] = self.sequences.logs.loggedwindspeed2m[idx - 1]
        self.sequences.logs.loggedwindspeed2m[0] = self.sequences.fluxes.windspeed2m
    cpdef inline void calc_dailywindspeed2m(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailywindspeed2m = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailywindspeed2m = self.sequences.fluxes.dailywindspeed2m + (self.sequences.logs.loggedwindspeed2m[idx])
        self.sequences.fluxes.dailywindspeed2m = self.sequences.fluxes.dailywindspeed2m / (self.parameters.derived.nmblogentries)
    cpdef inline void calc_windspeed10m(self)  nogil:
        self.sequences.fluxes.windspeed10m = self.return_adjustedwindspeed_v1(10.0)
    cpdef inline void calc_solardeclination(self)  nogil:
        self.sequences.fluxes.solardeclination = 0.41 * cos(            2.0 * self.parameters.fixed.pi * (self.parameters.derived.doy[self.idx_sim] - 171.0) / 365.0        )
    cpdef inline void calc_tsa_tsu(self)  nogil:
        cdef double d_dt
        self.sequences.fluxes.tsa = (            12.0            / self.parameters.fixed.pi            * acos(                tan(self.sequences.fluxes.solardeclination) * tan(self.parameters.derived.latituderad)                + 0.0145                / cos(self.sequences.fluxes.solardeclination)                / cos(self.parameters.derived.latituderad)            )        )
        self.sequences.fluxes.tsu = 24.0 - self.sequences.fluxes.tsa
        d_dt = (self.parameters.derived.utclongitude - self.parameters.control.longitude) * 4.0 / 60.0
        self.sequences.fluxes.tsa = self.sequences.fluxes.tsa + (d_dt)
        self.sequences.fluxes.tsu = self.sequences.fluxes.tsu + (d_dt)
    cpdef inline void calc_dailysunshineduration(self)  nogil:
        cdef int idx
        self.sequences.fluxes.dailysunshineduration = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            self.sequences.fluxes.dailysunshineduration = self.sequences.fluxes.dailysunshineduration + (self.sequences.logs.loggedsunshineduration[idx])
    cpdef inline void calc_earthsundistance(self)  nogil:
        self.sequences.fluxes.earthsundistance = 1.0 + 0.033 * cos(            2 * self.parameters.fixed.pi / 366.0 * (self.parameters.derived.doy[self.idx_sim] + 1)        )
    cpdef inline void calc_extraterrestrialradiation(self)  nogil:
        cdef double d_sunsethourangle
        d_sunsethourangle = (self.sequences.fluxes.tsu - self.sequences.fluxes.tsa) * self.parameters.fixed.pi / 24.0
        self.sequences.fluxes.extraterrestrialradiation = (            self.parameters.fixed.sol            * self.sequences.fluxes.earthsundistance            / self.parameters.fixed.pi            * (                d_sunsethourangle                * sin(self.sequences.fluxes.solardeclination)                * sin(self.parameters.derived.latituderad)                + cos(self.sequences.fluxes.solardeclination)                * cos(self.parameters.derived.latituderad)                * sin(d_sunsethourangle)            )        )
    cpdef inline void calc_possiblesunshineduration(self)  nogil:
        cdef double d_t1
        cdef double d_t0
        cdef double d_tc
        d_tc = self.parameters.derived.sct[self.idx_sim]
        d_t0 = max((d_tc - self.parameters.derived.hours / 2.0), self.sequences.fluxes.tsa)
        d_t1 = min((d_tc + self.parameters.derived.hours / 2.0), self.sequences.fluxes.tsu)
        self.sequences.fluxes.possiblesunshineduration = max(d_t1 - d_t0, 0.0)
    cpdef inline void calc_dailypossiblesunshineduration(self)  nogil:
        self.sequences.fluxes.dailypossiblesunshineduration = self.sequences.fluxes.tsu - self.sequences.fluxes.tsa
    cpdef inline void calc_sp(self)  nogil:
        cdef double d_temp
        cdef double d_sp
        cdef double d_tlp
        cdef double d_dt
        cdef int i
        cdef double d_fac
        d_fac = 2.0 * self.parameters.fixed.pi / 360.0
        self.sequences.fluxes.sp = 0.0
        for i in range(2):
            if i:
                d_dt = self.parameters.derived.hours / 2.0
            else:
                d_dt = -self.parameters.derived.hours / 2.0
            d_tlp = (                100.0                * d_fac                * ((self.parameters.derived.sct[self.idx_sim] + d_dt - self.sequences.fluxes.tsa) / (self.sequences.fluxes.tsu - self.sequences.fluxes.tsa))            )
            if d_tlp <= 0.0:
                d_sp = 0.0
            elif d_tlp < 100.0 * d_fac:
                d_sp = 50.0 - 50.0 * cos(1.8 * d_tlp)
                d_temp = 3.4 * sin(3.6 * d_tlp) ** 2
                if d_tlp <= 50.0 * d_fac:
                    d_sp = d_sp - (d_temp)
                else:
                    d_sp = d_sp + (d_temp)
            else:
                d_sp = 100.0
            if i:
                self.sequences.fluxes.sp = self.sequences.fluxes.sp + (d_sp)
            else:
                self.sequences.fluxes.sp = self.sequences.fluxes.sp - (d_sp)
    cpdef inline void calc_globalradiation(self)  nogil:
        cdef double d_pos
        cdef double d_act
        if self.sequences.fluxes.possiblesunshineduration > 0.0:
            d_act = self.sequences.inputs.sunshineduration
            d_pos = self.sequences.fluxes.possiblesunshineduration
        else:
            d_act = self.sequences.fluxes.dailysunshineduration
            d_pos = self.sequences.fluxes.dailypossiblesunshineduration
        self.sequences.fluxes.globalradiation = (            self.sequences.fluxes.sp / 100.0 * self.return_dailyglobalradiation_v1(d_act, d_pos)        )
    cpdef inline void update_loggedglobalradiation(self)  nogil:
        cdef int idx
        for idx in range(self.parameters.derived.nmblogentries - 1, 0, -1):
            self.sequences.logs.loggedglobalradiation[idx] = self.sequences.logs.loggedglobalradiation[idx - 1]
        self.sequences.logs.loggedglobalradiation[0] = self.sequences.fluxes.globalradiation
    cpdef inline void calc_dailyglobalradiation(self)  nogil:
        self.sequences.fluxes.dailyglobalradiation = self.return_dailyglobalradiation_v1(            self.sequences.fluxes.dailysunshineduration, self.sequences.fluxes.dailypossiblesunshineduration        )
    cpdef inline void calc_adjustedglobalradiation(self)  nogil:
        cdef int idx
        cdef double d_glob_sum
        d_glob_sum = 0.0
        for idx in range(self.parameters.derived.nmblogentries):
            d_glob_sum = d_glob_sum + (self.sequences.logs.loggedglobalradiation[idx])
        self.sequences.fluxes.adjustedglobalradiation = (            self.sequences.fluxes.globalradiation * self.sequences.fluxes.dailyglobalradiation / d_glob_sum        )
    cpdef inline void calc_saturationvapourpressure(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.saturationvapourpressure[k] = self.return_saturationvapourpressure_v1(                self.sequences.fluxes.tkor[k]            )
    cpdef inline void calc_dailysaturationvapourpressure(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailysaturationvapourpressure[                k            ] = self.return_saturationvapourpressure_v1(self.sequences.fluxes.tkortag[k])
    cpdef inline void calc_saturationvapourpressureslope(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.saturationvapourpressureslope[                k            ] = self.return_saturationvapourpressureslope_v1(self.sequences.fluxes.tkor[k])
    cpdef inline void calc_dailysaturationvapourpressureslope(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailysaturationvapourpressureslope[                k            ] = self.return_saturationvapourpressureslope_v1(self.sequences.fluxes.tkortag[k])
    cpdef inline void calc_actualvapourpressure(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.actualvapourpressure[k] = self.return_actualvapourpressure_v1(                self.sequences.fluxes.saturationvapourpressure[k], self.sequences.inputs.relativehumidity            )
    cpdef inline void calc_dailyactualvapourpressure(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailyactualvapourpressure[k] = self.return_actualvapourpressure_v1(                self.sequences.fluxes.dailysaturationvapourpressure[k],                self.sequences.fluxes.dailyrelativehumidity,            )
    cpdef inline void calc_nbes_inzp(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.nbes[k] = 0.0
                self.sequences.states.inzp[k] = 0.0
            else:
                self.sequences.fluxes.nbes[k] = max(                    self.sequences.fluxes.nkor[k]                    + self.sequences.states.inzp[k]                    - self.parameters.derived.kinz[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]],                    0.0,                )
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] + (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.nbes[k])
    cpdef inline void calc_snratio(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.fluxes.tkor[k] >= (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 0.0
            elif self.sequences.fluxes.tkor[k] <= (self.parameters.control.tgr[k] - self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 1.0
            else:
                self.sequences.aides.snratio[k] = (                    (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0) - self.sequences.fluxes.tkor[k]                ) / self.parameters.control.tsp[k]
    cpdef inline void calc_sbes(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.sbes[k] = self.sequences.aides.snratio[k] * self.sequences.fluxes.nbes[k]
    cpdef inline void calc_snowintmax(self)  nogil:
        cdef double d_lai
        cdef int k
        cdef int idx
        idx = self.parameters.derived.moy[self.idx_sim]
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, idx]
                self.sequences.fluxes.snowintmax[k] = self.parameters.control.p1simax + self.parameters.control.p2simax * d_lai
                if self.sequences.fluxes.tkor[k] >= -1.0:
                    self.sequences.fluxes.snowintmax[k] = self.sequences.fluxes.snowintmax[k] * (2)
                elif self.sequences.fluxes.tkor[k] > -3.0:
                    self.sequences.fluxes.snowintmax[k] = self.sequences.fluxes.snowintmax[k] * (2.5 + 0.5 * self.sequences.fluxes.tkor[k])
            else:
                self.sequences.fluxes.snowintmax[k] = 0.0
    cpdef inline void calc_snowintrate(self)  nogil:
        cdef double d_lai
        cdef int k
        cdef int idx
        idx = self.parameters.derived.moy[self.idx_sim]
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, idx]
                self.sequences.fluxes.snowintrate[k] = min(                    self.parameters.control.p1sirate + self.parameters.control.p2sirate * d_lai + self.parameters.control.p3sirate * self.sequences.states.sinz[k],                    1.0,                )
            else:
                self.sequences.fluxes.snowintrate[k] = 0.0
    cpdef inline void calc_nbesinz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.fluxes.nbesinz[k] = min(                    self.sequences.fluxes.snowintrate[k] * self.sequences.fluxes.nbes[k],                    max(self.sequences.fluxes.snowintmax[k] - self.sequences.states.sinz[k], 0.0),                )
            else:
                self.sequences.fluxes.nbesinz[k] = 0.0
    cpdef inline void calc_sbesinz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.fluxes.sbesinz[k] = self.sequences.aides.snratio[k] * self.sequences.fluxes.nbesinz[k]
            else:
                self.sequences.fluxes.sbesinz[k] = 0.0
    cpdef inline void calc_stinz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.states.stinz[k] = self.sequences.states.stinz[k] + (self.sequences.fluxes.sbesinz[k])
            else:
                self.sequences.states.stinz[k] = 0.0
    cpdef inline void calc_wadainz_sinz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.states.sinz[k] = self.sequences.states.sinz[k] + (self.sequences.fluxes.nbesinz[k])
                self.sequences.fluxes.wadainz[k] = max(self.sequences.states.sinz[k] - self.parameters.control.pwmax[k] * self.sequences.states.stinz[k], 0.0)
                self.sequences.states.sinz[k] = self.sequences.states.sinz[k] - (self.sequences.fluxes.wadainz[k])
            else:
                self.sequences.fluxes.wadainz[k] = 0.0
                self.sequences.states.sinz[k] = 0.0
    cpdef inline void calc_wniedinz_esnowinz(self)  nogil:
        cdef double d_water
        cdef double d_ice
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_ice = self.parameters.fixed.cpeis * self.sequences.fluxes.sbesinz[k]
                d_water = self.parameters.fixed.cpwasser * (                    self.sequences.fluxes.nbesinz[k] - self.sequences.fluxes.sbesinz[k] - self.sequences.fluxes.wadainz[k]                )
                self.sequences.fluxes.wniedinz[k] = (self.sequences.fluxes.tkor[k] - self.parameters.control.trefn[k]) * (d_ice + d_water)
                self.sequences.states.esnowinz[k] = self.sequences.states.esnowinz[k] + (self.sequences.fluxes.wniedinz[k])
            else:
                self.sequences.fluxes.wniedinz[k] = 0.0
                self.sequences.states.esnowinz[k] = 0.0
    cpdef inline void calc_tempsinz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.aides.tempsinz[k] = self.return_tempsinz_v1(k)
    cpdef inline void update_asinz(self)  nogil:
        cdef double d_r2
        cdef double d_r1
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.sinz[k] > 0:
                if isnan(self.sequences.states.asinz[k]):
                    self.sequences.states.asinz[k] = 0.0
                d_r1 = exp(                    5000.0 * (1 / 273.15 - 1.0 / (273.15 + self.sequences.aides.tempsinz[k]))                )
                d_r2 = min(d_r1 ** 10, 1.0)
                self.sequences.states.asinz[k] = self.sequences.states.asinz[k] * (max(1 - 0.1 * self.sequences.fluxes.sbesinz[k], 0.0))
                self.sequences.states.asinz[k] = self.sequences.states.asinz[k] + ((d_r1 + d_r2 + 0.03) / 1e6 * self.parameters.derived.seconds)
            else:
                self.sequences.states.asinz[k] = nan
    cpdef inline void calc_actualalbedoinz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.sinz[k] > 0.0:
                self.sequences.fluxes.actualalbedoinz[k] = self.parameters.control.albedo0snow * (                    1.0 - self.parameters.control.snowagingfactor * self.sequences.states.asinz[k] / (1.0 + self.sequences.states.asinz[k])                )
            else:
                self.sequences.fluxes.actualalbedoinz[k] = nan
    cpdef inline void calc_netshortwaveradiationinz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.fluxes.netshortwaveradiationinz[k] = (                    (1.0 - self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]])                    * (1.0 - self.sequences.fluxes.actualalbedoinz[k])                    * self.sequences.fluxes.adjustedglobalradiation                )
            else:
                self.sequences.fluxes.netshortwaveradiationinz[k] = 0.0
    cpdef inline void calc_rlatm(self)  nogil:
        cdef double d_t
        cdef int k
        cdef double d_common
        cdef double d_rs
        d_rs = self.sequences.fluxes.dailysunshineduration / self.sequences.fluxes.dailypossiblesunshineduration
        d_common = self.parameters.fixed.fratm * self.parameters.fixed.sigma * self.parameters.derived.days * (1.0 + 0.22 * (1.0 - d_rs) ** 2)
        for k in range(self.parameters.control.nhru):
            d_t = self.sequences.fluxes.tkor[k] + 273.15
            self.sequences.aides.rlatm[k] = d_common * (                d_t ** 4 * (self.sequences.fluxes.actualvapourpressure[k] * 10.0 / d_t) ** (1.0 / 7.0)            )
    cpdef inline void calc_schmpotinz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.sinz[k] > 0.0:
                self.sequences.fluxes.schmpotinz[k] = max(self.sequences.states.esnowinz[k] / self.parameters.fixed.rschmelz, 0.0)
            else:
                self.sequences.fluxes.schmpotinz[k] = 0.0
    cpdef inline void calc_schminz_stinz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.fluxes.schminz[k] = min(self.sequences.fluxes.schmpotinz[k], self.sequences.states.stinz[k])
                self.sequences.states.stinz[k] = self.sequences.states.stinz[k] - (self.sequences.fluxes.schminz[k])
            else:
                self.sequences.fluxes.schminz[k] = 0.0
    cpdef inline void calc_gefrpotinz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.sinz[k] > 0:
                self.sequences.fluxes.gefrpotinz[k] = max(-self.sequences.states.esnowinz[k] / self.parameters.fixed.rschmelz, 0)
            else:
                self.sequences.fluxes.gefrpotinz[k] = 0.0
    cpdef inline void calc_gefrinz_stinz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW) and self.parameters.control.refreezeflag:
                self.sequences.fluxes.gefrinz[k] = min(self.sequences.fluxes.gefrpotinz[k], (self.sequences.states.sinz[k] - self.sequences.states.stinz[k]))
                self.sequences.states.stinz[k] = self.sequences.states.stinz[k] + (self.sequences.fluxes.gefrinz[k])
            else:
                self.sequences.fluxes.gefrinz[k] = 0.0
    cpdef inline void calc_evsinz_sinz_stinz(self)  nogil:
        cdef double d_frac
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW) and (self.sequences.states.sinz[k] > 0.0):
                self.sequences.fluxes.evsinz[k] = min(self.sequences.fluxes.wlatinz[k] / self.parameters.fixed.lwe, self.sequences.states.sinz[k])
                d_frac = (self.sequences.states.sinz[k] - self.sequences.fluxes.evsinz[k]) / self.sequences.states.sinz[k]
                self.sequences.states.sinz[k] = self.sequences.states.sinz[k] * (d_frac)
                self.sequences.states.stinz[k] = self.sequences.states.stinz[k] * (d_frac)
            else:
                self.sequences.fluxes.evsinz[k] = 0.0
                self.sequences.states.sinz[k] = 0.0
                self.sequences.states.stinz[k] = 0.0
    cpdef inline void update_wadainz_sinz(self)  nogil:
        cdef double d_wadainz_corr
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                d_wadainz_corr = max(self.sequences.states.sinz[k] - self.parameters.control.pwmax[k] * self.sequences.states.stinz[k], 0.0)
                self.sequences.fluxes.wadainz[k] = self.sequences.fluxes.wadainz[k] + (d_wadainz_corr)
                self.sequences.states.sinz[k] = self.sequences.states.sinz[k] - (d_wadainz_corr)
    cpdef inline void calc_wats(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.wats[k] = 0.0
            elif self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.sbes[k] - self.sequences.fluxes.sbesinz[k])
            else:
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.sbes[k])
    cpdef inline void calc_wada_waes(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.waes[k] = 0.0
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.nbes[k] - self.sequences.fluxes.nbesinz[k] + self.sequences.fluxes.wadainz[k]
            if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                self.sequences.states.waes[k] = self.sequences.states.waes[k] + (self.sequences.fluxes.nbes[k])
                self.sequences.fluxes.wada[k] = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (self.sequences.fluxes.wada[k])
            else:
                self.sequences.states.waes[k] = self.sequences.states.waes[k] + (self.sequences.fluxes.nbes[k] - self.sequences.fluxes.nbesinz[k] + self.sequences.fluxes.wadainz[k])
                self.sequences.fluxes.wada[k] = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (self.sequences.fluxes.wada[k])
    cpdef inline void calc_wnied_esnow(self)  nogil:
        cdef double d_water
        cdef double d_ice
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.wnied[k] = 0.0
                self.sequences.states.esnow[k] = 0.0
            else:
                d_ice = self.parameters.fixed.cpeis * self.sequences.fluxes.sbes[k]
                d_water = self.parameters.fixed.cpwasser * (self.sequences.fluxes.nbes[k] - self.sequences.fluxes.sbes[k] - self.sequences.fluxes.wada[k])
                self.sequences.fluxes.wnied[k] = (self.sequences.fluxes.tkor[k] - self.parameters.control.trefn[k]) * (d_ice + d_water)
                self.sequences.states.esnow[k] = self.sequences.states.esnow[k] + (self.sequences.fluxes.wnied[k])
    cpdef inline void calc_temps(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.aides.temps[k] = self.return_temps_v1(k)
    cpdef inline void update_taus(self)  nogil:
        cdef double d_r2
        cdef double d_r1
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0:
                if isnan(self.sequences.states.taus[k]):
                    self.sequences.states.taus[k] = 0.0
                d_r1 = exp(                    5000.0 * (1 / 273.15 - 1.0 / (273.15 + self.sequences.aides.temps[k]))                )
                d_r2 = min(d_r1 ** 10, 1.0)
                self.sequences.states.taus[k] = self.sequences.states.taus[k] * (max(1 - 0.1 * self.sequences.fluxes.sbes[k], 0.0))
                self.sequences.states.taus[k] = self.sequences.states.taus[k] + ((d_r1 + d_r2 + 0.03) / 1e6 * self.parameters.derived.seconds)
            else:
                self.sequences.states.taus[k] = nan
    cpdef inline void calc_actualalbedo(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0.0:
                self.sequences.fluxes.actualalbedo[k] = self.parameters.control.albedo0snow * (                    1.0 - self.parameters.control.snowagingfactor * self.sequences.states.taus[k] / (1.0 + self.sequences.states.taus[k])                )
            else:
                self.sequences.fluxes.actualalbedo[k] = self.parameters.control.albedo[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
    cpdef inline void calc_netshortwaveradiationsnow(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netshortwaveradiationsnow[k] = (                self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]                * (1.0 - self.sequences.fluxes.actualalbedo[k])                * self.sequences.fluxes.adjustedglobalradiation            )
    cpdef inline void calc_tz(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.tz[k] = nan
            elif self.sequences.states.ebdn[k] < 0.0:
                self.sequences.fluxes.tz[k] = self.sequences.states.ebdn[k] / (2.0 * self.parameters.fixed.z * self.parameters.fixed.cg)
            elif self.sequences.states.ebdn[k] < self.parameters.derived.heatoffusion[k]:
                self.sequences.fluxes.tz[k] = 0.0
            else:
                self.sequences.fluxes.tz[k] = (self.sequences.states.ebdn[k] - self.parameters.derived.heatoffusion[k]) / (2.0 * self.parameters.fixed.z * self.parameters.fixed.cg)
    cpdef inline void calc_wg(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (FLUSS, SEE, WASSER):
                self.sequences.fluxes.wg[k] = 0.0
            else:
                self.sequences.fluxes.wg[k] = self.return_wg_v1(k)
    cpdef inline void calc_schmpot(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0.0:
                self.sequences.fluxes.schmpot[k] = max(self.sequences.states.esnow[k] / self.parameters.fixed.rschmelz, 0.0)
            else:
                self.sequences.fluxes.schmpot[k] = 0.0
    cpdef inline void calc_schm_wats(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.schm[k] = 0.0
            else:
                self.sequences.fluxes.schm[k] = min(self.sequences.fluxes.schmpot[k], self.sequences.states.wats[k])
                self.sequences.states.wats[k] = self.sequences.states.wats[k] - (self.sequences.fluxes.schm[k])
    cpdef inline void calc_gefrpot(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.sequences.states.waes[k] > 0:
                self.sequences.fluxes.gefrpot[k] = max(-self.sequences.states.esnow[k] / self.parameters.fixed.rschmelz, 0)
            else:
                self.sequences.fluxes.gefrpot[k] = 0.0
    cpdef inline void calc_gefr_wats(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE) or not self.parameters.control.refreezeflag:
                self.sequences.fluxes.gefr[k] = 0.0
            else:
                self.sequences.fluxes.gefr[k] = min(self.sequences.fluxes.gefrpot[k], (self.sequences.states.waes[k] - self.sequences.states.wats[k]))
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.gefr[k])
    cpdef inline void calc_evs_waes_wats(self)  nogil:
        cdef double d_frac
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, SEE, FLUSS) or (self.sequences.states.waes[k] <= 0.0):
                self.sequences.fluxes.evs[k] = 0.0
                self.sequences.states.waes[k] = 0.0
                self.sequences.states.wats[k] = 0.0
            else:
                self.sequences.fluxes.evs[k] = min(self.sequences.fluxes.wlatsnow[k] / self.parameters.fixed.lwe, self.sequences.states.waes[k])
                d_frac = (self.sequences.states.waes[k] - self.sequences.fluxes.evs[k]) / self.sequences.states.waes[k]
                self.sequences.states.waes[k] = self.sequences.states.waes[k] * (d_frac)
                self.sequences.states.wats[k] = self.sequences.states.wats[k] * (d_frac)
    cpdef inline void update_wada_waes(self)  nogil:
        cdef double d_wada_corr
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] not in (WASSER, FLUSS, SEE):
                d_wada_corr = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] + (d_wada_corr)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (d_wada_corr)
    cpdef inline void calc_netshortwaveradiation(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netshortwaveradiation[k] = (                1.0 - self.sequences.fluxes.actualalbedo[k]            ) * self.sequences.fluxes.adjustedglobalradiation
    cpdef inline void calc_dailynetshortwaveradiation(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailynetshortwaveradiation[k] = (                1.0 - self.sequences.fluxes.actualalbedo[k]            ) * self.sequences.fluxes.dailyglobalradiation
    cpdef inline void calc_dailynetlongwaveradiation(self)  nogil:
        cdef double d_temp
        cdef int k
        cdef double d_relsunshine
        d_relsunshine = self.sequences.fluxes.dailysunshineduration / self.sequences.fluxes.dailypossiblesunshineduration
        for k in range(self.parameters.control.nhru):
            d_temp = self.sequences.fluxes.tkortag[k] + 273.15
            self.sequences.fluxes.dailynetlongwaveradiation[k] = (                (0.2 + 0.8 * d_relsunshine)                * self.parameters.fixed.sigma                * d_temp ** 4                * (                    self.parameters.control.emissivity                    - self.parameters.fixed.fratm                    * (self.sequences.fluxes.dailyactualvapourpressure[k] * 10.0 / d_temp) ** (1.0 / 7.0)                )            )
    cpdef inline void calc_netradiation(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.netradiation[k] = self.return_netradiation_v1(                self.sequences.fluxes.netshortwaveradiation[k],                self.sequences.fluxes.dailynetlongwaveradiation[k] * self.parameters.derived.days,            )
    cpdef inline void calc_dailynetradiation(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dailynetradiation[k] = self.return_netradiation_v1(                self.sequences.fluxes.dailynetshortwaveradiation[k],                self.sequences.fluxes.dailynetlongwaveradiation[k],            )
    cpdef inline void calc_dryairpressure(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.dryairpressure[k] = (                self.sequences.inputs.atmosphericpressure - self.sequences.fluxes.actualvapourpressure[k]            )
    cpdef inline void calc_densityair(self)  nogil:
        cdef double d_t
        cdef int k
        for k in range(self.parameters.control.nhru):
            d_t = self.sequences.fluxes.tkor[k] + 273.15
            self.sequences.fluxes.densityair[k] = self.sequences.fluxes.dryairpressure[k] / (                self.parameters.fixed.rdryair * d_t            ) + self.sequences.fluxes.actualvapourpressure[k] / (self.parameters.fixed.rwatervapour * d_t)
    cpdef inline void calc_aerodynamicresistance(self)  nogil:
        cdef double d_z0
        cdef double d_ch
        cdef int k
        if self.sequences.fluxes.windspeed10m > 0.0:
            for k in range(self.parameters.control.nhru):
                d_ch = self.parameters.control.cropheight[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                if d_ch < 10.0:
                    d_z0 = 0.021 + 0.163 * d_ch
                    self.sequences.fluxes.aerodynamicresistance[k] = (                        6.25 / self.sequences.fluxes.windspeed10m * log(10.0 / d_z0) ** 2                    )
                else:
                    self.sequences.fluxes.aerodynamicresistance[k] = 94.0 / self.sequences.fluxes.windspeed10m
        else:
            for k in range(self.parameters.control.nhru):
                self.sequences.fluxes.aerodynamicresistance[k] = inf
    cpdef inline void calc_soilsurfaceresistance(self)  nogil:
        cdef double d_free
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, FLUSS, SEE, WASSER):
                self.sequences.fluxes.soilsurfaceresistance[k] = nan
            elif self.parameters.derived.nfk[k] > 20.0:
                self.sequences.fluxes.soilsurfaceresistance[k] = 100.0
            elif self.parameters.derived.nfk[k] > 0.0:
                d_free = min(max(self.sequences.states.bowa[k] - self.parameters.control.pwp[k], 0.0), self.parameters.derived.nfk[k])
                self.sequences.fluxes.soilsurfaceresistance[k] = (                    100.0 * self.parameters.derived.nfk[k] / (d_free + 0.01 * self.parameters.derived.nfk[k])                )
            else:
                self.sequences.fluxes.soilsurfaceresistance[k] = inf
    cpdef inline void calc_landusesurfaceresistance(self)  nogil:
        cdef double d_def
        cdef double d_res
        cdef int k
        for k in range(self.parameters.control.nhru):
            d_res = self.parameters.control.surfaceresistance[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
            if self.parameters.control.lnk[k] == NADELW:
                d_def = self.sequences.fluxes.saturationvapourpressure[k] - self.sequences.fluxes.actualvapourpressure[k]
                if (self.sequences.fluxes.tkor[k] <= -5.0) or (d_def >= 2.0):
                    self.sequences.fluxes.landusesurfaceresistance[k] = 10000.0
                elif self.sequences.fluxes.tkor[k] < 20.0:
                    self.sequences.fluxes.landusesurfaceresistance[k] = min(                        (25.0 * d_res) / (self.sequences.fluxes.tkor[k] + 5.0) / (1.0 - 0.5 * d_def),                        10000.0,                    )
                else:
                    self.sequences.fluxes.landusesurfaceresistance[k] = min(                        d_res / (1.0 - 0.5 * d_def), 10000.0                    )
            else:
                self.sequences.fluxes.landusesurfaceresistance[k] = d_res
            if self.parameters.control.lnk[k] not in (WASSER, FLUSS, SEE, VERS):
                if self.sequences.states.bowa[k] <= 0.0:
                    self.sequences.fluxes.landusesurfaceresistance[k] = inf
                elif self.sequences.states.bowa[k] < self.parameters.control.py[k]:
                    self.sequences.fluxes.landusesurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k] * (3.5 * (                        1.0 - self.sequences.states.bowa[k] / self.parameters.control.py[k]                    ) + exp(0.2 * self.parameters.control.py[k] / self.sequences.states.bowa[k]))
                else:
                    self.sequences.fluxes.landusesurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k] * (exp(0.2))
    cpdef inline void calc_actualsurfaceresistance(self)  nogil:
        cdef double d_invrestnight
        cdef double d_invrestday
        cdef double d_lai
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, FLUSS, SEE, WASSER):
                self.sequences.fluxes.actualsurfaceresistance[k] = self.sequences.fluxes.landusesurfaceresistance[k]
            else:
                d_lai = self.parameters.control.lai[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
                d_invrestday = (                    (1.0 - 0.7 ** d_lai) / self.sequences.fluxes.landusesurfaceresistance[k]                ) + 0.7 ** d_lai / self.sequences.fluxes.soilsurfaceresistance[k]
                d_invrestnight = d_lai / 2500.0 + 1.0 / self.sequences.fluxes.soilsurfaceresistance[k]
                self.sequences.fluxes.actualsurfaceresistance[k] = 1.0 / (                    (                        self.sequences.fluxes.possiblesunshineduration / self.parameters.derived.hours * d_invrestday                        + (1.0 - self.sequences.fluxes.possiblesunshineduration / self.parameters.derived.hours)                        * d_invrestnight                    )                )
    cpdef inline void calc_g(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (FLUSS, SEE, WASSER):
                self.sequences.fluxes.g[k] = 0.0
            else:
                self.sequences.fluxes.g[k] = self.parameters.derived.days * self.parameters.control.wg2z[self.parameters.derived.moy[self.idx_sim]]
    cpdef inline void calc_evpo(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, SEE, FLUSS):
                self.sequences.fluxes.evpo[k] = self.return_penman_v1(k)
            else:
                self.sequences.fluxes.evpo[k] = self.return_penmanmonteith_v1(k, 0.0)
    cpdef inline void calc_evi_inzp(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.evi[k] = self.sequences.fluxes.evpo[k]
                self.sequences.states.inzp[k] = 0.0
            elif self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
                if self.sequences.states.sinz[k] == 0.0:
                    self.sequences.fluxes.evi[k] = min(self.sequences.fluxes.evpo[k], self.sequences.states.inzp[k])
                    self.sequences.states.inzp[k] = self.sequences.states.inzp[k] - (self.sequences.fluxes.evi[k])
                else:
                    self.sequences.fluxes.evi[k] = 0.0
            elif self.sequences.states.waes[k] == 0.0:
                self.sequences.fluxes.evi[k] = min(self.sequences.fluxes.evpo[k], self.sequences.states.inzp[k])
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] - (self.sequences.fluxes.evi[k])
            else:
                self.sequences.fluxes.evi[k] = 0.0
    cpdef inline void calc_evb(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or ((self.parameters.control.lnk[k] not in (LAUBW, MISCHW, NADELW) and self.sequences.states.waes[k] > 0.0))                or (self.sequences.fluxes.evpo[k] == 0.0)            ):
                self.sequences.fluxes.evb[k] = 0.0
            else:
                self.sequences.fluxes.evb[k] = (                    (self.sequences.fluxes.evpo[k] - self.sequences.fluxes.evi[k])                    / self.sequences.fluxes.evpo[k]                    * self.return_penmanmonteith_v1(                        k,                        self.sequences.fluxes.actualsurfaceresistance[k],                    )                )
    cpdef inline void update_ebdn(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.ebdn[k] = 0.0
            else:
                self.sequences.states.ebdn[k] = self.sequences.states.ebdn[k] + (self.parameters.control.wg2z[self.parameters.derived.moy[self.idx_sim]] * self.parameters.derived.days - self.sequences.fluxes.wg[k])
    cpdef inline void calc_sff(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.fluxes.sff[k] = 0.0
            else:
                self.sequences.fluxes.sff[k] = min(                    max(                        1.0 - self.sequences.states.ebdn[k] / (self.parameters.fixed.bowa2z[k] * self.parameters.fixed.rschmelz),                        0.0,                    ),                    1.0,                )
    cpdef inline void calc_fvg(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.fluxes.fvg[k] = 0.0
            else:
                self.sequences.fluxes.fvg[k] = min(self.parameters.control.fvf * self.sequences.fluxes.sff[k] ** self.parameters.control.bsff, 1.0)
    cpdef inline void calc_qkap(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qkap[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 0]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k]
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 1]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k] * (                    1.0                    - (self.sequences.states.bowa[k] - self.parameters.control.kapgrenz[k, 0])                    / (self.parameters.control.kapgrenz[k, 1] - self.parameters.control.kapgrenz[k, 0])                )
            else:
                self.sequences.fluxes.qkap[k] = 0
    cpdef inline void calc_qbb(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.pwp[k])                or (self.parameters.control.wmax[k] <= 0.0)            ):
                self.sequences.fluxes.qbb[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.fk[k]:
                if self.parameters.control.rbeta:
                    self.sequences.fluxes.qbb[k] = 0.0
                else:
                    self.sequences.fluxes.qbb[k] = self.parameters.control.beta[k] * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])
            else:
                self.sequences.fluxes.qbb[k] = (                    self.parameters.control.beta[k]                    * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])                    * (                        1.0                        + (self.parameters.control.fbeta[k] - 1.0)                        * (self.sequences.states.bowa[k] - self.parameters.control.fk[k])                        / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                    )                )
    cpdef inline void calc_qib1(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (                self.sequences.states.bowa[k] <= self.parameters.control.pwp[k]            ):
                self.sequences.fluxes.qib1[k] = 0.0
            else:
                self.sequences.fluxes.qib1[k] = self.parameters.control.dmin[k] * (self.sequences.states.bowa[k] / self.parameters.control.wmax[k])
    cpdef inline void calc_qib2(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.fk[k])                or (self.parameters.control.wmax[k] <= self.parameters.control.fk[k])            ):
                self.sequences.fluxes.qib2[k] = 0.0
            else:
                self.sequences.fluxes.qib2[k] = (self.parameters.control.dmax[k] - self.parameters.control.dmin[k]) * (                    (self.sequences.states.bowa[k] - self.parameters.control.fk[k]) / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                ) ** 1.5
    cpdef inline void calc_qdb(self)  nogil:
        cdef double d_exz
        cdef double d_sfa
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qdb[k] = 0.0
            elif (self.parameters.control.lnk[k] in (VERS, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qdb[k] = self.sequences.fluxes.wada[k]
            else:
                if self.sequences.states.bowa[k] < self.parameters.control.wmax[k]:
                    d_sfa = (1.0 - self.sequences.states.bowa[k] / self.parameters.control.wmax[k]) ** (                        1.0 / (self.parameters.control.bsf[k] + 1.0)                    ) - (self.sequences.fluxes.wada[k] / ((self.parameters.control.bsf[k] + 1.0) * self.parameters.control.wmax[k]))
                else:
                    d_sfa = 0.0
                d_exz = self.sequences.states.bowa[k] + self.sequences.fluxes.wada[k] - self.parameters.control.wmax[k]
                self.sequences.fluxes.qdb[k] = d_exz
                if d_sfa > 0.0:
                    self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + (d_sfa ** (self.parameters.control.bsf[k] + 1.0) * self.parameters.control.wmax[k])
                self.sequences.fluxes.qdb[k] = max(self.sequences.fluxes.qdb[k], 0.0)
    cpdef inline void update_qdb(self)  nogil:
        cdef int k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + (self.sequences.fluxes.fvg[k] * (self.sequences.fluxes.wada[k] - self.sequences.fluxes.qdb[k]))
    cpdef inline void calc_bowa(self)  nogil:
        cdef double d_factor
        cdef double d_rvl
        cdef double d_incr
        cdef double d_decr
        cdef int k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.states.bowa[k] = 0.0
            else:
                d_decr = self.sequences.fluxes.qbb[k] + self.sequences.fluxes.qib1[k] + self.sequences.fluxes.qib2[k] + self.sequences.fluxes.qdb[k]
                d_incr = self.sequences.fluxes.wada[k] + self.sequences.fluxes.qkap[k]
                if self.sequences.fluxes.evb[k] > 0.0:
                    d_decr = d_decr + (self.sequences.fluxes.evb[k])
                else:
                    d_incr = d_incr - (self.sequences.fluxes.evb[k])
                if d_decr > self.sequences.states.bowa[k] + d_incr:
                    d_rvl = (self.sequences.states.bowa[k] + d_incr) / d_decr
                    if self.sequences.fluxes.evb[k] > 0.0:
                        self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_rvl)
                    self.sequences.fluxes.qbb[k] = self.sequences.fluxes.qbb[k] * (d_rvl)
                    self.sequences.fluxes.qib1[k] = self.sequences.fluxes.qib1[k] * (d_rvl)
                    self.sequences.fluxes.qib2[k] = self.sequences.fluxes.qib2[k] * (d_rvl)
                    self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] * (d_rvl)
                    self.sequences.states.bowa[k] = 0.0
                else:
                    self.sequences.states.bowa[k] = (self.sequences.states.bowa[k] + d_incr) - d_decr
                    if self.sequences.states.bowa[k] > self.parameters.control.wmax[k]:
                        d_factor = (self.sequences.states.bowa[k] - self.parameters.control.wmax[k]) / d_incr
                        if self.sequences.fluxes.evb[k] < 0.0:
                            self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_factor)
                        self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] * (d_factor)
                        self.sequences.fluxes.qkap[k] = self.sequences.fluxes.qkap[k] * (d_factor)
                        self.sequences.states.bowa[k] = self.parameters.control.wmax[k]
    cpdef inline void calc_qbgz(self)  nogil:
        cdef int k
        self.sequences.states.qbgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == SEE:
                self.sequences.states.qbgz = self.sequences.states.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, FLUSS, VERS):
                self.sequences.states.qbgz = self.sequences.states.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.qbb[k] - self.sequences.fluxes.qkap[k]))
    cpdef inline void calc_qigz1(self)  nogil:
        cdef int k
        self.sequences.states.qigz1 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.states.qigz1 = self.sequences.states.qigz1 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib1[k])
    cpdef inline void calc_qigz2(self)  nogil:
        cdef int k
        self.sequences.states.qigz2 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.states.qigz2 = self.sequences.states.qigz2 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib2[k])
    cpdef inline void calc_qdgz(self)  nogil:
        cdef int k
        self.sequences.fluxes.qdgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == FLUSS:
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, SEE):
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * self.sequences.fluxes.qdb[k])
    cpdef inline void calc_qbga(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kb <= 0.0:
            self.sequences.new_states.qbga = self.sequences.new_states.qbgz
        elif self.parameters.derived.kb > 1e200:
            self.sequences.new_states.qbga = self.sequences.old_states.qbga + self.sequences.new_states.qbgz - self.sequences.old_states.qbgz
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kb)
            self.sequences.new_states.qbga = (                self.sequences.old_states.qbga                + (self.sequences.old_states.qbgz - self.sequences.old_states.qbga) * d_temp                + (self.sequences.new_states.qbgz - self.sequences.old_states.qbgz) * (1.0 - self.parameters.derived.kb * d_temp)            )
    cpdef inline void calc_qiga1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.ki1 <= 0.0:
            self.sequences.new_states.qiga1 = self.sequences.new_states.qigz1
        elif self.parameters.derived.ki1 > 1e200:
            self.sequences.new_states.qiga1 = self.sequences.old_states.qiga1 + self.sequences.new_states.qigz1 - self.sequences.old_states.qigz1
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.ki1)
            self.sequences.new_states.qiga1 = (                self.sequences.old_states.qiga1                + (self.sequences.old_states.qigz1 - self.sequences.old_states.qiga1) * d_temp                + (self.sequences.new_states.qigz1 - self.sequences.old_states.qigz1) * (1.0 - self.parameters.derived.ki1 * d_temp)            )
    cpdef inline void calc_qiga2(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.ki2 <= 0.0:
            self.sequences.new_states.qiga2 = self.sequences.new_states.qigz2
        elif self.parameters.derived.ki2 > 1e200:
            self.sequences.new_states.qiga2 = self.sequences.old_states.qiga2 + self.sequences.new_states.qigz2 - self.sequences.old_states.qigz2
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.ki2)
            self.sequences.new_states.qiga2 = (                self.sequences.old_states.qiga2                + (self.sequences.old_states.qigz2 - self.sequences.old_states.qiga2) * d_temp                + (self.sequences.new_states.qigz2 - self.sequences.old_states.qigz2) * (1.0 - self.parameters.derived.ki2 * d_temp)            )
    cpdef inline void calc_qdgz1_qdgz2(self)  nogil:
        if self.sequences.fluxes.qdgz > self.parameters.control.a2:
            self.sequences.states.qdgz2 = (self.sequences.fluxes.qdgz - self.parameters.control.a2) ** 2 / (self.sequences.fluxes.qdgz + self.parameters.control.a1 - self.parameters.control.a2)
            self.sequences.states.qdgz1 = self.sequences.fluxes.qdgz - self.sequences.states.qdgz2
        else:
            self.sequences.states.qdgz2 = 0.0
            self.sequences.states.qdgz1 = self.sequences.fluxes.qdgz
    cpdef inline void calc_qdga1(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kd1 <= 0.0:
            self.sequences.new_states.qdga1 = self.sequences.new_states.qdgz1
        elif self.parameters.derived.kd1 > 1e200:
            self.sequences.new_states.qdga1 = self.sequences.old_states.qdga1 + self.sequences.new_states.qdgz1 - self.sequences.old_states.qdgz1
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kd1)
            self.sequences.new_states.qdga1 = (                self.sequences.old_states.qdga1                + (self.sequences.old_states.qdgz1 - self.sequences.old_states.qdga1) * d_temp                + (self.sequences.new_states.qdgz1 - self.sequences.old_states.qdgz1) * (1.0 - self.parameters.derived.kd1 * d_temp)            )
    cpdef inline void calc_qdga2(self)  nogil:
        cdef double d_temp
        if self.parameters.derived.kd2 <= 0.0:
            self.sequences.new_states.qdga2 = self.sequences.new_states.qdgz2
        elif self.parameters.derived.kd2 > 1e200:
            self.sequences.new_states.qdga2 = self.sequences.old_states.qdga2 + self.sequences.new_states.qdgz2 - self.sequences.old_states.qdgz2
        else:
            d_temp = 1.0 - exp(-1.0 / self.parameters.derived.kd2)
            self.sequences.new_states.qdga2 = (                self.sequences.old_states.qdga2                + (self.sequences.old_states.qdgz2 - self.sequences.old_states.qdga2) * d_temp                + (self.sequences.new_states.qdgz2 - self.sequences.old_states.qdgz2) * (1.0 - self.parameters.derived.kd2 * d_temp)            )
    cpdef inline void calc_qah(self)  nogil:
        cdef double d_epw
        cdef int k
        cdef double d_area
        self.sequences.fluxes.qah = self.sequences.fluxes.qzh + self.sequences.states.qbga + self.sequences.states.qiga1 + self.sequences.states.qiga2 + self.sequences.states.qdga1 + self.sequences.states.qdga2
        if (not self.parameters.control.negq) and (self.sequences.fluxes.qah < 0.0):
            d_area = 0.0
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] in (FLUSS, SEE):
                    d_area = d_area + (self.parameters.control.fhru[k])
            if d_area > 0.0:
                for k in range(self.parameters.control.nhru):
                    if self.parameters.control.lnk[k] in (FLUSS, SEE):
                        self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] + (self.sequences.fluxes.qah / d_area)
            self.sequences.fluxes.qah = 0.0
        d_epw = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qah = self.sequences.fluxes.qah + (self.parameters.control.fhru[k] * self.sequences.fluxes.nkor[k])
                d_epw = d_epw + (self.parameters.control.fhru[k] * self.sequences.fluxes.evi[k])
        if (self.sequences.fluxes.qah > d_epw) or self.parameters.control.negq:
            self.sequences.fluxes.qah = self.sequences.fluxes.qah - (d_epw)
        elif d_epw > 0.0:
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] == WASSER:
                    self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] * (self.sequences.fluxes.qah / d_epw)
            self.sequences.fluxes.qah = 0.0
    cpdef inline void calc_qa(self)  nogil:
        self.sequences.fluxes.qa = self.parameters.derived.qfactor * self.sequences.fluxes.qah
    cpdef inline double return_adjustedwindspeed_v1(self, double newheight)  nogil:
        return self.sequences.inputs.windspeed * (            log(newheight / self.parameters.fixed.z0)            / log(self.parameters.control.measuringheightwindspeed / self.parameters.fixed.z0)        )
    cpdef inline double return_actualvapourpressure_v1(self, double saturationvapourpressure, double relativehumidity)  nogil:
        return saturationvapourpressure * relativehumidity / 100.0
    cpdef inline double return_netlongwaveradiationinz_v1(self, numpy.int32_t k)  nogil:
        cdef double d_rlsnow
        cdef double d_fr
        d_fr = self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
        d_rlsnow = self.parameters.fixed.sigma * self.parameters.derived.days * (self.sequences.aides.tempsinz[k] + 273.15) ** 4
        return (1.0 - d_fr) * (d_rlsnow - self.sequences.aides.rlatm[k])
    cpdef inline double return_netlongwaveradiationsnow_v1(self, numpy.int32_t k)  nogil:
        cdef double d_fr
        cdef double d_counter
        cdef double d_temp
        cdef double d_sigma
        d_sigma = self.parameters.fixed.sigma * self.parameters.derived.days
        d_temp = self.sequences.fluxes.tkor[k] + 273.15
        d_counter = self.sequences.aides.rlatm[k]
        if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
            d_fr = self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
            d_counter = d_fr * d_counter + (1.0 - d_fr) * (0.97 * d_sigma * d_temp ** 4)
        return d_sigma * (self.sequences.fluxes.tempssurface[k] + 273.15) ** 4 - d_counter
    cpdef inline double return_dailyglobalradiation_v1(self, double sunshineduration, double possiblesunshineduration)  nogil:
        cdef int idx
        if possiblesunshineduration > 0.0:
            idx = self.parameters.derived.moy[self.idx_sim]
            if (sunshineduration <= 0.0) and (self.parameters.derived.days >= 1.0):
                return self.sequences.fluxes.extraterrestrialradiation * self.parameters.control.angstromalternative[idx]
            return self.sequences.fluxes.extraterrestrialradiation * (                self.parameters.control.angstromconstant[idx]                + self.parameters.control.angstromfactor[idx] * sunshineduration / possiblesunshineduration            )
        return 0.0
    cpdef inline double return_penman_v1(self, numpy.int32_t k)  nogil:
        return (            self.parameters.derived.days            * (                self.sequences.fluxes.dailysaturationvapourpressureslope[k]                * self.sequences.fluxes.dailynetradiation[k]                / self.parameters.fixed.lw                + self.parameters.fixed.psy                * (1.3 + 0.94 * self.sequences.fluxes.dailywindspeed2m)                * (                    self.sequences.fluxes.dailysaturationvapourpressure[k]                    - self.sequences.fluxes.dailyactualvapourpressure[k]                )            )            / (self.sequences.fluxes.dailysaturationvapourpressureslope[k] + self.parameters.fixed.psy)        )
    cpdef inline double return_penmanmonteith_v1(self, numpy.int32_t k, double actualsurfaceresistance)  nogil:
        cdef double d_c
        cdef double d_b
        cdef double d_ar
        d_ar = min(max(self.sequences.fluxes.aerodynamicresistance[k], 1e-6), 1e6)
        d_b = (            4.0            * self.parameters.control.emissivity            * self.parameters.fixed.sigma            / 60.0            / 60.0            / 24.0            * (273.15 + self.sequences.fluxes.tkor[k]) ** 3        )
        d_c = 1.0 + d_b * d_ar / self.sequences.fluxes.densityair[k] / self.parameters.fixed.cpluft
        return (            (                self.sequences.fluxes.saturationvapourpressureslope[k] * (self.sequences.fluxes.netradiation[k] + self.sequences.fluxes.g[k])                + self.parameters.derived.seconds                * d_c                * self.sequences.fluxes.densityair[k]                * self.parameters.fixed.cpluft                * (self.sequences.fluxes.saturationvapourpressure[k] - self.sequences.fluxes.actualvapourpressure[k])                / d_ar            )            / (                self.sequences.fluxes.saturationvapourpressureslope[k]                + self.parameters.fixed.psy * d_c * (1.0 + actualsurfaceresistance / d_ar)            )            / self.parameters.fixed.lw        )
    cpdef inline double return_energygainsnowsurface_v1(self, double tempssurface)  nogil:
        cdef int k
        k = self.idx_hru
        self.sequences.fluxes.tempssurface[k] = tempssurface
        self.sequences.fluxes.saturationvapourpressuresnow[k] = self.return_saturationvapourpressure_v1(            self.sequences.fluxes.tempssurface[k]        )
        self.sequences.fluxes.wlatsnow[k] = self.return_wlatsnow_v1(k)
        self.sequences.fluxes.wsenssnow[k] = self.return_wsenssnow_v1(k)
        self.sequences.fluxes.netlongwaveradiationsnow[k] = self.return_netlongwaveradiationsnow_v1(k)
        self.sequences.fluxes.netradiationsnow[k] = self.return_netradiation_v1(            self.sequences.fluxes.netshortwaveradiationsnow[k],            self.sequences.fluxes.netlongwaveradiationsnow[k],        )
        self.sequences.fluxes.wsurf[k] = self.return_wsurf_v1(k)
        return (            self.sequences.fluxes.wsurf[k] + self.sequences.fluxes.netradiationsnow[k] - self.sequences.fluxes.wsenssnow[k] - self.sequences.fluxes.wlatsnow[k]        )
    cpdef inline double return_saturationvapourpressure_v1(self, double temperature)  nogil:
        return 0.61078 * 2.71828 ** (17.08085 * temperature / (temperature + 234.175))
    cpdef inline double return_saturationvapourpressureslope_v1(self, double temperature)  nogil:
        return (            2443.06            * exp(17.08085 * temperature / (temperature + 234.175))            / (temperature + 234.175) ** 2        )
    cpdef inline double return_netradiation_v1(self, double netshortwaveradiation, double netlongwaveradiation)  nogil:
        return netshortwaveradiation - netlongwaveradiation
    cpdef inline double return_wsensinz_v1(self, numpy.int32_t k)  nogil:
        return (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k]) * (            self.sequences.aides.tempsinz[k] - self.sequences.fluxes.tkor[k]        )
    cpdef inline double return_wsenssnow_v1(self, numpy.int32_t k)  nogil:
        return (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k]) * (            self.sequences.fluxes.tempssurface[k] - self.sequences.fluxes.tkor[k]        )
    cpdef inline double return_wlatinz_v1(self, numpy.int32_t k)  nogil:
        return (            (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k])            * self.parameters.fixed.psyinv            * (self.sequences.fluxes.saturationvapourpressureinz[k] - self.sequences.fluxes.actualvapourpressure[k])        )
    cpdef inline double return_wlatsnow_v1(self, numpy.int32_t k)  nogil:
        return (            (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k])            * self.parameters.fixed.psyinv            * (self.sequences.fluxes.saturationvapourpressuresnow[k] - self.sequences.fluxes.actualvapourpressure[k])        )
    cpdef inline double return_wsurfinz_v1(self, numpy.int32_t k)  nogil:
        self.sequences.fluxes.saturationvapourpressureinz[k] = self.return_saturationvapourpressure_v1(            max(self.sequences.aides.tempsinz[k], self.sequences.fluxes.tkor[k])        )
        self.sequences.fluxes.wlatinz[k] = self.return_wlatinz_v1(k)
        self.sequences.fluxes.wsensinz[k] = self.return_wsensinz_v1(k)
        self.sequences.fluxes.netlongwaveradiationinz[k] = self.return_netlongwaveradiationinz_v1(k)
        self.sequences.fluxes.netradiationinz[k] = self.return_netradiation_v1(            self.sequences.fluxes.netshortwaveradiationinz[k], self.sequences.fluxes.netlongwaveradiationinz[k]        )
        self.sequences.fluxes.wsurfinz[k] = self.sequences.fluxes.wsensinz[k] + self.sequences.fluxes.wlatinz[k] - self.sequences.fluxes.netradiationinz[k]
        return self.sequences.fluxes.wsurfinz[k]
    cpdef inline double return_wsurf_v1(self, numpy.int32_t k)  nogil:
        if isinf(self.parameters.control.ktschnee):
            return inf
        return self.parameters.control.ktschnee * (self.sequences.aides.temps[k] - self.sequences.fluxes.tempssurface[k])
    cpdef inline double return_temps_v1(self, numpy.int32_t k)  nogil:
        cdef double d_water
        cdef double d_ice
        if self.sequences.states.waes[k] > 0.0:
            d_ice = self.parameters.fixed.cpeis * self.sequences.states.wats[k]
            d_water = self.parameters.fixed.cpwasser * (self.sequences.states.waes[k] - self.sequences.states.wats[k])
            return max(self.sequences.states.esnow[k] / (d_ice + d_water), -273.0)
        return nan
    cpdef inline double return_tempsinz_v1(self, numpy.int32_t k)  nogil:
        cdef double d_water
        cdef double d_ice
        if self.sequences.states.sinz[k] > 0.0:
            d_ice = self.parameters.fixed.cpeis * self.sequences.states.stinz[k]
            d_water = self.parameters.fixed.cpwasser * (self.sequences.states.sinz[k] - self.sequences.states.stinz[k])
            return max(self.sequences.states.esnowinz[k] / (d_ice + d_water), -273.0)
        return nan
    cpdef inline double return_wg_v1(self, numpy.int32_t k)  nogil:
        cdef double d_temp
        if self.sequences.states.waes[k] > 0.0:
            d_temp = self.sequences.aides.temps[k]
        else:
            d_temp = self.sequences.fluxes.tkor[k]
        return self.parameters.fixed.lambdag * (self.sequences.fluxes.tz[k] - d_temp) / self.parameters.fixed.z
    cpdef inline double return_backwardeulererrorinz_v1(self, double esnowinz)  nogil:
        cdef double d_esnowinz_old
        cdef int k
        k = self.idx_hru
        if self.sequences.states.sinz[k] > 0.0:
            d_esnowinz_old = self.sequences.states.esnowinz[k]
            self.sequences.states.esnowinz[k] = esnowinz
            self.sequences.aides.tempsinz[k] = self.return_tempsinz_v1(k)
            self.sequences.states.esnowinz[k] = d_esnowinz_old
            return d_esnowinz_old - esnowinz - self.return_wsurfinz_v1(k)
        return nan
    cpdef inline double return_backwardeulererror_v1(self, double esnow)  nogil:
        cdef double d_esnow_old
        cdef int k
        k = self.idx_hru
        if self.sequences.states.waes[k] > 0.0:
            d_esnow_old = self.sequences.states.esnow[k]
            self.sequences.states.esnow[k] = esnow
            self.sequences.aides.temps[k] = self.return_temps_v1(k)
            self.sequences.states.esnow[k] = d_esnow_old
            self.return_tempssurface_v1(k)
            self.sequences.fluxes.wg[k] = self.return_wg_v1(k)
            return d_esnow_old - esnow + self.sequences.fluxes.wg[k] - self.sequences.fluxes.wsurf[k]
        return nan
    cpdef inline double return_esnowinz_v1(self, numpy.int32_t k, double temps)  nogil:
        cdef double d_water
        cdef double d_ice
        d_ice = self.parameters.fixed.cpeis * self.sequences.states.stinz[k]
        d_water = self.parameters.fixed.cpwasser * (self.sequences.states.sinz[k] - self.sequences.states.stinz[k])
        return temps * (d_ice + d_water)
    cpdef inline double return_esnow_v1(self, numpy.int32_t k, double temps)  nogil:
        cdef double d_water
        cdef double d_ice
        d_ice = self.parameters.fixed.cpeis * self.sequences.states.wats[k]
        d_water = self.parameters.fixed.cpwasser * (self.sequences.states.waes[k] - self.sequences.states.wats[k])
        return temps * (d_ice + d_water)
    cpdef inline double return_tempssurface_v1(self, numpy.int32_t k)  nogil:
        if self.sequences.states.waes[k] > 0.0:
            if isinf(self.parameters.control.ktschnee):
                self.idx_hru = k
                self.return_energygainsnowsurface_v1(self.sequences.aides.temps[k])
                self.sequences.fluxes.wsurf[k] = (                    self.sequences.fluxes.wsenssnow[k] + self.sequences.fluxes.wlatsnow[k] - self.sequences.fluxes.netradiationsnow[k]                )
            else:
                self.idx_hru = k
                self.pegasustempssurface.find_x(-50.0, 0.0, -100.0, 0.0, 0.0, 1e-8, 10)
                self.sequences.fluxes.wsurf[k] = self.sequences.fluxes.wsurf[k] - (self.return_energygainsnowsurface_v1(                    self.sequences.fluxes.tempssurface[k]                ))
        else:
            self.sequences.fluxes.tempssurface[k] = nan
            self.sequences.fluxes.saturationvapourpressuresnow[k] = 0.0
            self.sequences.fluxes.wsenssnow[k] = 0.0
            self.sequences.fluxes.wlatsnow[k] = 0.0
            self.sequences.fluxes.wsurf[k] = 0.0
        return self.sequences.fluxes.tempssurface[k]
    cpdef inline double return_adjustedwindspeed(self, double newheight)  nogil:
        return self.sequences.inputs.windspeed * (            log(newheight / self.parameters.fixed.z0)            / log(self.parameters.control.measuringheightwindspeed / self.parameters.fixed.z0)        )
    cpdef inline double return_actualvapourpressure(self, double saturationvapourpressure, double relativehumidity)  nogil:
        return saturationvapourpressure * relativehumidity / 100.0
    cpdef inline double return_netlongwaveradiationinz(self, numpy.int32_t k)  nogil:
        cdef double d_rlsnow
        cdef double d_fr
        d_fr = self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
        d_rlsnow = self.parameters.fixed.sigma * self.parameters.derived.days * (self.sequences.aides.tempsinz[k] + 273.15) ** 4
        return (1.0 - d_fr) * (d_rlsnow - self.sequences.aides.rlatm[k])
    cpdef inline double return_netlongwaveradiationsnow(self, numpy.int32_t k)  nogil:
        cdef double d_fr
        cdef double d_counter
        cdef double d_temp
        cdef double d_sigma
        d_sigma = self.parameters.fixed.sigma * self.parameters.derived.days
        d_temp = self.sequences.fluxes.tkor[k] + 273.15
        d_counter = self.sequences.aides.rlatm[k]
        if self.parameters.control.lnk[k] in (LAUBW, MISCHW, NADELW):
            d_fr = self.parameters.derived.fr[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]]
            d_counter = d_fr * d_counter + (1.0 - d_fr) * (0.97 * d_sigma * d_temp ** 4)
        return d_sigma * (self.sequences.fluxes.tempssurface[k] + 273.15) ** 4 - d_counter
    cpdef inline double return_dailyglobalradiation(self, double sunshineduration, double possiblesunshineduration)  nogil:
        cdef int idx
        if possiblesunshineduration > 0.0:
            idx = self.parameters.derived.moy[self.idx_sim]
            if (sunshineduration <= 0.0) and (self.parameters.derived.days >= 1.0):
                return self.sequences.fluxes.extraterrestrialradiation * self.parameters.control.angstromalternative[idx]
            return self.sequences.fluxes.extraterrestrialradiation * (                self.parameters.control.angstromconstant[idx]                + self.parameters.control.angstromfactor[idx] * sunshineduration / possiblesunshineduration            )
        return 0.0
    cpdef inline double return_penman(self, numpy.int32_t k)  nogil:
        return (            self.parameters.derived.days            * (                self.sequences.fluxes.dailysaturationvapourpressureslope[k]                * self.sequences.fluxes.dailynetradiation[k]                / self.parameters.fixed.lw                + self.parameters.fixed.psy                * (1.3 + 0.94 * self.sequences.fluxes.dailywindspeed2m)                * (                    self.sequences.fluxes.dailysaturationvapourpressure[k]                    - self.sequences.fluxes.dailyactualvapourpressure[k]                )            )            / (self.sequences.fluxes.dailysaturationvapourpressureslope[k] + self.parameters.fixed.psy)        )
    cpdef inline double return_penmanmonteith(self, numpy.int32_t k, double actualsurfaceresistance)  nogil:
        cdef double d_c
        cdef double d_b
        cdef double d_ar
        d_ar = min(max(self.sequences.fluxes.aerodynamicresistance[k], 1e-6), 1e6)
        d_b = (            4.0            * self.parameters.control.emissivity            * self.parameters.fixed.sigma            / 60.0            / 60.0            / 24.0            * (273.15 + self.sequences.fluxes.tkor[k]) ** 3        )
        d_c = 1.0 + d_b * d_ar / self.sequences.fluxes.densityair[k] / self.parameters.fixed.cpluft
        return (            (                self.sequences.fluxes.saturationvapourpressureslope[k] * (self.sequences.fluxes.netradiation[k] + self.sequences.fluxes.g[k])                + self.parameters.derived.seconds                * d_c                * self.sequences.fluxes.densityair[k]                * self.parameters.fixed.cpluft                * (self.sequences.fluxes.saturationvapourpressure[k] - self.sequences.fluxes.actualvapourpressure[k])                / d_ar            )            / (                self.sequences.fluxes.saturationvapourpressureslope[k]                + self.parameters.fixed.psy * d_c * (1.0 + actualsurfaceresistance / d_ar)            )            / self.parameters.fixed.lw        )
    cpdef inline double return_energygainsnowsurface(self, double tempssurface)  nogil:
        cdef int k
        k = self.idx_hru
        self.sequences.fluxes.tempssurface[k] = tempssurface
        self.sequences.fluxes.saturationvapourpressuresnow[k] = self.return_saturationvapourpressure_v1(            self.sequences.fluxes.tempssurface[k]        )
        self.sequences.fluxes.wlatsnow[k] = self.return_wlatsnow_v1(k)
        self.sequences.fluxes.wsenssnow[k] = self.return_wsenssnow_v1(k)
        self.sequences.fluxes.netlongwaveradiationsnow[k] = self.return_netlongwaveradiationsnow_v1(k)
        self.sequences.fluxes.netradiationsnow[k] = self.return_netradiation_v1(            self.sequences.fluxes.netshortwaveradiationsnow[k],            self.sequences.fluxes.netlongwaveradiationsnow[k],        )
        self.sequences.fluxes.wsurf[k] = self.return_wsurf_v1(k)
        return (            self.sequences.fluxes.wsurf[k] + self.sequences.fluxes.netradiationsnow[k] - self.sequences.fluxes.wsenssnow[k] - self.sequences.fluxes.wlatsnow[k]        )
    cpdef inline double return_saturationvapourpressure(self, double temperature)  nogil:
        return 0.61078 * 2.71828 ** (17.08085 * temperature / (temperature + 234.175))
    cpdef inline double return_saturationvapourpressureslope(self, double temperature)  nogil:
        return (            2443.06            * exp(17.08085 * temperature / (temperature + 234.175))            / (temperature + 234.175) ** 2        )
    cpdef inline double return_netradiation(self, double netshortwaveradiation, double netlongwaveradiation)  nogil:
        return netshortwaveradiation - netlongwaveradiation
    cpdef inline double return_wsensinz(self, numpy.int32_t k)  nogil:
        return (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k]) * (            self.sequences.aides.tempsinz[k] - self.sequences.fluxes.tkor[k]        )
    cpdef inline double return_wsenssnow(self, numpy.int32_t k)  nogil:
        return (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k]) * (            self.sequences.fluxes.tempssurface[k] - self.sequences.fluxes.tkor[k]        )
    cpdef inline double return_wlatinz(self, numpy.int32_t k)  nogil:
        return (            (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k])            * self.parameters.fixed.psyinv            * (self.sequences.fluxes.saturationvapourpressureinz[k] - self.sequences.fluxes.actualvapourpressure[k])        )
    cpdef inline double return_wlatsnow(self, numpy.int32_t k)  nogil:
        return (            (self.parameters.control.turb0 + self.parameters.control.turb1 * self.sequences.fluxes.reducedwindspeed2m[k])            * self.parameters.fixed.psyinv            * (self.sequences.fluxes.saturationvapourpressuresnow[k] - self.sequences.fluxes.actualvapourpressure[k])        )
    cpdef inline double return_wsurfinz(self, numpy.int32_t k)  nogil:
        self.sequences.fluxes.saturationvapourpressureinz[k] = self.return_saturationvapourpressure_v1(            max(self.sequences.aides.tempsinz[k], self.sequences.fluxes.tkor[k])        )
        self.sequences.fluxes.wlatinz[k] = self.return_wlatinz_v1(k)
        self.sequences.fluxes.wsensinz[k] = self.return_wsensinz_v1(k)
        self.sequences.fluxes.netlongwaveradiationinz[k] = self.return_netlongwaveradiationinz_v1(k)
        self.sequences.fluxes.netradiationinz[k] = self.return_netradiation_v1(            self.sequences.fluxes.netshortwaveradiationinz[k], self.sequences.fluxes.netlongwaveradiationinz[k]        )
        self.sequences.fluxes.wsurfinz[k] = self.sequences.fluxes.wsensinz[k] + self.sequences.fluxes.wlatinz[k] - self.sequences.fluxes.netradiationinz[k]
        return self.sequences.fluxes.wsurfinz[k]
    cpdef inline double return_wsurf(self, numpy.int32_t k)  nogil:
        if isinf(self.parameters.control.ktschnee):
            return inf
        return self.parameters.control.ktschnee * (self.sequences.aides.temps[k] - self.sequences.fluxes.tempssurface[k])
    cpdef inline double return_temps(self, numpy.int32_t k)  nogil:
        cdef double d_water
        cdef double d_ice
        if self.sequences.states.waes[k] > 0.0:
            d_ice = self.parameters.fixed.cpeis * self.sequences.states.wats[k]
            d_water = self.parameters.fixed.cpwasser * (self.sequences.states.waes[k] - self.sequences.states.wats[k])
            return max(self.sequences.states.esnow[k] / (d_ice + d_water), -273.0)
        return nan
    cpdef inline double return_tempsinz(self, numpy.int32_t k)  nogil:
        cdef double d_water
        cdef double d_ice
        if self.sequences.states.sinz[k] > 0.0:
            d_ice = self.parameters.fixed.cpeis * self.sequences.states.stinz[k]
            d_water = self.parameters.fixed.cpwasser * (self.sequences.states.sinz[k] - self.sequences.states.stinz[k])
            return max(self.sequences.states.esnowinz[k] / (d_ice + d_water), -273.0)
        return nan
    cpdef inline double return_wg(self, numpy.int32_t k)  nogil:
        cdef double d_temp
        if self.sequences.states.waes[k] > 0.0:
            d_temp = self.sequences.aides.temps[k]
        else:
            d_temp = self.sequences.fluxes.tkor[k]
        return self.parameters.fixed.lambdag * (self.sequences.fluxes.tz[k] - d_temp) / self.parameters.fixed.z
    cpdef inline double return_backwardeulererrorinz(self, double esnowinz)  nogil:
        cdef double d_esnowinz_old
        cdef int k
        k = self.idx_hru
        if self.sequences.states.sinz[k] > 0.0:
            d_esnowinz_old = self.sequences.states.esnowinz[k]
            self.sequences.states.esnowinz[k] = esnowinz
            self.sequences.aides.tempsinz[k] = self.return_tempsinz_v1(k)
            self.sequences.states.esnowinz[k] = d_esnowinz_old
            return d_esnowinz_old - esnowinz - self.return_wsurfinz_v1(k)
        return nan
    cpdef inline double return_backwardeulererror(self, double esnow)  nogil:
        cdef double d_esnow_old
        cdef int k
        k = self.idx_hru
        if self.sequences.states.waes[k] > 0.0:
            d_esnow_old = self.sequences.states.esnow[k]
            self.sequences.states.esnow[k] = esnow
            self.sequences.aides.temps[k] = self.return_temps_v1(k)
            self.sequences.states.esnow[k] = d_esnow_old
            self.return_tempssurface_v1(k)
            self.sequences.fluxes.wg[k] = self.return_wg_v1(k)
            return d_esnow_old - esnow + self.sequences.fluxes.wg[k] - self.sequences.fluxes.wsurf[k]
        return nan
    cpdef inline double return_esnowinz(self, numpy.int32_t k, double temps)  nogil:
        cdef double d_water
        cdef double d_ice
        d_ice = self.parameters.fixed.cpeis * self.sequences.states.stinz[k]
        d_water = self.parameters.fixed.cpwasser * (self.sequences.states.sinz[k] - self.sequences.states.stinz[k])
        return temps * (d_ice + d_water)
    cpdef inline double return_esnow(self, numpy.int32_t k, double temps)  nogil:
        cdef double d_water
        cdef double d_ice
        d_ice = self.parameters.fixed.cpeis * self.sequences.states.wats[k]
        d_water = self.parameters.fixed.cpwasser * (self.sequences.states.waes[k] - self.sequences.states.wats[k])
        return temps * (d_ice + d_water)
    cpdef inline double return_tempssurface(self, numpy.int32_t k)  nogil:
        if self.sequences.states.waes[k] > 0.0:
            if isinf(self.parameters.control.ktschnee):
                self.idx_hru = k
                self.return_energygainsnowsurface_v1(self.sequences.aides.temps[k])
                self.sequences.fluxes.wsurf[k] = (                    self.sequences.fluxes.wsenssnow[k] + self.sequences.fluxes.wlatsnow[k] - self.sequences.fluxes.netradiationsnow[k]                )
            else:
                self.idx_hru = k
                self.pegasustempssurface.find_x(-50.0, 0.0, -100.0, 0.0, 0.0, 1e-8, 10)
                self.sequences.fluxes.wsurf[k] = self.sequences.fluxes.wsurf[k] - (self.return_energygainsnowsurface_v1(                    self.sequences.fluxes.tempssurface[k]                ))
        else:
            self.sequences.fluxes.tempssurface[k] = nan
            self.sequences.fluxes.saturationvapourpressuresnow[k] = 0.0
            self.sequences.fluxes.wsenssnow[k] = 0.0
            self.sequences.fluxes.wlatsnow[k] = 0.0
            self.sequences.fluxes.wsurf[k] = 0.0
        return self.sequences.fluxes.tempssurface[k]
    cpdef inline void pass_qa_v1(self)  nogil:
        self.sequences.outlets.q[0] = self.sequences.outlets.q[0] + (self.sequences.fluxes.qa)
    cpdef inline void pass_qa(self)  nogil:
        self.sequences.outlets.q[0] = self.sequences.outlets.q[0] + (self.sequences.fluxes.qa)
