# coding: utf-8
"""
Infotech official dictionaries
"""
from .pigtype import PigType
from .passtype import PassType
from .tube import Tube
from .company import Company
from .kbd import MethodsKBD
from .feature import Feature


NAME = {

  # PigType
  PigType.MFL: u"Дефектоскоп магнитный продольного намагничивания",
  PigType.TFI: u"Дефектоскоп магнитный поперечного намагничивания",
  PigType.CALIPER_MECH: u"Рычажный (профилемер)",
  PigType.NAVIGATE: u"Поршень навигационно-топографический",
  PigType.ULTRASONIC: u"Ультразвуковой дефектоскоп",
  PigType.CALIPER_MAGN: u"Магнитный профилемер",
  PigType.EMAP: u"Дефектоскоп электромагнитный акустический",
  PigType.COMBO: u"Комбинированный дефектоскоп",
  PigType.CLEANER: u"Очистной скребок",
  PigType.CALIPER_TOOL: u"Поршень-шаблон",

  # PassType
  PassType.COMPLEX: u"Комплексное внутритрубное обследование",
  PassType.COMPLEX_SKS: u"Комплексное внутритрубное обследование + СКС",
  PassType.COMPLEX_NAV: u"Комплексное внутритрубное обследование+навигация",
  PassType.NAVIGATE: u"Навигационно-профильное обследование",
  PassType.CALIPER: u"Профильное обследование",
  PassType.TFI: u"Стресc-коррозионное обследование",
  PassType.ULTRASONIC: u"Ультразвуковое обследование (УЗК)",
  PassType.EXPERIMENTAL: u"Экспериментальное обследование",
  PassType.EMAP: u"ЭМАП-обследование",

  # Tube
  Tube.BEZSHOV: u"Бесшовная",
  Tube.DVUSHOV: u"Двухшовная",
  Tube.UNKNOWN: u"Неопределенная секция",
  Tube.ODNOSHOV: u"Одношовная",
  Tube.SPIRAL: u"Спиралешовная",

  # Company
  Company.BSPC: u"BSPC B.V",
  Company.AVTOGAZ: u"Автогаз, ОАО",
  Company.AEROCOSM: u"Аэрокосмический мониторинг и технологии, ЗАО",
  Company.BKH: u"Бейкер Хьюз Технологии и трубопроводный сервис, АО",
  Company.GPAS: u"Газприборавтоматикасервис, ЗАО",
  Company.DIASCAN: u"ЦТД Диаскан, ОАО",
  Company.DIAPROM: u"НТЦ Диапром, ООО",
  Company.OEG: u"Оргэнергогаз, ОАО",
  Company.PODVGAZENERGO: u"Подводгазэнергосервис, ООО",
  Company.PODVODDIAG: u"Подводдиагностика, ООО",
  Company.PODVODSERV: u"Подводсервис, ООО",
  Company.ROZEN: u"Розен",
  Company.SNG: u"НПО Спецнефтегаз, ЗАО",
  Company.TUBOSCAN: u"Тьюбоскан, ООО",
  Company.VNUTRITRUBDIAG: u"НПЦ Внутритрубная диагностика, ООО",

  # MethodsKBD
  MethodsKBD.API579: u"API 579 Трещины, Уровень 2",
  MethodsKBD.ASME: u"ASME B31G-1991",
  MethodsKBD.BS7910: u"BS 7910:2005",
  MethodsKBD.DNV: u"DNV-RP-F101-2004",
  MethodsKBD.NGKS: u"Методика определения опасности повреждений стенки трубопроводов по данным обследования "
                   u"магнитными дефектоскопами, ультразвуковыми дефектоскопами и профилемерами, "
                   u"ЗАО 'Нефтегазкомплектсервис', 2000",
  MethodsKBD.GAZNADZOR2008: u"Инструкция по оценке дефектов труб... ООО Газнадзор, 2006/2008",
  MethodsKBD.ASMEB31G: u"Модифицированный ASME B31G, 1993",
  MethodsKBD.STO112: u"СТО Газпром 2-2.3-112",
  MethodsKBD.STO173: u"СТО Газпром 2-2.3-173",
  MethodsKBD.ASME2012: u"ASME B31G-2012",
  MethodsKBD.GAZNADZOR2013: u"Инструкция по оценке дефектов труб... ООО Газнадзор, 2013",
  MethodsKBD.VRD: u"ВРД 39-1.10-004-99",

  # Feature
  Feature.ANOMALY: u"Аномалия неизвестной природы",
  Feature.NESVAR_STYK: u"Несваренный стык патрона",
  Feature.POTERYA_CONTACTA: u"Потеря контакта с трубой",
  Feature.EXCENTR_CASE: u"Эксцентричный патрон",
  Feature.ANOMAL_KOLTSEVOGO: u"Аномалия кольцевого шва",
  Feature.ANOMAL_OBLTSOVKI: u"Аномалия облицовки шва",
  Feature.CORROZ_KOLTSEVOGO: u"Коррозия на кольцевом шве",
  Feature.NEPROVAR_UTYAZH: u"Непровар / утяжина",
  Feature.NO_USILEN_KOLTSEVOGO: u"Отсутствие усиления сварного шва",
  Feature.PODKLAD_KOLTSO: u"Подкладное кольцо",
  Feature.PODREZ: u"Подрез",
  Feature.PRAVKA_KROMOK: u"Правка кромок",
  Feature.PROVIS_KORNYA: u"Провис корня шва",
  Feature.SMESCHENIE_KROMOK: u"Смещение кромок",
  Feature.VNUTRI_SHOV_DEFEKT: u"Внутришовный дефект",
  Feature.PODGIB_KROMKY: u"Подгиб кромки со смещением",
  Feature.ANOMAL_PRODOLNOGO: u"Аномалия продольного шва",
  Feature.VYSHLIFOVKA_PRODOLNOGO: u"Место вышлифовки продольного шва",
  Feature.FORMA_PRODOLNOGO: u"Нарушение формы продольного шва",
  Feature.ANOMAL_SPIRALNOGO: u"Аномалия спирального шва",
  Feature.VYSHLIFOVKA_SPIRALNOGO: u"Место вышлифовки спирального шва",
  Feature.FORMA_SPIRALNOGO: u"Нарушение формы спирального шва",
  Feature.DENT: u"Вмятина",
  Feature.DENT_METAL_LOSS: u"Вмятина с дефектами потери металла",
  Feature.VNUTRYSTEN_RASSLOENIE: u"Внутристенное расслоение",
  Feature.GOFRA: u"Гофра",
  Feature.FACTORY_DEFEKT: u"Заводской дефект",
  Feature.METALL_DEFEKT: u"Металлургический дефект",
  Feature.VYSHLIFOVKA: u"Вышлифовка",
  Feature.ZONE_VERT_CRACKS: u"Зона поперечных трещин",
  Feature.ZONE_HOR_CRACKS: u"Зона продольных трещин",
  Feature.ZONE_CORROZ: u"Зона коррозии",
  Feature.CAVERNA: u"Каверна",
  Feature.CORROZ: u"Коррозия",
  Feature.KANAVKA_VERT: u"Поперечная канавка",
  Feature.METALL_LOSS: u"Потеря металла",
  Feature.KANAVKA_HOR: u"Продольная канавка",
  Feature.POINT_CORROZ: u"Точечная коррозия",
  Feature.MECHANICAL_DEFEKT: u"Механическое повреждение",
  Feature.RANDOM_ARC: u"Случайная дуга",
  Feature.RASSL_NO_POVERHNOST: u"Расслоение с выходом на поверхность",
  Feature.ZAVARKA: u"Заварка",
  Feature.ZAVARKA_OTVERST: u"Заварка отверстия",
  Feature.TECHNOLOGY_DEFEKT: u"Технологический дефект",
  Feature.CRACK_VERT_SHOV: u"Трещина на кольцевом шве",
  Feature.CRACK_HOR_SHOV: u"Трещина на продольном шве",
  Feature.CRACK_SPIRAL_SHOV: u"Трещина на спиральном шве",
  Feature.NESPLOSHNOST_PT: u"Несплошность плоскостного типа",
  Feature.CRACK_VERT: u"Поперечная трещина",
  Feature.CRACK_HOR: u"Продольная трещина",
  Feature.OVAL: u"Овализация",
  Feature.METALL_OUT: u"Металл снаружи",
  Feature.ISOL_STYK: u"Изоляционный стык",
  Feature.CURVE_INSERT: u"Кривая вставка",
  Feature.SEGMENT_INSERT: u"Сегментная вставка",
  Feature.HOMUT: u"Хомут",
  Feature.PIG_RUN: u"Камера запуска",
  Feature.PIG_RECEIVE: u"Камера приема",
  Feature.MARKER: u"Маркер",
  Feature.MARKER_RING: u"Маркерное кольцо",
  Feature.MARKER_MAGN: u"Маркер магнитный",
  Feature.ZAVAR_BOBYSHKI: u"Заварка бобышки",
  Feature.ZAVAR_OKNA: u"Заварка окна",
  Feature.REMONT_NAKLAD: u"Ремонтная накладка, вышлифовка и т.п.",
  Feature.METALL_CASE_START: u"Металлическая упрочняющая муфта, начало",
  Feature.METALL_CASE_END: u"Металлическая упрочняющая муфта, конец",
  Feature.KOMPOS_CASE_START: u"Композитная упрочняющая муфта, начало",
  Feature.KOMPOS_CASE_END: u"Композитная упрочняющая муфта, конец",
  Feature.WRONG_CONSTRUCT: u"Недопустимый конструктивный элемент",
  Feature.UNKNOWN: u"Нераспознанный объект",
  Feature.DU1000_DU1200: u"Переход с диаметра ДУ 1000 мм на ДУ 1200 мм.",
  Feature.DU1200_DU1000: u"Переход с диаметра ДУ 1200 мм на ДУ 1000 мм.",
  Feature.DU1200_DU1400: u"Переход с диаметра ДУ 1200 мм на ДУ 1400 мм.",
  Feature.DU1400_DU1200: u"Переход с диаметра ДУ 1400 мм на ДУ 1200 мм.",
  Feature.TUBE_ARMATURE: u"Трубная арматура",
  Feature.ELEMENT_OBUSTROY: u"Элемент обустройства",
  Feature.WATER_START: u"Начало водной преграды",
  Feature.WATER_END: u"Конец водной преграды",
  Feature.FLANETS: u"Фланцевые соединения",
  Feature.OTVOD_VREZKA: u"Отвод-врезка",
  Feature.CASE_START: u"Патрон начало",
  Feature.CASE_END: u"Патрон конец",
  Feature.PRIGRUZ_RING: u"Пригруз кольцевой",
  Feature.PRIGRUZ_START: u"Участок пригрузов начало",
  Feature.PRIGRUZ_END: u"Участок пригрузов конец",
  Feature.TROYNIK: u"Тройник",
  Feature.WALL_THICK: u"Изменение толщины стенки трубы",
  Feature.TURN_START: u"Отвод (поворот) начало",
  Feature.TURN_END: u"Отвод (поворот) конец",
  Feature.TURN_SEGM_START: u"Сегментный участок начало",
  Feature.TURN_SEGM_END: u"Сегментный участок конец",
  Feature.TURN_SEGM: u"Секторный отвод",
  Feature.WELD: u"Шов кольцевой",
  Feature.ZADVIZHKA: u"Задвижка",
  Feature.VALVE: u"Шаровой кран",
}
