# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBdsInstancePatchesResult',
    'AwaitableGetBdsInstancePatchesResult',
    'get_bds_instance_patches',
    'get_bds_instance_patches_output',
]

@pulumi.output_type
class GetBdsInstancePatchesResult:
    """
    A collection of values returned by getBdsInstancePatches.
    """
    def __init__(__self__, bds_instance_id=None, filters=None, id=None, patches=None):
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if patches and not isinstance(patches, list):
            raise TypeError("Expected argument 'patches' to be a list")
        pulumi.set(__self__, "patches", patches)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> str:
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBdsInstancePatchesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def patches(self) -> Sequence['outputs.GetBdsInstancePatchesPatchResult']:
        """
        The list of patches.
        """
        return pulumi.get(self, "patches")


class AwaitableGetBdsInstancePatchesResult(GetBdsInstancePatchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstancePatchesResult(
            bds_instance_id=self.bds_instance_id,
            filters=self.filters,
            id=self.id,
            patches=self.patches)


def get_bds_instance_patches(bds_instance_id: Optional[str] = None,
                             filters: Optional[Sequence[pulumi.InputType['GetBdsInstancePatchesFilterArgs']]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstancePatchesResult:
    """
    This data source provides the list of Bds Instance Patches in Oracle Cloud Infrastructure Big Data Service service.

    List all the available patches for this cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_patches = oci.BigDataService.get_bds_instance_patches(bds_instance_id=oci_bds_bds_instance["test_bds_instance"]["id"])
    ```


    :param str bds_instance_id: The OCID of the cluster.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstancePatches:getBdsInstancePatches', __args__, opts=opts, typ=GetBdsInstancePatchesResult).value

    return AwaitableGetBdsInstancePatchesResult(
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        patches=pulumi.get(__ret__, 'patches'))


@_utilities.lift_output_func(get_bds_instance_patches)
def get_bds_instance_patches_output(bds_instance_id: Optional[pulumi.Input[str]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetBdsInstancePatchesFilterArgs']]]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBdsInstancePatchesResult]:
    """
    This data source provides the list of Bds Instance Patches in Oracle Cloud Infrastructure Big Data Service service.

    List all the available patches for this cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_patches = oci.BigDataService.get_bds_instance_patches(bds_instance_id=oci_bds_bds_instance["test_bds_instance"]["id"])
    ```


    :param str bds_instance_id: The OCID of the cluster.
    """
    ...
