# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEtlRunsResult',
    'AwaitableGetEtlRunsResult',
    'get_etl_runs',
    'get_etl_runs_output',
]

@pulumi.output_type
class GetEtlRunsResult:
    """
    A collection of values returned by getEtlRuns.
    """
    def __init__(__self__, compartment_id=None, display_name=None, em_warehouse_id=None, etl_run_collections=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if em_warehouse_id and not isinstance(em_warehouse_id, str):
            raise TypeError("Expected argument 'em_warehouse_id' to be a str")
        pulumi.set(__self__, "em_warehouse_id", em_warehouse_id)
        if etl_run_collections and not isinstance(etl_run_collections, list):
            raise TypeError("Expected argument 'etl_run_collections' to be a list")
        pulumi.set(__self__, "etl_run_collections", etl_run_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the ETLRun.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="emWarehouseId")
    def em_warehouse_id(self) -> str:
        return pulumi.get(self, "em_warehouse_id")

    @property
    @pulumi.getter(name="etlRunCollections")
    def etl_run_collections(self) -> Sequence['outputs.GetEtlRunsEtlRunCollectionResult']:
        """
        The list of etl_run_collection.
        """
        return pulumi.get(self, "etl_run_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEtlRunsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetEtlRunsResult(GetEtlRunsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEtlRunsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            em_warehouse_id=self.em_warehouse_id,
            etl_run_collections=self.etl_run_collections,
            filters=self.filters,
            id=self.id)


def get_etl_runs(compartment_id: Optional[str] = None,
                 display_name: Optional[str] = None,
                 em_warehouse_id: Optional[str] = None,
                 filters: Optional[Sequence[pulumi.InputType['GetEtlRunsFilterArgs']]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEtlRunsResult:
    """
    This data source provides the list of Em Warehouse Etl Runs in Oracle Cloud Infrastructure Em Warehouse service.

    Gets a list of runs of an EmWarehouseResource by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_em_warehouse_etl_runs = oci.EmWarehouse.get_etl_runs(em_warehouse_id=oci_em_warehouse_em_warehouse["test_em_warehouse"]["id"],
        compartment_id=var["compartment_id"],
        display_name=var["em_warehouse_etl_run_display_name"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str em_warehouse_id: unique EmWarehouse identifier
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['emWarehouseId'] = em_warehouse_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:EmWarehouse/getEtlRuns:getEtlRuns', __args__, opts=opts, typ=GetEtlRunsResult).value

    return AwaitableGetEtlRunsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        em_warehouse_id=pulumi.get(__ret__, 'em_warehouse_id'),
        etl_run_collections=pulumi.get(__ret__, 'etl_run_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_etl_runs)
def get_etl_runs_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                        display_name: Optional[pulumi.Input[Optional[str]]] = None,
                        em_warehouse_id: Optional[pulumi.Input[str]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetEtlRunsFilterArgs']]]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEtlRunsResult]:
    """
    This data source provides the list of Em Warehouse Etl Runs in Oracle Cloud Infrastructure Em Warehouse service.

    Gets a list of runs of an EmWarehouseResource by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_em_warehouse_etl_runs = oci.EmWarehouse.get_etl_runs(em_warehouse_id=oci_em_warehouse_em_warehouse["test_em_warehouse"]["id"],
        compartment_id=var["compartment_id"],
        display_name=var["em_warehouse_etl_run_display_name"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str em_warehouse_id: unique EmWarehouse identifier
    """
    ...
