# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLogSavedSearchesResult',
    'AwaitableGetLogSavedSearchesResult',
    'get_log_saved_searches',
    'get_log_saved_searches_output',
]

@pulumi.output_type
class GetLogSavedSearchesResult:
    """
    A collection of values returned by getLogSavedSearches.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, log_saved_search_id=None, log_saved_search_summary_collections=None, name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_saved_search_id and not isinstance(log_saved_search_id, str):
            raise TypeError("Expected argument 'log_saved_search_id' to be a str")
        pulumi.set(__self__, "log_saved_search_id", log_saved_search_id)
        if log_saved_search_summary_collections and not isinstance(log_saved_search_summary_collections, list):
            raise TypeError("Expected argument 'log_saved_search_summary_collections' to be a list")
        pulumi.set(__self__, "log_saved_search_summary_collections", log_saved_search_summary_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLogSavedSearchesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logSavedSearchId")
    def log_saved_search_id(self) -> Optional[str]:
        return pulumi.get(self, "log_saved_search_id")

    @property
    @pulumi.getter(name="logSavedSearchSummaryCollections")
    def log_saved_search_summary_collections(self) -> Sequence['outputs.GetLogSavedSearchesLogSavedSearchSummaryCollectionResult']:
        """
        The list of log_saved_search_summary_collection.
        """
        return pulumi.get(self, "log_saved_search_summary_collections")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")


class AwaitableGetLogSavedSearchesResult(GetLogSavedSearchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogSavedSearchesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            log_saved_search_id=self.log_saved_search_id,
            log_saved_search_summary_collections=self.log_saved_search_summary_collections,
            name=self.name)


def get_log_saved_searches(compartment_id: Optional[str] = None,
                           filters: Optional[Sequence[pulumi.InputType['GetLogSavedSearchesFilterArgs']]] = None,
                           log_saved_search_id: Optional[str] = None,
                           name: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogSavedSearchesResult:
    """
    This data source provides the list of Log Saved Searches in Oracle Cloud Infrastructure Logging service.

    Lists LogSavedSearches for this compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_saved_searches = oci.Logging.get_log_saved_searches(compartment_id=var["compartment_id"],
        log_saved_search_id=oci_logging_log_saved_search["test_log_saved_search"]["id"],
        name=var["log_saved_search_name"])
    ```


    :param str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
    :param str log_saved_search_id: OCID of the LogSavedSearch.
    :param str name: Resource name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['logSavedSearchId'] = log_saved_search_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Logging/getLogSavedSearches:getLogSavedSearches', __args__, opts=opts, typ=GetLogSavedSearchesResult).value

    return AwaitableGetLogSavedSearchesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        log_saved_search_id=pulumi.get(__ret__, 'log_saved_search_id'),
        log_saved_search_summary_collections=pulumi.get(__ret__, 'log_saved_search_summary_collections'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_log_saved_searches)
def get_log_saved_searches_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetLogSavedSearchesFilterArgs']]]]] = None,
                                  log_saved_search_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  name: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLogSavedSearchesResult]:
    """
    This data source provides the list of Log Saved Searches in Oracle Cloud Infrastructure Logging service.

    Lists LogSavedSearches for this compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_saved_searches = oci.Logging.get_log_saved_searches(compartment_id=var["compartment_id"],
        log_saved_search_id=oci_logging_log_saved_search["test_log_saved_search"]["id"],
        name=var["log_saved_search_name"])
    ```


    :param str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
    :param str log_saved_search_id: OCID of the LogSavedSearch.
    :param str name: Resource name.
    """
    ...
