# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagementAgentResult',
    'AwaitableGetManagementAgentResult',
    'get_management_agent',
    'get_management_agent_output',
]

@pulumi.output_type
class GetManagementAgentResult:
    """
    A collection of values returned by getManagementAgent.
    """
    def __init__(__self__, availability_status=None, compartment_id=None, defined_tags=None, deploy_plugins_ids=None, display_name=None, freeform_tags=None, host=None, host_id=None, id=None, install_key_id=None, install_path=None, install_type=None, is_agent_auto_upgradable=None, is_customer_deployed=None, lifecycle_details=None, managed_agent_id=None, management_agent_id=None, management_agent_properties=None, platform_name=None, platform_type=None, platform_version=None, plugin_lists=None, resource_artifact_version=None, state=None, time_created=None, time_last_heartbeat=None, time_updated=None, version=None):
        if availability_status and not isinstance(availability_status, str):
            raise TypeError("Expected argument 'availability_status' to be a str")
        pulumi.set(__self__, "availability_status", availability_status)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if deploy_plugins_ids and not isinstance(deploy_plugins_ids, list):
            raise TypeError("Expected argument 'deploy_plugins_ids' to be a list")
        pulumi.set(__self__, "deploy_plugins_ids", deploy_plugins_ids)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if host_id and not isinstance(host_id, str):
            raise TypeError("Expected argument 'host_id' to be a str")
        pulumi.set(__self__, "host_id", host_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if install_key_id and not isinstance(install_key_id, str):
            raise TypeError("Expected argument 'install_key_id' to be a str")
        pulumi.set(__self__, "install_key_id", install_key_id)
        if install_path and not isinstance(install_path, str):
            raise TypeError("Expected argument 'install_path' to be a str")
        pulumi.set(__self__, "install_path", install_path)
        if install_type and not isinstance(install_type, str):
            raise TypeError("Expected argument 'install_type' to be a str")
        pulumi.set(__self__, "install_type", install_type)
        if is_agent_auto_upgradable and not isinstance(is_agent_auto_upgradable, bool):
            raise TypeError("Expected argument 'is_agent_auto_upgradable' to be a bool")
        pulumi.set(__self__, "is_agent_auto_upgradable", is_agent_auto_upgradable)
        if is_customer_deployed and not isinstance(is_customer_deployed, bool):
            raise TypeError("Expected argument 'is_customer_deployed' to be a bool")
        pulumi.set(__self__, "is_customer_deployed", is_customer_deployed)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if managed_agent_id and not isinstance(managed_agent_id, str):
            raise TypeError("Expected argument 'managed_agent_id' to be a str")
        pulumi.set(__self__, "managed_agent_id", managed_agent_id)
        if management_agent_id and not isinstance(management_agent_id, str):
            raise TypeError("Expected argument 'management_agent_id' to be a str")
        pulumi.set(__self__, "management_agent_id", management_agent_id)
        if management_agent_properties and not isinstance(management_agent_properties, list):
            raise TypeError("Expected argument 'management_agent_properties' to be a list")
        pulumi.set(__self__, "management_agent_properties", management_agent_properties)
        if platform_name and not isinstance(platform_name, str):
            raise TypeError("Expected argument 'platform_name' to be a str")
        pulumi.set(__self__, "platform_name", platform_name)
        if platform_type and not isinstance(platform_type, str):
            raise TypeError("Expected argument 'platform_type' to be a str")
        pulumi.set(__self__, "platform_type", platform_type)
        if platform_version and not isinstance(platform_version, str):
            raise TypeError("Expected argument 'platform_version' to be a str")
        pulumi.set(__self__, "platform_version", platform_version)
        if plugin_lists and not isinstance(plugin_lists, list):
            raise TypeError("Expected argument 'plugin_lists' to be a list")
        pulumi.set(__self__, "plugin_lists", plugin_lists)
        if resource_artifact_version and not isinstance(resource_artifact_version, str):
            raise TypeError("Expected argument 'resource_artifact_version' to be a str")
        pulumi.set(__self__, "resource_artifact_version", resource_artifact_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_heartbeat and not isinstance(time_last_heartbeat, str):
            raise TypeError("Expected argument 'time_last_heartbeat' to be a str")
        pulumi.set(__self__, "time_last_heartbeat", time_last_heartbeat)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> str:
        """
        The current availability status of managementAgent
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deployPluginsIds")
    def deploy_plugins_ids(self) -> Sequence[str]:
        return pulumi.get(self, "deploy_plugins_ids")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Management Agent Name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Management Agent host machine name
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> str:
        """
        Host resource ocid
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        agent identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="installKeyId")
    def install_key_id(self) -> str:
        """
        agent install key identifier
        """
        return pulumi.get(self, "install_key_id")

    @property
    @pulumi.getter(name="installPath")
    def install_path(self) -> str:
        """
        Path where Management Agent is installed
        """
        return pulumi.get(self, "install_path")

    @property
    @pulumi.getter(name="installType")
    def install_type(self) -> str:
        """
        The install type, either AGENT or GATEWAY
        """
        return pulumi.get(self, "install_type")

    @property
    @pulumi.getter(name="isAgentAutoUpgradable")
    def is_agent_auto_upgradable(self) -> bool:
        """
        true if the agent can be upgraded automatically; false if it must be upgraded manually. This flag is derived from the tenancy level auto upgrade preference.
        """
        return pulumi.get(self, "is_agent_auto_upgradable")

    @property
    @pulumi.getter(name="isCustomerDeployed")
    def is_customer_deployed(self) -> bool:
        """
        true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
        """
        return pulumi.get(self, "is_customer_deployed")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="managedAgentId")
    def managed_agent_id(self) -> str:
        return pulumi.get(self, "managed_agent_id")

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> str:
        return pulumi.get(self, "management_agent_id")

    @property
    @pulumi.getter(name="managementAgentProperties")
    def management_agent_properties(self) -> Sequence['outputs.GetManagementAgentManagementAgentPropertyResult']:
        """
        Additional properties for this Management Agent
        """
        return pulumi.get(self, "management_agent_properties")

    @property
    @pulumi.getter(name="platformName")
    def platform_name(self) -> str:
        """
        Platform Name
        """
        return pulumi.get(self, "platform_name")

    @property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> str:
        """
        Platform Type
        """
        return pulumi.get(self, "platform_type")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> str:
        """
        Platform Version
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="pluginLists")
    def plugin_lists(self) -> Sequence['outputs.GetManagementAgentPluginListResult']:
        """
        list of managementAgentPlugins associated with the agent
        """
        return pulumi.get(self, "plugin_lists")

    @property
    @pulumi.getter(name="resourceArtifactVersion")
    def resource_artifact_version(self) -> str:
        """
        Version of the deployment artifact instantiated by this Management Agent. The format for Standalone resourceMode is YYMMDD.HHMM, and the format for other modes (whose artifacts are based upon Standalone but can advance independently) is YYMMDD.HHMM.VVVVVVVVVVVV. VVVVVVVVVVVV is always a numeric value between 000000000000 and 999999999999
        """
        return pulumi.get(self, "resource_artifact_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of managementAgent
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the Management Agent was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastHeartbeat")
    def time_last_heartbeat(self) -> str:
        """
        The time the Management Agent has last recorded its health status in telemetry. This value will be null if the agent has not recorded its health status in last 7 days. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_last_heartbeat")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Management Agent was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Management Agent Version
        """
        return pulumi.get(self, "version")


class AwaitableGetManagementAgentResult(GetManagementAgentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementAgentResult(
            availability_status=self.availability_status,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            deploy_plugins_ids=self.deploy_plugins_ids,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            host=self.host,
            host_id=self.host_id,
            id=self.id,
            install_key_id=self.install_key_id,
            install_path=self.install_path,
            install_type=self.install_type,
            is_agent_auto_upgradable=self.is_agent_auto_upgradable,
            is_customer_deployed=self.is_customer_deployed,
            lifecycle_details=self.lifecycle_details,
            managed_agent_id=self.managed_agent_id,
            management_agent_id=self.management_agent_id,
            management_agent_properties=self.management_agent_properties,
            platform_name=self.platform_name,
            platform_type=self.platform_type,
            platform_version=self.platform_version,
            plugin_lists=self.plugin_lists,
            resource_artifact_version=self.resource_artifact_version,
            state=self.state,
            time_created=self.time_created,
            time_last_heartbeat=self.time_last_heartbeat,
            time_updated=self.time_updated,
            version=self.version)


def get_management_agent(management_agent_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementAgentResult:
    """
    This data source provides details about a specific Management Agent resource in Oracle Cloud Infrastructure Management Agent service.

    Gets complete details of the inventory of a given agent id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent = oci.ManagementAgent.get_management_agent(management_agent_id=oci_management_agent_management_agent["test_management_agent"]["id"])
    ```


    :param str management_agent_id: Unique Management Agent identifier
    """
    __args__ = dict()
    __args__['managementAgentId'] = management_agent_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getManagementAgent:getManagementAgent', __args__, opts=opts, typ=GetManagementAgentResult).value

    return AwaitableGetManagementAgentResult(
        availability_status=pulumi.get(__ret__, 'availability_status'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        deploy_plugins_ids=pulumi.get(__ret__, 'deploy_plugins_ids'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        host=pulumi.get(__ret__, 'host'),
        host_id=pulumi.get(__ret__, 'host_id'),
        id=pulumi.get(__ret__, 'id'),
        install_key_id=pulumi.get(__ret__, 'install_key_id'),
        install_path=pulumi.get(__ret__, 'install_path'),
        install_type=pulumi.get(__ret__, 'install_type'),
        is_agent_auto_upgradable=pulumi.get(__ret__, 'is_agent_auto_upgradable'),
        is_customer_deployed=pulumi.get(__ret__, 'is_customer_deployed'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        managed_agent_id=pulumi.get(__ret__, 'managed_agent_id'),
        management_agent_id=pulumi.get(__ret__, 'management_agent_id'),
        management_agent_properties=pulumi.get(__ret__, 'management_agent_properties'),
        platform_name=pulumi.get(__ret__, 'platform_name'),
        platform_type=pulumi.get(__ret__, 'platform_type'),
        platform_version=pulumi.get(__ret__, 'platform_version'),
        plugin_lists=pulumi.get(__ret__, 'plugin_lists'),
        resource_artifact_version=pulumi.get(__ret__, 'resource_artifact_version'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_heartbeat=pulumi.get(__ret__, 'time_last_heartbeat'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_management_agent)
def get_management_agent_output(management_agent_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagementAgentResult]:
    """
    This data source provides details about a specific Management Agent resource in Oracle Cloud Infrastructure Management Agent service.

    Gets complete details of the inventory of a given agent id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent = oci.ManagementAgent.get_management_agent(management_agent_id=oci_management_agent_management_agent["test_management_agent"]["id"])
    ```


    :param str management_agent_id: Unique Management Agent identifier
    """
    ...
