# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BackupDbSystemDetail',
    'ConfigurationConfigurationDetail',
    'ConfigurationConfigurationDetailItem',
    'ConfigurationDbConfigurationOverrides',
    'ConfigurationDbConfigurationOverridesItem',
    'DbSystemCredentials',
    'DbSystemCredentialsPasswordDetails',
    'DbSystemInstance',
    'DbSystemInstancesDetail',
    'DbSystemManagementPolicy',
    'DbSystemManagementPolicyBackupPolicy',
    'DbSystemNetworkDetails',
    'DbSystemSource',
    'DbSystemStorageDetails',
    'GetBackupDbSystemDetailResult',
    'GetBackupsBackupCollectionResult',
    'GetBackupsBackupCollectionItemResult',
    'GetBackupsBackupCollectionItemDbSystemDetailResult',
    'GetBackupsFilterResult',
    'GetConfigurationConfigurationDetailResult',
    'GetConfigurationConfigurationDetailItemResult',
    'GetConfigurationDbConfigurationOverrideResult',
    'GetConfigurationDbConfigurationOverrideItemResult',
    'GetConfigurationsConfigurationCollectionResult',
    'GetConfigurationsConfigurationCollectionItemResult',
    'GetConfigurationsConfigurationCollectionItemConfigurationDetailResult',
    'GetConfigurationsConfigurationCollectionItemConfigurationDetailItemResult',
    'GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideResult',
    'GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideItemResult',
    'GetConfigurationsFilterResult',
    'GetDbSystemConnectionDetailInstanceEndpointResult',
    'GetDbSystemConnectionDetailInstanceEndpointEndpointResult',
    'GetDbSystemConnectionDetailPrimaryDbEndpointResult',
    'GetDbSystemCredentialResult',
    'GetDbSystemCredentialPasswordDetailResult',
    'GetDbSystemInstanceResult',
    'GetDbSystemInstancesDetailResult',
    'GetDbSystemManagementPolicyResult',
    'GetDbSystemManagementPolicyBackupPolicyResult',
    'GetDbSystemNetworkDetailResult',
    'GetDbSystemSourceResult',
    'GetDbSystemStorageDetailResult',
    'GetDbSystemsDbSystemCollectionResult',
    'GetDbSystemsDbSystemCollectionItemResult',
    'GetDbSystemsDbSystemCollectionItemCredentialResult',
    'GetDbSystemsDbSystemCollectionItemCredentialPasswordDetailResult',
    'GetDbSystemsDbSystemCollectionItemInstanceResult',
    'GetDbSystemsDbSystemCollectionItemInstancesDetailResult',
    'GetDbSystemsDbSystemCollectionItemManagementPolicyResult',
    'GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyResult',
    'GetDbSystemsDbSystemCollectionItemNetworkDetailResult',
    'GetDbSystemsDbSystemCollectionItemSourceResult',
    'GetDbSystemsDbSystemCollectionItemStorageDetailResult',
    'GetDbSystemsFilterResult',
    'GetDefaultConfigurationConfigurationDetailResult',
    'GetDefaultConfigurationConfigurationDetailItemResult',
    'GetDefaultConfigurationsDefaultConfigurationCollectionResult',
    'GetDefaultConfigurationsDefaultConfigurationCollectionItemResult',
    'GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailResult',
    'GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailItemResult',
    'GetDefaultConfigurationsFilterResult',
    'GetShapesFilterResult',
    'GetShapesShapeCollectionResult',
    'GetShapesShapeCollectionItemResult',
]

@pulumi.output_type
class BackupDbSystemDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbVersion":
            suggest = "db_version"
        elif key == "systemType":
            suggest = "system_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupDbSystemDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupDbSystemDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupDbSystemDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 db_version: Optional[str] = None,
                 system_type: Optional[str] = None):
        """
        :param str db_version: The major and minor versions of the DbSystem software.
        :param str system_type: Type of the DbSystem.
        """
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if system_type is not None:
            pulumi.set(__self__, "system_type", system_type)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[str]:
        """
        The major and minor versions of the DbSystem software.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> Optional[str]:
        """
        Type of the DbSystem.
        """
        return pulumi.get(self, "system_type")


@pulumi.output_type
class ConfigurationConfigurationDetail(dict):
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.ConfigurationConfigurationDetailItem']] = None):
        """
        :param Sequence['ConfigurationConfigurationDetailItemArgs'] items: List of configuration overriden values
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.ConfigurationConfigurationDetailItem']]:
        """
        List of configuration overriden values
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ConfigurationConfigurationDetailItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedValues":
            suggest = "allowed_values"
        elif key == "configKey":
            suggest = "config_key"
        elif key == "dataType":
            suggest = "data_type"
        elif key == "defaultConfigValue":
            suggest = "default_config_value"
        elif key == "isOverridable":
            suggest = "is_overridable"
        elif key == "isRestartRequired":
            suggest = "is_restart_required"
        elif key == "overridenConfigValue":
            suggest = "overriden_config_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationConfigurationDetailItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationConfigurationDetailItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationConfigurationDetailItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_values: Optional[str] = None,
                 config_key: Optional[str] = None,
                 data_type: Optional[str] = None,
                 default_config_value: Optional[str] = None,
                 description: Optional[str] = None,
                 is_overridable: Optional[bool] = None,
                 is_restart_required: Optional[bool] = None,
                 overriden_config_value: Optional[str] = None):
        """
        :param str allowed_values: Range or list of allowed values
        :param str config_key: Key is the configuration key.
        :param str data_type: Describes about the Datatype value.
        :param str default_config_value: Default value
        :param str description: (Updatable) Details about the Configuration Set.
        :param bool is_overridable: This flags tells whether the value is overridable or not.
        :param bool is_restart_required: If true, modfying this configuration value will requires restart.
        :param str overriden_config_value: User selected configuration value
        """
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if config_key is not None:
            pulumi.set(__self__, "config_key", config_key)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if default_config_value is not None:
            pulumi.set(__self__, "default_config_value", default_config_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_overridable is not None:
            pulumi.set(__self__, "is_overridable", is_overridable)
        if is_restart_required is not None:
            pulumi.set(__self__, "is_restart_required", is_restart_required)
        if overriden_config_value is not None:
            pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[str]:
        """
        Range or list of allowed values
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> Optional[str]:
        """
        Key is the configuration key.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        Describes about the Datatype value.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultConfigValue")
    def default_config_value(self) -> Optional[str]:
        """
        Default value
        """
        return pulumi.get(self, "default_config_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        (Updatable) Details about the Configuration Set.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOverridable")
    def is_overridable(self) -> Optional[bool]:
        """
        This flags tells whether the value is overridable or not.
        """
        return pulumi.get(self, "is_overridable")

    @property
    @pulumi.getter(name="isRestartRequired")
    def is_restart_required(self) -> Optional[bool]:
        """
        If true, modfying this configuration value will requires restart.
        """
        return pulumi.get(self, "is_restart_required")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> Optional[str]:
        """
        User selected configuration value
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class ConfigurationDbConfigurationOverrides(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.ConfigurationDbConfigurationOverridesItem']):
        """
        :param Sequence['ConfigurationDbConfigurationOverridesItemArgs'] items: List of configuration overriden values
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.ConfigurationDbConfigurationOverridesItem']:
        """
        List of configuration overriden values
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ConfigurationDbConfigurationOverridesItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configKey":
            suggest = "config_key"
        elif key == "overridenConfigValue":
            suggest = "overriden_config_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationDbConfigurationOverridesItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationDbConfigurationOverridesItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationDbConfigurationOverridesItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_key: str,
                 overriden_config_value: str):
        """
        :param str config_key: Key is the configuration key.
        :param str overriden_config_value: User selected configuration value
        """
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> str:
        """
        Key is the configuration key.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> str:
        """
        User selected configuration value
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class DbSystemCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordDetails":
            suggest = "password_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_details: 'outputs.DbSystemCredentialsPasswordDetails',
                 username: str):
        """
        :param 'DbSystemCredentialsPasswordDetailsArgs' password_details: Details for the DbSystem password. Password can be passed as `VaultSecretPasswordDetails`(Vault) or `PlainTextPasswordDetails`.
        :param str username: The DB system username.
        """
        pulumi.set(__self__, "password_details", password_details)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordDetails")
    def password_details(self) -> 'outputs.DbSystemCredentialsPasswordDetails':
        """
        Details for the DbSystem password. Password can be passed as `VaultSecretPasswordDetails`(Vault) or `PlainTextPasswordDetails`.
        """
        return pulumi.get(self, "password_details")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The DB system username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DbSystemCredentialsPasswordDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordType":
            suggest = "password_type"
        elif key == "secretId":
            suggest = "secret_id"
        elif key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemCredentialsPasswordDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemCredentialsPasswordDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemCredentialsPasswordDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_type: str,
                 password: Optional[str] = None,
                 secret_id: Optional[str] = None,
                 secret_version: Optional[str] = None):
        """
        :param str password_type: Password type
        :param str password: The dbSystem password.
        :param str secret_id: The OCID of secret where the password is stored.
        :param str secret_version: The secret version where the password is stored.
        """
        pulumi.set(__self__, "password_type", password_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter(name="passwordType")
    def password_type(self) -> str:
        """
        Password type
        """
        return pulumi.get(self, "password_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The dbSystem password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[str]:
        """
        The OCID of secret where the password is stored.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[str]:
        """
        The secret version where the password is stored.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class DbSystemInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "lifecycleDetails":
            suggest = "lifecycle_details"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_domain: Optional[str] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 id: Optional[str] = None,
                 lifecycle_details: Optional[str] = None,
                 state: Optional[str] = None,
                 time_created: Optional[str] = None,
                 time_updated: Optional[str] = None):
        """
        :param str availability_domain: Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        :param str description: Description of the DbInstance. This field should be input by the user.
        :param str display_name: Display name of the DbInstance.
        :param str id: Unique identifier that is immutable on creation.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str state: The current state of the DbSystem.
        :param str time_created: The time the the DbSystem was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the DbInstance. This field should be input by the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the DbInstance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the DbSystem.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[str]:
        """
        The time the the DbSystem was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[str]:
        """
        The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class DbSystemInstancesDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemInstancesDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemInstancesDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemInstancesDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 private_ip: Optional[str] = None):
        """
        :param str description: Description of the DbInstance. This field should be input by the user.
        :param str display_name: Display name of the DbInstance.
        :param str private_ip: Private IP in customer subnet that will be assigned to the DbInstance. The value is optional. If the IP is not provided the IP will be chosen among the available IP addresses from the specified subnet.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the DbInstance. This field should be input by the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the DbInstance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        Private IP in customer subnet that will be assigned to the DbInstance. The value is optional. If the IP is not provided the IP will be chosen among the available IP addresses from the specified subnet.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class DbSystemManagementPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupPolicy":
            suggest = "backup_policy"
        elif key == "maintenanceWindowStart":
            suggest = "maintenance_window_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemManagementPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemManagementPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemManagementPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_policy: Optional['outputs.DbSystemManagementPolicyBackupPolicy'] = None,
                 maintenance_window_start: Optional[str] = None):
        """
        :param 'DbSystemManagementPolicyBackupPolicyArgs' backup_policy: (Updatable) Posgresql DB system backup policy
        :param str maintenance_window_start: (Updatable) The start of the maintenance window.
        """
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if maintenance_window_start is not None:
            pulumi.set(__self__, "maintenance_window_start", maintenance_window_start)

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional['outputs.DbSystemManagementPolicyBackupPolicy']:
        """
        (Updatable) Posgresql DB system backup policy
        """
        return pulumi.get(self, "backup_policy")

    @property
    @pulumi.getter(name="maintenanceWindowStart")
    def maintenance_window_start(self) -> Optional[str]:
        """
        (Updatable) The start of the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_start")


@pulumi.output_type
class DbSystemManagementPolicyBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupStart":
            suggest = "backup_start"
        elif key == "daysOfTheMonths":
            suggest = "days_of_the_months"
        elif key == "daysOfTheWeeks":
            suggest = "days_of_the_weeks"
        elif key == "retentionDays":
            suggest = "retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemManagementPolicyBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemManagementPolicyBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemManagementPolicyBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_start: Optional[str] = None,
                 days_of_the_months: Optional[Sequence[int]] = None,
                 days_of_the_weeks: Optional[Sequence[str]] = None,
                 kind: Optional[str] = None,
                 retention_days: Optional[int] = None):
        """
        :param str backup_start: (Updatable) Hour of the day when backup starts.
        :param Sequence[int] days_of_the_months: (Updatable) Days of the month when backup should start. If the day is greater last day of the current month, then it will be triggered on the last day of the current month
        :param Sequence[str] days_of_the_weeks: (Updatable) Weekly days
        :param str kind: (Updatable) Backup policy kind
        :param int retention_days: (Updatable) How many days the customers data should be stored after the db system deletion.
        """
        if backup_start is not None:
            pulumi.set(__self__, "backup_start", backup_start)
        if days_of_the_months is not None:
            pulumi.set(__self__, "days_of_the_months", days_of_the_months)
        if days_of_the_weeks is not None:
            pulumi.set(__self__, "days_of_the_weeks", days_of_the_weeks)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="backupStart")
    def backup_start(self) -> Optional[str]:
        """
        (Updatable) Hour of the day when backup starts.
        """
        return pulumi.get(self, "backup_start")

    @property
    @pulumi.getter(name="daysOfTheMonths")
    def days_of_the_months(self) -> Optional[Sequence[int]]:
        """
        (Updatable) Days of the month when backup should start. If the day is greater last day of the current month, then it will be triggered on the last day of the current month
        """
        return pulumi.get(self, "days_of_the_months")

    @property
    @pulumi.getter(name="daysOfTheWeeks")
    def days_of_the_weeks(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Weekly days
        """
        return pulumi.get(self, "days_of_the_weeks")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        (Updatable) Backup policy kind
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[int]:
        """
        (Updatable) How many days the customers data should be stored after the db system deletion.
        """
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class DbSystemNetworkDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "nsgIds":
            suggest = "nsg_ids"
        elif key == "primaryDbEndpointPrivateIp":
            suggest = "primary_db_endpoint_private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemNetworkDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemNetworkDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemNetworkDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: str,
                 nsg_ids: Optional[Sequence[str]] = None,
                 primary_db_endpoint_private_ip: Optional[str] = None):
        """
        :param str subnet_id: Customer Subnet identifier
        :param Sequence[str] nsg_ids: List of customer NetworkSecurityGroup identifiers
        :param str primary_db_endpoint_private_ip: Private IP in customer subnet. The value is optional. If the IP is not provided the IP will be chosen among the available IP addresses from the specified subnet.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if primary_db_endpoint_private_ip is not None:
            pulumi.set(__self__, "primary_db_endpoint_private_ip", primary_db_endpoint_private_ip)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Customer Subnet identifier
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[str]]:
        """
        List of customer NetworkSecurityGroup identifiers
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="primaryDbEndpointPrivateIp")
    def primary_db_endpoint_private_ip(self) -> Optional[str]:
        """
        Private IP in customer subnet. The value is optional. If the IP is not provided the IP will be chosen among the available IP addresses from the specified subnet.
        """
        return pulumi.get(self, "primary_db_endpoint_private_ip")


@pulumi.output_type
class DbSystemSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"
        elif key == "backupId":
            suggest = "backup_id"
        elif key == "isHavingRestoreConfigOverrides":
            suggest = "is_having_restore_config_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_type: str,
                 backup_id: Optional[str] = None,
                 is_having_restore_config_overrides: Optional[bool] = None):
        """
        :param str source_type: The source descriminator.
        :param str backup_id: DbSystem backup identifier.
        :param bool is_having_restore_config_overrides: Restore the DB config overrides from backup. Default is false
        """
        pulumi.set(__self__, "source_type", source_type)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if is_having_restore_config_overrides is not None:
            pulumi.set(__self__, "is_having_restore_config_overrides", is_having_restore_config_overrides)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The source descriminator.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[str]:
        """
        DbSystem backup identifier.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="isHavingRestoreConfigOverrides")
    def is_having_restore_config_overrides(self) -> Optional[bool]:
        """
        Restore the DB config overrides from backup. Default is false
        """
        return pulumi.get(self, "is_having_restore_config_overrides")


@pulumi.output_type
class DbSystemStorageDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isRegionallyDurable":
            suggest = "is_regionally_durable"
        elif key == "systemType":
            suggest = "system_type"
        elif key == "availabilityDomain":
            suggest = "availability_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemStorageDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemStorageDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemStorageDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_regionally_durable: bool,
                 system_type: str,
                 availability_domain: Optional[str] = None,
                 iops: Optional[str] = None):
        """
        :param bool is_regionally_durable: Specifies if the block volume used for the DbSystem is regional or AD-local. If not specified, it will be set to false. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        :param str system_type: Type of the DbSystem.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param str availability_domain: Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        :param str iops: (Updatable) DbSystem Performance Unit
        """
        pulumi.set(__self__, "is_regionally_durable", is_regionally_durable)
        pulumi.set(__self__, "system_type", system_type)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)

    @property
    @pulumi.getter(name="isRegionallyDurable")
    def is_regionally_durable(self) -> bool:
        """
        Specifies if the block volume used for the DbSystem is regional or AD-local. If not specified, it will be set to false. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        """
        return pulumi.get(self, "is_regionally_durable")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> str:
        """
        Type of the DbSystem.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_type")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def iops(self) -> Optional[str]:
        """
        (Updatable) DbSystem Performance Unit
        """
        return pulumi.get(self, "iops")


@pulumi.output_type
class GetBackupDbSystemDetailResult(dict):
    def __init__(__self__, *,
                 db_version: str,
                 system_type: str):
        """
        :param str db_version: The major and minor versions of the DbSystem software.
        :param str system_type: Type of the DbSystem.
        """
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "system_type", system_type)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> str:
        """
        The major and minor versions of the DbSystem software.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> str:
        """
        Type of the DbSystem.
        """
        return pulumi.get(self, "system_type")


@pulumi.output_type
class GetBackupsBackupCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetBackupsBackupCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetBackupsBackupCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetBackupsBackupCollectionItemResult(dict):
    def __init__(__self__, *,
                 backup_size: int,
                 compartment_id: str,
                 db_system_details: Sequence['outputs.GetBackupsBackupCollectionItemDbSystemDetailResult'],
                 db_system_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 last_accepted_request_token: str,
                 last_completed_request_token: str,
                 lifecycle_details: str,
                 retention_period: int,
                 source_type: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param int backup_size: Backup size in GB.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetBackupsBackupCollectionItemDbSystemDetailArgs'] db_system_details: Information about the DbSystem associated to a backup.
        :param str db_system_id: The source DbSystem OCID.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: Backup description
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: unique DbSystem identifier
        :param str last_accepted_request_token: lastAcceptedRequestToken from MP.
        :param str last_completed_request_token: lastCompletedRequestToken from MP.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param int retention_period: Backup retention period in days.
        :param str source_type: Specifies whether the backup was created manually, or via scheduled backup policy
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, Any] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the the Backup was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the Backup was updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "backup_size", backup_size)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_system_details", db_system_details)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_accepted_request_token", last_accepted_request_token)
        pulumi.set(__self__, "last_completed_request_token", last_completed_request_token)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "retention_period", retention_period)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="backupSize")
    def backup_size(self) -> int:
        """
        Backup size in GB.
        """
        return pulumi.get(self, "backup_size")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbSystemDetails")
    def db_system_details(self) -> Sequence['outputs.GetBackupsBackupCollectionItemDbSystemDetailResult']:
        """
        Information about the DbSystem associated to a backup.
        """
        return pulumi.get(self, "db_system_details")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> str:
        """
        The source DbSystem OCID.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Backup description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique DbSystem identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastAcceptedRequestToken")
    def last_accepted_request_token(self) -> str:
        """
        lastAcceptedRequestToken from MP.
        """
        return pulumi.get(self, "last_accepted_request_token")

    @property
    @pulumi.getter(name="lastCompletedRequestToken")
    def last_completed_request_token(self) -> str:
        """
        lastCompletedRequestToken from MP.
        """
        return pulumi.get(self, "last_completed_request_token")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> int:
        """
        Backup retention period in days.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Specifies whether the backup was created manually, or via scheduled backup policy
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the Backup was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Backup was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetBackupsBackupCollectionItemDbSystemDetailResult(dict):
    def __init__(__self__, *,
                 db_version: str,
                 system_type: str):
        """
        :param str db_version: The major and minor versions of the DbSystem software.
        :param str system_type: Type of the DbSystem.
        """
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "system_type", system_type)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> str:
        """
        The major and minor versions of the DbSystem software.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> str:
        """
        Type of the DbSystem.
        """
        return pulumi.get(self, "system_type")


@pulumi.output_type
class GetBackupsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetConfigurationConfigurationDetailResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigurationConfigurationDetailItemResult']):
        """
        :param Sequence['GetConfigurationConfigurationDetailItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigurationConfigurationDetailItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigurationConfigurationDetailItemResult(dict):
    def __init__(__self__, *,
                 allowed_values: str,
                 config_key: str,
                 data_type: str,
                 default_config_value: str,
                 description: str,
                 is_overridable: bool,
                 is_restart_required: bool,
                 overriden_config_value: str):
        """
        :param str allowed_values: Range or list of allowed values
        :param str config_key: Key is the configuration key.
        :param str data_type: Describes about the Datatype value.
        :param str default_config_value: Default value
        :param str description: Config description
        :param bool is_overridable: This flags tells whether the value is overridable or not.
        :param bool is_restart_required: If true, modfying this configuration value will requires restart.
        :param str overriden_config_value: User selected configuration value
        """
        pulumi.set(__self__, "allowed_values", allowed_values)
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "default_config_value", default_config_value)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "is_overridable", is_overridable)
        pulumi.set(__self__, "is_restart_required", is_restart_required)
        pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> str:
        """
        Range or list of allowed values
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> str:
        """
        Key is the configuration key.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        Describes about the Datatype value.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultConfigValue")
    def default_config_value(self) -> str:
        """
        Default value
        """
        return pulumi.get(self, "default_config_value")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Config description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOverridable")
    def is_overridable(self) -> bool:
        """
        This flags tells whether the value is overridable or not.
        """
        return pulumi.get(self, "is_overridable")

    @property
    @pulumi.getter(name="isRestartRequired")
    def is_restart_required(self) -> bool:
        """
        If true, modfying this configuration value will requires restart.
        """
        return pulumi.get(self, "is_restart_required")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> str:
        """
        User selected configuration value
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class GetConfigurationDbConfigurationOverrideResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigurationDbConfigurationOverrideItemResult']):
        """
        :param Sequence['GetConfigurationDbConfigurationOverrideItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigurationDbConfigurationOverrideItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigurationDbConfigurationOverrideItemResult(dict):
    def __init__(__self__, *,
                 config_key: str,
                 overriden_config_value: str):
        """
        :param str config_key: Key is the configuration key.
        :param str overriden_config_value: User selected configuration value
        """
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> str:
        """
        Key is the configuration key.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> str:
        """
        User selected configuration value
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigurationsConfigurationCollectionItemResult']):
        """
        :param Sequence['GetConfigurationsConfigurationCollectionItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigurationsConfigurationCollectionItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 configuration_details: Sequence['outputs.GetConfigurationsConfigurationCollectionItemConfigurationDetailResult'],
                 db_configuration_overrides: Sequence['outputs.GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideResult'],
                 db_version: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 instance_memory_size_in_gbs: int,
                 instance_ocpu_count: int,
                 lifecycle_details: str,
                 shape: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetConfigurationsConfigurationCollectionItemConfigurationDetailArgs'] configuration_details: List of DB Configuration Values.
        :param str db_version: Verison of the Postgresql DB like 14.5
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: Config description
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: Unique identifier that is immutable on creation
        :param int instance_memory_size_in_gbs: Memory Size in GB with 1GB increment. Min value matches the cpuCoreCount. Max value depends on the shape.
        :param int instance_ocpu_count: CPU cpuCoreCount. Min value is 1. Max value depends on the shape.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str shape: Shape name of the compute like VM.Standard.E4.Flex or VM.Standard3.Flex
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, Any] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time Configuration was created. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configuration_details", configuration_details)
        pulumi.set(__self__, "db_configuration_overrides", db_configuration_overrides)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Sequence['outputs.GetConfigurationsConfigurationCollectionItemConfigurationDetailResult']:
        """
        List of DB Configuration Values.
        """
        return pulumi.get(self, "configuration_details")

    @property
    @pulumi.getter(name="dbConfigurationOverrides")
    def db_configuration_overrides(self) -> Sequence['outputs.GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideResult']:
        return pulumi.get(self, "db_configuration_overrides")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> str:
        """
        Verison of the Postgresql DB like 14.5
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Config description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> int:
        """
        Memory Size in GB with 1GB increment. Min value matches the cpuCoreCount. Max value depends on the shape.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> int:
        """
        CPU cpuCoreCount. Min value is 1. Max value depends on the shape.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        Shape name of the compute like VM.Standard.E4.Flex or VM.Standard3.Flex
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time Configuration was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionItemConfigurationDetailResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigurationsConfigurationCollectionItemConfigurationDetailItemResult']):
        """
        :param Sequence['GetConfigurationsConfigurationCollectionItemConfigurationDetailItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigurationsConfigurationCollectionItemConfigurationDetailItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionItemConfigurationDetailItemResult(dict):
    def __init__(__self__, *,
                 allowed_values: str,
                 config_key: str,
                 data_type: str,
                 default_config_value: str,
                 description: str,
                 is_overridable: bool,
                 is_restart_required: bool,
                 overriden_config_value: str):
        """
        :param str allowed_values: Range or list of allowed values
        :param str config_key: Key is the configuration key.
        :param str data_type: Describes about the Datatype value.
        :param str default_config_value: Default value
        :param str description: Config description
        :param bool is_overridable: This flags tells whether the value is overridable or not.
        :param bool is_restart_required: If true, modfying this configuration value will requires restart.
        :param str overriden_config_value: User selected configuration value
        """
        pulumi.set(__self__, "allowed_values", allowed_values)
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "default_config_value", default_config_value)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "is_overridable", is_overridable)
        pulumi.set(__self__, "is_restart_required", is_restart_required)
        pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> str:
        """
        Range or list of allowed values
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> str:
        """
        Key is the configuration key.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        Describes about the Datatype value.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultConfigValue")
    def default_config_value(self) -> str:
        """
        Default value
        """
        return pulumi.get(self, "default_config_value")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Config description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOverridable")
    def is_overridable(self) -> bool:
        """
        This flags tells whether the value is overridable or not.
        """
        return pulumi.get(self, "is_overridable")

    @property
    @pulumi.getter(name="isRestartRequired")
    def is_restart_required(self) -> bool:
        """
        If true, modfying this configuration value will requires restart.
        """
        return pulumi.get(self, "is_restart_required")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> str:
        """
        User selected configuration value
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideItemResult']):
        """
        :param Sequence['GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideItemResult(dict):
    def __init__(__self__, *,
                 config_key: str,
                 overriden_config_value: str):
        """
        :param str config_key: Key is the configuration key.
        :param str overriden_config_value: User selected configuration value
        """
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> str:
        """
        Key is the configuration key.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> str:
        """
        User selected configuration value
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class GetConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDbSystemConnectionDetailInstanceEndpointResult(dict):
    def __init__(__self__, *,
                 db_instance_id: str,
                 endpoints: Sequence['outputs.GetDbSystemConnectionDetailInstanceEndpointEndpointResult']):
        """
        :param str db_instance_id: Unique identifier of the DbInstance.
        :param Sequence['GetDbSystemConnectionDetailInstanceEndpointEndpointArgs'] endpoints: The node endpoint information.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "endpoints", endpoints)

    @property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> str:
        """
        Unique identifier of the DbInstance.
        """
        return pulumi.get(self, "db_instance_id")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetDbSystemConnectionDetailInstanceEndpointEndpointResult']:
        """
        The node endpoint information.
        """
        return pulumi.get(self, "endpoints")


@pulumi.output_type
class GetDbSystemConnectionDetailInstanceEndpointEndpointResult(dict):
    def __init__(__self__, *,
                 fqdn: str,
                 ip_address: str,
                 port: int):
        """
        :param str fqdn: The FQDN of the endpoint
        :param str ip_address: The IP Address of the endpoint
        :param int port: The port Address of the endpoint
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        The FQDN of the endpoint
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP Address of the endpoint
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port Address of the endpoint
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetDbSystemConnectionDetailPrimaryDbEndpointResult(dict):
    def __init__(__self__, *,
                 fqdn: str,
                 ip_address: str,
                 port: int):
        """
        :param str fqdn: The FQDN of the endpoint
        :param str ip_address: The IP Address of the endpoint
        :param int port: The port Address of the endpoint
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        The FQDN of the endpoint
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP Address of the endpoint
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port Address of the endpoint
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetDbSystemCredentialResult(dict):
    def __init__(__self__, *,
                 password_details: Sequence['outputs.GetDbSystemCredentialPasswordDetailResult'],
                 username: str):
        pulumi.set(__self__, "password_details", password_details)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordDetails")
    def password_details(self) -> Sequence['outputs.GetDbSystemCredentialPasswordDetailResult']:
        return pulumi.get(self, "password_details")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetDbSystemCredentialPasswordDetailResult(dict):
    def __init__(__self__, *,
                 password: str,
                 password_type: str,
                 secret_id: str,
                 secret_version: str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "password_type", password_type)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordType")
    def password_type(self) -> str:
        return pulumi.get(self, "password_type")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> str:
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class GetDbSystemInstanceResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 description: str,
                 display_name: str,
                 id: str,
                 lifecycle_details: str,
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str availability_domain: Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        :param str description: Description of the DbInstance.
        :param str display_name: Display name of the DbInstance.
        :param str id: Unique identifier that is immutable on creation.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str state: The current state of the DbSystem.
        :param str time_created: The time the the DbSystem was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the DbInstance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name of the DbInstance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the DbSystem.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the DbSystem was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDbSystemInstancesDetailResult(dict):
    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 private_ip: str):
        """
        :param str description: Description of the DbInstance.
        :param str display_name: Display name of the DbInstance.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the DbInstance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name of the DbInstance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetDbSystemManagementPolicyResult(dict):
    def __init__(__self__, *,
                 backup_policies: Sequence['outputs.GetDbSystemManagementPolicyBackupPolicyResult'],
                 maintenance_window_start: str):
        """
        :param Sequence['GetDbSystemManagementPolicyBackupPolicyArgs'] backup_policies: Posgresql DB system backup policy
        :param str maintenance_window_start: The start of the maintenance window.
        """
        pulumi.set(__self__, "backup_policies", backup_policies)
        pulumi.set(__self__, "maintenance_window_start", maintenance_window_start)

    @property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Sequence['outputs.GetDbSystemManagementPolicyBackupPolicyResult']:
        """
        Posgresql DB system backup policy
        """
        return pulumi.get(self, "backup_policies")

    @property
    @pulumi.getter(name="maintenanceWindowStart")
    def maintenance_window_start(self) -> str:
        """
        The start of the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_start")


@pulumi.output_type
class GetDbSystemManagementPolicyBackupPolicyResult(dict):
    def __init__(__self__, *,
                 backup_start: str,
                 days_of_the_months: Sequence[int],
                 days_of_the_weeks: Sequence[str],
                 kind: str,
                 retention_days: int):
        """
        :param str backup_start: Hour of the day when backup starts.
        :param Sequence[int] days_of_the_months: Days of the month when backup should start. If the day is greater last day of the current month, then it will be triggered on the last day of the current month
        :param Sequence[str] days_of_the_weeks: Weekly days
        :param str kind: Backup policy kind
        :param int retention_days: How many days the customers data should be stored after the db system deletion.
        """
        pulumi.set(__self__, "backup_start", backup_start)
        pulumi.set(__self__, "days_of_the_months", days_of_the_months)
        pulumi.set(__self__, "days_of_the_weeks", days_of_the_weeks)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="backupStart")
    def backup_start(self) -> str:
        """
        Hour of the day when backup starts.
        """
        return pulumi.get(self, "backup_start")

    @property
    @pulumi.getter(name="daysOfTheMonths")
    def days_of_the_months(self) -> Sequence[int]:
        """
        Days of the month when backup should start. If the day is greater last day of the current month, then it will be triggered on the last day of the current month
        """
        return pulumi.get(self, "days_of_the_months")

    @property
    @pulumi.getter(name="daysOfTheWeeks")
    def days_of_the_weeks(self) -> Sequence[str]:
        """
        Weekly days
        """
        return pulumi.get(self, "days_of_the_weeks")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Backup policy kind
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> int:
        """
        How many days the customers data should be stored after the db system deletion.
        """
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class GetDbSystemNetworkDetailResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[str],
                 primary_db_endpoint_private_ip: str,
                 subnet_id: str):
        """
        :param Sequence[str] nsg_ids: List of customer NetworkSecurityGroup identifiers
        :param str primary_db_endpoint_private_ip: Private IP in customer subnet. The value is optional. If the IP is not provided the IP will be chosen among the available IP addresses from the specified subnet.
        :param str subnet_id: Customer Subnet identifier
        """
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "primary_db_endpoint_private_ip", primary_db_endpoint_private_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        List of customer NetworkSecurityGroup identifiers
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="primaryDbEndpointPrivateIp")
    def primary_db_endpoint_private_ip(self) -> str:
        """
        Private IP in customer subnet. The value is optional. If the IP is not provided the IP will be chosen among the available IP addresses from the specified subnet.
        """
        return pulumi.get(self, "primary_db_endpoint_private_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Customer Subnet identifier
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetDbSystemSourceResult(dict):
    def __init__(__self__, *,
                 backup_id: str,
                 is_having_restore_config_overrides: bool,
                 source_type: str):
        """
        :param str backup_id: DbSystem backup identifier.
        :param bool is_having_restore_config_overrides: Restore the DB config overrides from backup. Default is false
        :param str source_type: The source descriminator.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "is_having_restore_config_overrides", is_having_restore_config_overrides)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> str:
        """
        DbSystem backup identifier.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="isHavingRestoreConfigOverrides")
    def is_having_restore_config_overrides(self) -> bool:
        """
        Restore the DB config overrides from backup. Default is false
        """
        return pulumi.get(self, "is_having_restore_config_overrides")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The source descriminator.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetDbSystemStorageDetailResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 iops: str,
                 is_regionally_durable: bool,
                 system_type: str):
        """
        :param str availability_domain: Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        :param str iops: DbSystem Performance Unit
        :param bool is_regionally_durable: Specifies if the block volume used for the DbSystem is regional or AD-local. If not specified, it will be set to false. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        :param str system_type: Type of the DbSystem.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "is_regionally_durable", is_regionally_durable)
        pulumi.set(__self__, "system_type", system_type)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def iops(self) -> str:
        """
        DbSystem Performance Unit
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="isRegionallyDurable")
    def is_regionally_durable(self) -> bool:
        """
        Specifies if the block volume used for the DbSystem is regional or AD-local. If not specified, it will be set to false. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        """
        return pulumi.get(self, "is_regionally_durable")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> str:
        """
        Type of the DbSystem.
        """
        return pulumi.get(self, "system_type")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDbSystemsDbSystemCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemResult(dict):
    def __init__(__self__, *,
                 admin_username: str,
                 compartment_id: str,
                 config_id: str,
                 credentials: Sequence['outputs.GetDbSystemsDbSystemCollectionItemCredentialResult'],
                 db_version: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 instance_count: int,
                 instance_memory_size_in_gbs: int,
                 instance_ocpu_count: int,
                 instances: Sequence['outputs.GetDbSystemsDbSystemCollectionItemInstanceResult'],
                 instances_details: Sequence['outputs.GetDbSystemsDbSystemCollectionItemInstancesDetailResult'],
                 lifecycle_details: str,
                 management_policies: Sequence['outputs.GetDbSystemsDbSystemCollectionItemManagementPolicyResult'],
                 network_details: Sequence['outputs.GetDbSystemsDbSystemCollectionItemNetworkDetailResult'],
                 shape: str,
                 sources: Sequence['outputs.GetDbSystemsDbSystemCollectionItemSourceResult'],
                 state: str,
                 storage_details: Sequence['outputs.GetDbSystemsDbSystemCollectionItemStorageDetailResult'],
                 system_tags: Mapping[str, Any],
                 system_type: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str admin_username: The DB system username.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str config_id: Configuration identifier
        :param str db_version: The major and minor versions of the DbSystem software.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: Description of the DbInstance.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: unique DbSystem identifier
        :param int instance_count: Count of DbInstances in the DbSystem.
        :param int instance_memory_size_in_gbs: The total amount of memory available to each DbInstance, in gigabytes.
        :param int instance_ocpu_count: The total number of OCPUs available to each DbInstance.
        :param Sequence['GetDbSystemsDbSystemCollectionItemInstanceArgs'] instances: The list of DbInstances in the DbSystem.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetDbSystemsDbSystemCollectionItemManagementPolicyArgs'] management_policies: PostgreSQL DB system management policy
        :param Sequence['GetDbSystemsDbSystemCollectionItemNetworkDetailArgs'] network_details: DbSystem network details.
        :param str shape: Shape of dbInstance.
        :param Sequence['GetDbSystemsDbSystemCollectionItemSourceArgs'] sources: New source is used to restore the DB system.
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Sequence['GetDbSystemsDbSystemCollectionItemStorageDetailArgs'] storage_details: Storage details of the DbSystem.
        :param Mapping[str, Any] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str system_type: Type of the DbSystem.
        :param str time_created: The time the the DbSystem was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "admin_username", admin_username)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "instances_details", instances_details)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "management_policies", management_policies)
        pulumi.set(__self__, "network_details", network_details)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "storage_details", storage_details)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "system_type", system_type)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> str:
        """
        The DB system username.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> str:
        """
        Configuration identifier
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter
    def credentials(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemCredentialResult']:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> str:
        """
        The major and minor versions of the DbSystem software.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the DbInstance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique DbSystem identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        Count of DbInstances in the DbSystem.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> int:
        """
        The total amount of memory available to each DbInstance, in gigabytes.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> int:
        """
        The total number of OCPUs available to each DbInstance.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemInstanceResult']:
        """
        The list of DbInstances in the DbSystem.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="instancesDetails")
    def instances_details(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemInstancesDetailResult']:
        return pulumi.get(self, "instances_details")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="managementPolicies")
    def management_policies(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemManagementPolicyResult']:
        """
        PostgreSQL DB system management policy
        """
        return pulumi.get(self, "management_policies")

    @property
    @pulumi.getter(name="networkDetails")
    def network_details(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemNetworkDetailResult']:
        """
        DbSystem network details.
        """
        return pulumi.get(self, "network_details")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        Shape of dbInstance.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemSourceResult']:
        """
        New source is used to restore the DB system.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageDetails")
    def storage_details(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemStorageDetailResult']:
        """
        Storage details of the DbSystem.
        """
        return pulumi.get(self, "storage_details")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> str:
        """
        Type of the DbSystem.
        """
        return pulumi.get(self, "system_type")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the DbSystem was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemCredentialResult(dict):
    def __init__(__self__, *,
                 password_details: Sequence['outputs.GetDbSystemsDbSystemCollectionItemCredentialPasswordDetailResult'],
                 username: str):
        pulumi.set(__self__, "password_details", password_details)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordDetails")
    def password_details(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemCredentialPasswordDetailResult']:
        return pulumi.get(self, "password_details")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemCredentialPasswordDetailResult(dict):
    def __init__(__self__, *,
                 password: str,
                 password_type: str,
                 secret_id: str,
                 secret_version: str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "password_type", password_type)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordType")
    def password_type(self) -> str:
        return pulumi.get(self, "password_type")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> str:
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemInstanceResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 description: str,
                 display_name: str,
                 id: str,
                 lifecycle_details: str,
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str availability_domain: Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        :param str description: Description of the DbInstance.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str id: unique DbSystem identifier
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param str time_created: The time the the DbSystem was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the DbInstance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique DbSystem identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the DbSystem was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemInstancesDetailResult(dict):
    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 private_ip: str):
        """
        :param str description: Description of the DbInstance.
        :param str display_name: A filter to return only resources that match the entire display name given.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the DbInstance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemManagementPolicyResult(dict):
    def __init__(__self__, *,
                 backup_policies: Sequence['outputs.GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyResult'],
                 maintenance_window_start: str):
        """
        :param Sequence['GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyArgs'] backup_policies: Posgresql DB system backup policy
        :param str maintenance_window_start: The start of the maintenance window.
        """
        pulumi.set(__self__, "backup_policies", backup_policies)
        pulumi.set(__self__, "maintenance_window_start", maintenance_window_start)

    @property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyResult']:
        """
        Posgresql DB system backup policy
        """
        return pulumi.get(self, "backup_policies")

    @property
    @pulumi.getter(name="maintenanceWindowStart")
    def maintenance_window_start(self) -> str:
        """
        The start of the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_start")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyResult(dict):
    def __init__(__self__, *,
                 backup_start: str,
                 days_of_the_months: Sequence[int],
                 days_of_the_weeks: Sequence[str],
                 kind: str,
                 retention_days: int):
        """
        :param str backup_start: Hour of the day when backup starts.
        :param Sequence[int] days_of_the_months: Days of the month when backup should start. If the day is greater last day of the current month, then it will be triggered on the last day of the current month
        :param Sequence[str] days_of_the_weeks: Weekly days
        :param str kind: Backup policy kind
        :param int retention_days: How many days the customers data should be stored after the db system deletion.
        """
        pulumi.set(__self__, "backup_start", backup_start)
        pulumi.set(__self__, "days_of_the_months", days_of_the_months)
        pulumi.set(__self__, "days_of_the_weeks", days_of_the_weeks)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="backupStart")
    def backup_start(self) -> str:
        """
        Hour of the day when backup starts.
        """
        return pulumi.get(self, "backup_start")

    @property
    @pulumi.getter(name="daysOfTheMonths")
    def days_of_the_months(self) -> Sequence[int]:
        """
        Days of the month when backup should start. If the day is greater last day of the current month, then it will be triggered on the last day of the current month
        """
        return pulumi.get(self, "days_of_the_months")

    @property
    @pulumi.getter(name="daysOfTheWeeks")
    def days_of_the_weeks(self) -> Sequence[str]:
        """
        Weekly days
        """
        return pulumi.get(self, "days_of_the_weeks")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Backup policy kind
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> int:
        """
        How many days the customers data should be stored after the db system deletion.
        """
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemNetworkDetailResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[str],
                 primary_db_endpoint_private_ip: str,
                 subnet_id: str):
        """
        :param Sequence[str] nsg_ids: List of customer NetworkSecurityGroup identifiers
        :param str primary_db_endpoint_private_ip: Private IP in customer subnet. The value is optional. If the IP is not provided the IP will be chosen among the available IP addresses from the specified subnet.
        :param str subnet_id: Customer Subnet identifier
        """
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "primary_db_endpoint_private_ip", primary_db_endpoint_private_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        List of customer NetworkSecurityGroup identifiers
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="primaryDbEndpointPrivateIp")
    def primary_db_endpoint_private_ip(self) -> str:
        """
        Private IP in customer subnet. The value is optional. If the IP is not provided the IP will be chosen among the available IP addresses from the specified subnet.
        """
        return pulumi.get(self, "primary_db_endpoint_private_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Customer Subnet identifier
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemSourceResult(dict):
    def __init__(__self__, *,
                 backup_id: str,
                 is_having_restore_config_overrides: bool,
                 source_type: str):
        """
        :param str backup_id: DbSystem backup identifier.
        :param bool is_having_restore_config_overrides: Restore the DB config overrides from backup. Default is false
        :param str source_type: The source descriminator.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "is_having_restore_config_overrides", is_having_restore_config_overrides)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> str:
        """
        DbSystem backup identifier.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="isHavingRestoreConfigOverrides")
    def is_having_restore_config_overrides(self) -> bool:
        """
        Restore the DB config overrides from backup. Default is false
        """
        return pulumi.get(self, "is_having_restore_config_overrides")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The source descriminator.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemStorageDetailResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 iops: str,
                 is_regionally_durable: bool,
                 system_type: str):
        """
        :param str availability_domain: Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        :param str iops: DbSystem Performance Unit
        :param bool is_regionally_durable: Specifies if the block volume used for the DbSystem is regional or AD-local. If not specified, it will be set to false. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        :param str system_type: Type of the DbSystem.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "is_regionally_durable", is_regionally_durable)
        pulumi.set(__self__, "system_type", system_type)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        Specifies the availability domain of AD-local storage. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def iops(self) -> str:
        """
        DbSystem Performance Unit
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="isRegionallyDurable")
    def is_regionally_durable(self) -> bool:
        """
        Specifies if the block volume used for the DbSystem is regional or AD-local. If not specified, it will be set to false. If isRegionallyDurable is set to true, availabilityDomain should not be specified. If isRegionallyDurable is set to false, availabilityDomain must be specified.
        """
        return pulumi.get(self, "is_regionally_durable")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> str:
        """
        Type of the DbSystem.
        """
        return pulumi.get(self, "system_type")


@pulumi.output_type
class GetDbSystemsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDefaultConfigurationConfigurationDetailResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDefaultConfigurationConfigurationDetailItemResult']):
        """
        :param Sequence['GetDefaultConfigurationConfigurationDetailItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDefaultConfigurationConfigurationDetailItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDefaultConfigurationConfigurationDetailItemResult(dict):
    def __init__(__self__, *,
                 allowed_values: str,
                 config_key: str,
                 data_type: str,
                 default_config_value: str,
                 description: str,
                 is_overridable: bool,
                 is_restart_required: bool):
        """
        :param str allowed_values: Range or list of allowed values
        :param str config_key: Key is the configuration key.
        :param str data_type: Describes about the Datatype value.
        :param str default_config_value: Default value
        :param str description: Config description
        :param bool is_overridable: This flags tells whether the value is overridable or not.
        :param bool is_restart_required: If true, modfying this configuration value will requires restart.
        """
        pulumi.set(__self__, "allowed_values", allowed_values)
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "default_config_value", default_config_value)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "is_overridable", is_overridable)
        pulumi.set(__self__, "is_restart_required", is_restart_required)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> str:
        """
        Range or list of allowed values
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> str:
        """
        Key is the configuration key.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        Describes about the Datatype value.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultConfigValue")
    def default_config_value(self) -> str:
        """
        Default value
        """
        return pulumi.get(self, "default_config_value")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Config description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOverridable")
    def is_overridable(self) -> bool:
        """
        This flags tells whether the value is overridable or not.
        """
        return pulumi.get(self, "is_overridable")

    @property
    @pulumi.getter(name="isRestartRequired")
    def is_restart_required(self) -> bool:
        """
        If true, modfying this configuration value will requires restart.
        """
        return pulumi.get(self, "is_restart_required")


@pulumi.output_type
class GetDefaultConfigurationsDefaultConfigurationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemResult']):
        """
        :param Sequence['GetDefaultConfigurationsDefaultConfigurationCollectionItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDefaultConfigurationsDefaultConfigurationCollectionItemResult(dict):
    def __init__(__self__, *,
                 configuration_details: Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailResult'],
                 db_version: str,
                 description: str,
                 display_name: str,
                 id: str,
                 instance_memory_size_in_gbs: int,
                 instance_ocpu_count: int,
                 lifecycle_details: str,
                 shape: str,
                 state: str,
                 time_created: str):
        """
        :param Sequence['GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailArgs'] configuration_details: List of DB default Configuration Values.
        :param str db_version: Verison of the Postgresql DB like 14.5
        :param str description: Config description
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str id: Unique identifier that is immutable on creation
        :param int instance_memory_size_in_gbs: Memory Size in GB with 1GB increment. Min value matches the cpuCoreCount. Max value depends on the shape.
        :param int instance_ocpu_count: CPU cpuCoreCount. Min value is 1. Max value depends on the shape.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str shape: Shape name of the compute like VM.Standard.E4.Flex or VM.Standard3.Flex
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param str time_created: The time Configuration was created. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "configuration_details", configuration_details)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailResult']:
        """
        List of DB default Configuration Values.
        """
        return pulumi.get(self, "configuration_details")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> str:
        """
        Verison of the Postgresql DB like 14.5
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Config description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> int:
        """
        Memory Size in GB with 1GB increment. Min value matches the cpuCoreCount. Max value depends on the shape.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> int:
        """
        CPU cpuCoreCount. Min value is 1. Max value depends on the shape.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        Shape name of the compute like VM.Standard.E4.Flex or VM.Standard3.Flex
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time Configuration was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailItemResult']):
        """
        :param Sequence['GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailItemResult(dict):
    def __init__(__self__, *,
                 allowed_values: str,
                 config_key: str,
                 data_type: str,
                 default_config_value: str,
                 description: str,
                 is_overridable: bool,
                 is_restart_required: bool):
        """
        :param str allowed_values: Range or list of allowed values
        :param str config_key: Key is the configuration key.
        :param str data_type: Describes about the Datatype value.
        :param str default_config_value: Default value
        :param str description: Config description
        :param bool is_overridable: This flags tells whether the value is overridable or not.
        :param bool is_restart_required: If true, modfying this configuration value will requires restart.
        """
        pulumi.set(__self__, "allowed_values", allowed_values)
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "default_config_value", default_config_value)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "is_overridable", is_overridable)
        pulumi.set(__self__, "is_restart_required", is_restart_required)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> str:
        """
        Range or list of allowed values
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> str:
        """
        Key is the configuration key.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        Describes about the Datatype value.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultConfigValue")
    def default_config_value(self) -> str:
        """
        Default value
        """
        return pulumi.get(self, "default_config_value")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Config description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOverridable")
    def is_overridable(self) -> bool:
        """
        This flags tells whether the value is overridable or not.
        """
        return pulumi.get(self, "is_overridable")

    @property
    @pulumi.getter(name="isRestartRequired")
    def is_restart_required(self) -> bool:
        """
        If true, modfying this configuration value will requires restart.
        """
        return pulumi.get(self, "is_restart_required")


@pulumi.output_type
class GetDefaultConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetShapesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetShapesShapeCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetShapesShapeCollectionItemResult']):
        """
        :param Sequence['GetShapesShapeCollectionItemArgs'] items: List of dbSystems.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetShapesShapeCollectionItemResult']:
        """
        List of dbSystems.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetShapesShapeCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: str,
                 memory_size_in_gbs: int,
                 ocpu_count: int,
                 shape: str):
        """
        :param str id: A filter to return the feature by the shape name.
        :param int memory_size_in_gbs: The amount of memory in GB
        :param int ocpu_count: The number of OCPUs
        :param str shape: The Compute Shape Name like VM.Standard.E4.Flex
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        pulumi.set(__self__, "ocpu_count", ocpu_count)
        pulumi.set(__self__, "shape", shape)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return the feature by the shape name.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> int:
        """
        The amount of memory in GB
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> int:
        """
        The number of OCPUs
        """
        return pulumi.get(self, "ocpu_count")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        The Compute Shape Name like VM.Standard.E4.Flex
        """
        return pulumi.get(self, "shape")


