import * as route53 from '@aws-cdk/aws-route53';
import * as s3 from '@aws-cdk/aws-s3';
/**
 * Use a S3 as an alias record target.
 *
 * @stability stable
 */
export declare class BucketWebsiteTarget implements route53.IAliasRecordTarget {
    private readonly bucket;
    /**
     * @stability stable
     */
    constructor(bucket: s3.IBucket);
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record: route53.IRecordSet): route53.AliasRecordTargetConfig;
}
