import * as elb from '@aws-cdk/aws-elasticloadbalancing';
import * as route53 from '@aws-cdk/aws-route53';
/**
 * Use a classic ELB as an alias record target.
 *
 * @stability stable
 */
export declare class ClassicLoadBalancerTarget implements route53.IAliasRecordTarget {
    private readonly loadBalancer;
    /**
     * @stability stable
     */
    constructor(loadBalancer: elb.LoadBalancer);
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record: route53.IRecordSet): route53.AliasRecordTargetConfig;
}
