# backwards compat imports
from ovos_utils.ocp import MediaType, PlayerState, MediaState, MatchConfidence,\
    PlaybackType, PlaybackMode, LoopState, TrackState


def ocp_search():
    """
    Decorator for adding a method as a common play search handler.
    Decorated methods should either yield or return a list of dict results:
    {
      "media_type": <MediaType>,
      "playback": <PlaybackType>,
      "image": <(optional) str image/cover art URI>,
      "skill_icon": <(optional) str skill icon URI>,
      "bg_image": <(optional) str background image URI>,
      "uri": <str media URI>,
      "title": <str media title>,
      "artist": <str media artist/author>,
      "length": <(optional) int media length in milliseconds>,
      "match_confidence": <int 0-100 confidence this result matches request>
    }
    """

    def real_decorator(func):
        # Store the flag inside the function
        # This will be used later to identify the method
        if not hasattr(func, 'is_ocp_search_handler'):
            func.is_ocp_search_handler = True

        return func

    return real_decorator


def ocp_play():
    """
    Decorator for adding a method to handle media playback.
    """

    def real_decorator(func):
        # Store the flag inside the function
        # This will be used later to identify the method
        if not hasattr(func, 'is_ocp_playback_handler'):
            func.is_ocp_playback_handler = True

        return func

    return real_decorator


def ocp_previous():
    """
    Decorator for adding a method to handle requests to skip backward.
    """

    def real_decorator(func):
        # Store the flag inside the function
        # This will be used later to identify the method
        if not hasattr(func, 'is_ocp_prev_handler'):
            func.is_ocp_prev_handler = True

        return func

    return real_decorator


def ocp_next():
    """
    Decorator for adding a method to handle requests to skip forward.
    """

    def real_decorator(func):
        # Store the flag inside the function
        # This will be used later to identify the method
        if not hasattr(func, 'is_ocp_next_handler'):
            func.is_ocp_next_handler = True

        return func

    return real_decorator


def ocp_pause():
    """
    Decorator for adding a method to handle requests to pause playback.
    """

    def real_decorator(func):
        # Store the flag inside the function
        # This will be used later to identify the method
        if not hasattr(func, 'is_ocp_pause_handler'):
            func.is_ocp_pause_handler = True

        return func

    return real_decorator


def ocp_resume():
    """
    Decorator for adding a method to handle requests to resume playback.
    """

    def real_decorator(func):
        # Store the flag inside the function
        # This will be used later to identify the method
        if not hasattr(func, 'is_ocp_resume_handler'):
            func.is_ocp_resume_handler = True

        return func

    return real_decorator


def ocp_featured_media():
    """
    Decorator for adding a method to handle requests to provide featured media.
    """

    def real_decorator(func):
        # Store the flag inside the function
        # This will be used later to identify the method
        if not hasattr(func, 'is_ocp_featured_handler'):
            func.is_ocp_featured_handler = True

        return func

    return real_decorator

