def login(client):
    """ Login an API client object.

    This function calls the auth/token endpoint in order to obtain an
    authentication bearer token. It changes *in place* the `client` to update
    its access token configuration.

    Parameters
    ----------
    client: quetzal.client.Client
        Client object that will be used for the Quetzal API operation. Its
        configuration will be updated according to the results.

    Returns
    -------
    A response object whose type depends on autogenerated code. It has
    a `token` member with the access token obtained after a successful
    login.

    Raises
    ------
    quetzal.client.exceptions.QuetzalAPIException
        When the API returns an error.
    urllib3.exceptions.RequestError
        When there was a problem connecting to the server.

    """
    response = client.auth_get_token()
    # Manage success: save the access token
    client.configuration.access_token = response.token
    return response


def logout(client):
    """ Logout an API client object.

    This fucntion calls the auth/logout endpoint in order to invalidate the
    token associated to the user. In changes *in place* the `client` to
    update its access token configuration.

    Parameters
    ----------
    client: quetzal.client.Client
        Client object that will be used for the Quetzal API operation. Its
        configuration will be updated according to the results.

    Returns
    -------
    None

    Raises
    ------
    quetzal.client.exceptions.QuetzalAPIException
        When the API returns an error.
    urllib3.exceptions.RequestError
        When there was a problem connecting to the server.

    """
    client.auth_logout()
    # Manage success: save the access token
    client.configuration.access_token = None

