"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Analysis import SampleSizes
from zospy.api._ZOSAPI.Analysis.Settings import IAS_

__all__ = (
    "DisplayAsTypes",
    "Distortions",
    "FFA_AberrationTypes",
    "FFA_DecompositionTypes",
    "FFA_DisplayTypes",
    "FFA_FieldShapes",
    "FFA_ShowAsTypes",
    "FieldScanDirections",
    "IAS_FieldCurvatureAndDistortion",
    "IAS_FocalShiftDiagram",
    "IAS_FullFieldAberration",
    "IAS_GridDistortion",
    "IAS_LateralColor",
    "IAS_LongitudinalAberration",
    "IAS_RayTrace",
    "IAS_SeidelCoefficients",
    "IAS_SeidelDiagram",
    "IAS_ZernikeAnnularCoefficients",
    "IAS_ZernikeCoefficientsVsField",
    "IAS_ZernikeFringeCoefficients",
    "IAS_ZernikeStandardCoefficients",
    "RayTraceType",
    "ZernikeCoefficientTypes",
)

class DisplayAsTypes:
    Percent = 0
    Absolute = 1

class Distortions:
    F_TanTheta = 0
    F_Theta = 1
    Cal_F_Theta = 2
    Cal_F_TanTheta = 3
    SMIA_TV = 4

class FFA_AberrationTypes:
    Defocus = 0
    PrimaryAstigmatism = 1
    PrimaryComa = 2
    SpecifiedTerm = 3

class FFA_DecompositionTypes:
    ZernikeTerms = 0

class FFA_DisplayTypes:
    Absolute = 0
    Relative = 1
    Average = 2

class FFA_FieldShapes:
    Rectangular = 0
    Elliptical = 1

class FFA_ShowAsTypes:
    GreyScale = 0
    GreyScaleInverted = 1
    FalseColor = 2
    FalseColorInverted = 3
    Icons = 4

class FieldScanDirections:
    Plus_Y = 0
    Plus_X = 1
    Minus_Y = 2
    Minus_X = 3

class IAS_FieldCurvatureAndDistortion(IAS_):
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def DisplayAs(self) -> DisplayAsTypes: ...
    @DisplayAs.setter
    def DisplayAs(self, value: DisplayAsTypes) -> None: ...
    @property
    def Distortion(self) -> Distortions: ...
    @Distortion.setter
    def Distortion(self, value: Distortions) -> None: ...
    @property
    def ScanType(self) -> FieldScanDirections: ...
    @ScanType.setter
    def ScanType(self, value: FieldScanDirections) -> None: ...
    @property
    def UseDashes(self) -> bool: ...
    @UseDashes.setter
    def UseDashes(self, value: bool) -> None: ...
    @property
    def IgnoreVignette(self) -> bool: ...
    @IgnoreVignette.setter
    def IgnoreVignette(self, value: bool) -> None: ...
    @property
    def MaximumCurvature(self) -> float: ...
    @MaximumCurvature.setter
    def MaximumCurvature(self, value: float) -> None: ...
    @property
    def MaximumDistortion(self) -> float: ...
    @MaximumDistortion.setter
    def MaximumDistortion(self, value: float) -> None: ...
    @property
    def ReferenceField(self) -> IAS_Field: ...
    @property
    def FieldAspectRatio(self) -> float: ...
    @FieldAspectRatio.setter
    def FieldAspectRatio(self, value: float) -> None: ...

class IAS_FocalShiftDiagram(IAS_):
    @property
    def MaximumShift(self) -> float: ...
    @MaximumShift.setter
    def MaximumShift(self, value: float) -> None: ...
    @property
    def PupilZone(self) -> float: ...
    @PupilZone.setter
    def PupilZone(self, value: float) -> None: ...

class IAS_FullFieldAberration(IAS_):
    @property
    def FieldShape(self) -> FFA_FieldShapes: ...
    @FieldShape.setter
    def FieldShape(self, value: FFA_FieldShapes) -> None: ...
    @property
    def XFieldWidth(self) -> float: ...
    @XFieldWidth.setter
    def XFieldWidth(self, value: float) -> None: ...
    @property
    def YFieldWidth(self) -> float: ...
    @YFieldWidth.setter
    def YFieldWidth(self, value: float) -> None: ...
    @property
    def Decomposition(self) -> FFA_DecompositionTypes: ...
    @Decomposition.setter
    def Decomposition(self, value: FFA_DecompositionTypes) -> None: ...
    @property
    def MaximumTerm(self) -> int: ...
    @MaximumTerm.setter
    def MaximumTerm(self, value: int) -> None: ...
    @property
    def AberrationType(self) -> FFA_AberrationTypes: ...
    @property
    def AberrationNumber(self) -> int: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def XFieldSampling(self) -> int: ...
    @XFieldSampling.setter
    def XFieldSampling(self, value: int) -> None: ...
    @property
    def YFieldSampling(self) -> int: ...
    @YFieldSampling.setter
    def YFieldSampling(self, value: int) -> None: ...
    @property
    def PupilSampling(self) -> SampleSizes: ...
    @PupilSampling.setter
    def PupilSampling(self, value: SampleSizes) -> None: ...
    @property
    def ShowAs(self) -> FFA_ShowAsTypes: ...
    @ShowAs.setter
    def ShowAs(self, value: FFA_ShowAsTypes) -> None: ...
    @property
    def Display(self) -> FFA_DisplayTypes: ...
    @Display.setter
    def Display(self, value: FFA_DisplayTypes) -> None: ...
    def SetAberrationByNumber(self, aberrationNumber: int) -> bool: ...
    def SetAberrationByType(self, type: FFA_AberrationTypes) -> bool: ...

class IAS_GridDistortion(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def SymmetricMagnification(self) -> bool: ...
    @SymmetricMagnification.setter
    def SymmetricMagnification(self, value: bool) -> None: ...
    @property
    def ScaleFactor(self) -> float: ...
    @ScaleFactor.setter
    def ScaleFactor(self, value: float) -> None: ...
    @property
    def Aspect(self) -> float: ...
    @Aspect.setter
    def Aspect(self, value: float) -> None: ...
    @property
    def FieldWidth(self) -> float: ...
    @FieldWidth.setter
    def FieldWidth(self, value: float) -> None: ...
    @property
    def GridNumber(self) -> int: ...
    @GridNumber.setter
    def GridNumber(self, value: int) -> None: ...
    @property
    def Method(self) -> int: ...
    @Method.setter
    def Method(self, value: int) -> None: ...
    @property
    def RotateText(self) -> int: ...
    @RotateText.setter
    def RotateText(self, value: int) -> None: ...

class IAS_LateralColor(IAS_):
    @property
    def AllWavelengths(self) -> bool: ...
    @AllWavelengths.setter
    def AllWavelengths(self, value: bool) -> None: ...
    @property
    def ShowAiryDisk(self) -> bool: ...
    @ShowAiryDisk.setter
    def ShowAiryDisk(self, value: bool) -> None: ...
    @property
    def UseRealRays(self) -> bool: ...
    @UseRealRays.setter
    def UseRealRays(self, value: bool) -> None: ...
    @property
    def PlotScale(self) -> float: ...
    @PlotScale.setter
    def PlotScale(self, value: float) -> None: ...

class IAS_LongitudinalAberration(IAS_):
    @property
    def UseDashes(self) -> bool: ...
    @UseDashes.setter
    def UseDashes(self, value: bool) -> None: ...
    @property
    def PlotScale(self) -> float: ...
    @PlotScale.setter
    def PlotScale(self, value: float) -> None: ...

class IAS_RayTrace(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def UseGlobal(self) -> bool: ...
    @UseGlobal.setter
    def UseGlobal(self, value: bool) -> None: ...
    @property
    def Hx(self) -> float: ...
    @Hx.setter
    def Hx(self, value: float) -> None: ...
    @property
    def Hy(self) -> float: ...
    @Hy.setter
    def Hy(self, value: float) -> None: ...
    @property
    def Px(self) -> float: ...
    @Px.setter
    def Px(self, value: float) -> None: ...
    @property
    def Py(self) -> float: ...
    @Py.setter
    def Py(self, value: float) -> None: ...
    @property
    def Type(self) -> RayTraceType: ...
    @Type.setter
    def Type(self, value: RayTraceType) -> None: ...
    def UseArbitraryRay(self) -> None: ...

class IAS_SeidelCoefficients(IAS_):
    @property
    def Wavelength(self) -> IAS_Wavelength: ...

class IAS_SeidelDiagram(IAS_):
    @property
    def IgnoreChromatic(self) -> bool: ...
    @IgnoreChromatic.setter
    def IgnoreChromatic(self, value: bool) -> None: ...
    @property
    def IgnoreDistortion(self) -> bool: ...
    @IgnoreDistortion.setter
    def IgnoreDistortion(self, value: bool) -> None: ...
    @property
    def SuppressFrame(self) -> bool: ...
    @SuppressFrame.setter
    def SuppressFrame(self, value: bool) -> None: ...
    @property
    def PlotScale(self) -> float: ...
    @PlotScale.setter
    def PlotScale(self, value: float) -> None: ...

class IAS_ZernikeAnnularCoefficients(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Surface(self) -> IAS_Surface: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @property
    def ReferenceOBDToVertex(self) -> bool: ...
    @ReferenceOBDToVertex.setter
    def ReferenceOBDToVertex(self, value: bool) -> None: ...
    @property
    def Sx(self) -> float: ...
    @Sx.setter
    def Sx(self, value: float) -> None: ...
    @property
    def Sy(self) -> float: ...
    @Sy.setter
    def Sy(self, value: float) -> None: ...
    @property
    def Sr(self) -> float: ...
    @Sr.setter
    def Sr(self, value: float) -> None: ...
    @property
    def Obscuration(self) -> float: ...
    @Obscuration.setter
    def Obscuration(self, value: float) -> None: ...
    @property
    def MaximumNumberOfTerms(self) -> int: ...
    @MaximumNumberOfTerms.setter
    def MaximumNumberOfTerms(self, value: int) -> None: ...

class IAS_ZernikeCoefficientsVsField(IAS_):
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @property
    def FieldScanDirection(self) -> FieldScanDirections: ...
    @FieldScanDirection.setter
    def FieldScanDirection(self, value: FieldScanDirections) -> None: ...
    @property
    def ZernikeCoefficientType(self) -> ZernikeCoefficientTypes: ...
    @ZernikeCoefficientType.setter
    def ZernikeCoefficientType(self, value: ZernikeCoefficientTypes) -> None: ...
    @property
    def ScaleMinimum(self) -> float: ...
    @ScaleMinimum.setter
    def ScaleMinimum(self, value: float) -> None: ...
    @property
    def ScaleMaximum(self) -> float: ...
    @ScaleMaximum.setter
    def ScaleMaximum(self, value: float) -> None: ...
    @property
    def ObscurationFactor(self) -> float: ...
    @ObscurationFactor.setter
    def ObscurationFactor(self, value: float) -> None: ...
    @property
    def FieldDensity(self) -> int: ...
    @FieldDensity.setter
    def FieldDensity(self, value: int) -> None: ...
    @property
    def Coefficients(self) -> str: ...
    @Coefficients.setter
    def Coefficients(self, value: str) -> None: ...

class IAS_ZernikeFringeCoefficients(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Surface(self) -> IAS_Surface: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @property
    def ReferenceOBDToVertex(self) -> bool: ...
    @ReferenceOBDToVertex.setter
    def ReferenceOBDToVertex(self, value: bool) -> None: ...
    @property
    def Sx(self) -> float: ...
    @Sx.setter
    def Sx(self, value: float) -> None: ...
    @property
    def Sy(self) -> float: ...
    @Sy.setter
    def Sy(self, value: float) -> None: ...
    @property
    def Sr(self) -> float: ...
    @Sr.setter
    def Sr(self, value: float) -> None: ...
    @property
    def MaximumNumberOfTerms(self) -> int: ...
    @MaximumNumberOfTerms.setter
    def MaximumNumberOfTerms(self, value: int) -> None: ...

class IAS_ZernikeStandardCoefficients(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Surface(self) -> IAS_Surface: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @property
    def ReferenceOBDToVertex(self) -> bool: ...
    @ReferenceOBDToVertex.setter
    def ReferenceOBDToVertex(self, value: bool) -> None: ...
    @property
    def Sx(self) -> float: ...
    @Sx.setter
    def Sx(self, value: float) -> None: ...
    @property
    def Sy(self) -> float: ...
    @Sy.setter
    def Sy(self, value: float) -> None: ...
    @property
    def Sr(self) -> float: ...
    @Sr.setter
    def Sr(self, value: float) -> None: ...
    @property
    def Epsilon(self) -> float: ...
    @Epsilon.setter
    def Epsilon(self, value: float) -> None: ...
    @property
    def MaximumNumberOfTerms(self) -> int: ...
    @MaximumNumberOfTerms.setter
    def MaximumNumberOfTerms(self, value: int) -> None: ...

class RayTraceType:
    DirectionCosines = 0
    TangentAngle = 1
    YmUmYcUc = 2

class ZernikeCoefficientTypes:
    Fringe = 0
    Standard = 1
    Annular = 2
